/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class JavaEcosystemVariantDerivationStrategy
implements VariantDerivationStrategy {
    @Override
    public boolean derivesVariants() {
        return true;
    }

    @Override
    public ImmutableList<? extends ConfigurationMetadata> derive(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof DefaultMavenModuleResolveMetadata) {
            DefaultMavenModuleResolveMetadata md = (DefaultMavenModuleResolveMetadata)metadata;
            ImmutableAttributes attributes = md.getAttributes();
            MavenImmutableAttributesFactory attributesFactory = (MavenImmutableAttributesFactory)md.getAttributesFactory();
            DefaultConfigurationMetadata compileConfiguration = (DefaultConfigurationMetadata)md.getConfiguration("compile");
            DefaultConfigurationMetadata runtimeConfiguration = (DefaultConfigurationMetadata)md.getConfiguration("runtime");
            return ImmutableList.of((Object)JavaEcosystemVariantDerivationStrategy.libraryWithUsageAttribute(compileConfiguration, attributes, attributesFactory, "java-api"), (Object)JavaEcosystemVariantDerivationStrategy.libraryWithUsageAttribute(runtimeConfiguration, attributes, attributesFactory, "java-runtime"), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(compileConfiguration, attributes, attributesFactory, "java-api", false), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(runtimeConfiguration, attributes, attributesFactory, "java-runtime", false), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(compileConfiguration, attributes, attributesFactory, "java-api", true), (Object)JavaEcosystemVariantDerivationStrategy.platformWithUsageAttribute(runtimeConfiguration, attributes, attributesFactory, "java-runtime", true));
        }
        return null;
    }

    private static ConfigurationMetadata libraryWithUsageAttribute(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes, MavenImmutableAttributesFactory attributesFactory, String usage) {
        ImmutableAttributes attributes = attributesFactory.libraryWithUsage(originAttributes, usage);
        return conf.withAttributes(attributes).withoutConstraints();
    }

    private static ConfigurationMetadata platformWithUsageAttribute(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes, MavenImmutableAttributesFactory attributesFactory, String usage, boolean enforcedPlatform) {
        ImmutableAttributes attributes = attributesFactory.platformWithUsage(originAttributes, usage, enforcedPlatform);
        ModuleComponentIdentifier componentId = conf.getComponentId();
        String prefix = enforcedPlatform ? "enforced-platform-" : "platform-";
        DefaultConfigurationMetadata metadata = conf.withAttributes(prefix + conf.getName(), attributes);
        metadata = metadata.withConstraintsOnly().withCapabilities(Collections.singletonList(new ImmutableCapability(componentId.getGroup(), componentId.getModule() + "-derived-platform", componentId.getVersion())));
        if (enforcedPlatform) {
            metadata = metadata.withForcedDependencies();
        }
        return metadata;
    }
}

