/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.utils.ThreadUtils;

public class HttpPanelManager {
    private static HttpPanelManager instance = null;
    private HttpPanelManagement requestPanels = new HttpPanelManagement();
    private HttpPanelManagement responsePanels = new HttpPanelManagement();

    private HttpPanelManager() {
    }

    public static HttpPanelManager getInstance() {
        if (instance == null) {
            HttpPanelManager.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new HttpPanelManager();
        }
    }

    public void addRequestPanel(HttpPanel panel) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.addPanel(panel));
    }

    public void addRequestComponentFactory(HttpPanelComponentFactory componentFactory) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.addComponentFactory(componentFactory));
    }

    public void addRequestViewFactory(String componentName, HttpPanelViewFactory viewFactory) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.addViewFactory(componentName, viewFactory));
    }

    public void addRequestDefaultViewSelectorFactory(String componentName, HttpPanelDefaultViewSelectorFactory defaultViewSelectorFactory) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.addDefaultViewSelectorFactory(componentName, defaultViewSelectorFactory));
    }

    public void addResponsePanel(HttpPanel panel) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.addPanel(panel));
    }

    public void addResponseComponentFactory(HttpPanelComponentFactory componentFactory) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.addComponentFactory(componentFactory));
    }

    public void addResponseViewFactory(String componentName, HttpPanelViewFactory viewFactory) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.addViewFactory(componentName, viewFactory));
    }

    public void addResponseDefaultViewSelectorFactory(String componentName, HttpPanelDefaultViewSelectorFactory defaultViewSelectorFactory) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.addDefaultViewSelectorFactory(componentName, defaultViewSelectorFactory));
    }

    public void removeRequestPanel(HttpPanel panel) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removePanel(panel));
    }

    public void removeRequestComponentFactory(String componentFactoryName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removeComponentFactory(componentFactoryName));
    }

    public void removeRequestComponents(String componentName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removeComponents(componentName));
    }

    public void removeRequestViewFactory(String componentName, String viewFactoryName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removeViewFactory(componentName, viewFactoryName));
    }

    public void removeRequestViews(String componentName, String viewName, Object options) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removeViews(componentName, viewName, options));
    }

    public void removeRequestDefaultViewSelectorFactory(String componentName, String defaultViewSelectorFactoryName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removeDefaultViewSelectorFactory(componentName, defaultViewSelectorFactoryName));
    }

    public void removeRequestDefaultViewSelectors(String componentName, String defaultViewSelectorName, Object options) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removeDefaultViewSelectors(componentName, defaultViewSelectorName, options));
    }

    @Deprecated
    public void removeRequestDefaultViewSelectorFactoryAndDefaultViewSelectorsAdded(String componentName, String defaultViewSelectorName, Object options) {
        ThreadUtils.invokeAndWaitHandled(() -> this.requestPanels.removeDefaultViewSelectors(componentName, defaultViewSelectorName, options));
    }

    public void removeResponsePanel(HttpPanel panel) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.removePanel(panel));
    }

    public void removeResponseComponentFactory(String componentFactoryName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.removeComponentFactory(componentFactoryName));
    }

    public void removeResponseComponents(String componentName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.removeComponents(componentName));
    }

    public void removeResponseViewFactory(String componentName, String viewFactoryName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.removeViewFactory(componentName, viewFactoryName));
    }

    public void removeResponseViews(String componentName, String viewName, Object options) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.removeViews(componentName, viewName, options));
    }

    public void removeResponseDefaultViewSelectorFactory(String componentName, String defaultViewSelectorFactoryName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.removeDefaultViewSelectorFactory(componentName, defaultViewSelectorFactoryName));
    }

    public void removeResponseDefaultViewSelectors(String componentName, String defaultViewSelectorName, Object options) {
        ThreadUtils.invokeAndWaitHandled(() -> this.responsePanels.removeDefaultViewSelectors(componentName, defaultViewSelectorName, options));
    }

    public static interface HttpPanelDefaultViewSelectorFactory {
        public String getName();

        public HttpPanelDefaultViewSelector getNewDefaultViewSelector();

        public Object getOptions();
    }

    public static interface HttpPanelViewFactory {
        public String getName();

        public HttpPanelView getNewView();

        public Object getOptions();
    }

    public static interface HttpPanelComponentFactory {
        public String getName();

        public String getComponentName();

        public HttpPanelComponentInterface getNewComponent();
    }

    private static final class HttpPanelManagement {
        private List<HttpPanel> panels = new ArrayList<HttpPanel>();
        private Map<String, HttpPanelComponentFactory> components = new HashMap<String, HttpPanelComponentFactory>();
        private Map<String, Map<String, HttpPanelViewFactory>> views = new HashMap<String, Map<String, HttpPanelViewFactory>>();
        private Map<String, Map<String, HttpPanelDefaultViewSelectorFactory>> defaultViews = new HashMap<String, Map<String, HttpPanelDefaultViewSelectorFactory>>();

        public void addPanel(HttpPanel panel) {
            this.panels.add(panel);
            FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
            for (HttpPanelComponentFactory httpPanelComponentFactory : this.components.values()) {
                panel.addComponent(httpPanelComponentFactory.getNewComponent(), fileConfiguration);
            }
            for (Map.Entry entry : this.views.entrySet()) {
                for (Object viewFactory : ((Map)entry.getValue()).values()) {
                    panel.addView((String)entry.getKey(), viewFactory.getNewView(), viewFactory.getOptions(), fileConfiguration);
                }
            }
            for (Map.Entry entry : this.defaultViews.entrySet()) {
                for (Object viewFactory : ((Map)entry.getValue()).values()) {
                    panel.addDefaultViewSelector((String)entry.getKey(), viewFactory.getNewDefaultViewSelector(), viewFactory.getOptions());
                }
            }
        }

        public void removePanel(HttpPanel panel) {
            this.panels.remove(panel);
        }

        public void addComponentFactory(HttpPanelComponentFactory componentFactory) {
            if (this.components.containsKey(componentFactory.getName())) {
                return;
            }
            this.components.put(componentFactory.getName(), componentFactory);
            FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
            for (HttpPanel panel : this.panels) {
                Map<String, HttpPanelDefaultViewSelectorFactory> defaultViewsComp;
                panel.addComponent(componentFactory.getNewComponent(), fileConfiguration);
                String componentName = componentFactory.getComponentName();
                Map<String, HttpPanelViewFactory> componentViews = this.views.get(componentName);
                if (componentViews != null) {
                    for (HttpPanelViewFactory viewFactory : componentViews.values()) {
                        panel.addView(componentName, viewFactory.getNewView(), viewFactory.getOptions(), fileConfiguration);
                    }
                }
                if ((defaultViewsComp = this.defaultViews.get(componentName)) == null) continue;
                for (HttpPanelDefaultViewSelectorFactory defaultViewSelector : defaultViewsComp.values()) {
                    panel.addDefaultViewSelector(componentName, defaultViewSelector.getNewDefaultViewSelector(), defaultViewSelector.getOptions());
                }
            }
        }

        public void removeComponentFactory(String componentFactoryName) {
            this.components.remove(componentFactoryName);
        }

        public void removeComponents(String componentName) {
            for (HttpPanel panel : this.panels) {
                panel.removeComponent(componentName);
            }
        }

        public void addViewFactory(String componentName, HttpPanelViewFactory viewFactory) {
            Map<String, HttpPanelViewFactory> componentViews = this.views.get(componentName);
            if (componentViews == null) {
                componentViews = new HashMap<String, HttpPanelViewFactory>();
                this.views.put(componentName, componentViews);
            } else if (this.views.containsKey(viewFactory.getName())) {
                return;
            }
            componentViews.put(viewFactory.getName(), viewFactory);
            FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
            for (HttpPanel panel : this.panels) {
                panel.addView(componentName, viewFactory.getNewView(), viewFactory.getOptions(), fileConfiguration);
            }
        }

        public void removeViewFactory(String componentName, String viewFactoryName) {
            Map<String, HttpPanelViewFactory> componentViews = this.views.get(componentName);
            if (componentViews == null) {
                return;
            }
            HttpPanelViewFactory viewFactory = componentViews.get(viewFactoryName);
            if (viewFactory == null) {
                return;
            }
            componentViews.remove(viewFactoryName);
            if (componentViews.isEmpty()) {
                this.views.put(componentName, null);
            }
        }

        public void removeViews(String componentName, String viewName, Object options) {
            for (HttpPanel panel : this.panels) {
                panel.removeView(componentName, viewName, options);
            }
        }

        public void addDefaultViewSelectorFactory(String componentName, HttpPanelDefaultViewSelectorFactory defaultViewSelectorFactory) {
            Map<String, HttpPanelDefaultViewSelectorFactory> componentDefaultViews = this.defaultViews.get(componentName);
            if (componentDefaultViews == null) {
                componentDefaultViews = new HashMap<String, HttpPanelDefaultViewSelectorFactory>();
                this.defaultViews.put(componentName, componentDefaultViews);
            } else if (this.views.containsKey(defaultViewSelectorFactory.getName())) {
                return;
            }
            componentDefaultViews.put(defaultViewSelectorFactory.getName(), defaultViewSelectorFactory);
            for (HttpPanel panel : this.panels) {
                panel.addDefaultViewSelector(componentName, defaultViewSelectorFactory.getNewDefaultViewSelector(), defaultViewSelectorFactory.getOptions());
            }
        }

        public void removeDefaultViewSelectorFactory(String componentName, String viewFactoryName) {
            Map<String, HttpPanelDefaultViewSelectorFactory> componentDefaultViews = this.defaultViews.get(componentName);
            if (componentDefaultViews == null) {
                return;
            }
            HttpPanelDefaultViewSelectorFactory viewFactory = componentDefaultViews.get(viewFactoryName);
            if (viewFactory == null) {
                return;
            }
            componentDefaultViews.remove(viewFactoryName);
            if (componentDefaultViews.isEmpty()) {
                this.defaultViews.put(componentName, null);
            }
        }

        public void removeDefaultViewSelectors(String componentName, String defaultViewSelectorName, Object options) {
            for (HttpPanel panel : this.panels) {
                panel.removeDefaultViewSelector(componentName, defaultViewSelectorName, options);
            }
        }
    }
}

