// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9CN11.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,at91sam9cn11

// Atmel AT91SAM9CN11 device: ARM926EJ Embedded Microprocessor Unit, 400MHz, Crypto engine, LCD, USB, LPDDR/DDR2/MLC NAND support, 217 Pins (refer to http://www.atmel.com/devices/SAM9CN11.aspx for more)
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "AT91SAM9CN11"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Debug Unit
	IRQ_DBGU = 1

	// Parallel Input/Output Controller A
	IRQ_PIOA = 2

	// Parallel Input/Output Controller C
	IRQ_PIOC = 3

	// Fuse Controller
	IRQ_FUSE = 4

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 5

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 6

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 7

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	IRQ_USART3 = 8

	// Two-wire Interface 0
	IRQ_TWI0 = 9

	// Two-wire Interface 1
	IRQ_TWI1 = 10

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 12

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 13

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 14

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 15

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 16

	// Timer Counter 0
	IRQ_TC0 = 17

	// Pulse Width Modulation Controller
	IRQ_PWM = 18

	// Analog-to-Digital Converter
	IRQ_ADC = 19

	// DMA Controller
	IRQ_DMAC = 20

	// USB Device Port
	IRQ_UDP = 23

	// LCD Controller
	IRQ_LCDC = 25

	// Secure Hash Algorithm
	IRQ_SHA = 27

	// Synchronous Serial Controller
	IRQ_SSC = 28

	// Advanced Encryption Standard
	IRQ_AES = 29

	// True Random Number Generator
	IRQ_TRNG = 30

	// Advanced Interrupt Controller
	IRQ_IRQ = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export FIQ_IRQHandler
func interruptFIQ() {
	callHandlers(IRQ_FIQ)
}

//export DBGU_IRQHandler
func interruptDBGU() {
	callHandlers(IRQ_DBGU)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export FUSE_IRQHandler
func interruptFUSE() {
	callHandlers(IRQ_FUSE)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export HSMCI_IRQHandler
func interruptHSMCI() {
	callHandlers(IRQ_HSMCI)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DMAC_IRQHandler
func interruptDMAC() {
	callHandlers(IRQ_DMAC)
}

//export UDP_IRQHandler
func interruptUDP() {
	callHandlers(IRQ_UDP)
}

//export LCDC_IRQHandler
func interruptLCDC() {
	callHandlers(IRQ_LCDC)
}

//export SHA_IRQHandler
func interruptSHA() {
	callHandlers(IRQ_SHA)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export IRQ_IRQHandler
func interruptIRQ() {
	callHandlers(IRQ_IRQ)
}

// Peripherals.
var (
	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0004000)))

	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf0008000)))

	// Advanced Encryption Standard
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0xf000c000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0xf0010000)))

	// Secure Hash Algorithm
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0xf0014000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xf8008000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0xf800c000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8010000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8014000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xf801c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8024000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8028000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0xf8034000)))

	// LCD Controller
	LCDC = (*LCDC_Type)(unsafe.Pointer(uintptr(0xf8038000)))

	// USB Device Port
	UDP = (*UDP_Type)(unsafe.Pointer(uintptr(0xf803c000)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8040000)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8044000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0xf8048000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0xf804c000)))

	// Fuse Controller
	FUSE = (*FUSE_Type)(unsafe.Pointer(uintptr(0xffffdc00)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffde00)))

	// Programmable Multibit Error Corrected Code Controller
	PMECC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe000)))

	// Programmable Multibit ECC Error Location
	PMERRLOC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe600)))

	// DDR_SDR SDRAM Controller
	DDRSDRC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe800)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// DMA Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Parallel Input/Output Controller D
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe10)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe40)))

	// Slow Clock Controller
	SCKC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe50)))

	// Boot Sequence Controller
	BSC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe54)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe60)))

	// Real-time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0xfffffeb0)))
)

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSNAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCSR_CSNAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.WPMR: Write Protection Control Register
func (o *SPI_Type) SetWPMR_SPIWPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPMR_SPIWPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SPI_Type) SetWPMR_SPIWPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetWPMR_SPIWPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SPI.WPSR: Write Protection Status Register
func (o *SPI_Type) SetWPSR_SPIWPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x7)|value)
}
func (o *SPI_Type) GetWPSR_SPIWPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x7
}
func (o *SPI_Type) SetWPSR_SPIWPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetWPSR_SPIWPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// HSMCI.CR: Control Register
func (o *HSMCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// HSMCI.MR: Mode Register
func (o *HSMCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetMR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetMR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetMR_PADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetMR_PADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetMR_CLKODD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetMR_CLKODD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}

// HSMCI.DTOR: Data Timeout Register
func (o *HSMCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// HSMCI.SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.ARGR: Argument Register
func (o *HSMCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *HSMCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// HSMCI.CMDR: Command Register
func (o *HSMCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetCMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetCMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetCMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetCMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.BLKR: Block Register
func (o *HSMCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetCSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetCSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetCSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetCSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.RSPR: Response Register
func (o *HSMCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// HSMCI.RDR: Receive Data Register
func (o *HSMCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *HSMCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// HSMCI.TDR: Transmit Data Register
func (o *HSMCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *HSMCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// HSMCI.SR: Status Register
func (o *HSMCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetSR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetSR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetSR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetSR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetSR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetSR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetSR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetSR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetSR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetSR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetSR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetSR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetSR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetSR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetSR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetSR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetSR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetSR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// HSMCI.IER: Interrupt Enable Register
func (o *HSMCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIER_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIER_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIER_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIER_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIER_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIER_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSMCI.IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIDR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIDR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIDR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIDR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIDR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIDR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIMR_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIMR_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIMR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIMR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIMR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIMR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.DMA: DMA Configuration Register
func (o *HSMCI_Type) SetDMA_OFFSET(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetDMA_OFFSET() uint32 {
	return volatile.LoadUint32(&o.DMA.Reg) & 0x3
}
func (o *HSMCI_Type) SetDMA_CHKSIZE(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDMA_CHKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x70) >> 4
}
func (o *HSMCI_Type) SetDMA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetDMA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetDMA_ROPT(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetDMA_ROPT() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x1000) >> 12
}

// HSMCI.CFG: Configuration Register
func (o *HSMCI_Type) SetCFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetCFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetCFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetCFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetCFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetCFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}

// HSMCI.WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetWPMR_WP_EN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPMR_WP_EN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPMR_WP_KEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPMR_WP_KEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetWPSR_WP_VS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetWPSR_WP_VS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0xf
}
func (o *HSMCI_Type) SetWPSR_WP_VSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPSR_WP_VSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// HSMCI.FIFO: FIFO Memory Aperture0
func (o *HSMCI_Type) SetFIFO(idx int, value uint32) {
	volatile.StoreUint32(&o.FIFO[idx].Reg, value)
}
func (o *HSMCI_Type) GetFIFO(idx int) uint32 {
	return volatile.LoadUint32(&o.FIFO[idx].Reg)
}

// Advanced Encryption Standard
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	_      [8]byte
	IER    volatile.Register32    // 0x10
	IDR    volatile.Register32    // 0x14
	IMR    volatile.Register32    // 0x18
	ISR    volatile.Register32    // 0x1C
	KEYWR  [8]volatile.Register32 // 0x20
	IDATAR [4]volatile.Register32 // 0x40
	ODATAR [4]volatile.Register32 // 0x50
	IVR    [4]volatile.Register32 // 0x60
}

// AES.CR: Control Register
func (o *AES_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *AES_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// AES.MR: Mode Register
func (o *AES_Type) SetMR_CIPHER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetMR_CIPHER() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *AES_Type) SetMR_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetMR_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8) >> 3
}
func (o *AES_Type) SetMR_PROCDLY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0)|value<<4)
}
func (o *AES_Type) GetMR_PROCDLY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0) >> 4
}
func (o *AES_Type) SetMR_SMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x300)|value<<8)
}
func (o *AES_Type) GetMR_SMOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x300) >> 8
}
func (o *AES_Type) SetMR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc00)|value<<10)
}
func (o *AES_Type) GetMR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc00) >> 10
}
func (o *AES_Type) SetMR_OPMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000)|value<<12)
}
func (o *AES_Type) GetMR_OPMOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000) >> 12
}
func (o *AES_Type) SetMR_LOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *AES_Type) GetMR_LOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *AES_Type) SetMR_CFBS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70000)|value<<16)
}
func (o *AES_Type) GetMR_CFBS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70000) >> 16
}
func (o *AES_Type) SetMR_CKEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00000)|value<<20)
}
func (o *AES_Type) GetMR_CKEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00000) >> 20
}

// AES.IER: Interrupt Enable Register
func (o *AES_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *AES_Type) SetIER_URAD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIER_URAD() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}

// AES.IDR: Interrupt Disable Register
func (o *AES_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *AES_Type) SetIDR_URAD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}

// AES.IMR: Interrupt Mask Register
func (o *AES_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AES_Type) SetIMR_URAD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}

// AES.ISR: Interrupt Status Register
func (o *AES_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *AES_Type) SetISR_URAD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetISR_URAT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf000)|value<<12)
}
func (o *AES_Type) GetISR_URAT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf000) >> 12
}

// AES.KEYWR: Key Word Register
func (o *AES_Type) SetKEYWR(idx int, value uint32) {
	volatile.StoreUint32(&o.KEYWR[idx].Reg, value)
}
func (o *AES_Type) GetKEYWR(idx int) uint32 {
	return volatile.LoadUint32(&o.KEYWR[idx].Reg)
}

// AES.IDATAR: Input Data Register
func (o *AES_Type) SetIDATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.IDATAR[idx].Reg, value)
}
func (o *AES_Type) GetIDATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.IDATAR[idx].Reg)
}

// AES.ODATAR: Output Data Register
func (o *AES_Type) SetODATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.ODATAR[idx].Reg, value)
}
func (o *AES_Type) GetODATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.ODATAR[idx].Reg)
}

// AES.IVR: Initialization Vector Register
func (o *AES_Type) SetIVR(idx int, value uint32) {
	volatile.StoreUint32(&o.IVR[idx].Reg, value)
}
func (o *AES_Type) GetIVR(idx int) uint32 {
	return volatile.LoadUint32(&o.IVR[idx].Reg)
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protect Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Secure Hash Algorithm
type SHA_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	_      [8]byte
	IER    volatile.Register32 // 0x10
	IDR    volatile.Register32 // 0x14
	IMR    volatile.Register32 // 0x18
	ISR    volatile.Register32 // 0x1C
	_      [32]byte
	IDATAR [16]volatile.Register32 // 0x40
	ODATAR [8]volatile.Register32  // 0x80
}

// SHA.CR: Control Register
func (o *SHA_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SHA_Type) SetCR_FIRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *SHA_Type) GetCR_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *SHA_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SHA_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// SHA.MR: Mode Register
func (o *SHA_Type) SetMR_SMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3)|value)
}
func (o *SHA_Type) GetMR_SMOD() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x3
}
func (o *SHA_Type) SetMR_PROCDLY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SHA_Type) GetMR_PROCDLY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SHA_Type) SetMR_ALGO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *SHA_Type) GetMR_ALGO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *SHA_Type) SetMR_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *SHA_Type) GetMR_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}

// SHA.IER: Interrupt Enable Register
func (o *SHA_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SHA_Type) SetIER_URAD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SHA_Type) GetIER_URAD() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}

// SHA.IDR: Interrupt Disable Register
func (o *SHA_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SHA_Type) SetIDR_URAD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SHA_Type) GetIDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}

// SHA.IMR: Interrupt Mask Register
func (o *SHA_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SHA_Type) SetIMR_URAD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SHA_Type) GetIMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}

// SHA.ISR: Interrupt Status Register
func (o *SHA_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *SHA_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *SHA_Type) SetISR_URAD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *SHA_Type) GetISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *SHA_Type) SetISR_URAT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x7000)|value<<12)
}
func (o *SHA_Type) GetISR_URAT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x7000) >> 12
}

// SHA.IDATAR: Input Data 0 Register
func (o *SHA_Type) SetIDATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.IDATAR[idx].Reg, value)
}
func (o *SHA_Type) GetIDATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.IDATAR[idx].Reg)
}

// SHA.ODATAR: Output Data 0 Register
func (o *SHA_Type) SetODATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.ODATAR[idx].Reg, value)
}
func (o *SHA_Type) GetODATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.ODATAR[idx].Reg)
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [4]byte
	RAB0 volatile.Register32 // 0xC
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [4]byte
	RAB1 volatile.Register32 // 0x4C
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [4]byte
	RAB2 volatile.Register32 // 0x8C
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.RAB0: Register AB (channel = 0)
func (o *TC_Type) SetRAB0(value uint32) {
	volatile.StoreUint32(&o.RAB0.Reg, value)
}
func (o *TC_Type) GetRAB0() uint32 {
	return volatile.LoadUint32(&o.RAB0.Reg)
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.RAB1: Register AB (channel = 1)
func (o *TC_Type) SetRAB1(value uint32) {
	volatile.StoreUint32(&o.RAB1.Reg, value)
}
func (o *TC_Type) GetRAB1() uint32 {
	return volatile.LoadUint32(&o.RAB1.Reg)
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.RAB2: Register AB (channel = 2)
func (o *TC_Type) SetRAB2(value uint32) {
	volatile.StoreUint32(&o.RAB2.Reg, value)
}
func (o *TC_Type) GetRAB2() uint32 {
	return volatile.LoadUint32(&o.RAB2.Reg)
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR           volatile.Register32 // 0x0
	MMR          volatile.Register32 // 0x4
	SMR          volatile.Register32 // 0x8
	IADR         volatile.Register32 // 0xC
	CWGR         volatile.Register32 // 0x10
	_            [12]byte
	SR           volatile.Register32 // 0x20
	IER          volatile.Register32 // 0x24
	IDR          volatile.Register32 // 0x28
	IMR          volatile.Register32 // 0x2C
	RHR          volatile.Register32 // 0x30
	THR          volatile.Register32 // 0x34
	_            [172]byte
	WPROT_MODE   volatile.Register32 // 0xE4
	WPROT_STATUS volatile.Register32 // 0xE8
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// TWI.WPROT_MODE: Protection Mode Register
func (o *TWI_Type) SetWPROT_MODE_WPROT(value uint32) {
	volatile.StoreUint32(&o.WPROT_MODE.Reg, volatile.LoadUint32(&o.WPROT_MODE.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetWPROT_MODE_WPROT() uint32 {
	return volatile.LoadUint32(&o.WPROT_MODE.Reg) & 0x1
}
func (o *TWI_Type) SetWPROT_MODE_SECURITY_CODE(value uint32) {
	volatile.StoreUint32(&o.WPROT_MODE.Reg, volatile.LoadUint32(&o.WPROT_MODE.Reg)&^(0xffffff00)|value<<8)
}
func (o *TWI_Type) GetWPROT_MODE_SECURITY_CODE() uint32 {
	return (volatile.LoadUint32(&o.WPROT_MODE.Reg) & 0xffffff00) >> 8
}

// TWI.WPROT_STATUS: Protection Status Register
func (o *TWI_Type) SetWPROT_STATUS_WPROTERR(value uint32) {
	volatile.StoreUint32(&o.WPROT_STATUS.Reg, volatile.LoadUint32(&o.WPROT_STATUS.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetWPROT_STATUS_WPROTERR() uint32 {
	return volatile.LoadUint32(&o.WPROT_STATUS.Reg) & 0x1
}
func (o *TWI_Type) SetWPROT_STATUS_WPROTADDR(value uint32) {
	volatile.StoreUint32(&o.WPROT_STATUS.Reg, volatile.LoadUint32(&o.WPROT_STATUS.Reg)&^(0xffffff00)|value<<8)
}
func (o *TWI_Type) GetWPROT_STATUS_WPROTADDR() uint32 {
	return (volatile.LoadUint32(&o.WPROT_STATUS.Reg) & 0xffffff00) >> 8
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	IDR   volatile.Register32 // 0xC
	IMR   volatile.Register32 // 0x10
	CSR   volatile.Register32 // 0x14
	RHR   volatile.Register32 // 0x18
	THR   volatile.Register32 // 0x1C
	BRGR  volatile.Register32 // 0x20
	RTOR  volatile.Register32 // 0x24
	TTGR  volatile.Register32 // 0x28
	_     [20]byte
	FIDI  volatile.Register32 // 0x40
	NER   volatile.Register32 // 0x44
	_     [4]byte
	IF    volatile.Register32 // 0x4C
	MAN   volatile.Register32 // 0x50
	LINMR volatile.Register32 // 0x54
	LINIR volatile.Register32 // 0x58
	_     [136]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR_LINABT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR_LINABT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR_LINWKUP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCR_LINWKUP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_INVDATA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetMR_INVDATA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIER_MANE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIER_MANE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIDR_MANE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIMR_MANE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receiver Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmitter Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0x1ffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0x1ffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Encoder Decoder Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.LINMR: LIN Mode Register
func (o *USART_Type) SetLINMR_NACT(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x3)|value)
}
func (o *USART_Type) GetLINMR_NACT() uint32 {
	return volatile.LoadUint32(&o.LINMR.Reg) & 0x3
}
func (o *USART_Type) SetLINMR_PARDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetLINMR_PARDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetLINMR_CHKDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetLINMR_CHKDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetLINMR_CHKTYP(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetLINMR_CHKTYP() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetLINMR_DLM(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetLINMR_DLM() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetLINMR_FSDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetLINMR_FSDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetLINMR_WKUPTYP(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetLINMR_WKUPTYP() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetLINMR_DLC(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetLINMR_DLC() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetLINMR_PDCM(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetLINMR_PDCM() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x10000) >> 16
}

// USART.LINIR: LIN Identifier Register
func (o *USART_Type) SetLINIR_IDCHR(value uint32) {
	volatile.StoreUint32(&o.LINIR.Reg, volatile.LoadUint32(&o.LINIR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetLINIR_IDCHR() uint32 {
	return volatile.LoadUint32(&o.LINIR.Reg) & 0xff
}

// USART.WPMR: Write Protect Mode Register
func (o *USART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *USART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// USART.WPSR: Write Protect Status Register
func (o *USART_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *USART_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// PWM.MR: PWM Mode Register
func (o *PWM_Type) SetMR_DIVA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetMR_DIVA() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *PWM_Type) SetMR_PREA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetMR_PREA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetMR_DIVB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetMR_DIVB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetMR_PREB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetMR_PREB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER: PWM Interrupt Enable Register
func (o *PWM_Type) SetIER_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PWM_Type) SetIER_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}

// PWM.IDR: PWM Interrupt Disable Register
func (o *PWM_Type) SetIDR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PWM_Type) SetIDR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}

// PWM.IMR: PWM Interrupt Mask Register
func (o *PWM_Type) SetIMR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PWM_Type) SetIMR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}

// PWM.ISR: PWM Interrupt Status Register
func (o *PWM_Type) SetISR_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PWM_Type) SetISR_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, value)
}
func (o *PWM_Type) GetCDTY0() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg)
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, value)
}
func (o *PWM_Type) GetCPRD0() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg)
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, value)
}
func (o *PWM_Type) GetCCNT0() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg)
}

// PWM.CUPD0: PWM Channel Update Register (ch_num = 0)
func (o *PWM_Type) SetCUPD0(value uint32) {
	volatile.StoreUint32(&o.CUPD0.Reg, value)
}
func (o *PWM_Type) GetCUPD0() uint32 {
	return volatile.LoadUint32(&o.CUPD0.Reg)
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, value)
}
func (o *PWM_Type) GetCDTY1() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg)
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, value)
}
func (o *PWM_Type) GetCPRD1() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg)
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, value)
}
func (o *PWM_Type) GetCCNT1() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg)
}

// PWM.CUPD1: PWM Channel Update Register (ch_num = 1)
func (o *PWM_Type) SetCUPD1(value uint32) {
	volatile.StoreUint32(&o.CUPD1.Reg, value)
}
func (o *PWM_Type) GetCUPD1() uint32 {
	return volatile.LoadUint32(&o.CUPD1.Reg)
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, value)
}
func (o *PWM_Type) GetCDTY2() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg)
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, value)
}
func (o *PWM_Type) GetCPRD2() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg)
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, value)
}
func (o *PWM_Type) GetCCNT2() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg)
}

// PWM.CUPD2: PWM Channel Update Register (ch_num = 2)
func (o *PWM_Type) SetCUPD2(value uint32) {
	volatile.StoreUint32(&o.CUPD2.Reg, value)
}
func (o *PWM_Type) GetCUPD2() uint32 {
	return volatile.LoadUint32(&o.CUPD2.Reg)
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, value)
}
func (o *PWM_Type) GetCDTY3() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg)
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, value)
}
func (o *PWM_Type) GetCPRD3() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg)
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, value)
}
func (o *PWM_Type) GetCCNT3() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg)
}

// PWM.CUPD3: PWM Channel Update Register (ch_num = 3)
func (o *PWM_Type) SetCUPD3(value uint32) {
	volatile.StoreUint32(&o.CUPD3.Reg, value)
}
func (o *PWM_Type) GetCUPD3() uint32 {
	return volatile.LoadUint32(&o.CUPD3.Reg)
}

// LCD Controller
type LCDC_Type struct {
	LCDCFG0  volatile.Register32 // 0x0
	LCDCFG1  volatile.Register32 // 0x4
	LCDCFG2  volatile.Register32 // 0x8
	LCDCFG3  volatile.Register32 // 0xC
	LCDCFG4  volatile.Register32 // 0x10
	LCDCFG5  volatile.Register32 // 0x14
	LCDCFG6  volatile.Register32 // 0x18
	_        [4]byte
	LCDEN    volatile.Register32 // 0x20
	LCDDIS   volatile.Register32 // 0x24
	LCDSR    volatile.Register32 // 0x28
	LCDIER   volatile.Register32 // 0x2C
	LCDIDR   volatile.Register32 // 0x30
	LCDIMR   volatile.Register32 // 0x34
	LCDISR   volatile.Register32 // 0x38
	_        [4]byte
	BASECHER volatile.Register32 // 0x40
	BASECHDR volatile.Register32 // 0x44
	BASECHSR volatile.Register32 // 0x48
	BASEIER  volatile.Register32 // 0x4C
	BASEIDR  volatile.Register32 // 0x50
	BASEIMR  volatile.Register32 // 0x54
	BASEISR  volatile.Register32 // 0x58
	BASEHEAD volatile.Register32 // 0x5C
	BASEADDR volatile.Register32 // 0x60
	BASECTRL volatile.Register32 // 0x64
	BASENEXT volatile.Register32 // 0x68
	BASECFG0 volatile.Register32 // 0x6C
	BASECFG1 volatile.Register32 // 0x70
	BASECFG2 volatile.Register32 // 0x74
	BASECFG3 volatile.Register32 // 0x78
	BASECFG4 volatile.Register32 // 0x7C
	_        [896]byte
	BASECLUT [256]volatile.Register32 // 0x400
	_        [6124]byte
	ADDRSIZE volatile.Register32    // 0x1FEC
	IPNAME   [2]volatile.Register32 // 0x1FF0
	FEATURES volatile.Register32    // 0x1FF8
	VERSION  volatile.Register32    // 0x1FFC
}

// LCDC.LCDCFG0: LCD Controller Configuration Register 0
func (o *LCDC_Type) SetLCDCFG0_CLKPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCFG0_CLKPOL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCFG0_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCFG0_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCFG0_CLKPWMSEL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDCFG0_CLKPWMSEL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDCFG0_CGDISBASE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG0_CGDISBASE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDCFG0_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.LCDCFG0.Reg, volatile.LoadUint32(&o.LCDCFG0.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG0_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG0.Reg) & 0xff0000) >> 16
}

// LCDC.LCDCFG1: LCD Controller Configuration Register 1
func (o *LCDC_Type) SetLCDCFG1_HSPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG1.Reg, volatile.LoadUint32(&o.LCDCFG1.Reg)&^(0x3f)|value)
}
func (o *LCDC_Type) GetLCDCFG1_HSPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG1.Reg) & 0x3f
}
func (o *LCDC_Type) SetLCDCFG1_VSPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG1.Reg, volatile.LoadUint32(&o.LCDCFG1.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG1_VSPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG1.Reg) & 0x3f0000) >> 16
}

// LCDC.LCDCFG2: LCD Controller Configuration Register 2
func (o *LCDC_Type) SetLCDCFG2_VFPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG2.Reg, volatile.LoadUint32(&o.LCDCFG2.Reg)&^(0x3f)|value)
}
func (o *LCDC_Type) GetLCDCFG2_VFPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG2.Reg) & 0x3f
}
func (o *LCDC_Type) SetLCDCFG2_VBPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG2.Reg, volatile.LoadUint32(&o.LCDCFG2.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG2_VBPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG2.Reg) & 0x3f0000) >> 16
}

// LCDC.LCDCFG3: LCD Controller Configuration Register 3
func (o *LCDC_Type) SetLCDCFG3_HFPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG3.Reg, volatile.LoadUint32(&o.LCDCFG3.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetLCDCFG3_HFPW() uint32 {
	return volatile.LoadUint32(&o.LCDCFG3.Reg) & 0xff
}
func (o *LCDC_Type) SetLCDCFG3_HBPW(value uint32) {
	volatile.StoreUint32(&o.LCDCFG3.Reg, volatile.LoadUint32(&o.LCDCFG3.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG3_HBPW() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG3.Reg) & 0xff0000) >> 16
}

// LCDC.LCDCFG4: LCD Controller Configuration Register 4
func (o *LCDC_Type) SetLCDCFG4_PPL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG4.Reg, volatile.LoadUint32(&o.LCDCFG4.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetLCDCFG4_PPL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG4.Reg) & 0x7ff
}
func (o *LCDC_Type) SetLCDCFG4_RPF(value uint32) {
	volatile.StoreUint32(&o.LCDCFG4.Reg, volatile.LoadUint32(&o.LCDCFG4.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG4_RPF() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG4.Reg) & 0x7ff0000) >> 16
}

// LCDC.LCDCFG5: LCD Controller Configuration Register 5
func (o *LCDC_Type) SetLCDCFG5_HSPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCFG5_HSPOL() uint32 {
	return volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCFG5_VSPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDCFG5_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDCFG5_VSPDLYS(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCFG5_VSPDLYS() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCFG5_VSPDLYE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDCFG5_VSPDLYE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDCFG5_DISPPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDCFG5_DISPPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDCFG5_DITHER(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCDCFG5_DITHER() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x40) >> 6
}
func (o *LCDC_Type) SetLCDCFG5_DISPDLY(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x80)|value<<7)
}
func (o *LCDC_Type) GetLCDCFG5_DISPDLY() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x80) >> 7
}
func (o *LCDC_Type) SetLCDCFG5_MODE(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG5_MODE() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x300) >> 8
}
func (o *LCDC_Type) SetLCDCFG5_VSPSU(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDCFG5_VSPSU() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDCFG5_VSPHO(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x2000)|value<<13)
}
func (o *LCDC_Type) GetLCDCFG5_VSPHO() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x2000) >> 13
}
func (o *LCDC_Type) SetLCDCFG5_GUARDTIME(value uint32) {
	volatile.StoreUint32(&o.LCDCFG5.Reg, volatile.LoadUint32(&o.LCDCFG5.Reg)&^(0x1f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDCFG5_GUARDTIME() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG5.Reg) & 0x1f0000) >> 16
}

// LCDC.LCDCFG6: LCD Controller Configuration Register 6
func (o *LCDC_Type) SetLCDCFG6_PWMPS(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0x7)|value)
}
func (o *LCDC_Type) GetLCDCFG6_PWMPS() uint32 {
	return volatile.LoadUint32(&o.LCDCFG6.Reg) & 0x7
}
func (o *LCDC_Type) SetLCDCFG6_PWMPOL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDCFG6_PWMPOL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG6.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDCFG6_PWMCVAL(value uint32) {
	volatile.StoreUint32(&o.LCDCFG6.Reg, volatile.LoadUint32(&o.LCDCFG6.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetLCDCFG6_PWMCVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDCFG6.Reg) & 0xff00) >> 8
}

// LCDC.LCDEN: LCD Controller Enable Register
func (o *LCDC_Type) SetLCDEN_CLKEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDEN_CLKEN() uint32 {
	return volatile.LoadUint32(&o.LCDEN.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDEN_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDEN_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDEN_DISPEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDEN_DISPEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDEN_PWMEN(value uint32) {
	volatile.StoreUint32(&o.LCDEN.Reg, volatile.LoadUint32(&o.LCDEN.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDEN_PWMEN() uint32 {
	return (volatile.LoadUint32(&o.LCDEN.Reg) & 0x8) >> 3
}

// LCDC.LCDDIS: LCD Controller Disable Register
func (o *LCDC_Type) SetLCDDIS_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDDIS_CLKDIS() uint32 {
	return volatile.LoadUint32(&o.LCDDIS.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDDIS_SYNCDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDDIS_SYNCDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDDIS_DISPDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDDIS_DISPDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDDIS_PWMDIS(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDDIS_PWMDIS() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDDIS_CLKRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDDIS_CLKRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDDIS_SYNCRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDDIS_SYNCRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDDIS_DISPRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDDIS_DISPRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDDIS_PWMRST(value uint32) {
	volatile.StoreUint32(&o.LCDDIS.Reg, volatile.LoadUint32(&o.LCDDIS.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDDIS_PWMRST() uint32 {
	return (volatile.LoadUint32(&o.LCDDIS.Reg) & 0x800) >> 11
}

// LCDC.LCDSR: LCD Controller Status Register
func (o *LCDC_Type) SetLCDSR_CLKSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDSR_CLKSTS() uint32 {
	return volatile.LoadUint32(&o.LCDSR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDSR_LCDSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDSR_LCDSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDSR_DISPSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDSR_DISPSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDSR_PWMSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetLCDSR_PWMSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetLCDSR_SIPSTS(value uint32) {
	volatile.StoreUint32(&o.LCDSR.Reg, volatile.LoadUint32(&o.LCDSR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDSR_SIPSTS() uint32 {
	return (volatile.LoadUint32(&o.LCDSR.Reg) & 0x10) >> 4
}

// LCDC.LCDIER: LCD Controller Interrupt Enable Register
func (o *LCDC_Type) SetLCDIER_SOFIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIER_SOFIE() uint32 {
	return volatile.LoadUint32(&o.LCDIER.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIER_DISIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIER_DISIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIER_DISPIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIER_DISPIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIER_FIFOERRIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIER_FIFOERRIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIER_BASEIE(value uint32) {
	volatile.StoreUint32(&o.LCDIER.Reg, volatile.LoadUint32(&o.LCDIER.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIER_BASEIE() uint32 {
	return (volatile.LoadUint32(&o.LCDIER.Reg) & 0x100) >> 8
}

// LCDC.LCDIDR: LCD Controller Interrupt Disable Register
func (o *LCDC_Type) SetLCDIDR_SOFID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIDR_SOFID() uint32 {
	return volatile.LoadUint32(&o.LCDIDR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIDR_DISID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIDR_DISID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIDR_DISPID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIDR_DISPID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIDR_FIFOERRID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIDR_FIFOERRID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIDR_BASEID(value uint32) {
	volatile.StoreUint32(&o.LCDIDR.Reg, volatile.LoadUint32(&o.LCDIDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIDR_BASEID() uint32 {
	return (volatile.LoadUint32(&o.LCDIDR.Reg) & 0x100) >> 8
}

// LCDC.LCDIMR: LCD Controller Interrupt Mask Register
func (o *LCDC_Type) SetLCDIMR_SOFIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDIMR_SOFIM() uint32 {
	return volatile.LoadUint32(&o.LCDIMR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDIMR_DISIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDIMR_DISIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDIMR_DISPIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDIMR_DISPIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDIMR_FIFOERRIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDIMR_FIFOERRIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDIMR_BASEIM(value uint32) {
	volatile.StoreUint32(&o.LCDIMR.Reg, volatile.LoadUint32(&o.LCDIMR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDIMR_BASEIM() uint32 {
	return (volatile.LoadUint32(&o.LCDIMR.Reg) & 0x100) >> 8
}

// LCDC.LCDISR: LCD Controller Interrupt Status Register
func (o *LCDC_Type) SetLCDISR_SOF(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDISR_SOF() uint32 {
	return volatile.LoadUint32(&o.LCDISR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDISR_DIS(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCDISR_DIS() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCDISR_DISP(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDISR_DISP() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDISR_FIFOERR(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCDISR_FIFOERR() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCDISR_BASE(value uint32) {
	volatile.StoreUint32(&o.LCDISR.Reg, volatile.LoadUint32(&o.LCDISR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDISR_BASE() uint32 {
	return (volatile.LoadUint32(&o.LCDISR.Reg) & 0x100) >> 8
}

// LCDC.BASECHER: Base Layer Channel Enable Register
func (o *LCDC_Type) SetBASECHER_CHEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHER_CHEN() uint32 {
	return volatile.LoadUint32(&o.BASECHER.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHER_UPDATEEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECHER_UPDATEEN() uint32 {
	return (volatile.LoadUint32(&o.BASECHER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECHER_A2QEN(value uint32) {
	volatile.StoreUint32(&o.BASECHER.Reg, volatile.LoadUint32(&o.BASECHER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECHER_A2QEN() uint32 {
	return (volatile.LoadUint32(&o.BASECHER.Reg) & 0x4) >> 2
}

// LCDC.BASECHDR: Base Layer Channel Disable Register
func (o *LCDC_Type) SetBASECHDR_CHDIS(value uint32) {
	volatile.StoreUint32(&o.BASECHDR.Reg, volatile.LoadUint32(&o.BASECHDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHDR_CHDIS() uint32 {
	return volatile.LoadUint32(&o.BASECHDR.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHDR_CHRST(value uint32) {
	volatile.StoreUint32(&o.BASECHDR.Reg, volatile.LoadUint32(&o.BASECHDR.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECHDR_CHRST() uint32 {
	return (volatile.LoadUint32(&o.BASECHDR.Reg) & 0x100) >> 8
}

// LCDC.BASECHSR: Base Layer Channel Status Register
func (o *LCDC_Type) SetBASECHSR_CHSR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECHSR_CHSR() uint32 {
	return volatile.LoadUint32(&o.BASECHSR.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECHSR_UPDATESR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECHSR_UPDATESR() uint32 {
	return (volatile.LoadUint32(&o.BASECHSR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECHSR_A2QSR(value uint32) {
	volatile.StoreUint32(&o.BASECHSR.Reg, volatile.LoadUint32(&o.BASECHSR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECHSR_A2QSR() uint32 {
	return (volatile.LoadUint32(&o.BASECHSR.Reg) & 0x4) >> 2
}

// LCDC.BASEIER: Base Layer Interrupt Enable Register
func (o *LCDC_Type) SetBASEIER_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIER_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIER_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIER_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIER_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIER_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIER_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIER_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIER_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIER.Reg, volatile.LoadUint32(&o.BASEIER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIER_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIER.Reg) & 0x40) >> 6
}

// LCDC.BASEIDR: Base Layer Interrupt Disabled Register
func (o *LCDC_Type) SetBASEIDR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIDR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIDR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIDR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIDR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIDR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIDR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIDR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIDR.Reg, volatile.LoadUint32(&o.BASEIDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIDR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIDR.Reg) & 0x40) >> 6
}

// LCDC.BASEIMR: Base Layer Interrupt Mask Register
func (o *LCDC_Type) SetBASEIMR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEIMR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEIMR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEIMR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEIMR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEIMR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEIMR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEIMR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEIMR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEIMR.Reg, volatile.LoadUint32(&o.BASEIMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEIMR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEIMR.Reg) & 0x40) >> 6
}

// LCDC.BASEISR: Base Layer Interrupt status Register
func (o *LCDC_Type) SetBASEISR_DMA(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASEISR_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASEISR_DSCR(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASEISR_DSCR() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASEISR_ADD(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASEISR_ADD() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASEISR_DONE(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASEISR_DONE() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetBASEISR_OVR(value uint32) {
	volatile.StoreUint32(&o.BASEISR.Reg, volatile.LoadUint32(&o.BASEISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetBASEISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.BASEISR.Reg) & 0x40) >> 6
}

// LCDC.BASEHEAD: Base Layer DMA Head Register
func (o *LCDC_Type) SetBASEHEAD_HEAD(value uint32) {
	volatile.StoreUint32(&o.BASEHEAD.Reg, volatile.LoadUint32(&o.BASEHEAD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetBASEHEAD_HEAD() uint32 {
	return (volatile.LoadUint32(&o.BASEHEAD.Reg) & 0xfffffffc) >> 2
}

// LCDC.BASEADDR: Base Layer DMA Address Register
func (o *LCDC_Type) SetBASEADDR(value uint32) {
	volatile.StoreUint32(&o.BASEADDR.Reg, value)
}
func (o *LCDC_Type) GetBASEADDR() uint32 {
	return volatile.LoadUint32(&o.BASEADDR.Reg)
}

// LCDC.BASECTRL: Base Layer DMA Control Register
func (o *LCDC_Type) SetBASECTRL_DFETCH(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECTRL_DFETCH() uint32 {
	return volatile.LoadUint32(&o.BASECTRL.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECTRL_LFETCH(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetBASECTRL_LFETCH() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetBASECTRL_DMAIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetBASECTRL_DMAIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetBASECTRL_DSCRIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetBASECTRL_DSCRIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetBASECTRL_ADDIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetBASECTRL_ADDIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetBASECTRL_DONEIEN(value uint32) {
	volatile.StoreUint32(&o.BASECTRL.Reg, volatile.LoadUint32(&o.BASECTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetBASECTRL_DONEIEN() uint32 {
	return (volatile.LoadUint32(&o.BASECTRL.Reg) & 0x20) >> 5
}

// LCDC.BASENEXT: Base Layer DMA Next Register
func (o *LCDC_Type) SetBASENEXT(value uint32) {
	volatile.StoreUint32(&o.BASENEXT.Reg, value)
}
func (o *LCDC_Type) GetBASENEXT() uint32 {
	return volatile.LoadUint32(&o.BASENEXT.Reg)
}

// LCDC.BASECFG0: Base Layer Configuration Register 0
func (o *LCDC_Type) SetBASECFG0_BLEN(value uint32) {
	volatile.StoreUint32(&o.BASECFG0.Reg, volatile.LoadUint32(&o.BASECFG0.Reg)&^(0x30)|value<<4)
}
func (o *LCDC_Type) GetBASECFG0_BLEN() uint32 {
	return (volatile.LoadUint32(&o.BASECFG0.Reg) & 0x30) >> 4
}
func (o *LCDC_Type) SetBASECFG0_DLBO(value uint32) {
	volatile.StoreUint32(&o.BASECFG0.Reg, volatile.LoadUint32(&o.BASECFG0.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECFG0_DLBO() uint32 {
	return (volatile.LoadUint32(&o.BASECFG0.Reg) & 0x100) >> 8
}

// LCDC.BASECFG1: Base Layer Configuration Register 1
func (o *LCDC_Type) SetBASECFG1_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetBASECFG1_CLUTEN() uint32 {
	return volatile.LoadUint32(&o.BASECFG1.Reg) & 0x1
}
func (o *LCDC_Type) SetBASECFG1_RGBMODE(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0xf0)|value<<4)
}
func (o *LCDC_Type) GetBASECFG1_RGBMODE() uint32 {
	return (volatile.LoadUint32(&o.BASECFG1.Reg) & 0xf0) >> 4
}
func (o *LCDC_Type) SetBASECFG1_CLUTMODE(value uint32) {
	volatile.StoreUint32(&o.BASECFG1.Reg, volatile.LoadUint32(&o.BASECFG1.Reg)&^(0x300)|value<<8)
}
func (o *LCDC_Type) GetBASECFG1_CLUTMODE() uint32 {
	return (volatile.LoadUint32(&o.BASECFG1.Reg) & 0x300) >> 8
}

// LCDC.BASECFG2: Base Layer Configuration Register 2
func (o *LCDC_Type) SetBASECFG2(value uint32) {
	volatile.StoreUint32(&o.BASECFG2.Reg, value)
}
func (o *LCDC_Type) GetBASECFG2() uint32 {
	return volatile.LoadUint32(&o.BASECFG2.Reg)
}

// LCDC.BASECFG3: Base Layer Configuration Register 3
func (o *LCDC_Type) SetBASECFG3_BDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetBASECFG3_BDEF() uint32 {
	return volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff
}
func (o *LCDC_Type) SetBASECFG3_GDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetBASECFG3_GDEF() uint32 {
	return (volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetBASECFG3_RDEF(value uint32) {
	volatile.StoreUint32(&o.BASECFG3.Reg, volatile.LoadUint32(&o.BASECFG3.Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECFG3_RDEF() uint32 {
	return (volatile.LoadUint32(&o.BASECFG3.Reg) & 0xff0000) >> 16
}

// LCDC.BASECFG4: Base Layer Configuration Register 4
func (o *LCDC_Type) SetBASECFG4_DMA(value uint32) {
	volatile.StoreUint32(&o.BASECFG4.Reg, volatile.LoadUint32(&o.BASECFG4.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetBASECFG4_DMA() uint32 {
	return (volatile.LoadUint32(&o.BASECFG4.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetBASECFG4_REP(value uint32) {
	volatile.StoreUint32(&o.BASECFG4.Reg, volatile.LoadUint32(&o.BASECFG4.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetBASECFG4_REP() uint32 {
	return (volatile.LoadUint32(&o.BASECFG4.Reg) & 0x200) >> 9
}

// LCDC.BASECLUT: Base CLUT Register
func (o *LCDC_Type) SetBASECLUT_BCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetBASECLUT_BCLUT(idx int) uint32 {
	return volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff
}
func (o *LCDC_Type) SetBASECLUT_GCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetBASECLUT_GCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetBASECLUT_RCLUT(idx int, value uint32) {
	volatile.StoreUint32(&o.BASECLUT[idx].Reg, volatile.LoadUint32(&o.BASECLUT[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *LCDC_Type) GetBASECLUT_RCLUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.BASECLUT[idx].Reg) & 0xff0000) >> 16
}

// USB Device Port
type UDP_Type struct {
	FRM_NUM  volatile.Register32 // 0x0
	GLB_STAT volatile.Register32 // 0x4
	FADDR    volatile.Register32 // 0x8
	_        [4]byte
	IER      volatile.Register32 // 0x10
	IDR      volatile.Register32 // 0x14
	IMR      volatile.Register32 // 0x18
	ISR      volatile.Register32 // 0x1C
	ICR      volatile.Register32 // 0x20
	_        [4]byte
	RST_EP   volatile.Register32 // 0x28
	_        [4]byte
	CSR      [6]volatile.Register32 // 0x30
	_        [8]byte
	FDR      [6]volatile.Register32 // 0x50
	_        [12]byte
	TXVC     volatile.Register32 // 0x74
}

// UDP.FRM_NUM: Frame Number Register
func (o *UDP_Type) SetFRM_NUM(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x7ff)|value)
}
func (o *UDP_Type) GetFRM_NUM() uint32 {
	return volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x7ff
}
func (o *UDP_Type) SetFRM_NUM_FRM_ERR(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x10000)|value<<16)
}
func (o *UDP_Type) GetFRM_NUM_FRM_ERR() uint32 {
	return (volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x10000) >> 16
}
func (o *UDP_Type) SetFRM_NUM_FRM_OK(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x20000)|value<<17)
}
func (o *UDP_Type) GetFRM_NUM_FRM_OK() uint32 {
	return (volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x20000) >> 17
}

// UDP.GLB_STAT: Global State Register
func (o *UDP_Type) SetGLB_STAT_FADDEN(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetGLB_STAT_FADDEN() uint32 {
	return volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x1
}
func (o *UDP_Type) SetGLB_STAT_CONFG(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetGLB_STAT_CONFG() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetGLB_STAT_ESR(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetGLB_STAT_ESR() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetGLB_STAT_RSMINPR(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetGLB_STAT_RSMINPR() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetGLB_STAT_RMWUPE(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetGLB_STAT_RMWUPE() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x10) >> 4
}

// UDP.FADDR: Function Address Register
func (o *UDP_Type) SetFADDR_FADD(value uint32) {
	volatile.StoreUint32(&o.FADDR.Reg, volatile.LoadUint32(&o.FADDR.Reg)&^(0x7f)|value)
}
func (o *UDP_Type) GetFADDR_FADD() uint32 {
	return volatile.LoadUint32(&o.FADDR.Reg) & 0x7f
}
func (o *UDP_Type) SetFADDR_FEN(value uint32) {
	volatile.StoreUint32(&o.FADDR.Reg, volatile.LoadUint32(&o.FADDR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetFADDR_FEN() uint32 {
	return (volatile.LoadUint32(&o.FADDR.Reg) & 0x100) >> 8
}

// UDP.IER: Interrupt Enable Register
func (o *UDP_Type) SetIER_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIER_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UDP_Type) SetIER_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIER_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIER_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIER_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIER_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIER_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIER_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIER_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIER_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIER_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIER_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIER_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIER_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIER_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIER_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetIER_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetIER_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIER_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIER_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIER_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// UDP.IDR: Interrupt Disable Register
func (o *UDP_Type) SetIDR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIDR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UDP_Type) SetIDR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIDR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIDR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIDR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIDR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIDR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIDR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIDR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIDR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIDR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIDR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIDR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIDR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIDR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIDR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetIDR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetIDR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIDR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIDR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIDR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}

// UDP.IMR: Interrupt Mask Register
func (o *UDP_Type) SetIMR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIMR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UDP_Type) SetIMR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIMR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIMR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIMR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIMR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIMR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIMR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIMR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIMR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIMR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIMR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIMR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIMR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIMR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIMR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetIMR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetIMR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIMR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIMR_BIT12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetIMR_BIT12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetIMR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIMR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}

// UDP.ISR: Interrupt Status Register
func (o *UDP_Type) SetISR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetISR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *UDP_Type) SetISR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetISR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetISR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetISR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetISR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetISR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetISR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetISR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetISR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetISR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetISR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetISR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetISR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetISR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetISR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetISR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetISR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetISR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetISR_ENDBUSRES(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetISR_ENDBUSRES() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetISR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetISR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// UDP.ICR: Interrupt Clear Register
func (o *UDP_Type) SetICR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetICR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetICR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetICR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetICR_EXTRSM(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *UDP_Type) GetICR_EXTRSM() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *UDP_Type) SetICR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetICR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetICR_ENDBUSRES(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetICR_ENDBUSRES() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetICR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetICR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}

// UDP.RST_EP: Reset Endpoint Register
func (o *UDP_Type) SetRST_EP_EP0(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetRST_EP_EP0() uint32 {
	return volatile.LoadUint32(&o.RST_EP.Reg) & 0x1
}
func (o *UDP_Type) SetRST_EP_EP1(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetRST_EP_EP1() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetRST_EP_EP2(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetRST_EP_EP2() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetRST_EP_EP3(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetRST_EP_EP3() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetRST_EP_EP4(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetRST_EP_EP4() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetRST_EP_EP5(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetRST_EP_EP5() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x20) >> 5
}

// UDP.CSR: Endpoint Control and Status Register
func (o *UDP_Type) SetCSR_TXCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetCSR_TXCOMP(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *UDP_Type) SetCSR_RX_DATA_BK0(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetCSR_RX_DATA_BK0(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetCSR_RXSETUP(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetCSR_RXSETUP(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetCSR_STALLSENT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetCSR_STALLSENT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetCSR_TXPKTRDY(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetCSR_TXPKTRDY(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetCSR_FORCESTALL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetCSR_FORCESTALL(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetCSR_RX_DATA_BK1(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetCSR_RX_DATA_BK1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetCSR_DIR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetCSR_DIR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x80) >> 7
}
func (o *UDP_Type) SetCSR_EPTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x700)|value<<8)
}
func (o *UDP_Type) GetCSR_EPTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x700) >> 8
}
func (o *UDP_Type) SetCSR_DTGLE(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetCSR_DTGLE(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetCSR_EPEDS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *UDP_Type) GetCSR_EPEDS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8000) >> 15
}
func (o *UDP_Type) SetCSR_RXBYTECNT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x7ff0000)|value<<16)
}
func (o *UDP_Type) GetCSR_RXBYTECNT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x7ff0000) >> 16
}

// UDP.FDR: Endpoint FIFO Data Register
func (o *UDP_Type) SetFDR_FIFO_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.FDR[idx].Reg, volatile.LoadUint32(&o.FDR[idx].Reg)&^(0xff)|value)
}
func (o *UDP_Type) GetFDR_FIFO_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.FDR[idx].Reg) & 0xff
}

// UDP.TXVC: Transceiver Control Register
func (o *UDP_Type) SetTXVC_TXVDIS(value uint32) {
	volatile.StoreUint32(&o.TXVC.Reg, volatile.LoadUint32(&o.TXVC.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetTXVC_TXVDIS() uint32 {
	return (volatile.LoadUint32(&o.TXVC.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetTXVC_PUON(value uint32) {
	volatile.StoreUint32(&o.TXVC.Reg, volatile.LoadUint32(&o.TXVC.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetTXVC_PUON() uint32 {
	return (volatile.LoadUint32(&o.TXVC.Reg) & 0x200) >> 9
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// TRNG.CR: Control Register
func (o *TRNG_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TRNG_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TRNG_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffffff00) >> 8
}

// TRNG.IER: Interrupt Enable Register
func (o *TRNG_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// TRNG.IDR: Interrupt Disable Register
func (o *TRNG_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// TRNG.IMR: Interrupt Mask Register
func (o *TRNG_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// TRNG.ISR: Interrupt Status Register
func (o *TRNG_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// TRNG.ODATA: Output Data Register
func (o *TRNG_Type) SetODATA(value uint32) {
	volatile.StoreUint32(&o.ODATA.Reg, value)
}
func (o *TRNG_Type) GetODATA() uint32 {
	return volatile.LoadUint32(&o.ODATA.Reg)
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	SEQR1  volatile.Register32 // 0x8
	SEQR2  volatile.Register32 // 0xC
	CHER   volatile.Register32 // 0x10
	CHDR   volatile.Register32 // 0x14
	CHSR   volatile.Register32 // 0x18
	_      [4]byte
	LCDR   volatile.Register32 // 0x20
	IER    volatile.Register32 // 0x24
	IDR    volatile.Register32 // 0x28
	IMR    volatile.Register32 // 0x2C
	ISR    volatile.Register32 // 0x30
	_      [8]byte
	OVER   volatile.Register32 // 0x3C
	EMR    volatile.Register32 // 0x40
	CWR    volatile.Register32 // 0x44
	_      [8]byte
	CDR    [12]volatile.Register32 // 0x50
	_      [20]byte
	ACR    volatile.Register32 // 0x94
	_      [24]byte
	TSMR   volatile.Register32 // 0xB0
	XPOSR  volatile.Register32 // 0xB4
	YPOSR  volatile.Register32 // 0xB8
	PRESSR volatile.Register32 // 0xBC
	TRGR   volatile.Register32 // 0xC0
	_      [32]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// ADC.CR: Control Register
func (o *ADC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_TSCALIB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_TSCALIB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// ADC.MR: Mode Register
func (o *ADC_Type) SetMR_LOWRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetMR_LOWRES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// ADC.SEQR1: Channel Sequence Register 1
func (o *ADC_Type) SetSEQR1_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR1_USCH1() uint32 {
	return volatile.LoadUint32(&o.SEQR1.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR1_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR1_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR1_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR1_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR1_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR1_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR1_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR1_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR1_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR1_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR1_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR1_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR1_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR1_USCH8() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000000) >> 28
}

// ADC.SEQR2: Channel Sequence Register 2
func (o *ADC_Type) SetSEQR2_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR2_USCH9() uint32 {
	return volatile.LoadUint32(&o.SEQR2.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR2_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR2_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR2_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR2_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR2_USCH12(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR2_USCH12() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR2_USCH13(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR2_USCH13() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR2_USCH14(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR2_USCH14() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR2_USCH15(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR2_USCH15() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR2_USCH16(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR2_USCH16() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000000) >> 28
}

// ADC.CHER: Channel Enable Register
func (o *ADC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}

// ADC.CHDR: Channel Disable Register
func (o *ADC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}

// ADC.CHSR: Channel Status Register
func (o *ADC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}

// ADC.LCDR: Last Converted Data Register
func (o *ADC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xfff
}
func (o *ADC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000) >> 12
}

// ADC.IER: Interrupt Enable Register
func (o *ADC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_XRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIER_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIER_YRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIER_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIER_PRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIER_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIER_PEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIER_PEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIER_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIER_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}

// ADC.IDR: Interrupt Disable Register
func (o *ADC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIDR_XRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIDR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIDR_YRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIDR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIDR_PRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIDR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIDR_PEN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIDR_PEN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIDR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIDR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}

// ADC.IMR: Interrupt Mask Register
func (o *ADC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIMR_XRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetIMR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetIMR_YRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetIMR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetIMR_PRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetIMR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIMR_PEN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetIMR_PEN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetIMR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetIMR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}

// ADC.ISR: Interrupt Status Register
func (o *ADC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_XRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetISR_XRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetISR_YRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetISR_YRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetISR_PRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetISR_PRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetISR_PEN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetISR_PEN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetISR_NOPEN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetISR_NOPEN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetISR_PENS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetISR_PENS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// ADC.OVER: Overrun Status Register
func (o *ADC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *ADC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}

// ADC.EMR: Extended Mode Register
func (o *ADC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *ADC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}

// ADC.CWR: Compare Window Register
func (o *ADC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xfff
}
func (o *ADC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xfff0000) >> 16
}

// ADC.CDR: Channel Data Register
func (o *ADC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xfff
}

// ADC.ACR: Analog Control Register
func (o *ADC_Type) SetACR_PENDETSENS(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetACR_PENDETSENS() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}

// ADC.TSMR: Touchscreen Mode Register
func (o *ADC_Type) SetTSMR_TSMODE(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetTSMR_TSMODE() uint32 {
	return volatile.LoadUint32(&o.TSMR.Reg) & 0x3
}
func (o *ADC_Type) SetTSMR_TSAV(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetTSMR_TSAV() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetTSMR_TSFREQ(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetTSMR_TSFREQ() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetTSMR_TSSCTIM(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetTSMR_TSSCTIM() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetTSMR_NOTSDMA(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetTSMR_NOTSDMA() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetTSMR_PENDET(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetTSMR_PENDET() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetTSMR_PENDBC(value uint32) {
	volatile.StoreUint32(&o.TSMR.Reg, volatile.LoadUint32(&o.TSMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetTSMR_PENDBC() uint32 {
	return (volatile.LoadUint32(&o.TSMR.Reg) & 0xf0000000) >> 28
}

// ADC.XPOSR: Touchscreen X Position Register
func (o *ADC_Type) SetXPOSR_XPOS(value uint32) {
	volatile.StoreUint32(&o.XPOSR.Reg, volatile.LoadUint32(&o.XPOSR.Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetXPOSR_XPOS() uint32 {
	return volatile.LoadUint32(&o.XPOSR.Reg) & 0x3ff
}
func (o *ADC_Type) SetXPOSR_XSCALE(value uint32) {
	volatile.StoreUint32(&o.XPOSR.Reg, volatile.LoadUint32(&o.XPOSR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ADC_Type) GetXPOSR_XSCALE() uint32 {
	return (volatile.LoadUint32(&o.XPOSR.Reg) & 0x3ff0000) >> 16
}

// ADC.YPOSR: Touchscreen Y Position Register
func (o *ADC_Type) SetYPOSR_YPOS(value uint32) {
	volatile.StoreUint32(&o.YPOSR.Reg, volatile.LoadUint32(&o.YPOSR.Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetYPOSR_YPOS() uint32 {
	return volatile.LoadUint32(&o.YPOSR.Reg) & 0x3ff
}
func (o *ADC_Type) SetYPOSR_YSCALE(value uint32) {
	volatile.StoreUint32(&o.YPOSR.Reg, volatile.LoadUint32(&o.YPOSR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ADC_Type) GetYPOSR_YSCALE() uint32 {
	return (volatile.LoadUint32(&o.YPOSR.Reg) & 0x3ff0000) >> 16
}

// ADC.PRESSR: Touchscreen Pressure Register
func (o *ADC_Type) SetPRESSR_Z1(value uint32) {
	volatile.StoreUint32(&o.PRESSR.Reg, volatile.LoadUint32(&o.PRESSR.Reg)&^(0x3ff)|value)
}
func (o *ADC_Type) GetPRESSR_Z1() uint32 {
	return volatile.LoadUint32(&o.PRESSR.Reg) & 0x3ff
}
func (o *ADC_Type) SetPRESSR_Z2(value uint32) {
	volatile.StoreUint32(&o.PRESSR.Reg, volatile.LoadUint32(&o.PRESSR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ADC_Type) GetPRESSR_Z2() uint32 {
	return (volatile.LoadUint32(&o.PRESSR.Reg) & 0x3ff0000) >> 16
}

// ADC.TRGR: Trigger Register
func (o *ADC_Type) SetTRGR_TRGMOD(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetTRGR_TRGMOD() uint32 {
	return volatile.LoadUint32(&o.TRGR.Reg) & 0x7
}
func (o *ADC_Type) SetTRGR_TRGPER(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0xffff0000)|value<<16)
}
func (o *ADC_Type) GetTRGR_TRGPER() uint32 {
	return (volatile.LoadUint32(&o.TRGR.Reg) & 0xffff0000) >> 16
}

// ADC.WPMR: Write Protect Mode Register
func (o *ADC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ADC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ADC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ADC.WPSR: Write Protect Status Register
func (o *ADC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ADC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ADC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Fuse Controller
type FUSE_Type struct {
	CR volatile.Register32     // 0x0
	MR volatile.Register32     // 0x4
	IR volatile.Register32     // 0x8
	DR volatile.Register32     // 0xC
	SR [10]volatile.Register32 // 0x10
}

// FUSE.CR: Fuse Control Register
func (o *FUSE_Type) SetCR_WRQ(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FUSE_Type) GetCR_WRQ() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FUSE_Type) SetCR_RRQ(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FUSE_Type) GetCR_RRQ() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FUSE_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *FUSE_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}

// FUSE.MR: Fuse Mode Register
func (o *FUSE_Type) SetMR_MSK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *FUSE_Type) GetMR_MSK() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}

// FUSE.IR: Fuse Index Register
func (o *FUSE_Type) SetIR_WS(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *FUSE_Type) GetIR_WS() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *FUSE_Type) SetIR_RS(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *FUSE_Type) GetIR_RS() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *FUSE_Type) SetIR_WSEL(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xf00)|value<<8)
}
func (o *FUSE_Type) GetIR_WSEL() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xf00) >> 8
}

// FUSE.DR: Fuse Data Register
func (o *FUSE_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *FUSE_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// FUSE.SR: Fuse Status Register
func (o *FUSE_Type) SetSR(idx int, value uint32) {
	volatile.StoreUint32(&o.SR[idx].Reg, value)
}
func (o *FUSE_Type) GetSR(idx int) uint32 {
	return volatile.LoadUint32(&o.SR[idx].Reg)
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [6]volatile.Register32 // 0x0
	_     [40]byte
	SCFG  [5]volatile.Register32 // 0x40
	_     [44]byte
	PRAS0 volatile.Register32 // 0x80
	_     [4]byte
	PRAS1 volatile.Register32 // 0x88
	_     [4]byte
	PRAS2 volatile.Register32 // 0x90
	_     [4]byte
	PRAS3 volatile.Register32 // 0x98
	_     [4]byte
	PRAS4 volatile.Register32 // 0xA0
	_     [92]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MCFG[idx].Reg, volatile.LoadUint32(&o.MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MCFG[idx].Reg) & 0x7
}

// MATRIX.SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetSCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x1ff)|value)
}
func (o *MATRIX_Type) GetSCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x1ff
}
func (o *MATRIX_Type) SetSCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetSCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetSCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x3c0000)|value<<18)
}
func (o *MATRIX_Type) GetSCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x3c0000) >> 18
}

// MATRIX.PRAS0: Priority Register A for Slave 0
func (o *MATRIX_Type) SetPRAS0_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS0_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS0_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS0_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS0_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS0_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS0_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS0_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS0_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS0_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS0_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS0_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x300000) >> 20
}

// MATRIX.PRAS1: Priority Register A for Slave 1
func (o *MATRIX_Type) SetPRAS1_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS1_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS1_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS1_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS1_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS1_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS1_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS1_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS1_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS1_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS1_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS1_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x300000) >> 20
}

// MATRIX.PRAS2: Priority Register A for Slave 2
func (o *MATRIX_Type) SetPRAS2_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS2_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS2_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS2_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS2_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS2_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS2_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS2_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS2_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS2_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS2_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS2_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x300000) >> 20
}

// MATRIX.PRAS3: Priority Register A for Slave 3
func (o *MATRIX_Type) SetPRAS3_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS3_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS3_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS3_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS3_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS3_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS3_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS3_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS3_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS3_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS3_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS3_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x300000) >> 20
}

// MATRIX.PRAS4: Priority Register A for Slave 4
func (o *MATRIX_Type) SetPRAS4_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS4_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS4_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS4_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS4_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS4_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS4_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS4_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS4_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS4_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS4_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS4_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x300000) >> 20
}

// MATRIX.MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetMRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetMRCR_RCB5(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetMRCR_RCB5() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x20) >> 5
}

// MATRIX.WPMR: Write Protect Mode Register
func (o *MATRIX_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.WPSR: Write Protect Status Register
func (o *MATRIX_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Programmable Multibit Error Corrected Code Controller
type EBI_Type struct {
	CFG     volatile.Register32 // 0x0
	SAREA   volatile.Register32 // 0x4
	SADDR   volatile.Register32 // 0x8
	EADDR   volatile.Register32 // 0xC
	CLK     volatile.Register32 // 0x10
	CTRL    volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	IER     volatile.Register32 // 0x1C
	IDR     volatile.Register32 // 0x20
	IMR     volatile.Register32 // 0x24
	ISR     volatile.Register32 // 0x28
	_       [20]byte
	ECC0_0  volatile.Register32 // 0x40
	ECC1_0  volatile.Register32 // 0x44
	ECC2_0  volatile.Register32 // 0x48
	ECC3_0  volatile.Register32 // 0x4C
	ECC4_0  volatile.Register32 // 0x50
	ECC5_0  volatile.Register32 // 0x54
	ECC6_0  volatile.Register32 // 0x58
	ECC7_0  volatile.Register32 // 0x5C
	ECC8_0  volatile.Register32 // 0x60
	ECC9_0  volatile.Register32 // 0x64
	ECC10_0 volatile.Register32 // 0x68
	_       [20]byte
	ECC0_1  volatile.Register32 // 0x80
	ECC1_1  volatile.Register32 // 0x84
	ECC2_1  volatile.Register32 // 0x88
	ECC3_1  volatile.Register32 // 0x8C
	ECC4_1  volatile.Register32 // 0x90
	ECC5_1  volatile.Register32 // 0x94
	ECC6_1  volatile.Register32 // 0x98
	ECC7_1  volatile.Register32 // 0x9C
	ECC8_1  volatile.Register32 // 0xA0
	ECC9_1  volatile.Register32 // 0xA4
	ECC10_1 volatile.Register32 // 0xA8
	_       [20]byte
	ECC0_2  volatile.Register32 // 0xC0
	ECC1_2  volatile.Register32 // 0xC4
	ECC2_2  volatile.Register32 // 0xC8
	ECC3_2  volatile.Register32 // 0xCC
	ECC4_2  volatile.Register32 // 0xD0
	ECC5_2  volatile.Register32 // 0xD4
	ECC6_2  volatile.Register32 // 0xD8
	ECC7_2  volatile.Register32 // 0xDC
	ECC8_2  volatile.Register32 // 0xE0
	ECC9_2  volatile.Register32 // 0xE4
	ECC10_2 volatile.Register32 // 0xE8
	_       [20]byte
	ECC0_3  volatile.Register32 // 0x100
	ECC1_3  volatile.Register32 // 0x104
	ECC2_3  volatile.Register32 // 0x108
	ECC3_3  volatile.Register32 // 0x10C
	ECC4_3  volatile.Register32 // 0x110
	ECC5_3  volatile.Register32 // 0x114
	ECC6_3  volatile.Register32 // 0x118
	ECC7_3  volatile.Register32 // 0x11C
	ECC8_3  volatile.Register32 // 0x120
	ECC9_3  volatile.Register32 // 0x124
	ECC10_3 volatile.Register32 // 0x128
	_       [20]byte
	ECC0_4  volatile.Register32 // 0x140
	ECC1_4  volatile.Register32 // 0x144
	ECC2_4  volatile.Register32 // 0x148
	ECC3_4  volatile.Register32 // 0x14C
	ECC4_4  volatile.Register32 // 0x150
	ECC5_4  volatile.Register32 // 0x154
	ECC6_4  volatile.Register32 // 0x158
	ECC7_4  volatile.Register32 // 0x15C
	ECC8_4  volatile.Register32 // 0x160
	ECC9_4  volatile.Register32 // 0x164
	ECC10_4 volatile.Register32 // 0x168
	_       [20]byte
	ECC0_5  volatile.Register32 // 0x180
	ECC1_5  volatile.Register32 // 0x184
	ECC2_5  volatile.Register32 // 0x188
	ECC3_5  volatile.Register32 // 0x18C
	ECC4_5  volatile.Register32 // 0x190
	ECC5_5  volatile.Register32 // 0x194
	ECC6_5  volatile.Register32 // 0x198
	ECC7_5  volatile.Register32 // 0x19C
	ECC8_5  volatile.Register32 // 0x1A0
	ECC9_5  volatile.Register32 // 0x1A4
	ECC10_5 volatile.Register32 // 0x1A8
	_       [20]byte
	ECC0_6  volatile.Register32 // 0x1C0
	ECC1_6  volatile.Register32 // 0x1C4
	ECC2_6  volatile.Register32 // 0x1C8
	ECC3_6  volatile.Register32 // 0x1CC
	ECC4_6  volatile.Register32 // 0x1D0
	ECC5_6  volatile.Register32 // 0x1D4
	ECC6_6  volatile.Register32 // 0x1D8
	ECC7_6  volatile.Register32 // 0x1DC
	ECC8_6  volatile.Register32 // 0x1E0
	ECC9_6  volatile.Register32 // 0x1E4
	ECC10_6 volatile.Register32 // 0x1E8
	_       [20]byte
	ECC0_7  volatile.Register32 // 0x200
	ECC1_7  volatile.Register32 // 0x204
	ECC2_7  volatile.Register32 // 0x208
	ECC3_7  volatile.Register32 // 0x20C
	ECC4_7  volatile.Register32 // 0x210
	ECC5_7  volatile.Register32 // 0x214
	ECC6_7  volatile.Register32 // 0x218
	ECC7_7  volatile.Register32 // 0x21C
	ECC8_7  volatile.Register32 // 0x220
	ECC9_7  volatile.Register32 // 0x224
	ECC10_7 volatile.Register32 // 0x228
	_       [20]byte
	REM0_0  volatile.Register32 // 0x240
	REM1_0  volatile.Register32 // 0x244
	REM2_0  volatile.Register32 // 0x248
	REM3_0  volatile.Register32 // 0x24C
	REM4_0  volatile.Register32 // 0x250
	REM5_0  volatile.Register32 // 0x254
	REM6_0  volatile.Register32 // 0x258
	REM7_0  volatile.Register32 // 0x25C
	REM8_0  volatile.Register32 // 0x260
	REM9_0  volatile.Register32 // 0x264
	REM10_0 volatile.Register32 // 0x268
	REM11_0 volatile.Register32 // 0x26C
	_       [16]byte
	REM0_1  volatile.Register32 // 0x280
	REM1_1  volatile.Register32 // 0x284
	REM2_1  volatile.Register32 // 0x288
	REM3_1  volatile.Register32 // 0x28C
	REM4_1  volatile.Register32 // 0x290
	REM5_1  volatile.Register32 // 0x294
	REM6_1  volatile.Register32 // 0x298
	REM7_1  volatile.Register32 // 0x29C
	REM8_1  volatile.Register32 // 0x2A0
	REM9_1  volatile.Register32 // 0x2A4
	REM10_1 volatile.Register32 // 0x2A8
	REM11_1 volatile.Register32 // 0x2AC
	_       [16]byte
	REM0_2  volatile.Register32 // 0x2C0
	REM1_2  volatile.Register32 // 0x2C4
	REM2_2  volatile.Register32 // 0x2C8
	REM3_2  volatile.Register32 // 0x2CC
	REM4_2  volatile.Register32 // 0x2D0
	REM5_2  volatile.Register32 // 0x2D4
	REM6_2  volatile.Register32 // 0x2D8
	REM7_2  volatile.Register32 // 0x2DC
	REM8_2  volatile.Register32 // 0x2E0
	REM9_2  volatile.Register32 // 0x2E4
	REM10_2 volatile.Register32 // 0x2E8
	REM11_2 volatile.Register32 // 0x2EC
	_       [16]byte
	REM0_3  volatile.Register32 // 0x300
	REM1_3  volatile.Register32 // 0x304
	REM2_3  volatile.Register32 // 0x308
	REM3_3  volatile.Register32 // 0x30C
	REM4_3  volatile.Register32 // 0x310
	REM5_3  volatile.Register32 // 0x314
	REM6_3  volatile.Register32 // 0x318
	REM7_3  volatile.Register32 // 0x31C
	REM8_3  volatile.Register32 // 0x320
	REM9_3  volatile.Register32 // 0x324
	REM10_3 volatile.Register32 // 0x328
	REM11_3 volatile.Register32 // 0x32C
	_       [16]byte
	REM0_4  volatile.Register32 // 0x340
	REM1_4  volatile.Register32 // 0x344
	REM2_4  volatile.Register32 // 0x348
	REM3_4  volatile.Register32 // 0x34C
	REM4_4  volatile.Register32 // 0x350
	REM5_4  volatile.Register32 // 0x354
	REM6_4  volatile.Register32 // 0x358
	REM7_4  volatile.Register32 // 0x35C
	REM8_4  volatile.Register32 // 0x360
	REM9_4  volatile.Register32 // 0x364
	REM10_4 volatile.Register32 // 0x368
	REM11_4 volatile.Register32 // 0x36C
	_       [16]byte
	REM0_5  volatile.Register32 // 0x380
	REM1_5  volatile.Register32 // 0x384
	REM2_5  volatile.Register32 // 0x388
	REM3_5  volatile.Register32 // 0x38C
	REM4_5  volatile.Register32 // 0x390
	REM5_5  volatile.Register32 // 0x394
	REM6_5  volatile.Register32 // 0x398
	REM7_5  volatile.Register32 // 0x39C
	REM8_5  volatile.Register32 // 0x3A0
	REM9_5  volatile.Register32 // 0x3A4
	REM10_5 volatile.Register32 // 0x3A8
	REM11_5 volatile.Register32 // 0x3AC
	_       [16]byte
	REM0_6  volatile.Register32 // 0x3C0
	REM1_6  volatile.Register32 // 0x3C4
	REM2_6  volatile.Register32 // 0x3C8
	REM3_6  volatile.Register32 // 0x3CC
	REM4_6  volatile.Register32 // 0x3D0
	REM5_6  volatile.Register32 // 0x3D4
	REM6_6  volatile.Register32 // 0x3D8
	REM7_6  volatile.Register32 // 0x3DC
	REM8_6  volatile.Register32 // 0x3E0
	REM9_6  volatile.Register32 // 0x3E4
	REM10_6 volatile.Register32 // 0x3E8
	REM11_6 volatile.Register32 // 0x3EC
	_       [16]byte
	REM0_7  volatile.Register32 // 0x400
	REM1_7  volatile.Register32 // 0x404
	REM2_7  volatile.Register32 // 0x408
	REM3_7  volatile.Register32 // 0x40C
	REM4_7  volatile.Register32 // 0x410
	REM5_7  volatile.Register32 // 0x414
	REM6_7  volatile.Register32 // 0x418
	REM7_7  volatile.Register32 // 0x41C
	REM8_7  volatile.Register32 // 0x420
	REM9_7  volatile.Register32 // 0x424
	REM10_7 volatile.Register32 // 0x428
	REM11_7 volatile.Register32 // 0x42C
}

// EBI.CFG: PMECC Configuration Register
func (o *EBI_Type) SetCFG_BCH_ERR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetCFG_BCH_ERR() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x7
}
func (o *EBI_Type) SetCFG_SECTORSZ(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetCFG_SECTORSZ() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetCFG_PAGESIZE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x300)|value<<8)
}
func (o *EBI_Type) GetCFG_PAGESIZE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x300) >> 8
}
func (o *EBI_Type) SetCFG_NANDWR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *EBI_Type) GetCFG_NANDWR() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *EBI_Type) SetCFG_SPAREEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetCFG_SPAREEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetCFG_AUTO(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100000)|value<<20)
}
func (o *EBI_Type) GetCFG_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100000) >> 20
}

// EBI.SAREA: PMECC Spare Area Size Register
func (o *EBI_Type) SetSAREA_SPARESIZE(value uint32) {
	volatile.StoreUint32(&o.SAREA.Reg, volatile.LoadUint32(&o.SAREA.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetSAREA_SPARESIZE() uint32 {
	return volatile.LoadUint32(&o.SAREA.Reg) & 0x1ff
}

// EBI.SADDR: PMECC Start Address Register
func (o *EBI_Type) SetSADDR_STARTADDR(value uint32) {
	volatile.StoreUint32(&o.SADDR.Reg, volatile.LoadUint32(&o.SADDR.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetSADDR_STARTADDR() uint32 {
	return volatile.LoadUint32(&o.SADDR.Reg) & 0x1ff
}

// EBI.EADDR: PMECC End Address Register
func (o *EBI_Type) SetEADDR_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.EADDR.Reg, volatile.LoadUint32(&o.EADDR.Reg)&^(0x1ff)|value)
}
func (o *EBI_Type) GetEADDR_ENDADDR() uint32 {
	return volatile.LoadUint32(&o.EADDR.Reg) & 0x1ff
}

// EBI.CLK: PMECC Clock Control Register
func (o *EBI_Type) SetCLK_CLKCTRL(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetCLK_CLKCTRL() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x7
}

// EBI.CTRL: PMECC Control Register
func (o *EBI_Type) SetCTRL_RST(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetCTRL_RST() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *EBI_Type) SetCTRL_DATA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetCTRL_DATA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetCTRL_USER(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EBI_Type) GetCTRL_USER() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *EBI_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetCTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetCTRL_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EBI_Type) GetCTRL_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}

// EBI.SR: PMECC Status Register
func (o *EBI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetSR_BUSY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *EBI_Type) SetSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetSR_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}

// EBI.IER: PMECC Interrupt Enable register
func (o *EBI_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIER_ERRIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// EBI.IDR: PMECC Interrupt Disable Register
func (o *EBI_Type) SetIDR_ERRID(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIDR_ERRID() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// EBI.IMR: PMECC Interrupt Mask Register
func (o *EBI_Type) SetIMR_ERRIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIMR_ERRIM() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// EBI.ISR: PMECC Interrupt Status Register
func (o *EBI_Type) SetISR_ERRIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff)|value)
}
func (o *EBI_Type) GetISR_ERRIS() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0xff
}

// EBI.ECC0_0: PMECC ECC 0 Register (sec_num = 0)
func (o *EBI_Type) SetECC0_0(value uint32) {
	volatile.StoreUint32(&o.ECC0_0.Reg, value)
}
func (o *EBI_Type) GetECC0_0() uint32 {
	return volatile.LoadUint32(&o.ECC0_0.Reg)
}

// EBI.ECC1_0: PMECC ECC 1 Register (sec_num = 0)
func (o *EBI_Type) SetECC1_0(value uint32) {
	volatile.StoreUint32(&o.ECC1_0.Reg, value)
}
func (o *EBI_Type) GetECC1_0() uint32 {
	return volatile.LoadUint32(&o.ECC1_0.Reg)
}

// EBI.ECC2_0: PMECC ECC 2 Register (sec_num = 0)
func (o *EBI_Type) SetECC2_0(value uint32) {
	volatile.StoreUint32(&o.ECC2_0.Reg, value)
}
func (o *EBI_Type) GetECC2_0() uint32 {
	return volatile.LoadUint32(&o.ECC2_0.Reg)
}

// EBI.ECC3_0: PMECC ECC 3 Register (sec_num = 0)
func (o *EBI_Type) SetECC3_0(value uint32) {
	volatile.StoreUint32(&o.ECC3_0.Reg, value)
}
func (o *EBI_Type) GetECC3_0() uint32 {
	return volatile.LoadUint32(&o.ECC3_0.Reg)
}

// EBI.ECC4_0: PMECC ECC 4 Register (sec_num = 0)
func (o *EBI_Type) SetECC4_0(value uint32) {
	volatile.StoreUint32(&o.ECC4_0.Reg, value)
}
func (o *EBI_Type) GetECC4_0() uint32 {
	return volatile.LoadUint32(&o.ECC4_0.Reg)
}

// EBI.ECC5_0: PMECC ECC 5 Register (sec_num = 0)
func (o *EBI_Type) SetECC5_0(value uint32) {
	volatile.StoreUint32(&o.ECC5_0.Reg, value)
}
func (o *EBI_Type) GetECC5_0() uint32 {
	return volatile.LoadUint32(&o.ECC5_0.Reg)
}

// EBI.ECC6_0: PMECC ECC 6 Register (sec_num = 0)
func (o *EBI_Type) SetECC6_0(value uint32) {
	volatile.StoreUint32(&o.ECC6_0.Reg, value)
}
func (o *EBI_Type) GetECC6_0() uint32 {
	return volatile.LoadUint32(&o.ECC6_0.Reg)
}

// EBI.ECC7_0: PMECC ECC 7 Register (sec_num = 0)
func (o *EBI_Type) SetECC7_0(value uint32) {
	volatile.StoreUint32(&o.ECC7_0.Reg, value)
}
func (o *EBI_Type) GetECC7_0() uint32 {
	return volatile.LoadUint32(&o.ECC7_0.Reg)
}

// EBI.ECC8_0: PMECC ECC 8 Register (sec_num = 0)
func (o *EBI_Type) SetECC8_0(value uint32) {
	volatile.StoreUint32(&o.ECC8_0.Reg, value)
}
func (o *EBI_Type) GetECC8_0() uint32 {
	return volatile.LoadUint32(&o.ECC8_0.Reg)
}

// EBI.ECC9_0: PMECC ECC 9 Register (sec_num = 0)
func (o *EBI_Type) SetECC9_0(value uint32) {
	volatile.StoreUint32(&o.ECC9_0.Reg, value)
}
func (o *EBI_Type) GetECC9_0() uint32 {
	return volatile.LoadUint32(&o.ECC9_0.Reg)
}

// EBI.ECC10_0: PMECC ECC 10 Register (sec_num = 0)
func (o *EBI_Type) SetECC10_0(value uint32) {
	volatile.StoreUint32(&o.ECC10_0.Reg, value)
}
func (o *EBI_Type) GetECC10_0() uint32 {
	return volatile.LoadUint32(&o.ECC10_0.Reg)
}

// EBI.ECC0_1: PMECC ECC 0 Register (sec_num = 1)
func (o *EBI_Type) SetECC0_1(value uint32) {
	volatile.StoreUint32(&o.ECC0_1.Reg, value)
}
func (o *EBI_Type) GetECC0_1() uint32 {
	return volatile.LoadUint32(&o.ECC0_1.Reg)
}

// EBI.ECC1_1: PMECC ECC 1 Register (sec_num = 1)
func (o *EBI_Type) SetECC1_1(value uint32) {
	volatile.StoreUint32(&o.ECC1_1.Reg, value)
}
func (o *EBI_Type) GetECC1_1() uint32 {
	return volatile.LoadUint32(&o.ECC1_1.Reg)
}

// EBI.ECC2_1: PMECC ECC 2 Register (sec_num = 1)
func (o *EBI_Type) SetECC2_1(value uint32) {
	volatile.StoreUint32(&o.ECC2_1.Reg, value)
}
func (o *EBI_Type) GetECC2_1() uint32 {
	return volatile.LoadUint32(&o.ECC2_1.Reg)
}

// EBI.ECC3_1: PMECC ECC 3 Register (sec_num = 1)
func (o *EBI_Type) SetECC3_1(value uint32) {
	volatile.StoreUint32(&o.ECC3_1.Reg, value)
}
func (o *EBI_Type) GetECC3_1() uint32 {
	return volatile.LoadUint32(&o.ECC3_1.Reg)
}

// EBI.ECC4_1: PMECC ECC 4 Register (sec_num = 1)
func (o *EBI_Type) SetECC4_1(value uint32) {
	volatile.StoreUint32(&o.ECC4_1.Reg, value)
}
func (o *EBI_Type) GetECC4_1() uint32 {
	return volatile.LoadUint32(&o.ECC4_1.Reg)
}

// EBI.ECC5_1: PMECC ECC 5 Register (sec_num = 1)
func (o *EBI_Type) SetECC5_1(value uint32) {
	volatile.StoreUint32(&o.ECC5_1.Reg, value)
}
func (o *EBI_Type) GetECC5_1() uint32 {
	return volatile.LoadUint32(&o.ECC5_1.Reg)
}

// EBI.ECC6_1: PMECC ECC 6 Register (sec_num = 1)
func (o *EBI_Type) SetECC6_1(value uint32) {
	volatile.StoreUint32(&o.ECC6_1.Reg, value)
}
func (o *EBI_Type) GetECC6_1() uint32 {
	return volatile.LoadUint32(&o.ECC6_1.Reg)
}

// EBI.ECC7_1: PMECC ECC 7 Register (sec_num = 1)
func (o *EBI_Type) SetECC7_1(value uint32) {
	volatile.StoreUint32(&o.ECC7_1.Reg, value)
}
func (o *EBI_Type) GetECC7_1() uint32 {
	return volatile.LoadUint32(&o.ECC7_1.Reg)
}

// EBI.ECC8_1: PMECC ECC 8 Register (sec_num = 1)
func (o *EBI_Type) SetECC8_1(value uint32) {
	volatile.StoreUint32(&o.ECC8_1.Reg, value)
}
func (o *EBI_Type) GetECC8_1() uint32 {
	return volatile.LoadUint32(&o.ECC8_1.Reg)
}

// EBI.ECC9_1: PMECC ECC 9 Register (sec_num = 1)
func (o *EBI_Type) SetECC9_1(value uint32) {
	volatile.StoreUint32(&o.ECC9_1.Reg, value)
}
func (o *EBI_Type) GetECC9_1() uint32 {
	return volatile.LoadUint32(&o.ECC9_1.Reg)
}

// EBI.ECC10_1: PMECC ECC 10 Register (sec_num = 1)
func (o *EBI_Type) SetECC10_1(value uint32) {
	volatile.StoreUint32(&o.ECC10_1.Reg, value)
}
func (o *EBI_Type) GetECC10_1() uint32 {
	return volatile.LoadUint32(&o.ECC10_1.Reg)
}

// EBI.ECC0_2: PMECC ECC 0 Register (sec_num = 2)
func (o *EBI_Type) SetECC0_2(value uint32) {
	volatile.StoreUint32(&o.ECC0_2.Reg, value)
}
func (o *EBI_Type) GetECC0_2() uint32 {
	return volatile.LoadUint32(&o.ECC0_2.Reg)
}

// EBI.ECC1_2: PMECC ECC 1 Register (sec_num = 2)
func (o *EBI_Type) SetECC1_2(value uint32) {
	volatile.StoreUint32(&o.ECC1_2.Reg, value)
}
func (o *EBI_Type) GetECC1_2() uint32 {
	return volatile.LoadUint32(&o.ECC1_2.Reg)
}

// EBI.ECC2_2: PMECC ECC 2 Register (sec_num = 2)
func (o *EBI_Type) SetECC2_2(value uint32) {
	volatile.StoreUint32(&o.ECC2_2.Reg, value)
}
func (o *EBI_Type) GetECC2_2() uint32 {
	return volatile.LoadUint32(&o.ECC2_2.Reg)
}

// EBI.ECC3_2: PMECC ECC 3 Register (sec_num = 2)
func (o *EBI_Type) SetECC3_2(value uint32) {
	volatile.StoreUint32(&o.ECC3_2.Reg, value)
}
func (o *EBI_Type) GetECC3_2() uint32 {
	return volatile.LoadUint32(&o.ECC3_2.Reg)
}

// EBI.ECC4_2: PMECC ECC 4 Register (sec_num = 2)
func (o *EBI_Type) SetECC4_2(value uint32) {
	volatile.StoreUint32(&o.ECC4_2.Reg, value)
}
func (o *EBI_Type) GetECC4_2() uint32 {
	return volatile.LoadUint32(&o.ECC4_2.Reg)
}

// EBI.ECC5_2: PMECC ECC 5 Register (sec_num = 2)
func (o *EBI_Type) SetECC5_2(value uint32) {
	volatile.StoreUint32(&o.ECC5_2.Reg, value)
}
func (o *EBI_Type) GetECC5_2() uint32 {
	return volatile.LoadUint32(&o.ECC5_2.Reg)
}

// EBI.ECC6_2: PMECC ECC 6 Register (sec_num = 2)
func (o *EBI_Type) SetECC6_2(value uint32) {
	volatile.StoreUint32(&o.ECC6_2.Reg, value)
}
func (o *EBI_Type) GetECC6_2() uint32 {
	return volatile.LoadUint32(&o.ECC6_2.Reg)
}

// EBI.ECC7_2: PMECC ECC 7 Register (sec_num = 2)
func (o *EBI_Type) SetECC7_2(value uint32) {
	volatile.StoreUint32(&o.ECC7_2.Reg, value)
}
func (o *EBI_Type) GetECC7_2() uint32 {
	return volatile.LoadUint32(&o.ECC7_2.Reg)
}

// EBI.ECC8_2: PMECC ECC 8 Register (sec_num = 2)
func (o *EBI_Type) SetECC8_2(value uint32) {
	volatile.StoreUint32(&o.ECC8_2.Reg, value)
}
func (o *EBI_Type) GetECC8_2() uint32 {
	return volatile.LoadUint32(&o.ECC8_2.Reg)
}

// EBI.ECC9_2: PMECC ECC 9 Register (sec_num = 2)
func (o *EBI_Type) SetECC9_2(value uint32) {
	volatile.StoreUint32(&o.ECC9_2.Reg, value)
}
func (o *EBI_Type) GetECC9_2() uint32 {
	return volatile.LoadUint32(&o.ECC9_2.Reg)
}

// EBI.ECC10_2: PMECC ECC 10 Register (sec_num = 2)
func (o *EBI_Type) SetECC10_2(value uint32) {
	volatile.StoreUint32(&o.ECC10_2.Reg, value)
}
func (o *EBI_Type) GetECC10_2() uint32 {
	return volatile.LoadUint32(&o.ECC10_2.Reg)
}

// EBI.ECC0_3: PMECC ECC 0 Register (sec_num = 3)
func (o *EBI_Type) SetECC0_3(value uint32) {
	volatile.StoreUint32(&o.ECC0_3.Reg, value)
}
func (o *EBI_Type) GetECC0_3() uint32 {
	return volatile.LoadUint32(&o.ECC0_3.Reg)
}

// EBI.ECC1_3: PMECC ECC 1 Register (sec_num = 3)
func (o *EBI_Type) SetECC1_3(value uint32) {
	volatile.StoreUint32(&o.ECC1_3.Reg, value)
}
func (o *EBI_Type) GetECC1_3() uint32 {
	return volatile.LoadUint32(&o.ECC1_3.Reg)
}

// EBI.ECC2_3: PMECC ECC 2 Register (sec_num = 3)
func (o *EBI_Type) SetECC2_3(value uint32) {
	volatile.StoreUint32(&o.ECC2_3.Reg, value)
}
func (o *EBI_Type) GetECC2_3() uint32 {
	return volatile.LoadUint32(&o.ECC2_3.Reg)
}

// EBI.ECC3_3: PMECC ECC 3 Register (sec_num = 3)
func (o *EBI_Type) SetECC3_3(value uint32) {
	volatile.StoreUint32(&o.ECC3_3.Reg, value)
}
func (o *EBI_Type) GetECC3_3() uint32 {
	return volatile.LoadUint32(&o.ECC3_3.Reg)
}

// EBI.ECC4_3: PMECC ECC 4 Register (sec_num = 3)
func (o *EBI_Type) SetECC4_3(value uint32) {
	volatile.StoreUint32(&o.ECC4_3.Reg, value)
}
func (o *EBI_Type) GetECC4_3() uint32 {
	return volatile.LoadUint32(&o.ECC4_3.Reg)
}

// EBI.ECC5_3: PMECC ECC 5 Register (sec_num = 3)
func (o *EBI_Type) SetECC5_3(value uint32) {
	volatile.StoreUint32(&o.ECC5_3.Reg, value)
}
func (o *EBI_Type) GetECC5_3() uint32 {
	return volatile.LoadUint32(&o.ECC5_3.Reg)
}

// EBI.ECC6_3: PMECC ECC 6 Register (sec_num = 3)
func (o *EBI_Type) SetECC6_3(value uint32) {
	volatile.StoreUint32(&o.ECC6_3.Reg, value)
}
func (o *EBI_Type) GetECC6_3() uint32 {
	return volatile.LoadUint32(&o.ECC6_3.Reg)
}

// EBI.ECC7_3: PMECC ECC 7 Register (sec_num = 3)
func (o *EBI_Type) SetECC7_3(value uint32) {
	volatile.StoreUint32(&o.ECC7_3.Reg, value)
}
func (o *EBI_Type) GetECC7_3() uint32 {
	return volatile.LoadUint32(&o.ECC7_3.Reg)
}

// EBI.ECC8_3: PMECC ECC 8 Register (sec_num = 3)
func (o *EBI_Type) SetECC8_3(value uint32) {
	volatile.StoreUint32(&o.ECC8_3.Reg, value)
}
func (o *EBI_Type) GetECC8_3() uint32 {
	return volatile.LoadUint32(&o.ECC8_3.Reg)
}

// EBI.ECC9_3: PMECC ECC 9 Register (sec_num = 3)
func (o *EBI_Type) SetECC9_3(value uint32) {
	volatile.StoreUint32(&o.ECC9_3.Reg, value)
}
func (o *EBI_Type) GetECC9_3() uint32 {
	return volatile.LoadUint32(&o.ECC9_3.Reg)
}

// EBI.ECC10_3: PMECC ECC 10 Register (sec_num = 3)
func (o *EBI_Type) SetECC10_3(value uint32) {
	volatile.StoreUint32(&o.ECC10_3.Reg, value)
}
func (o *EBI_Type) GetECC10_3() uint32 {
	return volatile.LoadUint32(&o.ECC10_3.Reg)
}

// EBI.ECC0_4: PMECC ECC 0 Register (sec_num = 4)
func (o *EBI_Type) SetECC0_4(value uint32) {
	volatile.StoreUint32(&o.ECC0_4.Reg, value)
}
func (o *EBI_Type) GetECC0_4() uint32 {
	return volatile.LoadUint32(&o.ECC0_4.Reg)
}

// EBI.ECC1_4: PMECC ECC 1 Register (sec_num = 4)
func (o *EBI_Type) SetECC1_4(value uint32) {
	volatile.StoreUint32(&o.ECC1_4.Reg, value)
}
func (o *EBI_Type) GetECC1_4() uint32 {
	return volatile.LoadUint32(&o.ECC1_4.Reg)
}

// EBI.ECC2_4: PMECC ECC 2 Register (sec_num = 4)
func (o *EBI_Type) SetECC2_4(value uint32) {
	volatile.StoreUint32(&o.ECC2_4.Reg, value)
}
func (o *EBI_Type) GetECC2_4() uint32 {
	return volatile.LoadUint32(&o.ECC2_4.Reg)
}

// EBI.ECC3_4: PMECC ECC 3 Register (sec_num = 4)
func (o *EBI_Type) SetECC3_4(value uint32) {
	volatile.StoreUint32(&o.ECC3_4.Reg, value)
}
func (o *EBI_Type) GetECC3_4() uint32 {
	return volatile.LoadUint32(&o.ECC3_4.Reg)
}

// EBI.ECC4_4: PMECC ECC 4 Register (sec_num = 4)
func (o *EBI_Type) SetECC4_4(value uint32) {
	volatile.StoreUint32(&o.ECC4_4.Reg, value)
}
func (o *EBI_Type) GetECC4_4() uint32 {
	return volatile.LoadUint32(&o.ECC4_4.Reg)
}

// EBI.ECC5_4: PMECC ECC 5 Register (sec_num = 4)
func (o *EBI_Type) SetECC5_4(value uint32) {
	volatile.StoreUint32(&o.ECC5_4.Reg, value)
}
func (o *EBI_Type) GetECC5_4() uint32 {
	return volatile.LoadUint32(&o.ECC5_4.Reg)
}

// EBI.ECC6_4: PMECC ECC 6 Register (sec_num = 4)
func (o *EBI_Type) SetECC6_4(value uint32) {
	volatile.StoreUint32(&o.ECC6_4.Reg, value)
}
func (o *EBI_Type) GetECC6_4() uint32 {
	return volatile.LoadUint32(&o.ECC6_4.Reg)
}

// EBI.ECC7_4: PMECC ECC 7 Register (sec_num = 4)
func (o *EBI_Type) SetECC7_4(value uint32) {
	volatile.StoreUint32(&o.ECC7_4.Reg, value)
}
func (o *EBI_Type) GetECC7_4() uint32 {
	return volatile.LoadUint32(&o.ECC7_4.Reg)
}

// EBI.ECC8_4: PMECC ECC 8 Register (sec_num = 4)
func (o *EBI_Type) SetECC8_4(value uint32) {
	volatile.StoreUint32(&o.ECC8_4.Reg, value)
}
func (o *EBI_Type) GetECC8_4() uint32 {
	return volatile.LoadUint32(&o.ECC8_4.Reg)
}

// EBI.ECC9_4: PMECC ECC 9 Register (sec_num = 4)
func (o *EBI_Type) SetECC9_4(value uint32) {
	volatile.StoreUint32(&o.ECC9_4.Reg, value)
}
func (o *EBI_Type) GetECC9_4() uint32 {
	return volatile.LoadUint32(&o.ECC9_4.Reg)
}

// EBI.ECC10_4: PMECC ECC 10 Register (sec_num = 4)
func (o *EBI_Type) SetECC10_4(value uint32) {
	volatile.StoreUint32(&o.ECC10_4.Reg, value)
}
func (o *EBI_Type) GetECC10_4() uint32 {
	return volatile.LoadUint32(&o.ECC10_4.Reg)
}

// EBI.ECC0_5: PMECC ECC 0 Register (sec_num = 5)
func (o *EBI_Type) SetECC0_5(value uint32) {
	volatile.StoreUint32(&o.ECC0_5.Reg, value)
}
func (o *EBI_Type) GetECC0_5() uint32 {
	return volatile.LoadUint32(&o.ECC0_5.Reg)
}

// EBI.ECC1_5: PMECC ECC 1 Register (sec_num = 5)
func (o *EBI_Type) SetECC1_5(value uint32) {
	volatile.StoreUint32(&o.ECC1_5.Reg, value)
}
func (o *EBI_Type) GetECC1_5() uint32 {
	return volatile.LoadUint32(&o.ECC1_5.Reg)
}

// EBI.ECC2_5: PMECC ECC 2 Register (sec_num = 5)
func (o *EBI_Type) SetECC2_5(value uint32) {
	volatile.StoreUint32(&o.ECC2_5.Reg, value)
}
func (o *EBI_Type) GetECC2_5() uint32 {
	return volatile.LoadUint32(&o.ECC2_5.Reg)
}

// EBI.ECC3_5: PMECC ECC 3 Register (sec_num = 5)
func (o *EBI_Type) SetECC3_5(value uint32) {
	volatile.StoreUint32(&o.ECC3_5.Reg, value)
}
func (o *EBI_Type) GetECC3_5() uint32 {
	return volatile.LoadUint32(&o.ECC3_5.Reg)
}

// EBI.ECC4_5: PMECC ECC 4 Register (sec_num = 5)
func (o *EBI_Type) SetECC4_5(value uint32) {
	volatile.StoreUint32(&o.ECC4_5.Reg, value)
}
func (o *EBI_Type) GetECC4_5() uint32 {
	return volatile.LoadUint32(&o.ECC4_5.Reg)
}

// EBI.ECC5_5: PMECC ECC 5 Register (sec_num = 5)
func (o *EBI_Type) SetECC5_5(value uint32) {
	volatile.StoreUint32(&o.ECC5_5.Reg, value)
}
func (o *EBI_Type) GetECC5_5() uint32 {
	return volatile.LoadUint32(&o.ECC5_5.Reg)
}

// EBI.ECC6_5: PMECC ECC 6 Register (sec_num = 5)
func (o *EBI_Type) SetECC6_5(value uint32) {
	volatile.StoreUint32(&o.ECC6_5.Reg, value)
}
func (o *EBI_Type) GetECC6_5() uint32 {
	return volatile.LoadUint32(&o.ECC6_5.Reg)
}

// EBI.ECC7_5: PMECC ECC 7 Register (sec_num = 5)
func (o *EBI_Type) SetECC7_5(value uint32) {
	volatile.StoreUint32(&o.ECC7_5.Reg, value)
}
func (o *EBI_Type) GetECC7_5() uint32 {
	return volatile.LoadUint32(&o.ECC7_5.Reg)
}

// EBI.ECC8_5: PMECC ECC 8 Register (sec_num = 5)
func (o *EBI_Type) SetECC8_5(value uint32) {
	volatile.StoreUint32(&o.ECC8_5.Reg, value)
}
func (o *EBI_Type) GetECC8_5() uint32 {
	return volatile.LoadUint32(&o.ECC8_5.Reg)
}

// EBI.ECC9_5: PMECC ECC 9 Register (sec_num = 5)
func (o *EBI_Type) SetECC9_5(value uint32) {
	volatile.StoreUint32(&o.ECC9_5.Reg, value)
}
func (o *EBI_Type) GetECC9_5() uint32 {
	return volatile.LoadUint32(&o.ECC9_5.Reg)
}

// EBI.ECC10_5: PMECC ECC 10 Register (sec_num = 5)
func (o *EBI_Type) SetECC10_5(value uint32) {
	volatile.StoreUint32(&o.ECC10_5.Reg, value)
}
func (o *EBI_Type) GetECC10_5() uint32 {
	return volatile.LoadUint32(&o.ECC10_5.Reg)
}

// EBI.ECC0_6: PMECC ECC 0 Register (sec_num = 6)
func (o *EBI_Type) SetECC0_6(value uint32) {
	volatile.StoreUint32(&o.ECC0_6.Reg, value)
}
func (o *EBI_Type) GetECC0_6() uint32 {
	return volatile.LoadUint32(&o.ECC0_6.Reg)
}

// EBI.ECC1_6: PMECC ECC 1 Register (sec_num = 6)
func (o *EBI_Type) SetECC1_6(value uint32) {
	volatile.StoreUint32(&o.ECC1_6.Reg, value)
}
func (o *EBI_Type) GetECC1_6() uint32 {
	return volatile.LoadUint32(&o.ECC1_6.Reg)
}

// EBI.ECC2_6: PMECC ECC 2 Register (sec_num = 6)
func (o *EBI_Type) SetECC2_6(value uint32) {
	volatile.StoreUint32(&o.ECC2_6.Reg, value)
}
func (o *EBI_Type) GetECC2_6() uint32 {
	return volatile.LoadUint32(&o.ECC2_6.Reg)
}

// EBI.ECC3_6: PMECC ECC 3 Register (sec_num = 6)
func (o *EBI_Type) SetECC3_6(value uint32) {
	volatile.StoreUint32(&o.ECC3_6.Reg, value)
}
func (o *EBI_Type) GetECC3_6() uint32 {
	return volatile.LoadUint32(&o.ECC3_6.Reg)
}

// EBI.ECC4_6: PMECC ECC 4 Register (sec_num = 6)
func (o *EBI_Type) SetECC4_6(value uint32) {
	volatile.StoreUint32(&o.ECC4_6.Reg, value)
}
func (o *EBI_Type) GetECC4_6() uint32 {
	return volatile.LoadUint32(&o.ECC4_6.Reg)
}

// EBI.ECC5_6: PMECC ECC 5 Register (sec_num = 6)
func (o *EBI_Type) SetECC5_6(value uint32) {
	volatile.StoreUint32(&o.ECC5_6.Reg, value)
}
func (o *EBI_Type) GetECC5_6() uint32 {
	return volatile.LoadUint32(&o.ECC5_6.Reg)
}

// EBI.ECC6_6: PMECC ECC 6 Register (sec_num = 6)
func (o *EBI_Type) SetECC6_6(value uint32) {
	volatile.StoreUint32(&o.ECC6_6.Reg, value)
}
func (o *EBI_Type) GetECC6_6() uint32 {
	return volatile.LoadUint32(&o.ECC6_6.Reg)
}

// EBI.ECC7_6: PMECC ECC 7 Register (sec_num = 6)
func (o *EBI_Type) SetECC7_6(value uint32) {
	volatile.StoreUint32(&o.ECC7_6.Reg, value)
}
func (o *EBI_Type) GetECC7_6() uint32 {
	return volatile.LoadUint32(&o.ECC7_6.Reg)
}

// EBI.ECC8_6: PMECC ECC 8 Register (sec_num = 6)
func (o *EBI_Type) SetECC8_6(value uint32) {
	volatile.StoreUint32(&o.ECC8_6.Reg, value)
}
func (o *EBI_Type) GetECC8_6() uint32 {
	return volatile.LoadUint32(&o.ECC8_6.Reg)
}

// EBI.ECC9_6: PMECC ECC 9 Register (sec_num = 6)
func (o *EBI_Type) SetECC9_6(value uint32) {
	volatile.StoreUint32(&o.ECC9_6.Reg, value)
}
func (o *EBI_Type) GetECC9_6() uint32 {
	return volatile.LoadUint32(&o.ECC9_6.Reg)
}

// EBI.ECC10_6: PMECC ECC 10 Register (sec_num = 6)
func (o *EBI_Type) SetECC10_6(value uint32) {
	volatile.StoreUint32(&o.ECC10_6.Reg, value)
}
func (o *EBI_Type) GetECC10_6() uint32 {
	return volatile.LoadUint32(&o.ECC10_6.Reg)
}

// EBI.ECC0_7: PMECC ECC 0 Register (sec_num = 7)
func (o *EBI_Type) SetECC0_7(value uint32) {
	volatile.StoreUint32(&o.ECC0_7.Reg, value)
}
func (o *EBI_Type) GetECC0_7() uint32 {
	return volatile.LoadUint32(&o.ECC0_7.Reg)
}

// EBI.ECC1_7: PMECC ECC 1 Register (sec_num = 7)
func (o *EBI_Type) SetECC1_7(value uint32) {
	volatile.StoreUint32(&o.ECC1_7.Reg, value)
}
func (o *EBI_Type) GetECC1_7() uint32 {
	return volatile.LoadUint32(&o.ECC1_7.Reg)
}

// EBI.ECC2_7: PMECC ECC 2 Register (sec_num = 7)
func (o *EBI_Type) SetECC2_7(value uint32) {
	volatile.StoreUint32(&o.ECC2_7.Reg, value)
}
func (o *EBI_Type) GetECC2_7() uint32 {
	return volatile.LoadUint32(&o.ECC2_7.Reg)
}

// EBI.ECC3_7: PMECC ECC 3 Register (sec_num = 7)
func (o *EBI_Type) SetECC3_7(value uint32) {
	volatile.StoreUint32(&o.ECC3_7.Reg, value)
}
func (o *EBI_Type) GetECC3_7() uint32 {
	return volatile.LoadUint32(&o.ECC3_7.Reg)
}

// EBI.ECC4_7: PMECC ECC 4 Register (sec_num = 7)
func (o *EBI_Type) SetECC4_7(value uint32) {
	volatile.StoreUint32(&o.ECC4_7.Reg, value)
}
func (o *EBI_Type) GetECC4_7() uint32 {
	return volatile.LoadUint32(&o.ECC4_7.Reg)
}

// EBI.ECC5_7: PMECC ECC 5 Register (sec_num = 7)
func (o *EBI_Type) SetECC5_7(value uint32) {
	volatile.StoreUint32(&o.ECC5_7.Reg, value)
}
func (o *EBI_Type) GetECC5_7() uint32 {
	return volatile.LoadUint32(&o.ECC5_7.Reg)
}

// EBI.ECC6_7: PMECC ECC 6 Register (sec_num = 7)
func (o *EBI_Type) SetECC6_7(value uint32) {
	volatile.StoreUint32(&o.ECC6_7.Reg, value)
}
func (o *EBI_Type) GetECC6_7() uint32 {
	return volatile.LoadUint32(&o.ECC6_7.Reg)
}

// EBI.ECC7_7: PMECC ECC 7 Register (sec_num = 7)
func (o *EBI_Type) SetECC7_7(value uint32) {
	volatile.StoreUint32(&o.ECC7_7.Reg, value)
}
func (o *EBI_Type) GetECC7_7() uint32 {
	return volatile.LoadUint32(&o.ECC7_7.Reg)
}

// EBI.ECC8_7: PMECC ECC 8 Register (sec_num = 7)
func (o *EBI_Type) SetECC8_7(value uint32) {
	volatile.StoreUint32(&o.ECC8_7.Reg, value)
}
func (o *EBI_Type) GetECC8_7() uint32 {
	return volatile.LoadUint32(&o.ECC8_7.Reg)
}

// EBI.ECC9_7: PMECC ECC 9 Register (sec_num = 7)
func (o *EBI_Type) SetECC9_7(value uint32) {
	volatile.StoreUint32(&o.ECC9_7.Reg, value)
}
func (o *EBI_Type) GetECC9_7() uint32 {
	return volatile.LoadUint32(&o.ECC9_7.Reg)
}

// EBI.ECC10_7: PMECC ECC 10 Register (sec_num = 7)
func (o *EBI_Type) SetECC10_7(value uint32) {
	volatile.StoreUint32(&o.ECC10_7.Reg, value)
}
func (o *EBI_Type) GetECC10_7() uint32 {
	return volatile.LoadUint32(&o.ECC10_7.Reg)
}

// EBI.REM0_0: PMECC REM 0 Register (sec_num = 0)
func (o *EBI_Type) SetREM0_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_0.Reg, volatile.LoadUint32(&o.REM0_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_0.Reg, volatile.LoadUint32(&o.REM0_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_0: PMECC REM 1 Register (sec_num = 0)
func (o *EBI_Type) SetREM1_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_0.Reg, volatile.LoadUint32(&o.REM1_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_0.Reg, volatile.LoadUint32(&o.REM1_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_0: PMECC REM 2 Register (sec_num = 0)
func (o *EBI_Type) SetREM2_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_0.Reg, volatile.LoadUint32(&o.REM2_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_0.Reg, volatile.LoadUint32(&o.REM2_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_0: PMECC REM 3 Register (sec_num = 0)
func (o *EBI_Type) SetREM3_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_0.Reg, volatile.LoadUint32(&o.REM3_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_0.Reg, volatile.LoadUint32(&o.REM3_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_0: PMECC REM 4 Register (sec_num = 0)
func (o *EBI_Type) SetREM4_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_0.Reg, volatile.LoadUint32(&o.REM4_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_0.Reg, volatile.LoadUint32(&o.REM4_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_0: PMECC REM 5 Register (sec_num = 0)
func (o *EBI_Type) SetREM5_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_0.Reg, volatile.LoadUint32(&o.REM5_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_0.Reg, volatile.LoadUint32(&o.REM5_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_0: PMECC REM 6 Register (sec_num = 0)
func (o *EBI_Type) SetREM6_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_0.Reg, volatile.LoadUint32(&o.REM6_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_0.Reg, volatile.LoadUint32(&o.REM6_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_0: PMECC REM 7 Register (sec_num = 0)
func (o *EBI_Type) SetREM7_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_0.Reg, volatile.LoadUint32(&o.REM7_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_0.Reg, volatile.LoadUint32(&o.REM7_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_0: PMECC REM 8 Register (sec_num = 0)
func (o *EBI_Type) SetREM8_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_0.Reg, volatile.LoadUint32(&o.REM8_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_0.Reg, volatile.LoadUint32(&o.REM8_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_0: PMECC REM 9 Register (sec_num = 0)
func (o *EBI_Type) SetREM9_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_0.Reg, volatile.LoadUint32(&o.REM9_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_0.Reg, volatile.LoadUint32(&o.REM9_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_0: PMECC REM 10 Register (sec_num = 0)
func (o *EBI_Type) SetREM10_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_0.Reg, volatile.LoadUint32(&o.REM10_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_0.Reg, volatile.LoadUint32(&o.REM10_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_0: PMECC REM 11 Register (sec_num = 0)
func (o *EBI_Type) SetREM11_0_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_0.Reg, volatile.LoadUint32(&o.REM11_0.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_0_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_0.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_0_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_0.Reg, volatile.LoadUint32(&o.REM11_0.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_0_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_0.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_1: PMECC REM 0 Register (sec_num = 1)
func (o *EBI_Type) SetREM0_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_1.Reg, volatile.LoadUint32(&o.REM0_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_1.Reg, volatile.LoadUint32(&o.REM0_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_1: PMECC REM 1 Register (sec_num = 1)
func (o *EBI_Type) SetREM1_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_1.Reg, volatile.LoadUint32(&o.REM1_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_1.Reg, volatile.LoadUint32(&o.REM1_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_1: PMECC REM 2 Register (sec_num = 1)
func (o *EBI_Type) SetREM2_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_1.Reg, volatile.LoadUint32(&o.REM2_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_1.Reg, volatile.LoadUint32(&o.REM2_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_1: PMECC REM 3 Register (sec_num = 1)
func (o *EBI_Type) SetREM3_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_1.Reg, volatile.LoadUint32(&o.REM3_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_1.Reg, volatile.LoadUint32(&o.REM3_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_1: PMECC REM 4 Register (sec_num = 1)
func (o *EBI_Type) SetREM4_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_1.Reg, volatile.LoadUint32(&o.REM4_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_1.Reg, volatile.LoadUint32(&o.REM4_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_1: PMECC REM 5 Register (sec_num = 1)
func (o *EBI_Type) SetREM5_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_1.Reg, volatile.LoadUint32(&o.REM5_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_1.Reg, volatile.LoadUint32(&o.REM5_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_1: PMECC REM 6 Register (sec_num = 1)
func (o *EBI_Type) SetREM6_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_1.Reg, volatile.LoadUint32(&o.REM6_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_1.Reg, volatile.LoadUint32(&o.REM6_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_1: PMECC REM 7 Register (sec_num = 1)
func (o *EBI_Type) SetREM7_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_1.Reg, volatile.LoadUint32(&o.REM7_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_1.Reg, volatile.LoadUint32(&o.REM7_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_1: PMECC REM 8 Register (sec_num = 1)
func (o *EBI_Type) SetREM8_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_1.Reg, volatile.LoadUint32(&o.REM8_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_1.Reg, volatile.LoadUint32(&o.REM8_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_1: PMECC REM 9 Register (sec_num = 1)
func (o *EBI_Type) SetREM9_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_1.Reg, volatile.LoadUint32(&o.REM9_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_1.Reg, volatile.LoadUint32(&o.REM9_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_1: PMECC REM 10 Register (sec_num = 1)
func (o *EBI_Type) SetREM10_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_1.Reg, volatile.LoadUint32(&o.REM10_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_1.Reg, volatile.LoadUint32(&o.REM10_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_1: PMECC REM 11 Register (sec_num = 1)
func (o *EBI_Type) SetREM11_1_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_1.Reg, volatile.LoadUint32(&o.REM11_1.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_1_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_1.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_1_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_1.Reg, volatile.LoadUint32(&o.REM11_1.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_1_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_1.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_2: PMECC REM 0 Register (sec_num = 2)
func (o *EBI_Type) SetREM0_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_2.Reg, volatile.LoadUint32(&o.REM0_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_2.Reg, volatile.LoadUint32(&o.REM0_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_2: PMECC REM 1 Register (sec_num = 2)
func (o *EBI_Type) SetREM1_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_2.Reg, volatile.LoadUint32(&o.REM1_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_2.Reg, volatile.LoadUint32(&o.REM1_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_2: PMECC REM 2 Register (sec_num = 2)
func (o *EBI_Type) SetREM2_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_2.Reg, volatile.LoadUint32(&o.REM2_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_2.Reg, volatile.LoadUint32(&o.REM2_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_2: PMECC REM 3 Register (sec_num = 2)
func (o *EBI_Type) SetREM3_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_2.Reg, volatile.LoadUint32(&o.REM3_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_2.Reg, volatile.LoadUint32(&o.REM3_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_2: PMECC REM 4 Register (sec_num = 2)
func (o *EBI_Type) SetREM4_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_2.Reg, volatile.LoadUint32(&o.REM4_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_2.Reg, volatile.LoadUint32(&o.REM4_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_2: PMECC REM 5 Register (sec_num = 2)
func (o *EBI_Type) SetREM5_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_2.Reg, volatile.LoadUint32(&o.REM5_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_2.Reg, volatile.LoadUint32(&o.REM5_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_2: PMECC REM 6 Register (sec_num = 2)
func (o *EBI_Type) SetREM6_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_2.Reg, volatile.LoadUint32(&o.REM6_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_2.Reg, volatile.LoadUint32(&o.REM6_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_2: PMECC REM 7 Register (sec_num = 2)
func (o *EBI_Type) SetREM7_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_2.Reg, volatile.LoadUint32(&o.REM7_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_2.Reg, volatile.LoadUint32(&o.REM7_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_2: PMECC REM 8 Register (sec_num = 2)
func (o *EBI_Type) SetREM8_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_2.Reg, volatile.LoadUint32(&o.REM8_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_2.Reg, volatile.LoadUint32(&o.REM8_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_2: PMECC REM 9 Register (sec_num = 2)
func (o *EBI_Type) SetREM9_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_2.Reg, volatile.LoadUint32(&o.REM9_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_2.Reg, volatile.LoadUint32(&o.REM9_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_2: PMECC REM 10 Register (sec_num = 2)
func (o *EBI_Type) SetREM10_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_2.Reg, volatile.LoadUint32(&o.REM10_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_2.Reg, volatile.LoadUint32(&o.REM10_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_2: PMECC REM 11 Register (sec_num = 2)
func (o *EBI_Type) SetREM11_2_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_2.Reg, volatile.LoadUint32(&o.REM11_2.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_2_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_2.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_2_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_2.Reg, volatile.LoadUint32(&o.REM11_2.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_2_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_2.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_3: PMECC REM 0 Register (sec_num = 3)
func (o *EBI_Type) SetREM0_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_3.Reg, volatile.LoadUint32(&o.REM0_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_3.Reg, volatile.LoadUint32(&o.REM0_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_3: PMECC REM 1 Register (sec_num = 3)
func (o *EBI_Type) SetREM1_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_3.Reg, volatile.LoadUint32(&o.REM1_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_3.Reg, volatile.LoadUint32(&o.REM1_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_3: PMECC REM 2 Register (sec_num = 3)
func (o *EBI_Type) SetREM2_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_3.Reg, volatile.LoadUint32(&o.REM2_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_3.Reg, volatile.LoadUint32(&o.REM2_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_3: PMECC REM 3 Register (sec_num = 3)
func (o *EBI_Type) SetREM3_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_3.Reg, volatile.LoadUint32(&o.REM3_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_3.Reg, volatile.LoadUint32(&o.REM3_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_3: PMECC REM 4 Register (sec_num = 3)
func (o *EBI_Type) SetREM4_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_3.Reg, volatile.LoadUint32(&o.REM4_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_3.Reg, volatile.LoadUint32(&o.REM4_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_3: PMECC REM 5 Register (sec_num = 3)
func (o *EBI_Type) SetREM5_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_3.Reg, volatile.LoadUint32(&o.REM5_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_3.Reg, volatile.LoadUint32(&o.REM5_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_3: PMECC REM 6 Register (sec_num = 3)
func (o *EBI_Type) SetREM6_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_3.Reg, volatile.LoadUint32(&o.REM6_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_3.Reg, volatile.LoadUint32(&o.REM6_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_3: PMECC REM 7 Register (sec_num = 3)
func (o *EBI_Type) SetREM7_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_3.Reg, volatile.LoadUint32(&o.REM7_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_3.Reg, volatile.LoadUint32(&o.REM7_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_3: PMECC REM 8 Register (sec_num = 3)
func (o *EBI_Type) SetREM8_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_3.Reg, volatile.LoadUint32(&o.REM8_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_3.Reg, volatile.LoadUint32(&o.REM8_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_3: PMECC REM 9 Register (sec_num = 3)
func (o *EBI_Type) SetREM9_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_3.Reg, volatile.LoadUint32(&o.REM9_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_3.Reg, volatile.LoadUint32(&o.REM9_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_3: PMECC REM 10 Register (sec_num = 3)
func (o *EBI_Type) SetREM10_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_3.Reg, volatile.LoadUint32(&o.REM10_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_3.Reg, volatile.LoadUint32(&o.REM10_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_3: PMECC REM 11 Register (sec_num = 3)
func (o *EBI_Type) SetREM11_3_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_3.Reg, volatile.LoadUint32(&o.REM11_3.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_3_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_3.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_3_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_3.Reg, volatile.LoadUint32(&o.REM11_3.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_3_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_3.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_4: PMECC REM 0 Register (sec_num = 4)
func (o *EBI_Type) SetREM0_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_4.Reg, volatile.LoadUint32(&o.REM0_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_4.Reg, volatile.LoadUint32(&o.REM0_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_4: PMECC REM 1 Register (sec_num = 4)
func (o *EBI_Type) SetREM1_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_4.Reg, volatile.LoadUint32(&o.REM1_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_4.Reg, volatile.LoadUint32(&o.REM1_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_4: PMECC REM 2 Register (sec_num = 4)
func (o *EBI_Type) SetREM2_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_4.Reg, volatile.LoadUint32(&o.REM2_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_4.Reg, volatile.LoadUint32(&o.REM2_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_4: PMECC REM 3 Register (sec_num = 4)
func (o *EBI_Type) SetREM3_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_4.Reg, volatile.LoadUint32(&o.REM3_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_4.Reg, volatile.LoadUint32(&o.REM3_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_4: PMECC REM 4 Register (sec_num = 4)
func (o *EBI_Type) SetREM4_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_4.Reg, volatile.LoadUint32(&o.REM4_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_4.Reg, volatile.LoadUint32(&o.REM4_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_4: PMECC REM 5 Register (sec_num = 4)
func (o *EBI_Type) SetREM5_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_4.Reg, volatile.LoadUint32(&o.REM5_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_4.Reg, volatile.LoadUint32(&o.REM5_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_4: PMECC REM 6 Register (sec_num = 4)
func (o *EBI_Type) SetREM6_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_4.Reg, volatile.LoadUint32(&o.REM6_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_4.Reg, volatile.LoadUint32(&o.REM6_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_4: PMECC REM 7 Register (sec_num = 4)
func (o *EBI_Type) SetREM7_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_4.Reg, volatile.LoadUint32(&o.REM7_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_4.Reg, volatile.LoadUint32(&o.REM7_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_4: PMECC REM 8 Register (sec_num = 4)
func (o *EBI_Type) SetREM8_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_4.Reg, volatile.LoadUint32(&o.REM8_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_4.Reg, volatile.LoadUint32(&o.REM8_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_4: PMECC REM 9 Register (sec_num = 4)
func (o *EBI_Type) SetREM9_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_4.Reg, volatile.LoadUint32(&o.REM9_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_4.Reg, volatile.LoadUint32(&o.REM9_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_4: PMECC REM 10 Register (sec_num = 4)
func (o *EBI_Type) SetREM10_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_4.Reg, volatile.LoadUint32(&o.REM10_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_4.Reg, volatile.LoadUint32(&o.REM10_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_4: PMECC REM 11 Register (sec_num = 4)
func (o *EBI_Type) SetREM11_4_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_4.Reg, volatile.LoadUint32(&o.REM11_4.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_4_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_4.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_4_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_4.Reg, volatile.LoadUint32(&o.REM11_4.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_4_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_4.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_5: PMECC REM 0 Register (sec_num = 5)
func (o *EBI_Type) SetREM0_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_5.Reg, volatile.LoadUint32(&o.REM0_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_5.Reg, volatile.LoadUint32(&o.REM0_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_5: PMECC REM 1 Register (sec_num = 5)
func (o *EBI_Type) SetREM1_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_5.Reg, volatile.LoadUint32(&o.REM1_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_5.Reg, volatile.LoadUint32(&o.REM1_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_5: PMECC REM 2 Register (sec_num = 5)
func (o *EBI_Type) SetREM2_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_5.Reg, volatile.LoadUint32(&o.REM2_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_5.Reg, volatile.LoadUint32(&o.REM2_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_5: PMECC REM 3 Register (sec_num = 5)
func (o *EBI_Type) SetREM3_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_5.Reg, volatile.LoadUint32(&o.REM3_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_5.Reg, volatile.LoadUint32(&o.REM3_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_5: PMECC REM 4 Register (sec_num = 5)
func (o *EBI_Type) SetREM4_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_5.Reg, volatile.LoadUint32(&o.REM4_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_5.Reg, volatile.LoadUint32(&o.REM4_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_5: PMECC REM 5 Register (sec_num = 5)
func (o *EBI_Type) SetREM5_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_5.Reg, volatile.LoadUint32(&o.REM5_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_5.Reg, volatile.LoadUint32(&o.REM5_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_5: PMECC REM 6 Register (sec_num = 5)
func (o *EBI_Type) SetREM6_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_5.Reg, volatile.LoadUint32(&o.REM6_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_5.Reg, volatile.LoadUint32(&o.REM6_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_5: PMECC REM 7 Register (sec_num = 5)
func (o *EBI_Type) SetREM7_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_5.Reg, volatile.LoadUint32(&o.REM7_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_5.Reg, volatile.LoadUint32(&o.REM7_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_5: PMECC REM 8 Register (sec_num = 5)
func (o *EBI_Type) SetREM8_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_5.Reg, volatile.LoadUint32(&o.REM8_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_5.Reg, volatile.LoadUint32(&o.REM8_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_5: PMECC REM 9 Register (sec_num = 5)
func (o *EBI_Type) SetREM9_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_5.Reg, volatile.LoadUint32(&o.REM9_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_5.Reg, volatile.LoadUint32(&o.REM9_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_5: PMECC REM 10 Register (sec_num = 5)
func (o *EBI_Type) SetREM10_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_5.Reg, volatile.LoadUint32(&o.REM10_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_5.Reg, volatile.LoadUint32(&o.REM10_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_5: PMECC REM 11 Register (sec_num = 5)
func (o *EBI_Type) SetREM11_5_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_5.Reg, volatile.LoadUint32(&o.REM11_5.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_5_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_5.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_5_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_5.Reg, volatile.LoadUint32(&o.REM11_5.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_5_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_5.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_6: PMECC REM 0 Register (sec_num = 6)
func (o *EBI_Type) SetREM0_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_6.Reg, volatile.LoadUint32(&o.REM0_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_6.Reg, volatile.LoadUint32(&o.REM0_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_6: PMECC REM 1 Register (sec_num = 6)
func (o *EBI_Type) SetREM1_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_6.Reg, volatile.LoadUint32(&o.REM1_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_6.Reg, volatile.LoadUint32(&o.REM1_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_6: PMECC REM 2 Register (sec_num = 6)
func (o *EBI_Type) SetREM2_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_6.Reg, volatile.LoadUint32(&o.REM2_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_6.Reg, volatile.LoadUint32(&o.REM2_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_6: PMECC REM 3 Register (sec_num = 6)
func (o *EBI_Type) SetREM3_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_6.Reg, volatile.LoadUint32(&o.REM3_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_6.Reg, volatile.LoadUint32(&o.REM3_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_6: PMECC REM 4 Register (sec_num = 6)
func (o *EBI_Type) SetREM4_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_6.Reg, volatile.LoadUint32(&o.REM4_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_6.Reg, volatile.LoadUint32(&o.REM4_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_6: PMECC REM 5 Register (sec_num = 6)
func (o *EBI_Type) SetREM5_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_6.Reg, volatile.LoadUint32(&o.REM5_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_6.Reg, volatile.LoadUint32(&o.REM5_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_6: PMECC REM 6 Register (sec_num = 6)
func (o *EBI_Type) SetREM6_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_6.Reg, volatile.LoadUint32(&o.REM6_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_6.Reg, volatile.LoadUint32(&o.REM6_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_6: PMECC REM 7 Register (sec_num = 6)
func (o *EBI_Type) SetREM7_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_6.Reg, volatile.LoadUint32(&o.REM7_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_6.Reg, volatile.LoadUint32(&o.REM7_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_6: PMECC REM 8 Register (sec_num = 6)
func (o *EBI_Type) SetREM8_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_6.Reg, volatile.LoadUint32(&o.REM8_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_6.Reg, volatile.LoadUint32(&o.REM8_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_6: PMECC REM 9 Register (sec_num = 6)
func (o *EBI_Type) SetREM9_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_6.Reg, volatile.LoadUint32(&o.REM9_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_6.Reg, volatile.LoadUint32(&o.REM9_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_6: PMECC REM 10 Register (sec_num = 6)
func (o *EBI_Type) SetREM10_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_6.Reg, volatile.LoadUint32(&o.REM10_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_6.Reg, volatile.LoadUint32(&o.REM10_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_6: PMECC REM 11 Register (sec_num = 6)
func (o *EBI_Type) SetREM11_6_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_6.Reg, volatile.LoadUint32(&o.REM11_6.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_6_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_6.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_6_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_6.Reg, volatile.LoadUint32(&o.REM11_6.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_6_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_6.Reg) & 0x3fff0000) >> 16
}

// EBI.REM0_7: PMECC REM 0 Register (sec_num = 7)
func (o *EBI_Type) SetREM0_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM0_7.Reg, volatile.LoadUint32(&o.REM0_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM0_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM0_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM0_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM0_7.Reg, volatile.LoadUint32(&o.REM0_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM0_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM0_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM1_7: PMECC REM 1 Register (sec_num = 7)
func (o *EBI_Type) SetREM1_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM1_7.Reg, volatile.LoadUint32(&o.REM1_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM1_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM1_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM1_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM1_7.Reg, volatile.LoadUint32(&o.REM1_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM1_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM1_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM2_7: PMECC REM 2 Register (sec_num = 7)
func (o *EBI_Type) SetREM2_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM2_7.Reg, volatile.LoadUint32(&o.REM2_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM2_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM2_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM2_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM2_7.Reg, volatile.LoadUint32(&o.REM2_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM2_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM2_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM3_7: PMECC REM 3 Register (sec_num = 7)
func (o *EBI_Type) SetREM3_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM3_7.Reg, volatile.LoadUint32(&o.REM3_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM3_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM3_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM3_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM3_7.Reg, volatile.LoadUint32(&o.REM3_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM3_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM3_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM4_7: PMECC REM 4 Register (sec_num = 7)
func (o *EBI_Type) SetREM4_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM4_7.Reg, volatile.LoadUint32(&o.REM4_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM4_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM4_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM4_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM4_7.Reg, volatile.LoadUint32(&o.REM4_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM4_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM4_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM5_7: PMECC REM 5 Register (sec_num = 7)
func (o *EBI_Type) SetREM5_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM5_7.Reg, volatile.LoadUint32(&o.REM5_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM5_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM5_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM5_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM5_7.Reg, volatile.LoadUint32(&o.REM5_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM5_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM5_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM6_7: PMECC REM 6 Register (sec_num = 7)
func (o *EBI_Type) SetREM6_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM6_7.Reg, volatile.LoadUint32(&o.REM6_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM6_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM6_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM6_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM6_7.Reg, volatile.LoadUint32(&o.REM6_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM6_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM6_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM7_7: PMECC REM 7 Register (sec_num = 7)
func (o *EBI_Type) SetREM7_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM7_7.Reg, volatile.LoadUint32(&o.REM7_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM7_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM7_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM7_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM7_7.Reg, volatile.LoadUint32(&o.REM7_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM7_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM7_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM8_7: PMECC REM 8 Register (sec_num = 7)
func (o *EBI_Type) SetREM8_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM8_7.Reg, volatile.LoadUint32(&o.REM8_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM8_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM8_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM8_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM8_7.Reg, volatile.LoadUint32(&o.REM8_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM8_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM8_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM9_7: PMECC REM 9 Register (sec_num = 7)
func (o *EBI_Type) SetREM9_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM9_7.Reg, volatile.LoadUint32(&o.REM9_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM9_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM9_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM9_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM9_7.Reg, volatile.LoadUint32(&o.REM9_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM9_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM9_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM10_7: PMECC REM 10 Register (sec_num = 7)
func (o *EBI_Type) SetREM10_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM10_7.Reg, volatile.LoadUint32(&o.REM10_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM10_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM10_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM10_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM10_7.Reg, volatile.LoadUint32(&o.REM10_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM10_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM10_7.Reg) & 0x3fff0000) >> 16
}

// EBI.REM11_7: PMECC REM 11 Register (sec_num = 7)
func (o *EBI_Type) SetREM11_7_REM2NP1(value uint32) {
	volatile.StoreUint32(&o.REM11_7.Reg, volatile.LoadUint32(&o.REM11_7.Reg)&^(0x3fff)|value)
}
func (o *EBI_Type) GetREM11_7_REM2NP1() uint32 {
	return volatile.LoadUint32(&o.REM11_7.Reg) & 0x3fff
}
func (o *EBI_Type) SetREM11_7_REM2NP3(value uint32) {
	volatile.StoreUint32(&o.REM11_7.Reg, volatile.LoadUint32(&o.REM11_7.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EBI_Type) GetREM11_7_REM2NP3() uint32 {
	return (volatile.LoadUint32(&o.REM11_7.Reg) & 0x3fff0000) >> 16
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	SPIP0  volatile.Register32 // 0x54
	DPIP0  volatile.Register32 // 0x58
	_      [8]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	SPIP1  volatile.Register32 // 0x7C
	DPIP1  volatile.Register32 // 0x80
	_      [8]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	SPIP2  volatile.Register32 // 0xA4
	DPIP2  volatile.Register32 // 0xA8
	_      [8]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	SPIP3  volatile.Register32 // 0xCC
	DPIP3  volatile.Register32 // 0xD0
	_      [8]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	SPIP4  volatile.Register32 // 0xF4
	DPIP4  volatile.Register32 // 0xF8
	_      [8]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	SPIP5  volatile.Register32 // 0x11C
	DPIP5  volatile.Register32 // 0x120
	_      [8]byte
	SADDR6 volatile.Register32 // 0x12C
	DADDR6 volatile.Register32 // 0x130
	DSCR6  volatile.Register32 // 0x134
	CTRLA6 volatile.Register32 // 0x138
	CTRLB6 volatile.Register32 // 0x13C
	CFG6   volatile.Register32 // 0x140
	SPIP6  volatile.Register32 // 0x144
	DPIP6  volatile.Register32 // 0x148
	_      [8]byte
	SADDR7 volatile.Register32 // 0x154
	DADDR7 volatile.Register32 // 0x158
	DSCR7  volatile.Register32 // 0x15C
	CTRLA7 volatile.Register32 // 0x160
	CTRLB7 volatile.Register32 // 0x164
	CFG7   volatile.Register32 // 0x168
	SPIP7  volatile.Register32 // 0x16C
	DPIP7  volatile.Register32 // 0x170
	_      [112]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// DMAC.GCFG: DMAC Global Configuration Register
func (o *DMAC_Type) SetGCFG_ARB_CFG(value uint32) {
	volatile.StoreUint32(&o.GCFG.Reg, volatile.LoadUint32(&o.GCFG.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetGCFG_ARB_CFG() uint32 {
	return (volatile.LoadUint32(&o.GCFG.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetGCFG_DICEN(value uint32) {
	volatile.StoreUint32(&o.GCFG.Reg, volatile.LoadUint32(&o.GCFG.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetGCFG_DICEN() uint32 {
	return (volatile.LoadUint32(&o.GCFG.Reg) & 0x100) >> 8
}

// DMAC.EN: DMAC Enable Register
func (o *DMAC_Type) SetEN_ENABLE(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEN_ENABLE() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DMAC.SREQ: DMAC Software Single Request Register
func (o *DMAC_Type) SetSREQ_SSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSREQ_SSREQ0() uint32 {
	return volatile.LoadUint32(&o.SREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetSREQ_DSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSREQ_DSREQ0() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSREQ_SSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSREQ_SSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSREQ_DSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSREQ_DSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSREQ_SSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSREQ_SSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSREQ_DSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSREQ_DSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSREQ_SSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSREQ_SSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSREQ_DSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSREQ_DSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetSREQ_SSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetSREQ_SSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetSREQ_DSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetSREQ_DSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetSREQ_SSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetSREQ_SSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetSREQ_DSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetSREQ_DSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetSREQ_SSREQ6(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetSREQ_SSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetSREQ_DSREQ6(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetSREQ_DSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetSREQ_SSREQ7(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetSREQ_SSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetSREQ_DSREQ7(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetSREQ_DSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8000) >> 15
}

// DMAC.CREQ: DMAC Software Chunk Transfer Request Register
func (o *DMAC_Type) SetCREQ_SCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCREQ_SCREQ0() uint32 {
	return volatile.LoadUint32(&o.CREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetCREQ_DCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCREQ_DCREQ0() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCREQ_SCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCREQ_SCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCREQ_DCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCREQ_DCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCREQ_SCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCREQ_SCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCREQ_DCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCREQ_DCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCREQ_SCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCREQ_SCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCREQ_DCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCREQ_DCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCREQ_SCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCREQ_SCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCREQ_DCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCREQ_DCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCREQ_SCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCREQ_SCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCREQ_DCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCREQ_DCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCREQ_SCREQ6(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCREQ_SCREQ6() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCREQ_DCREQ6(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCREQ_DCREQ6() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCREQ_SCREQ7(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCREQ_SCREQ7() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCREQ_DCREQ7(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCREQ_DCREQ7() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8000) >> 15
}

// DMAC.LAST: DMAC Software Last Transfer Flag Register
func (o *DMAC_Type) SetLAST_SLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetLAST_SLAST0() uint32 {
	return volatile.LoadUint32(&o.LAST.Reg) & 0x1
}
func (o *DMAC_Type) SetLAST_DLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetLAST_DLAST0() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetLAST_SLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetLAST_SLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetLAST_DLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetLAST_DLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetLAST_SLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetLAST_SLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetLAST_DLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetLAST_DLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetLAST_SLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetLAST_SLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetLAST_DLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetLAST_DLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetLAST_SLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetLAST_SLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetLAST_DLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetLAST_DLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetLAST_SLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetLAST_SLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetLAST_DLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetLAST_DLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetLAST_SLAST6(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetLAST_SLAST6() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetLAST_DLAST6(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetLAST_DLAST6() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetLAST_SLAST7(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetLAST_SLAST7() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetLAST_DLAST7(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetLAST_DLAST7() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8000) >> 15
}

// DMAC.EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
func (o *DMAC_Type) SetEBCIER_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIER_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIER.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIER_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIER_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIER_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIER_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIER_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIER_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIER_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIER_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIER_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIER_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIER_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIER_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIER_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIER_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIER_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIER_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIER_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIER_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIER_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIER_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIER_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIER_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIER_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIER_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIER_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIER_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIER_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIER_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIER_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIER_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIER_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIER_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIER_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIER_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIER_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIER_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIER_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIER_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIER_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIER_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIER_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIER_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIER_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIER_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIER_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIER_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetEBCIER_DICERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetEBCIER_DICERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetEBCIER_DICERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetEBCIER_DICERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetEBCIER_DICERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetEBCIER_DICERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetEBCIER_DICERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetEBCIER_DICERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetEBCIER_DICERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetEBCIER_DICERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetEBCIER_DICERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetEBCIER_DICERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetEBCIER_DICERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetEBCIER_DICERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetEBCIER_DICERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetEBCIER_DICERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80000000) >> 31
}

// DMAC.EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
func (o *DMAC_Type) SetEBCIDR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIDR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIDR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIDR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIDR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIDR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIDR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIDR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIDR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIDR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIDR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIDR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIDR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIDR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIDR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIDR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIDR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIDR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIDR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIDR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIDR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIDR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIDR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIDR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIDR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIDR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIDR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIDR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIDR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIDR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIDR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIDR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIDR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIDR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIDR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIDR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIDR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIDR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIDR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIDR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIDR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIDR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIDR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIDR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIDR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIDR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIDR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIDR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetEBCIDR_DICERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetEBCIDR_DICERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetEBCIDR_DICERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetEBCIDR_DICERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetEBCIDR_DICERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetEBCIDR_DICERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetEBCIDR_DICERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetEBCIDR_DICERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetEBCIDR_DICERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetEBCIDR_DICERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetEBCIDR_DICERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetEBCIDR_DICERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetEBCIDR_DICERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetEBCIDR_DICERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetEBCIDR_DICERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetEBCIDR_DICERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80000000) >> 31
}

// DMAC.EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
func (o *DMAC_Type) SetEBCIMR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIMR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIMR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIMR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIMR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIMR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIMR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIMR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIMR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIMR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIMR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIMR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIMR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIMR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIMR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIMR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIMR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIMR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIMR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIMR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIMR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIMR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIMR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIMR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIMR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIMR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIMR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIMR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIMR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIMR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIMR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIMR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIMR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIMR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIMR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIMR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIMR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIMR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIMR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIMR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIMR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIMR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIMR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIMR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIMR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIMR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIMR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIMR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetEBCIMR_DICERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetEBCIMR_DICERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetEBCIMR_DICERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetEBCIMR_DICERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetEBCIMR_DICERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetEBCIMR_DICERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetEBCIMR_DICERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetEBCIMR_DICERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetEBCIMR_DICERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetEBCIMR_DICERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetEBCIMR_DICERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetEBCIMR_DICERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetEBCIMR_DICERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetEBCIMR_DICERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetEBCIMR_DICERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetEBCIMR_DICERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80000000) >> 31
}

// DMAC.EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
func (o *DMAC_Type) SetEBCISR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCISR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCISR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCISR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCISR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCISR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCISR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCISR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCISR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCISR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCISR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCISR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCISR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCISR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCISR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCISR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCISR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCISR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCISR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCISR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCISR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCISR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCISR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCISR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCISR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCISR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCISR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCISR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCISR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCISR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCISR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCISR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCISR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCISR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCISR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCISR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCISR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCISR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCISR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCISR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCISR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCISR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCISR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCISR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCISR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCISR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCISR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCISR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCISR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetEBCISR_DICERR0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetEBCISR_DICERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetEBCISR_DICERR1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetEBCISR_DICERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetEBCISR_DICERR2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetEBCISR_DICERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetEBCISR_DICERR3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetEBCISR_DICERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetEBCISR_DICERR4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetEBCISR_DICERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetEBCISR_DICERR5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetEBCISR_DICERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetEBCISR_DICERR6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetEBCISR_DICERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetEBCISR_DICERR7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetEBCISR_DICERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80000000) >> 31
}

// DMAC.CHER: DMAC Channel Handler Enable Register
func (o *DMAC_Type) SetCHER_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHER_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DMAC_Type) SetCHER_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHER_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHER_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHER_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHER_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHER_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHER_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHER_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHER_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHER_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHER_ENA6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHER_ENA6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHER_ENA7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHER_ENA7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHER_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHER_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHER_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHER_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHER_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHER_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHER_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHER_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHER_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHER_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHER_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHER_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHER_SUSP6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHER_SUSP6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHER_SUSP7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHER_SUSP7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetCHER_KEEP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHER_KEEP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHER_KEEP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHER_KEEP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHER_KEEP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHER_KEEP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHER_KEEP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHER_KEEP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHER_KEEP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHER_KEEP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHER_KEEP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHER_KEEP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetCHER_KEEP6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCHER_KEEP6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCHER_KEEP7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCHER_KEEP7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80000000) >> 31
}

// DMAC.CHDR: DMAC Channel Handler Disable Register
func (o *DMAC_Type) SetCHDR_DIS0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHDR_DIS0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHDR_DIS1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHDR_DIS1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHDR_DIS2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHDR_DIS2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHDR_DIS3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHDR_DIS3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHDR_DIS4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHDR_DIS4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHDR_DIS5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHDR_DIS5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHDR_DIS6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHDR_DIS6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHDR_DIS7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHDR_DIS7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHDR_RES0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHDR_RES0() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHDR_RES1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHDR_RES1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHDR_RES2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHDR_RES2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHDR_RES3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHDR_RES3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHDR_RES4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHDR_RES4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHDR_RES5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHDR_RES5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHDR_RES6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHDR_RES6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHDR_RES7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHDR_RES7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8000) >> 15
}

// DMAC.CHSR: DMAC Channel Handler Status Register
func (o *DMAC_Type) SetCHSR_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSR_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSR_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSR_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSR_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSR_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHSR_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHSR_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHSR_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHSR_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHSR_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHSR_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHSR_ENA6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHSR_ENA6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHSR_ENA7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHSR_ENA7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHSR_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHSR_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHSR_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHSR_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHSR_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHSR_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHSR_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHSR_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHSR_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHSR_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHSR_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHSR_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHSR_SUSP6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHSR_SUSP6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHSR_SUSP7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHSR_SUSP7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetCHSR_EMPT0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCHSR_EMPT0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCHSR_EMPT1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetCHSR_EMPT1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetCHSR_EMPT2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetCHSR_EMPT2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetCHSR_EMPT3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetCHSR_EMPT3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetCHSR_EMPT4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCHSR_EMPT4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCHSR_EMPT5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCHSR_EMPT5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCHSR_EMPT6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCHSR_EMPT6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCHSR_EMPT7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetCHSR_EMPT7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetCHSR_STAL0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHSR_STAL0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHSR_STAL1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHSR_STAL1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHSR_STAL2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHSR_STAL2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHSR_STAL3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHSR_STAL3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHSR_STAL4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHSR_STAL4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHSR_STAL5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHSR_STAL5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetCHSR_STAL6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCHSR_STAL6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCHSR_STAL7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCHSR_STAL7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000000) >> 31
}

// DMAC.SADDR0: DMAC Channel Source Address Register (ch_num = 0)
func (o *DMAC_Type) SetSADDR0(value uint32) {
	volatile.StoreUint32(&o.SADDR0.Reg, value)
}
func (o *DMAC_Type) GetSADDR0() uint32 {
	return volatile.LoadUint32(&o.SADDR0.Reg)
}

// DMAC.DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
func (o *DMAC_Type) SetDADDR0(value uint32) {
	volatile.StoreUint32(&o.DADDR0.Reg, value)
}
func (o *DMAC_Type) GetDADDR0() uint32 {
	return volatile.LoadUint32(&o.DADDR0.Reg)
}

// DMAC.DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
func (o *DMAC_Type) SetDSCR0_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR0_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR0.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR0_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR0_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR0.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA0: DMAC Channel Control A Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLA0_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA0_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA0.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA0_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA0_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA0_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA0_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA0_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA0_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA0_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA0_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA0_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA0_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB0: DMAC Channel Control B Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLB0_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB0_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB0_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB0_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB0_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB0_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB0_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB0_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB0_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB0_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB0_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB0_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB0_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB0_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB0_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB0_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB0_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB0_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB0_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB0_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB0_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB0_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x80000000) >> 31
}

// DMAC.CFG0: DMAC Channel Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetCFG0_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG0_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG0.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG0_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG0_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG0_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG0_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG0_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG0_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG0_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG0_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG0_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG0_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG0_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG0_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG0_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG0_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG0_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG0_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG0_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG0_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG0_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG0_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG0_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG0_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG0_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG0_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP0: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetSPIP0_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP0.Reg, volatile.LoadUint32(&o.SPIP0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP0_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP0.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP0_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP0.Reg, volatile.LoadUint32(&o.SPIP0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP0_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP0.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP0: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetDPIP0_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP0.Reg, volatile.LoadUint32(&o.DPIP0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP0_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP0.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP0_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP0.Reg, volatile.LoadUint32(&o.DPIP0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP0_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP0.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR1: DMAC Channel Source Address Register (ch_num = 1)
func (o *DMAC_Type) SetSADDR1(value uint32) {
	volatile.StoreUint32(&o.SADDR1.Reg, value)
}
func (o *DMAC_Type) GetSADDR1() uint32 {
	return volatile.LoadUint32(&o.SADDR1.Reg)
}

// DMAC.DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
func (o *DMAC_Type) SetDADDR1(value uint32) {
	volatile.StoreUint32(&o.DADDR1.Reg, value)
}
func (o *DMAC_Type) GetDADDR1() uint32 {
	return volatile.LoadUint32(&o.DADDR1.Reg)
}

// DMAC.DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
func (o *DMAC_Type) SetDSCR1_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR1_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR1.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR1.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA1: DMAC Channel Control A Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLA1_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA1_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA1.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA1_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA1_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA1_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA1_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA1_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA1_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA1_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA1_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA1_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA1_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB1: DMAC Channel Control B Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLB1_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB1_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB1_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB1_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB1_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB1_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB1_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB1_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB1_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB1_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB1_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB1_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB1_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB1_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB1_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB1_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB1_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB1_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB1_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB1_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB1_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB1_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x80000000) >> 31
}

// DMAC.CFG1: DMAC Channel Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetCFG1_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG1_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG1_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG1_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG1_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG1_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG1_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG1_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG1_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG1_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG1_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG1_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG1_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG1_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG1_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG1_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG1_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG1_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG1_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG1_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG1_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG1_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG1_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG1_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG1_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP1: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetSPIP1_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP1.Reg, volatile.LoadUint32(&o.SPIP1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP1_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP1.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP1_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP1.Reg, volatile.LoadUint32(&o.SPIP1.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP1_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP1.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP1: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetDPIP1_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP1.Reg, volatile.LoadUint32(&o.DPIP1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP1_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP1.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP1_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP1.Reg, volatile.LoadUint32(&o.DPIP1.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP1_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP1.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR2: DMAC Channel Source Address Register (ch_num = 2)
func (o *DMAC_Type) SetSADDR2(value uint32) {
	volatile.StoreUint32(&o.SADDR2.Reg, value)
}
func (o *DMAC_Type) GetSADDR2() uint32 {
	return volatile.LoadUint32(&o.SADDR2.Reg)
}

// DMAC.DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
func (o *DMAC_Type) SetDADDR2(value uint32) {
	volatile.StoreUint32(&o.DADDR2.Reg, value)
}
func (o *DMAC_Type) GetDADDR2() uint32 {
	return volatile.LoadUint32(&o.DADDR2.Reg)
}

// DMAC.DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
func (o *DMAC_Type) SetDSCR2_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR2_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR2.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR2_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR2_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR2.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA2: DMAC Channel Control A Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLA2_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA2_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA2.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA2_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA2_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA2_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA2_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA2_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA2_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA2_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA2_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA2_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA2_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB2: DMAC Channel Control B Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLB2_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB2_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB2_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB2_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB2_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB2_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB2_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB2_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB2_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB2_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB2_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB2_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB2_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB2_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB2_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB2_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB2_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB2_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB2_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB2_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB2_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB2_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x80000000) >> 31
}

// DMAC.CFG2: DMAC Channel Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetCFG2_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG2_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG2_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG2_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG2_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG2_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG2_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG2_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG2_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG2_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG2_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG2_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG2_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG2_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG2_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG2_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG2_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG2_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG2_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG2_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG2_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG2_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG2_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG2_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG2_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG2_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP2: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetSPIP2_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP2.Reg, volatile.LoadUint32(&o.SPIP2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP2_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP2.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP2_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP2.Reg, volatile.LoadUint32(&o.SPIP2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP2_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP2.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP2: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetDPIP2_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP2.Reg, volatile.LoadUint32(&o.DPIP2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP2_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP2.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP2_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP2.Reg, volatile.LoadUint32(&o.DPIP2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP2_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP2.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR3: DMAC Channel Source Address Register (ch_num = 3)
func (o *DMAC_Type) SetSADDR3(value uint32) {
	volatile.StoreUint32(&o.SADDR3.Reg, value)
}
func (o *DMAC_Type) GetSADDR3() uint32 {
	return volatile.LoadUint32(&o.SADDR3.Reg)
}

// DMAC.DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
func (o *DMAC_Type) SetDADDR3(value uint32) {
	volatile.StoreUint32(&o.DADDR3.Reg, value)
}
func (o *DMAC_Type) GetDADDR3() uint32 {
	return volatile.LoadUint32(&o.DADDR3.Reg)
}

// DMAC.DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
func (o *DMAC_Type) SetDSCR3_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR3_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR3.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR3_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR3_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR3.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA3: DMAC Channel Control A Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLA3_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA3_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA3.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA3_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA3_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA3_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA3_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA3_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA3_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA3_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA3_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA3_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA3_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB3: DMAC Channel Control B Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLB3_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB3_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB3_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB3_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB3_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB3_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB3_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB3_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB3_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB3_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB3_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB3_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB3_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB3_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB3_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB3_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB3_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB3_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB3_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB3_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB3_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB3_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x80000000) >> 31
}

// DMAC.CFG3: DMAC Channel Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetCFG3_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG3_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG3.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG3_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG3_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG3_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG3_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG3_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG3_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG3_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG3_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG3_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG3_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG3_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG3_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG3_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG3_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG3_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG3_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG3_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG3_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG3_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG3_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG3_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG3_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG3_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG3_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP3: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetSPIP3_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP3.Reg, volatile.LoadUint32(&o.SPIP3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP3_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP3.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP3_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP3.Reg, volatile.LoadUint32(&o.SPIP3.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP3_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP3.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP3: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetDPIP3_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP3.Reg, volatile.LoadUint32(&o.DPIP3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP3_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP3.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP3_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP3.Reg, volatile.LoadUint32(&o.DPIP3.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP3_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP3.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR4: DMAC Channel Source Address Register (ch_num = 4)
func (o *DMAC_Type) SetSADDR4(value uint32) {
	volatile.StoreUint32(&o.SADDR4.Reg, value)
}
func (o *DMAC_Type) GetSADDR4() uint32 {
	return volatile.LoadUint32(&o.SADDR4.Reg)
}

// DMAC.DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
func (o *DMAC_Type) SetDADDR4(value uint32) {
	volatile.StoreUint32(&o.DADDR4.Reg, value)
}
func (o *DMAC_Type) GetDADDR4() uint32 {
	return volatile.LoadUint32(&o.DADDR4.Reg)
}

// DMAC.DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
func (o *DMAC_Type) SetDSCR4_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR4.Reg, volatile.LoadUint32(&o.DSCR4.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR4_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR4.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR4_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR4.Reg, volatile.LoadUint32(&o.DSCR4.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR4_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR4.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA4: DMAC Channel Control A Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLA4_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA4_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA4.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA4_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA4_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA4_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA4_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA4_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA4_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA4_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA4_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA4_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA4_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB4: DMAC Channel Control B Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLB4_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB4_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB4.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB4_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB4_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB4_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB4_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB4_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB4_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB4_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB4_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB4_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB4_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB4_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB4_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB4_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB4_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB4_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB4_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB4_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB4_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB4_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB4_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x80000000) >> 31
}

// DMAC.CFG4: DMAC Channel Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetCFG4_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG4_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG4.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG4_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG4_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG4_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG4_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG4_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG4_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG4_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG4_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG4_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG4_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG4_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG4_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG4_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG4_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG4_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG4_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG4_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG4_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG4_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG4_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG4_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG4_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG4_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG4_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP4: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetSPIP4_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP4.Reg, volatile.LoadUint32(&o.SPIP4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP4_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP4.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP4_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP4.Reg, volatile.LoadUint32(&o.SPIP4.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP4_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP4.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP4: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetDPIP4_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP4.Reg, volatile.LoadUint32(&o.DPIP4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP4_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP4.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP4_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP4.Reg, volatile.LoadUint32(&o.DPIP4.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP4_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP4.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR5: DMAC Channel Source Address Register (ch_num = 5)
func (o *DMAC_Type) SetSADDR5(value uint32) {
	volatile.StoreUint32(&o.SADDR5.Reg, value)
}
func (o *DMAC_Type) GetSADDR5() uint32 {
	return volatile.LoadUint32(&o.SADDR5.Reg)
}

// DMAC.DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
func (o *DMAC_Type) SetDADDR5(value uint32) {
	volatile.StoreUint32(&o.DADDR5.Reg, value)
}
func (o *DMAC_Type) GetDADDR5() uint32 {
	return volatile.LoadUint32(&o.DADDR5.Reg)
}

// DMAC.DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
func (o *DMAC_Type) SetDSCR5_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR5.Reg, volatile.LoadUint32(&o.DSCR5.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR5_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR5.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR5_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR5.Reg, volatile.LoadUint32(&o.DSCR5.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR5_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR5.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA5: DMAC Channel Control A Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLA5_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA5_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA5.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA5_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA5_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA5_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA5_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA5_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA5_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA5_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA5_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA5_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA5_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB5: DMAC Channel Control B Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLB5_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB5_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB5.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB5_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB5_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB5_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB5_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB5_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB5_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB5_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB5_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB5_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB5_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB5_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB5_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB5_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB5_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB5_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB5_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB5_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB5_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB5_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB5_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x80000000) >> 31
}

// DMAC.CFG5: DMAC Channel Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetCFG5_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG5_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG5.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG5_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG5_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG5_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG5_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG5_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG5_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG5_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG5_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG5_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG5_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG5_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG5_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG5_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG5_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG5_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG5_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG5_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG5_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG5_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG5_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG5_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG5_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG5_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG5_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP5: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetSPIP5_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP5.Reg, volatile.LoadUint32(&o.SPIP5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP5_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP5.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP5_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP5.Reg, volatile.LoadUint32(&o.SPIP5.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP5_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP5.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP5: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetDPIP5_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP5.Reg, volatile.LoadUint32(&o.DPIP5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP5_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP5.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP5_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP5.Reg, volatile.LoadUint32(&o.DPIP5.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP5_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP5.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR6: DMAC Channel Source Address Register (ch_num = 6)
func (o *DMAC_Type) SetSADDR6(value uint32) {
	volatile.StoreUint32(&o.SADDR6.Reg, value)
}
func (o *DMAC_Type) GetSADDR6() uint32 {
	return volatile.LoadUint32(&o.SADDR6.Reg)
}

// DMAC.DADDR6: DMAC Channel Destination Address Register (ch_num = 6)
func (o *DMAC_Type) SetDADDR6(value uint32) {
	volatile.StoreUint32(&o.DADDR6.Reg, value)
}
func (o *DMAC_Type) GetDADDR6() uint32 {
	return volatile.LoadUint32(&o.DADDR6.Reg)
}

// DMAC.DSCR6: DMAC Channel Descriptor Address Register (ch_num = 6)
func (o *DMAC_Type) SetDSCR6_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR6.Reg, volatile.LoadUint32(&o.DSCR6.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR6_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR6.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR6_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR6.Reg, volatile.LoadUint32(&o.DSCR6.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR6_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR6.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA6: DMAC Channel Control A Register (ch_num = 6)
func (o *DMAC_Type) SetCTRLA6_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA6_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA6.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA6_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA6_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA6_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA6_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA6_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA6_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA6_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA6_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA6_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA6_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB6: DMAC Channel Control B Register (ch_num = 6)
func (o *DMAC_Type) SetCTRLB6_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB6_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB6.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB6_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB6_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB6_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB6_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB6_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB6_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB6_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB6_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB6_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB6_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB6_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB6_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB6_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB6_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB6_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB6_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB6_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB6_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB6_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB6_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x80000000) >> 31
}

// DMAC.CFG6: DMAC Channel Configuration Register (ch_num = 6)
func (o *DMAC_Type) SetCFG6_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG6_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG6.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG6_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG6_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG6_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG6_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG6_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG6_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG6_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG6_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG6_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG6_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG6_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG6_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG6_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG6_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG6_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG6_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG6_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG6_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG6_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG6_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG6_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG6_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG6_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG6_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG6_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG6_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP6: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 6)
func (o *DMAC_Type) SetSPIP6_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP6.Reg, volatile.LoadUint32(&o.SPIP6.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP6_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP6.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP6_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP6.Reg, volatile.LoadUint32(&o.SPIP6.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP6_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP6.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP6: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 6)
func (o *DMAC_Type) SetDPIP6_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP6.Reg, volatile.LoadUint32(&o.DPIP6.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP6_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP6.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP6_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP6.Reg, volatile.LoadUint32(&o.DPIP6.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP6_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP6.Reg) & 0x3ff0000) >> 16
}

// DMAC.SADDR7: DMAC Channel Source Address Register (ch_num = 7)
func (o *DMAC_Type) SetSADDR7(value uint32) {
	volatile.StoreUint32(&o.SADDR7.Reg, value)
}
func (o *DMAC_Type) GetSADDR7() uint32 {
	return volatile.LoadUint32(&o.SADDR7.Reg)
}

// DMAC.DADDR7: DMAC Channel Destination Address Register (ch_num = 7)
func (o *DMAC_Type) SetDADDR7(value uint32) {
	volatile.StoreUint32(&o.DADDR7.Reg, value)
}
func (o *DMAC_Type) GetDADDR7() uint32 {
	return volatile.LoadUint32(&o.DADDR7.Reg)
}

// DMAC.DSCR7: DMAC Channel Descriptor Address Register (ch_num = 7)
func (o *DMAC_Type) SetDSCR7_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR7.Reg, volatile.LoadUint32(&o.DSCR7.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR7_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR7.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR7_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR7.Reg, volatile.LoadUint32(&o.DSCR7.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR7_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR7.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA7: DMAC Channel Control A Register (ch_num = 7)
func (o *DMAC_Type) SetCTRLA7_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA7_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA7.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA7_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA7_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA7_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA7_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA7_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA7_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA7_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA7_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA7_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA7_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB7: DMAC Channel Control B Register (ch_num = 7)
func (o *DMAC_Type) SetCTRLB7_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB7_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB7.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB7_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB7_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB7_SRC_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRLB7_SRC_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRLB7_DST_PIP(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCTRLB7_DST_PIP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCTRLB7_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB7_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB7_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB7_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB7_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB7_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB7_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB7_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB7_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB7_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB7_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB7_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB7_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB7_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x80000000) >> 31
}

// DMAC.CFG7: DMAC Channel Configuration Register (ch_num = 7)
func (o *DMAC_Type) SetCFG7_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG7_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG7.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG7_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG7_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG7_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG7_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG7_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG7_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG7_SRC_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xc00)|value<<10)
}
func (o *DMAC_Type) GetCFG7_SRC_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xc00) >> 10
}
func (o *DMAC_Type) SetCFG7_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG7_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG7_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG7_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG7_DST_PER_MSB(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xc000)|value<<14)
}
func (o *DMAC_Type) GetCFG7_DST_PER_MSB() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xc000) >> 14
}
func (o *DMAC_Type) SetCFG7_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG7_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG7_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG7_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG7_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG7_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG7_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG7_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG7_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG7_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG7_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG7_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x30000000) >> 28
}

// DMAC.SPIP7: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 7)
func (o *DMAC_Type) SetSPIP7_SPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.SPIP7.Reg, volatile.LoadUint32(&o.SPIP7.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetSPIP7_SPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.SPIP7.Reg) & 0xffff
}
func (o *DMAC_Type) SetSPIP7_SPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.SPIP7.Reg, volatile.LoadUint32(&o.SPIP7.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetSPIP7_SPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.SPIP7.Reg) & 0x3ff0000) >> 16
}

// DMAC.DPIP7: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 7)
func (o *DMAC_Type) SetDPIP7_DPIP_HOLE(value uint32) {
	volatile.StoreUint32(&o.DPIP7.Reg, volatile.LoadUint32(&o.DPIP7.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetDPIP7_DPIP_HOLE() uint32 {
	return volatile.LoadUint32(&o.DPIP7.Reg) & 0xffff
}
func (o *DMAC_Type) SetDPIP7_DPIP_BOUNDARY(value uint32) {
	volatile.StoreUint32(&o.DPIP7.Reg, volatile.LoadUint32(&o.DPIP7.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DMAC_Type) GetDPIP7_DPIP_BOUNDARY() uint32 {
	return (volatile.LoadUint32(&o.DPIP7.Reg) & 0x3ff0000) >> 16
}

// DMAC.WPMR: DMAC Write Protect Mode Register
func (o *DMAC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DMAC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DMAC.WPSR: DMAC Write Protect Status Register
func (o *DMAC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *DMAC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
	_     [152]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// AIC.SMR: Source Mode Register
func (o *AIC_Type) SetSMR_PRIOR(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x7)|value)
}
func (o *AIC_Type) GetSMR_PRIOR(idx int) uint32 {
	return volatile.LoadUint32(&o.SMR[idx].Reg) & 0x7
}
func (o *AIC_Type) SetSMR_SRCTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x60)|value<<5)
}
func (o *AIC_Type) GetSMR_SRCTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SMR[idx].Reg) & 0x60) >> 5
}

// AIC.SVR: Source Vector Register
func (o *AIC_Type) SetSVR(idx int, value uint32) {
	volatile.StoreUint32(&o.SVR[idx].Reg, value)
}
func (o *AIC_Type) GetSVR(idx int) uint32 {
	return volatile.LoadUint32(&o.SVR[idx].Reg)
}

// AIC.IVR: Interrupt Vector Register
func (o *AIC_Type) SetIVR(value uint32) {
	volatile.StoreUint32(&o.IVR.Reg, value)
}
func (o *AIC_Type) GetIVR() uint32 {
	return volatile.LoadUint32(&o.IVR.Reg)
}

// AIC.FVR: FIQ Interrupt Vector Register
func (o *AIC_Type) SetFVR(value uint32) {
	volatile.StoreUint32(&o.FVR.Reg, value)
}
func (o *AIC_Type) GetFVR() uint32 {
	return volatile.LoadUint32(&o.FVR.Reg)
}

// AIC.ISR: Interrupt Status Register
func (o *AIC_Type) SetISR_IRQID(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1f)|value)
}
func (o *AIC_Type) GetISR_IRQID() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1f
}

// AIC.IPR: Interrupt Pending Register
func (o *AIC_Type) SetIPR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIPR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IPR.Reg) & 0x1
}
func (o *AIC_Type) SetIPR_SYS(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIPR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIPR_PID2(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIPR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIPR_PID3(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIPR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIPR_PID4(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIPR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIPR_PID5(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIPR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIPR_PID6(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIPR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIPR_PID7(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIPR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIPR_PID8(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIPR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIPR_PID9(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIPR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIPR_PID10(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIPR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIPR_PID11(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIPR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIPR_PID12(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIPR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIPR_PID13(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIPR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIPR_PID14(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIPR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIPR_PID15(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIPR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIPR_PID16(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIPR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIPR_PID17(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIPR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIPR_PID18(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIPR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIPR_PID19(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIPR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIPR_PID20(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIPR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIPR_PID21(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIPR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIPR_PID22(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIPR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIPR_PID23(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIPR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIPR_PID24(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIPR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIPR_PID25(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIPR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIPR_PID26(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIPR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIPR_PID27(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIPR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIPR_PID28(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIPR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIPR_PID29(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIPR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIPR_PID30(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIPR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIPR_PID31(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIPR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000000) >> 31
}

// AIC.IMR: Interrupt Mask Register
func (o *AIC_Type) SetIMR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIMR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AIC_Type) SetIMR_SYS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIMR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIMR_PID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIMR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIMR_PID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIMR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIMR_PID4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIMR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIMR_PID5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIMR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIMR_PID6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIMR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIMR_PID7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIMR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIMR_PID8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIMR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIMR_PID9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIMR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIMR_PID10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIMR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIMR_PID11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIMR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIMR_PID12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIMR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIMR_PID13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIMR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIMR_PID14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIMR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIMR_PID15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIMR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIMR_PID16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIMR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIMR_PID17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIMR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIMR_PID18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIMR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIMR_PID19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIMR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIMR_PID20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIMR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIMR_PID21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIMR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIMR_PID22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIMR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIMR_PID23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIMR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIMR_PID24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIMR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIMR_PID25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIMR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIMR_PID26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIMR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIMR_PID27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIMR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIMR_PID28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIMR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIMR_PID29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIMR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIMR_PID30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIMR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIMR_PID31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIMR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// AIC.CISR: Core Interrupt Status Register
func (o *AIC_Type) SetCISR_NFIQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetCISR_NFIQ() uint32 {
	return volatile.LoadUint32(&o.CISR.Reg) & 0x1
}
func (o *AIC_Type) SetCISR_NIRQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetCISR_NIRQ() uint32 {
	return (volatile.LoadUint32(&o.CISR.Reg) & 0x2) >> 1
}

// AIC.IECR: Interrupt Enable Command Register
func (o *AIC_Type) SetIECR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIECR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IECR.Reg) & 0x1
}
func (o *AIC_Type) SetIECR_SYS(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIECR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIECR_PID2(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIECR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIECR_PID3(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIECR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIECR_PID4(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIECR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIECR_PID5(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIECR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIECR_PID6(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIECR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIECR_PID7(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIECR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIECR_PID8(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIECR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIECR_PID9(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIECR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIECR_PID10(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIECR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIECR_PID11(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIECR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIECR_PID12(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIECR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIECR_PID13(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIECR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIECR_PID14(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIECR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIECR_PID15(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIECR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIECR_PID16(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIECR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIECR_PID17(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIECR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIECR_PID18(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIECR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIECR_PID19(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIECR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIECR_PID20(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIECR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIECR_PID21(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIECR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIECR_PID22(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIECR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIECR_PID23(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIECR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIECR_PID24(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIECR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIECR_PID25(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIECR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIECR_PID26(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIECR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIECR_PID27(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIECR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIECR_PID28(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIECR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIECR_PID29(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIECR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIECR_PID30(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIECR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIECR_PID31(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIECR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000000) >> 31
}

// AIC.IDCR: Interrupt Disable Command Register
func (o *AIC_Type) SetIDCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIDCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IDCR.Reg) & 0x1
}
func (o *AIC_Type) SetIDCR_SYS(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIDCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIDCR_PID2(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIDCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIDCR_PID3(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIDCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIDCR_PID4(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIDCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIDCR_PID5(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIDCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIDCR_PID6(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIDCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIDCR_PID7(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIDCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIDCR_PID8(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIDCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIDCR_PID9(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIDCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIDCR_PID10(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIDCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIDCR_PID11(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIDCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIDCR_PID12(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIDCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIDCR_PID13(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIDCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIDCR_PID14(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIDCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIDCR_PID15(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIDCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIDCR_PID16(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIDCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIDCR_PID17(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIDCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIDCR_PID18(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIDCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIDCR_PID19(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIDCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIDCR_PID20(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIDCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIDCR_PID21(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIDCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIDCR_PID22(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIDCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIDCR_PID23(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIDCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIDCR_PID24(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIDCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIDCR_PID25(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIDCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIDCR_PID26(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIDCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIDCR_PID27(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIDCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIDCR_PID28(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIDCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIDCR_PID29(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIDCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIDCR_PID30(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIDCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIDCR_PID31(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIDCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000000) >> 31
}

// AIC.ICCR: Interrupt Clear Command Register
func (o *AIC_Type) SetICCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetICCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ICCR.Reg) & 0x1
}
func (o *AIC_Type) SetICCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetICCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetICCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetICCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetICCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetICCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetICCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetICCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetICCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetICCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetICCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetICCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetICCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetICCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetICCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetICCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetICCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetICCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetICCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetICCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetICCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetICCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetICCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetICCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetICCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetICCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetICCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetICCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetICCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetICCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetICCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetICCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetICCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetICCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetICCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetICCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetICCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetICCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetICCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetICCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetICCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetICCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetICCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetICCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetICCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetICCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetICCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetICCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetICCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetICCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetICCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetICCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetICCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetICCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetICCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetICCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetICCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetICCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetICCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetICCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetICCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetICCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000000) >> 31
}

// AIC.ISCR: Interrupt Set Command Register
func (o *AIC_Type) SetISCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetISCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ISCR.Reg) & 0x1
}
func (o *AIC_Type) SetISCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetISCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetISCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetISCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetISCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetISCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetISCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetISCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetISCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetISCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetISCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetISCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetISCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetISCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetISCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetISCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetISCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetISCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetISCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetISCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetISCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetISCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetISCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetISCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetISCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetISCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetISCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetISCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetISCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetISCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetISCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetISCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetISCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetISCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetISCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetISCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetISCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetISCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetISCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetISCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetISCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetISCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetISCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetISCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetISCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetISCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetISCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetISCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetISCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetISCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetISCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetISCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetISCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetISCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetISCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetISCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetISCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetISCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetISCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetISCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetISCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetISCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000000) >> 31
}

// AIC.SPU: Spurious Interrupt Vector Register
func (o *AIC_Type) SetSPU(value uint32) {
	volatile.StoreUint32(&o.SPU.Reg, value)
}
func (o *AIC_Type) GetSPU() uint32 {
	return volatile.LoadUint32(&o.SPU.Reg)
}

// AIC.DCR: Debug Control Register
func (o *AIC_Type) SetDCR_PROT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetDCR_PROT() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}
func (o *AIC_Type) SetDCR_GMSK(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetDCR_GMSK() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x2) >> 1
}

// AIC.FFER: Fast Forcing Enable Register
func (o *AIC_Type) SetFFER_SYS(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFER_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFER_PID2(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFER_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFER_PID3(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFER_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFER_PID4(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFER_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFER_PID5(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFER_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFER_PID6(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFER_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFER_PID7(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFER_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFER_PID8(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFER_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFER_PID9(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFER_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFER_PID10(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFER_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFER_PID11(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFER_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFER_PID12(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFER_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFER_PID13(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFER_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFER_PID14(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFER_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFER_PID15(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFER_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFER_PID16(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFER_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFER_PID17(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFER_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFER_PID18(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFER_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFER_PID19(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFER_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFER_PID20(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFER_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFER_PID21(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFER_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFER_PID22(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFER_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFER_PID23(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFER_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFER_PID24(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFER_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFER_PID25(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFER_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFER_PID26(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFER_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFER_PID27(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFER_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFER_PID28(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFER_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFER_PID29(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFER_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFER_PID30(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFER_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFER_PID31(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFER_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000000) >> 31
}

// AIC.FFDR: Fast Forcing Disable Register
func (o *AIC_Type) SetFFDR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFDR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFDR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFDR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFDR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFDR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFDR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFDR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFDR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFDR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFDR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFDR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFDR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFDR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFDR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFDR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFDR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFDR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFDR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFDR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFDR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFDR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFDR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFDR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFDR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFDR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFDR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFDR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFDR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFDR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFDR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFDR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFDR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFDR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFDR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFDR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFDR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFDR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFDR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFDR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFDR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFDR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFDR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFDR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFDR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFDR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFDR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFDR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFDR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFDR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFDR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFDR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFDR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFDR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFDR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFDR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFDR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFDR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFDR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFDR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFDR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFDR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000000) >> 31
}

// AIC.FFSR: Fast Forcing Status Register
func (o *AIC_Type) SetFFSR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFSR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFSR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFSR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFSR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFSR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFSR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFSR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFSR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFSR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFSR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFSR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFSR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFSR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFSR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFSR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFSR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFSR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFSR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFSR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFSR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFSR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFSR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFSR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFSR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFSR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFSR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFSR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFSR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFSR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFSR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFSR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFSR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFSR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFSR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFSR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFSR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFSR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFSR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFSR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFSR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFSR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFSR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFSR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFSR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFSR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFSR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFSR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFSR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFSR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFSR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFSR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFSR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFSR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFSR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFSR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFSR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFSR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFSR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFSR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFSR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFSR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000000) >> 31
}

// AIC.WPMR: Write Protect Mode Register
func (o *AIC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *AIC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *AIC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// AIC.WPSR: Write Protect Status Register
func (o *AIC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *AIC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *AIC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
}

// DBGU.CR: Control Register
func (o *DBGU_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGU_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGU_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// DBGU.MR: Mode Register
func (o *DBGU_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *DBGU_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *DBGU_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *DBGU_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// DBGU.IER: Interrupt Enable Register
func (o *DBGU_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DBGU_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIER_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIER_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIER_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIER_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// DBGU.IDR: Interrupt Disable Register
func (o *DBGU_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DBGU_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIDR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIDR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIDR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIDR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// DBGU.IMR: Interrupt Mask Register
func (o *DBGU_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DBGU_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIMR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIMR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIMR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIMR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// DBGU.SR: Status Register
func (o *DBGU_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *DBGU_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetSR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetSR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetSR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetSR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DBGU.RHR: Receive Holding Register
func (o *DBGU_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// DBGU.THR: Transmit Holding Register
func (o *DBGU_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// DBGU.BRGR: Baud Rate Generator Register
func (o *DBGU_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// DBGU.CIDR: Chip ID Register
func (o *DBGU_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *DBGU_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *DBGU_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *DBGU_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *DBGU_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *DBGU_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *DBGU_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *DBGU_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *DBGU_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *DBGU_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *DBGU_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *DBGU_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *DBGU_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// DBGU.EXID: Chip ID Extension Register
func (o *DBGU_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *DBGU_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// DBGU.FNR: Force NTRST Register
func (o *DBGU_Type) SetFNR_FNTRST(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetFNR_FNTRST() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x1
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [12]byte
	DELAYR  volatile.Register32 // 0x110
	DRIVER1 volatile.Register32 // 0x114
	DRIVER2 volatile.Register32 // 0x118
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetISR_P21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetISR_P22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetISR_P22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetISR_P23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetISR_P23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetISR_P24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetISR_P24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetISR_P25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetISR_P25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetISR_P26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetISR_P26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetISR_P27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetISR_P27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetISR_P28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetISR_P28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetISR_P29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetISR_P29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetISR_P30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetISR_P30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetISR_P31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetISR_P31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// PIO.MDER: Multi-driver Enable Register
func (o *PIO_Type) SetMDER_P0(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDER_P0() uint32 {
	return volatile.LoadUint32(&o.MDER.Reg) & 0x1
}
func (o *PIO_Type) SetMDER_P1(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDER_P1() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDER_P2(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDER_P2() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDER_P3(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDER_P3() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDER_P4(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDER_P4() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDER_P5(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDER_P5() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDER_P6(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDER_P6() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDER_P7(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDER_P7() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDER_P8(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDER_P8() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDER_P9(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDER_P9() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDER_P10(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDER_P10() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDER_P11(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDER_P11() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDER_P12(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDER_P12() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDER_P13(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDER_P13() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDER_P14(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDER_P14() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDER_P15(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDER_P15() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDER_P16(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDER_P16() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDER_P17(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDER_P17() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDER_P18(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDER_P18() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDER_P19(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDER_P19() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDER_P20(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDER_P20() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDER_P21(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDER_P21() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDER_P22(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDER_P22() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDER_P23(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDER_P23() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDER_P24(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDER_P24() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDER_P25(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDER_P25() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDER_P26(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDER_P26() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDER_P27(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDER_P27() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDER_P28(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDER_P28() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDER_P29(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDER_P29() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDER_P30(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDER_P30() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDER_P31(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDER_P31() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000000) >> 31
}

// PIO.MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetMDDR_P0(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDDR_P0() uint32 {
	return volatile.LoadUint32(&o.MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetMDDR_P1(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDDR_P2(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDDR_P3(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDDR_P4(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDDR_P5(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDDR_P6(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDDR_P7(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDDR_P8(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDDR_P9(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDDR_P10(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDDR_P11(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDDR_P12(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDDR_P13(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDDR_P14(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDDR_P15(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDDR_P16(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDDR_P17(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDDR_P18(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDDR_P19(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDDR_P20(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDDR_P21(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDDR_P22(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDDR_P23(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDDR_P24(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDDR_P25(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDDR_P26(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDDR_P27(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDDR_P28(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDDR_P29(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDDR_P30(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDDR_P31(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000000) >> 31
}

// PIO.MDSR: Multi-driver Status Register
func (o *PIO_Type) SetMDSR_P0(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDSR_P0() uint32 {
	return volatile.LoadUint32(&o.MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetMDSR_P1(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDSR_P2(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDSR_P3(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDSR_P4(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDSR_P5(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDSR_P6(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDSR_P7(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDSR_P8(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDSR_P9(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDSR_P10(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDSR_P11(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDSR_P12(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDSR_P13(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDSR_P14(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDSR_P15(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDSR_P16(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDSR_P17(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDSR_P18(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDSR_P19(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDSR_P20(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDSR_P21(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDSR_P22(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDSR_P23(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDSR_P24(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDSR_P25(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDSR_P26(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDSR_P27(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDSR_P28(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDSR_P29(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDSR_P30(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDSR_P31(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PUER: Pull-up Enable Register
func (o *PIO_Type) SetPUER_P0(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUER_P0() uint32 {
	return volatile.LoadUint32(&o.PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPUER_P1(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUER_P2(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUER_P3(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUER_P4(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUER_P5(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUER_P6(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUER_P7(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUER_P8(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUER_P9(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUER_P10(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUER_P11(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUER_P12(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUER_P13(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUER_P14(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUER_P15(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUER_P16(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUER_P17(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUER_P18(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUER_P19(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUER_P20(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUER_P21(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUER_P22(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUER_P23(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUER_P24(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUER_P25(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUER_P26(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUER_P27(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUER_P28(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUER_P29(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUER_P30(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUER_P31(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000000) >> 31
}

// PIO.PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000000) >> 31
}

// PIO.ABCDSR: Peripheral Select Register
func (o *PIO_Type) SetABCDSR_P0(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetABCDSR_P0(idx int) uint32 {
	return volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1
}
func (o *PIO_Type) SetABCDSR_P1(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetABCDSR_P1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetABCDSR_P2(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetABCDSR_P2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetABCDSR_P3(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetABCDSR_P3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetABCDSR_P4(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetABCDSR_P4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetABCDSR_P5(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetABCDSR_P5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetABCDSR_P6(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetABCDSR_P6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetABCDSR_P7(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetABCDSR_P7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetABCDSR_P8(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetABCDSR_P8(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetABCDSR_P9(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetABCDSR_P9(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetABCDSR_P10(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetABCDSR_P10(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetABCDSR_P11(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetABCDSR_P11(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetABCDSR_P12(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetABCDSR_P12(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetABCDSR_P13(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetABCDSR_P13(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetABCDSR_P14(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetABCDSR_P14(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetABCDSR_P15(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetABCDSR_P15(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetABCDSR_P16(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetABCDSR_P16(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetABCDSR_P17(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetABCDSR_P17(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetABCDSR_P18(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetABCDSR_P18(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetABCDSR_P19(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetABCDSR_P19(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetABCDSR_P20(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetABCDSR_P20(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetABCDSR_P21(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetABCDSR_P21(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetABCDSR_P22(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetABCDSR_P22(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetABCDSR_P23(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetABCDSR_P23(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetABCDSR_P24(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetABCDSR_P24(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetABCDSR_P25(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetABCDSR_P25(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetABCDSR_P26(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetABCDSR_P26(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetABCDSR_P27(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetABCDSR_P27(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetABCDSR_P28(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetABCDSR_P28(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetABCDSR_P29(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetABCDSR_P29(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetABCDSR_P30(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetABCDSR_P30(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetABCDSR_P31(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetABCDSR_P31(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000000) >> 31
}

// PIO.IFSCDR: Input Filter Slow Clock Disable Register
func (o *PIO_Type) SetIFSCDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSCER: Input Filter Slow Clock Enable Register
func (o *PIO_Type) SetIFSCER_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCER_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCER.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCER_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCER_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCER_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCER_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCER_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCER_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCER_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCER_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCER_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCER_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCER_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCER_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCER_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCER_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCER_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCER_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCER_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCER_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCER_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCER_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCER_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCER_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCER_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCER_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCER_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCER_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCER_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCER_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCER_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCER_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCER_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000000) >> 31
}

// PIO.IFSCSR: Input Filter Slow Clock Status Register
func (o *PIO_Type) SetIFSCSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000000) >> 31
}

// PIO.SCDR: Slow Clock Divider Debouncing Register
func (o *PIO_Type) SetSCDR_DIV(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x3fff)|value)
}
func (o *PIO_Type) GetSCDR_DIV() uint32 {
	return volatile.LoadUint32(&o.SCDR.Reg) & 0x3fff
}

// PIO.PPDDR: Pad Pull-down Disable Register
func (o *PIO_Type) SetPPDDR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDDR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDDR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDDR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDDR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDDR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDDR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDDR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDDR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDDR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDDR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDDR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDDR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDDR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDDR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDDR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDDR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDDR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDDR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDDR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDDR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDDR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDDR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDDR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDDR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDDR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDDR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDDR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDDR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDDR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDDR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDDR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDDR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDDR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000000) >> 31
}

// PIO.PPDER: Pad Pull-down Enable Register
func (o *PIO_Type) SetPPDER_P0(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDER_P0() uint32 {
	return volatile.LoadUint32(&o.PPDER.Reg) & 0x1
}
func (o *PIO_Type) SetPPDER_P1(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDER_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDER_P2(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDER_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDER_P3(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDER_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDER_P4(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDER_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDER_P5(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDER_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDER_P6(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDER_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDER_P7(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDER_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDER_P8(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDER_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDER_P9(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDER_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDER_P10(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDER_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDER_P11(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDER_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDER_P12(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDER_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDER_P13(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDER_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDER_P14(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDER_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDER_P15(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDER_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDER_P16(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDER_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDER_P17(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDER_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDER_P18(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDER_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDER_P19(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDER_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDER_P20(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDER_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDER_P21(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDER_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDER_P22(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDER_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDER_P23(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDER_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDER_P24(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDER_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDER_P25(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDER_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDER_P26(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDER_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDER_P27(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDER_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDER_P28(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDER_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDER_P29(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDER_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDER_P30(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDER_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDER_P31(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDER_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000000) >> 31
}

// PIO.PPDSR: Pad Pull-down Status Register
func (o *PIO_Type) SetPPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000000) >> 31
}

// PIO.OWER: Output Write Enable
func (o *PIO_Type) SetOWER_P0(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWER_P0() uint32 {
	return volatile.LoadUint32(&o.OWER.Reg) & 0x1
}
func (o *PIO_Type) SetOWER_P1(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWER_P1() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWER_P2(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWER_P2() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWER_P3(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWER_P3() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWER_P4(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWER_P4() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWER_P5(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWER_P5() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWER_P6(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWER_P6() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWER_P7(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWER_P7() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWER_P8(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWER_P8() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWER_P9(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWER_P9() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWER_P10(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWER_P10() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWER_P11(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWER_P11() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWER_P12(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWER_P12() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWER_P13(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWER_P13() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWER_P14(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWER_P14() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWER_P15(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWER_P15() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWER_P16(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWER_P16() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWER_P17(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWER_P17() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWER_P18(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWER_P18() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWER_P19(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWER_P19() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWER_P20(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWER_P20() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWER_P21(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWER_P21() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWER_P22(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWER_P22() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWER_P23(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWER_P23() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWER_P24(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWER_P24() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWER_P25(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWER_P25() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWER_P26(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWER_P26() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWER_P27(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWER_P27() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWER_P28(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWER_P28() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWER_P29(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWER_P29() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWER_P30(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWER_P30() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWER_P31(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWER_P31() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000000) >> 31
}

// PIO.OWDR: Output Write Disable
func (o *PIO_Type) SetOWDR_P0(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWDR_P0() uint32 {
	return volatile.LoadUint32(&o.OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetOWDR_P1(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWDR_P2(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWDR_P3(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWDR_P4(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWDR_P5(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWDR_P6(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWDR_P7(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWDR_P8(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWDR_P9(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWDR_P10(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWDR_P11(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWDR_P12(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWDR_P13(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWDR_P14(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWDR_P15(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWDR_P16(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWDR_P17(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWDR_P18(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWDR_P19(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWDR_P20(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWDR_P21(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWDR_P22(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWDR_P23(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWDR_P24(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWDR_P25(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWDR_P26(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWDR_P27(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWDR_P28(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWDR_P29(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWDR_P30(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWDR_P31(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000000) >> 31
}

// PIO.OWSR: Output Write Status Register
func (o *PIO_Type) SetOWSR_P0(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWSR_P0() uint32 {
	return volatile.LoadUint32(&o.OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetOWSR_P1(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWSR_P2(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWSR_P3(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWSR_P4(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWSR_P5(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWSR_P6(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWSR_P7(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWSR_P8(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWSR_P9(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWSR_P10(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWSR_P11(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWSR_P12(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWSR_P13(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWSR_P14(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWSR_P15(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWSR_P16(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWSR_P17(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWSR_P18(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWSR_P19(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWSR_P20(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWSR_P21(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWSR_P22(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWSR_P23(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWSR_P24(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWSR_P25(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWSR_P26(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWSR_P27(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWSR_P28(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWSR_P29(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWSR_P30(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWSR_P31(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000000) >> 31
}

// PIO.AIMER: Additional Interrupt Modes Enable Register
func (o *PIO_Type) SetAIMER_P0(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMER_P0() uint32 {
	return volatile.LoadUint32(&o.AIMER.Reg) & 0x1
}
func (o *PIO_Type) SetAIMER_P1(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMER_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMER_P2(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMER_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMER_P3(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMER_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMER_P4(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMER_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMER_P5(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMER_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMER_P6(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMER_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMER_P7(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMER_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMER_P8(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMER_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMER_P9(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMER_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMER_P10(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMER_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMER_P11(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMER_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMER_P12(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMER_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMER_P13(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMER_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMER_P14(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMER_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMER_P15(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMER_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMER_P16(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMER_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMER_P17(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMER_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMER_P18(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMER_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMER_P19(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMER_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMER_P20(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMER_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMER_P21(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMER_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMER_P22(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMER_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMER_P23(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMER_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMER_P24(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMER_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMER_P25(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMER_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMER_P26(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMER_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMER_P27(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMER_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMER_P28(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMER_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMER_P29(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMER_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMER_P30(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMER_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMER_P31(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMER_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000000) >> 31
}

// PIO.AIMDR: Additional Interrupt Modes Disables Register
func (o *PIO_Type) SetAIMDR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMDR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMDR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMDR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMDR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMDR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMDR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMDR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMDR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMDR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMDR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMDR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMDR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMDR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMDR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMDR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMDR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMDR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMDR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMDR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMDR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMDR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMDR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMDR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMDR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMDR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMDR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMDR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMDR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMDR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMDR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMDR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMDR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMDR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMDR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMDR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMDR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMDR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMDR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMDR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMDR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMDR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMDR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMDR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMDR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMDR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMDR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMDR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMDR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMDR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMDR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMDR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMDR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMDR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMDR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMDR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMDR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMDR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMDR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMDR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMDR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMDR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMDR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMDR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMDR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000000) >> 31
}

// PIO.AIMMR: Additional Interrupt Modes Mask Register
func (o *PIO_Type) SetAIMMR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMMR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMMR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMMR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMMR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMMR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMMR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMMR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMMR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMMR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMMR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMMR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMMR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMMR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMMR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMMR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMMR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMMR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMMR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMMR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMMR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMMR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMMR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMMR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMMR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMMR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMMR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMMR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMMR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMMR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMMR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMMR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMMR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMMR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMMR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMMR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMMR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMMR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMMR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMMR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMMR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMMR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMMR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMMR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMMR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMMR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMMR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMMR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMMR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMMR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMMR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMMR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMMR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMMR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMMR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMMR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMMR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMMR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMMR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMMR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMMR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMMR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMMR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMMR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMMR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000000) >> 31
}

// PIO.ESR: Edge Select Register
func (o *PIO_Type) SetESR_P0(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetESR_P0() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}
func (o *PIO_Type) SetESR_P1(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetESR_P1() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetESR_P2(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetESR_P2() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetESR_P3(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetESR_P3() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetESR_P4(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetESR_P4() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetESR_P5(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetESR_P5() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetESR_P6(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetESR_P6() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetESR_P7(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetESR_P7() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetESR_P8(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetESR_P8() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetESR_P9(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetESR_P9() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetESR_P10(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetESR_P10() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetESR_P11(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetESR_P11() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetESR_P12(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetESR_P12() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetESR_P13(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetESR_P13() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetESR_P14(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetESR_P14() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetESR_P15(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetESR_P15() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetESR_P16(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetESR_P16() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetESR_P17(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetESR_P17() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetESR_P18(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetESR_P18() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetESR_P19(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetESR_P19() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetESR_P20(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetESR_P20() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetESR_P21(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetESR_P21() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetESR_P22(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetESR_P22() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetESR_P23(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetESR_P23() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetESR_P24(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetESR_P24() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetESR_P25(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetESR_P25() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetESR_P26(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetESR_P26() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetESR_P27(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetESR_P27() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetESR_P28(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetESR_P28() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetESR_P29(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetESR_P29() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetESR_P30(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetESR_P30() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetESR_P31(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetESR_P31() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000000) >> 31
}

// PIO.LSR: Level Select Register
func (o *PIO_Type) SetLSR_P0(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLSR_P0() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *PIO_Type) SetLSR_P1(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLSR_P2(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLSR_P3(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLSR_P4(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLSR_P5(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLSR_P6(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLSR_P7(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLSR_P8(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLSR_P9(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLSR_P10(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLSR_P11(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLSR_P12(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLSR_P13(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLSR_P14(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLSR_P15(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLSR_P16(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLSR_P17(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLSR_P18(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLSR_P19(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLSR_P20(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLSR_P21(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLSR_P22(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLSR_P23(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLSR_P24(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLSR_P25(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLSR_P26(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLSR_P27(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLSR_P28(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLSR_P29(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLSR_P30(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLSR_P31(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000000) >> 31
}

// PIO.ELSR: Edge/Level Status Register
func (o *PIO_Type) SetELSR_P0(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetELSR_P0() uint32 {
	return volatile.LoadUint32(&o.ELSR.Reg) & 0x1
}
func (o *PIO_Type) SetELSR_P1(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetELSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetELSR_P2(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetELSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetELSR_P3(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetELSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetELSR_P4(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetELSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetELSR_P5(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetELSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetELSR_P6(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetELSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetELSR_P7(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetELSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetELSR_P8(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetELSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetELSR_P9(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetELSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetELSR_P10(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetELSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetELSR_P11(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetELSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetELSR_P12(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetELSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetELSR_P13(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetELSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetELSR_P14(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetELSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetELSR_P15(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetELSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetELSR_P16(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetELSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetELSR_P17(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetELSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetELSR_P18(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetELSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetELSR_P19(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetELSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetELSR_P20(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetELSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetELSR_P21(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetELSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetELSR_P22(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetELSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetELSR_P23(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetELSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetELSR_P24(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetELSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetELSR_P25(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetELSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetELSR_P26(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetELSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetELSR_P27(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetELSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetELSR_P28(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetELSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetELSR_P29(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetELSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetELSR_P30(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetELSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetELSR_P31(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetELSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000000) >> 31
}

// PIO.FELLSR: Falling Edge/Low Level Select Register
func (o *PIO_Type) SetFELLSR_P0(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFELLSR_P0() uint32 {
	return volatile.LoadUint32(&o.FELLSR.Reg) & 0x1
}
func (o *PIO_Type) SetFELLSR_P1(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFELLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFELLSR_P2(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFELLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFELLSR_P3(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFELLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFELLSR_P4(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFELLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFELLSR_P5(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFELLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFELLSR_P6(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFELLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFELLSR_P7(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFELLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFELLSR_P8(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFELLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFELLSR_P9(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFELLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFELLSR_P10(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFELLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFELLSR_P11(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFELLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFELLSR_P12(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFELLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFELLSR_P13(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFELLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFELLSR_P14(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFELLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFELLSR_P15(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFELLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFELLSR_P16(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFELLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFELLSR_P17(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFELLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFELLSR_P18(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFELLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFELLSR_P19(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFELLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFELLSR_P20(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFELLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFELLSR_P21(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFELLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFELLSR_P22(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFELLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFELLSR_P23(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFELLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFELLSR_P24(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFELLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFELLSR_P25(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFELLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFELLSR_P26(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFELLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFELLSR_P27(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFELLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFELLSR_P28(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFELLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFELLSR_P29(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFELLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFELLSR_P30(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFELLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFELLSR_P31(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFELLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000000) >> 31
}

// PIO.REHLSR: Rising Edge/ High Level Select Register
func (o *PIO_Type) SetREHLSR_P0(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetREHLSR_P0() uint32 {
	return volatile.LoadUint32(&o.REHLSR.Reg) & 0x1
}
func (o *PIO_Type) SetREHLSR_P1(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetREHLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetREHLSR_P2(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetREHLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetREHLSR_P3(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetREHLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetREHLSR_P4(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetREHLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetREHLSR_P5(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetREHLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetREHLSR_P6(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetREHLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetREHLSR_P7(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetREHLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetREHLSR_P8(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetREHLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetREHLSR_P9(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetREHLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetREHLSR_P10(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetREHLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetREHLSR_P11(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetREHLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetREHLSR_P12(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetREHLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetREHLSR_P13(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetREHLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetREHLSR_P14(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetREHLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetREHLSR_P15(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetREHLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetREHLSR_P16(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetREHLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetREHLSR_P17(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetREHLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetREHLSR_P18(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetREHLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetREHLSR_P19(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetREHLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetREHLSR_P20(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetREHLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetREHLSR_P21(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetREHLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetREHLSR_P22(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetREHLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetREHLSR_P23(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetREHLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetREHLSR_P24(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetREHLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetREHLSR_P25(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetREHLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetREHLSR_P26(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetREHLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetREHLSR_P27(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetREHLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetREHLSR_P28(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetREHLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetREHLSR_P29(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetREHLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetREHLSR_P30(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetREHLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetREHLSR_P31(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetREHLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000000) >> 31
}

// PIO.FRLHSR: Fall/Rise - Low/High Status Register
func (o *PIO_Type) SetFRLHSR_P0(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFRLHSR_P0() uint32 {
	return volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1
}
func (o *PIO_Type) SetFRLHSR_P1(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFRLHSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFRLHSR_P2(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFRLHSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFRLHSR_P3(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFRLHSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFRLHSR_P4(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFRLHSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFRLHSR_P5(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFRLHSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFRLHSR_P6(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFRLHSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFRLHSR_P7(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFRLHSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFRLHSR_P8(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFRLHSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFRLHSR_P9(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFRLHSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFRLHSR_P10(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFRLHSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFRLHSR_P11(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFRLHSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFRLHSR_P12(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFRLHSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFRLHSR_P13(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFRLHSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFRLHSR_P14(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFRLHSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFRLHSR_P15(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFRLHSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFRLHSR_P16(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFRLHSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFRLHSR_P17(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFRLHSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFRLHSR_P18(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFRLHSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFRLHSR_P19(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFRLHSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFRLHSR_P20(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFRLHSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFRLHSR_P21(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFRLHSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFRLHSR_P22(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFRLHSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFRLHSR_P23(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFRLHSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFRLHSR_P24(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFRLHSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFRLHSR_P25(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFRLHSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFRLHSR_P26(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFRLHSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFRLHSR_P27(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFRLHSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFRLHSR_P28(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFRLHSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFRLHSR_P29(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFRLHSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFRLHSR_P30(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFRLHSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFRLHSR_P31(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFRLHSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000000) >> 31
}

// PIO.LOCKSR: Lock Status
func (o *PIO_Type) SetLOCKSR_P0(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLOCKSR_P0() uint32 {
	return volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1
}
func (o *PIO_Type) SetLOCKSR_P1(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLOCKSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLOCKSR_P2(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLOCKSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLOCKSR_P3(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLOCKSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLOCKSR_P4(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLOCKSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLOCKSR_P5(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLOCKSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLOCKSR_P6(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLOCKSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLOCKSR_P7(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLOCKSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLOCKSR_P8(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLOCKSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLOCKSR_P9(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLOCKSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLOCKSR_P10(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLOCKSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLOCKSR_P11(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLOCKSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLOCKSR_P12(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLOCKSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLOCKSR_P13(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLOCKSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLOCKSR_P14(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLOCKSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLOCKSR_P15(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLOCKSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLOCKSR_P16(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLOCKSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLOCKSR_P17(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLOCKSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLOCKSR_P18(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLOCKSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLOCKSR_P19(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLOCKSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLOCKSR_P20(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLOCKSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLOCKSR_P21(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLOCKSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLOCKSR_P22(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLOCKSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLOCKSR_P23(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLOCKSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLOCKSR_P24(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLOCKSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLOCKSR_P25(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLOCKSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLOCKSR_P26(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLOCKSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLOCKSR_P27(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLOCKSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLOCKSR_P28(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLOCKSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLOCKSR_P29(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLOCKSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLOCKSR_P30(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLOCKSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLOCKSR_P31(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLOCKSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000000) >> 31
}

// PIO.WPMR: Write Protect Mode Register
func (o *PIO_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *PIO_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PIO_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// PIO.WPSR: Write Protect Status Register
func (o *PIO_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PIO_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PIO_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// PIO.SCHMITT: Schmitt Trigger Register
func (o *PIO_Type) SetSCHMITT_SCHMITT0(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT0() uint32 {
	return volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT1(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT1() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT2(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT2() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSCHMITT_SCHMITT3(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT3() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSCHMITT_SCHMITT4(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT4() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSCHMITT_SCHMITT5(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT5() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSCHMITT_SCHMITT6(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT6() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSCHMITT_SCHMITT7(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT7() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSCHMITT_SCHMITT8(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT8() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSCHMITT_SCHMITT9(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT9() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSCHMITT_SCHMITT10(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT10() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSCHMITT_SCHMITT11(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT11() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSCHMITT_SCHMITT12(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT12() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSCHMITT_SCHMITT13(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT13() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSCHMITT_SCHMITT14(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT14() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSCHMITT_SCHMITT15(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT15() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSCHMITT_SCHMITT16(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT16() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSCHMITT_SCHMITT17(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT17() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSCHMITT_SCHMITT18(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT18() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSCHMITT_SCHMITT19(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT19() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSCHMITT_SCHMITT20(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT20() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSCHMITT_SCHMITT21(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT21() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSCHMITT_SCHMITT22(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT22() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSCHMITT_SCHMITT23(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT23() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSCHMITT_SCHMITT24(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT24() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSCHMITT_SCHMITT25(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT25() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSCHMITT_SCHMITT26(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT26() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSCHMITT_SCHMITT27(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT27() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSCHMITT_SCHMITT28(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT28() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSCHMITT_SCHMITT29(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT29() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSCHMITT_SCHMITT30(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT30() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSCHMITT_SCHMITT31(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT31() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000000) >> 31
}

// PIO.DELAYR: IO Delay Register
func (o *PIO_Type) SetDELAYR_Delay0(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf)|value)
}
func (o *PIO_Type) GetDELAYR_Delay0() uint32 {
	return volatile.LoadUint32(&o.DELAYR.Reg) & 0xf
}
func (o *PIO_Type) SetDELAYR_Delay1(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf0)|value<<4)
}
func (o *PIO_Type) GetDELAYR_Delay1() uint32 {
	return (volatile.LoadUint32(&o.DELAYR.Reg) & 0xf0) >> 4
}
func (o *PIO_Type) SetDELAYR_Delay2(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf00)|value<<8)
}
func (o *PIO_Type) GetDELAYR_Delay2() uint32 {
	return (volatile.LoadUint32(&o.DELAYR.Reg) & 0xf00) >> 8
}
func (o *PIO_Type) SetDELAYR_Delay3(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf000)|value<<12)
}
func (o *PIO_Type) GetDELAYR_Delay3() uint32 {
	return (volatile.LoadUint32(&o.DELAYR.Reg) & 0xf000) >> 12
}
func (o *PIO_Type) SetDELAYR_Delay4(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf0000)|value<<16)
}
func (o *PIO_Type) GetDELAYR_Delay4() uint32 {
	return (volatile.LoadUint32(&o.DELAYR.Reg) & 0xf0000) >> 16
}
func (o *PIO_Type) SetDELAYR_Delay5(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf00000)|value<<20)
}
func (o *PIO_Type) GetDELAYR_Delay5() uint32 {
	return (volatile.LoadUint32(&o.DELAYR.Reg) & 0xf00000) >> 20
}
func (o *PIO_Type) SetDELAYR_Delay6(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf000000)|value<<24)
}
func (o *PIO_Type) GetDELAYR_Delay6() uint32 {
	return (volatile.LoadUint32(&o.DELAYR.Reg) & 0xf000000) >> 24
}
func (o *PIO_Type) SetDELAYR_Delay7(value uint32) {
	volatile.StoreUint32(&o.DELAYR.Reg, volatile.LoadUint32(&o.DELAYR.Reg)&^(0xf0000000)|value<<28)
}
func (o *PIO_Type) GetDELAYR_Delay7() uint32 {
	return (volatile.LoadUint32(&o.DELAYR.Reg) & 0xf0000000) >> 28
}

// PIO.DRIVER1: I/O Drive Register 1
func (o *PIO_Type) SetDRIVER1_LINE0(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x3)|value)
}
func (o *PIO_Type) GetDRIVER1_LINE0() uint32 {
	return volatile.LoadUint32(&o.DRIVER1.Reg) & 0x3
}
func (o *PIO_Type) SetDRIVER1_LINE1(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc)|value<<2)
}
func (o *PIO_Type) GetDRIVER1_LINE1() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc) >> 2
}
func (o *PIO_Type) SetDRIVER1_LINE2(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x30)|value<<4)
}
func (o *PIO_Type) GetDRIVER1_LINE2() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0x30) >> 4
}
func (o *PIO_Type) SetDRIVER1_LINE3(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc0)|value<<6)
}
func (o *PIO_Type) GetDRIVER1_LINE3() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc0) >> 6
}
func (o *PIO_Type) SetDRIVER1_LINE4(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x300)|value<<8)
}
func (o *PIO_Type) GetDRIVER1_LINE4() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0x300) >> 8
}
func (o *PIO_Type) SetDRIVER1_LINE5(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc00)|value<<10)
}
func (o *PIO_Type) GetDRIVER1_LINE5() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc00) >> 10
}
func (o *PIO_Type) SetDRIVER1_LINE6(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x3000)|value<<12)
}
func (o *PIO_Type) GetDRIVER1_LINE6() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0x3000) >> 12
}
func (o *PIO_Type) SetDRIVER1_LINE7(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc000)|value<<14)
}
func (o *PIO_Type) GetDRIVER1_LINE7() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc000) >> 14
}
func (o *PIO_Type) SetDRIVER1_LINE8(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x30000)|value<<16)
}
func (o *PIO_Type) GetDRIVER1_LINE8() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0x30000) >> 16
}
func (o *PIO_Type) SetDRIVER1_LINE9(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc0000)|value<<18)
}
func (o *PIO_Type) GetDRIVER1_LINE9() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc0000) >> 18
}
func (o *PIO_Type) SetDRIVER1_LINE10(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x300000)|value<<20)
}
func (o *PIO_Type) GetDRIVER1_LINE10() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0x300000) >> 20
}
func (o *PIO_Type) SetDRIVER1_LINE11(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc00000)|value<<22)
}
func (o *PIO_Type) GetDRIVER1_LINE11() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc00000) >> 22
}
func (o *PIO_Type) SetDRIVER1_LINE12(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x3000000)|value<<24)
}
func (o *PIO_Type) GetDRIVER1_LINE12() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0x3000000) >> 24
}
func (o *PIO_Type) SetDRIVER1_LINE13(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc000000)|value<<26)
}
func (o *PIO_Type) GetDRIVER1_LINE13() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc000000) >> 26
}
func (o *PIO_Type) SetDRIVER1_LINE14(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0x30000000)|value<<28)
}
func (o *PIO_Type) GetDRIVER1_LINE14() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0x30000000) >> 28
}
func (o *PIO_Type) SetDRIVER1_LINE15(value uint32) {
	volatile.StoreUint32(&o.DRIVER1.Reg, volatile.LoadUint32(&o.DRIVER1.Reg)&^(0xc0000000)|value<<30)
}
func (o *PIO_Type) GetDRIVER1_LINE15() uint32 {
	return (volatile.LoadUint32(&o.DRIVER1.Reg) & 0xc0000000) >> 30
}

// PIO.DRIVER2: I/O Drive Register 2
func (o *PIO_Type) SetDRIVER2_LINE16(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x3)|value)
}
func (o *PIO_Type) GetDRIVER2_LINE16() uint32 {
	return volatile.LoadUint32(&o.DRIVER2.Reg) & 0x3
}
func (o *PIO_Type) SetDRIVER2_LINE17(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc)|value<<2)
}
func (o *PIO_Type) GetDRIVER2_LINE17() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc) >> 2
}
func (o *PIO_Type) SetDRIVER2_LINE18(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x30)|value<<4)
}
func (o *PIO_Type) GetDRIVER2_LINE18() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0x30) >> 4
}
func (o *PIO_Type) SetDRIVER2_LINE19(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc0)|value<<6)
}
func (o *PIO_Type) GetDRIVER2_LINE19() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc0) >> 6
}
func (o *PIO_Type) SetDRIVER2_LINE20(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x300)|value<<8)
}
func (o *PIO_Type) GetDRIVER2_LINE20() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0x300) >> 8
}
func (o *PIO_Type) SetDRIVER2_LINE21(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc00)|value<<10)
}
func (o *PIO_Type) GetDRIVER2_LINE21() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc00) >> 10
}
func (o *PIO_Type) SetDRIVER2_LINE22(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x3000)|value<<12)
}
func (o *PIO_Type) GetDRIVER2_LINE22() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0x3000) >> 12
}
func (o *PIO_Type) SetDRIVER2_LINE23(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc000)|value<<14)
}
func (o *PIO_Type) GetDRIVER2_LINE23() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc000) >> 14
}
func (o *PIO_Type) SetDRIVER2_LINE24(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x30000)|value<<16)
}
func (o *PIO_Type) GetDRIVER2_LINE24() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0x30000) >> 16
}
func (o *PIO_Type) SetDRIVER2_LINE25(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc0000)|value<<18)
}
func (o *PIO_Type) GetDRIVER2_LINE25() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc0000) >> 18
}
func (o *PIO_Type) SetDRIVER2_LINE26(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x300000)|value<<20)
}
func (o *PIO_Type) GetDRIVER2_LINE26() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0x300000) >> 20
}
func (o *PIO_Type) SetDRIVER2_LINE27(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc00000)|value<<22)
}
func (o *PIO_Type) GetDRIVER2_LINE27() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc00000) >> 22
}
func (o *PIO_Type) SetDRIVER2_LINE28(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x3000000)|value<<24)
}
func (o *PIO_Type) GetDRIVER2_LINE28() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0x3000000) >> 24
}
func (o *PIO_Type) SetDRIVER2_LINE29(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc000000)|value<<26)
}
func (o *PIO_Type) GetDRIVER2_LINE29() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc000000) >> 26
}
func (o *PIO_Type) SetDRIVER2_LINE30(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0x30000000)|value<<28)
}
func (o *PIO_Type) GetDRIVER2_LINE30() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0x30000000) >> 28
}
func (o *PIO_Type) SetDRIVER2_LINE31(value uint32) {
	volatile.StoreUint32(&o.DRIVER2.Reg, volatile.LoadUint32(&o.DRIVER2.Reg)&^(0xc0000000)|value<<30)
}
func (o *PIO_Type) GetDRIVER2_LINE31() uint32 {
	return (volatile.LoadUint32(&o.DRIVER2.Reg) & 0xc0000000) >> 30
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER    volatile.Register32 // 0x0
	PMC_SCDR    volatile.Register32 // 0x4
	PMC_SCSR    volat