# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Intf module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_intf.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Intf
else:
    import _Intf

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Intf.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _Intf.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Intf.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Intf.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _Intf.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _Intf.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _Intf.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _Intf.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _Intf.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _Intf.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Intf.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _Intf.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _Intf.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Intf.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Intf.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Intf.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _Intf.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Intf:
_Intf.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _Intf.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.BVH

from enum import IntEnum
from OCC.Core.Exception import *

Intf_EXTERNAL = _Intf.Intf_EXTERNAL
Intf_FACE = _Intf.Intf_FACE
Intf_EDGE = _Intf.Intf_EDGE
Intf_VERTEX = _Intf.Intf_VERTEX


class Intf_PIType(IntEnum):
	Intf_EXTERNAL = 0
	Intf_FACE = 1
	Intf_EDGE = 2
	Intf_VERTEX = 3
Intf_EXTERNAL = Intf_PIType.Intf_EXTERNAL
Intf_FACE = Intf_PIType.Intf_FACE
Intf_EDGE = Intf_PIType.Intf_EDGE
Intf_VERTEX = Intf_PIType.Intf_VERTEX

class Intf_Array1OfLin(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Array1< gp_Lin >::iterator":
        return _Intf.Intf_Array1OfLin_begin(self)

    def end(self) -> "NCollection_Array1< gp_Lin >::iterator":
        return _Intf.Intf_Array1OfLin_end(self)

    def cbegin(self) -> "NCollection_Array1< gp_Lin >::const_iterator":
        return _Intf.Intf_Array1OfLin_cbegin(self)

    def cend(self) -> "NCollection_Array1< gp_Lin >::const_iterator":
        return _Intf.Intf_Array1OfLin_cend(self)

    def __init__(self, *args):
        _Intf.Intf_Array1OfLin_swiginit(self, _Intf.new_Intf_Array1OfLin(*args))

    def Init(self, theValue: "gp_Lin") -> "void":
        return _Intf.Intf_Array1OfLin_Init(self, theValue)

    def Size(self) -> "Standard_Integer":
        return _Intf.Intf_Array1OfLin_Size(self)

    def Length(self) -> "Standard_Integer":
        return _Intf.Intf_Array1OfLin_Length(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _Intf.Intf_Array1OfLin_IsEmpty(self)

    def Lower(self) -> "Standard_Integer":
        return _Intf.Intf_Array1OfLin_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _Intf.Intf_Array1OfLin_Upper(self)

    def IsDeletable(self) -> "Standard_Boolean":
        return _Intf.Intf_Array1OfLin_IsDeletable(self)

    def IsAllocated(self) -> "Standard_Boolean":
        return _Intf.Intf_Array1OfLin_IsAllocated(self)

    def Assign(self, theOther: "Intf_Array1OfLin") -> "NCollection_Array1< gp_Lin > &":
        return _Intf.Intf_Array1OfLin_Assign(self, theOther)

    def Move(self, theOther: "Intf_Array1OfLin") -> "NCollection_Array1< gp_Lin > &":
        return _Intf.Intf_Array1OfLin_Move(self, theOther)

    def Set(self, *args) -> "NCollection_Array1< gp_Lin > &":
        return _Intf.Intf_Array1OfLin_Set(self, *args)

    def First(self) -> "gp_Lin const &":
        return _Intf.Intf_Array1OfLin_First(self)

    def ChangeFirst(self) -> "gp_Lin &":
        return _Intf.Intf_Array1OfLin_ChangeFirst(self)

    def Last(self) -> "gp_Lin const &":
        return _Intf.Intf_Array1OfLin_Last(self)

    def ChangeLast(self) -> "gp_Lin &":
        return _Intf.Intf_Array1OfLin_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "gp_Lin const &":
        return _Intf.Intf_Array1OfLin_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "gp_Lin &":
        return _Intf.Intf_Array1OfLin_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "gp_Lin &":
        return _Intf.Intf_Array1OfLin___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "gp_Lin") -> "void":
        return _Intf.Intf_Array1OfLin_SetValue(self, theIndex, theItem)

    def Resize(self, theLower: "Standard_Integer const", theUpper: "Standard_Integer const", theToCopyData: "Standard_Boolean const") -> "void":
        return _Intf.Intf_Array1OfLin_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _Intf.delete_Intf_Array1OfLin

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Intf_Array1OfLin in _Intf:
_Intf.Intf_Array1OfLin_swigregister(Intf_Array1OfLin)

class Intf_SeqOfSectionLine(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Sequence< Intf_SectionLine >::iterator":
        return _Intf.Intf_SeqOfSectionLine_begin(self)

    def end(self) -> "NCollection_Sequence< Intf_SectionLine >::iterator":
        return _Intf.Intf_SeqOfSectionLine_end(self)

    def cbegin(self) -> "NCollection_Sequence< Intf_SectionLine >::const_iterator":
        return _Intf.Intf_SeqOfSectionLine_cbegin(self)

    def cend(self) -> "NCollection_Sequence< Intf_SectionLine >::const_iterator":
        return _Intf.Intf_SeqOfSectionLine_cend(self)

    def __init__(self, *args):
        _Intf.Intf_SeqOfSectionLine_swiginit(self, _Intf.new_Intf_SeqOfSectionLine(*args))

    def Size(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionLine_Size(self)

    def Length(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionLine_Length(self)

    def Lower(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionLine_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionLine_Upper(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _Intf.Intf_SeqOfSectionLine_IsEmpty(self)

    def Reverse(self) -> "void":
        return _Intf.Intf_SeqOfSectionLine_Reverse(self)

    def Exchange(self, I: "Standard_Integer const", J: "Standard_Integer const") -> "void":
        return _Intf.Intf_SeqOfSectionLine_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
        return _Intf.Intf_SeqOfSectionLine_delNode(theNode, theAl)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _Intf.Intf_SeqOfSectionLine_Clear(self, theAllocator)

    def Assign(self, theOther: "Intf_SeqOfSectionLine") -> "NCollection_Sequence< Intf_SectionLine > &":
        return _Intf.Intf_SeqOfSectionLine_Assign(self, theOther)

    def Set(self, theOther: "Intf_SeqOfSectionLine") -> "NCollection_Sequence< Intf_SectionLine > &":
        return _Intf.Intf_SeqOfSectionLine_Set(self, theOther)

    def Remove(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionLine_Remove(self, *args)

    def Append(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionLine_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionLine_Prepend(self, *args)

    def InsertBefore(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionLine_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionLine_InsertAfter(self, *args)

    def Split(self, theIndex: "Standard_Integer const", theSeq: "Intf_SeqOfSectionLine") -> "void":
        return _Intf.Intf_SeqOfSectionLine_Split(self, theIndex, theSeq)

    def First(self) -> "Intf_SectionLine const &":
        return _Intf.Intf_SeqOfSectionLine_First(self)

    def ChangeFirst(self) -> "Intf_SectionLine &":
        return _Intf.Intf_SeqOfSectionLine_ChangeFirst(self)

    def Last(self) -> "Intf_SectionLine const &":
        return _Intf.Intf_SeqOfSectionLine_Last(self)

    def ChangeLast(self) -> "Intf_SectionLine &":
        return _Intf.Intf_SeqOfSectionLine_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "Intf_SectionLine const &":
        return _Intf.Intf_SeqOfSectionLine_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "Intf_SectionLine &":
        return _Intf.Intf_SeqOfSectionLine_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "Intf_SectionLine &":
        return _Intf.Intf_SeqOfSectionLine___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "Intf_SectionLine") -> "void":
        return _Intf.Intf_SeqOfSectionLine_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Intf.delete_Intf_SeqOfSectionLine

    def __len__(self):
        return self.Size()


# Register Intf_SeqOfSectionLine in _Intf:
_Intf.Intf_SeqOfSectionLine_swigregister(Intf_SeqOfSectionLine)

def Intf_SeqOfSectionLine_delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
    return _Intf.Intf_SeqOfSectionLine_delNode(theNode, theAl)

class Intf_SeqOfSectionPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Sequence< Intf_SectionPoint >::iterator":
        return _Intf.Intf_SeqOfSectionPoint_begin(self)

    def end(self) -> "NCollection_Sequence< Intf_SectionPoint >::iterator":
        return _Intf.Intf_SeqOfSectionPoint_end(self)

    def cbegin(self) -> "NCollection_Sequence< Intf_SectionPoint >::const_iterator":
        return _Intf.Intf_SeqOfSectionPoint_cbegin(self)

    def cend(self) -> "NCollection_Sequence< Intf_SectionPoint >::const_iterator":
        return _Intf.Intf_SeqOfSectionPoint_cend(self)

    def __init__(self, *args):
        _Intf.Intf_SeqOfSectionPoint_swiginit(self, _Intf.new_Intf_SeqOfSectionPoint(*args))

    def Size(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionPoint_Size(self)

    def Length(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionPoint_Length(self)

    def Lower(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionPoint_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfSectionPoint_Upper(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _Intf.Intf_SeqOfSectionPoint_IsEmpty(self)

    def Reverse(self) -> "void":
        return _Intf.Intf_SeqOfSectionPoint_Reverse(self)

    def Exchange(self, I: "Standard_Integer const", J: "Standard_Integer const") -> "void":
        return _Intf.Intf_SeqOfSectionPoint_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
        return _Intf.Intf_SeqOfSectionPoint_delNode(theNode, theAl)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _Intf.Intf_SeqOfSectionPoint_Clear(self, theAllocator)

    def Assign(self, theOther: "Intf_SeqOfSectionPoint") -> "NCollection_Sequence< Intf_SectionPoint > &":
        return _Intf.Intf_SeqOfSectionPoint_Assign(self, theOther)

    def Set(self, theOther: "Intf_SeqOfSectionPoint") -> "NCollection_Sequence< Intf_SectionPoint > &":
        return _Intf.Intf_SeqOfSectionPoint_Set(self, theOther)

    def Remove(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionPoint_Remove(self, *args)

    def Append(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionPoint_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionPoint_Prepend(self, *args)

    def InsertBefore(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionPoint_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _Intf.Intf_SeqOfSectionPoint_InsertAfter(self, *args)

    def Split(self, theIndex: "Standard_Integer const", theSeq: "Intf_SeqOfSectionPoint") -> "void":
        return _Intf.Intf_SeqOfSectionPoint_Split(self, theIndex, theSeq)

    def First(self) -> "Intf_SectionPoint const &":
        return _Intf.Intf_SeqOfSectionPoint_First(self)

    def ChangeFirst(self) -> "Intf_SectionPoint &":
        return _Intf.Intf_SeqOfSectionPoint_ChangeFirst(self)

    def Last(self) -> "Intf_SectionPoint const &":
        return _Intf.Intf_SeqOfSectionPoint_Last(self)

    def ChangeLast(self) -> "Intf_SectionPoint &":
        return _Intf.Intf_SeqOfSectionPoint_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "Intf_SectionPoint const &":
        return _Intf.Intf_SeqOfSectionPoint_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "Intf_SectionPoint &":
        return _Intf.Intf_SeqOfSectionPoint_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "Intf_SectionPoint &":
        return _Intf.Intf_SeqOfSectionPoint___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "Intf_SectionPoint") -> "void":
        return _Intf.Intf_SeqOfSectionPoint_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Intf.delete_Intf_SeqOfSectionPoint

    def __len__(self):
        return self.Size()


# Register Intf_SeqOfSectionPoint in _Intf:
_Intf.Intf_SeqOfSectionPoint_swigregister(Intf_SeqOfSectionPoint)

def Intf_SeqOfSectionPoint_delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
    return _Intf.Intf_SeqOfSectionPoint_delNode(theNode, theAl)

class Intf_SeqOfTangentZone(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Sequence< Intf_TangentZone >::iterator":
        return _Intf.Intf_SeqOfTangentZone_begin(self)

    def end(self) -> "NCollection_Sequence< Intf_TangentZone >::iterator":
        return _Intf.Intf_SeqOfTangentZone_end(self)

    def cbegin(self) -> "NCollection_Sequence< Intf_TangentZone >::const_iterator":
        return _Intf.Intf_SeqOfTangentZone_cbegin(self)

    def cend(self) -> "NCollection_Sequence< Intf_TangentZone >::const_iterator":
        return _Intf.Intf_SeqOfTangentZone_cend(self)

    def __init__(self, *args):
        _Intf.Intf_SeqOfTangentZone_swiginit(self, _Intf.new_Intf_SeqOfTangentZone(*args))

    def Size(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfTangentZone_Size(self)

    def Length(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfTangentZone_Length(self)

    def Lower(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfTangentZone_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _Intf.Intf_SeqOfTangentZone_Upper(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _Intf.Intf_SeqOfTangentZone_IsEmpty(self)

    def Reverse(self) -> "void":
        return _Intf.Intf_SeqOfTangentZone_Reverse(self)

    def Exchange(self, I: "Standard_Integer const", J: "Standard_Integer const") -> "void":
        return _Intf.Intf_SeqOfTangentZone_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
        return _Intf.Intf_SeqOfTangentZone_delNode(theNode, theAl)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _Intf.Intf_SeqOfTangentZone_Clear(self, theAllocator)

    def Assign(self, theOther: "Intf_SeqOfTangentZone") -> "NCollection_Sequence< Intf_TangentZone > &":
        return _Intf.Intf_SeqOfTangentZone_Assign(self, theOther)

    def Set(self, theOther: "Intf_SeqOfTangentZone") -> "NCollection_Sequence< Intf_TangentZone > &":
        return _Intf.Intf_SeqOfTangentZone_Set(self, theOther)

    def Remove(self, *args) -> "void":
        return _Intf.Intf_SeqOfTangentZone_Remove(self, *args)

    def Append(self, *args) -> "void":
        return _Intf.Intf_SeqOfTangentZone_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _Intf.Intf_SeqOfTangentZone_Prepend(self, *args)

    def InsertBefore(self, *args) -> "void":
        return _Intf.Intf_SeqOfTangentZone_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _Intf.Intf_SeqOfTangentZone_InsertAfter(self, *args)

    def Split(self, theIndex: "Standard_Integer const", theSeq: "Intf_SeqOfTangentZone") -> "void":
        return _Intf.Intf_SeqOfTangentZone_Split(self, theIndex, theSeq)

    def First(self) -> "Intf_TangentZone const &":
        return _Intf.Intf_SeqOfTangentZone_First(self)

    def ChangeFirst(self) -> "Intf_TangentZone &":
        return _Intf.Intf_SeqOfTangentZone_ChangeFirst(self)

    def Last(self) -> "Intf_TangentZone const &":
        return _Intf.Intf_SeqOfTangentZone_Last(self)

    def ChangeLast(self) -> "Intf_TangentZone &":
        return _Intf.Intf_SeqOfTangentZone_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "Intf_TangentZone const &":
        return _Intf.Intf_SeqOfTangentZone_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "Intf_TangentZone &":
        return _Intf.Intf_SeqOfTangentZone_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "Intf_TangentZone &":
        return _Intf.Intf_SeqOfTangentZone___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "Intf_TangentZone") -> "void":
        return _Intf.Intf_SeqOfTangentZone_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Intf.delete_Intf_SeqOfTangentZone

    def __len__(self):
        return self.Size()


# Register Intf_SeqOfTangentZone in _Intf:
_Intf.Intf_SeqOfTangentZone_swigregister(Intf_SeqOfTangentZone)

def Intf_SeqOfTangentZone_delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
    return _Intf.Intf_SeqOfTangentZone_delNode(theNode, theAl)

class intf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Contain(*args) -> "Standard_Boolean":
        r"""
        Compute if the triangle <p1> <p2> <p3> contain <thepnt>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        ThePnt: gp_Pnt

        Returns
        -------
        bool

        """
        return _Intf.intf_Contain(*args)

    @staticmethod
    def PlaneEquation(*args) -> "Standard_Real &":
        r"""
        Computes the interference between two polygons in 2d. result : points of intersections and zones of tangence. computes the interference between a polygon or a straight line and a polyhedron. points of intersection and zones of tangence. give the plane equation of the triangle <p1> <p2> <p3>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        P3: gp_Pnt
        NormalVector: gp_XYZ

        Returns
        -------
        PolarDistance: float

        """
        return _Intf.intf_PlaneEquation(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _Intf.intf_swiginit(self, _Intf.new_intf())
    __swig_destroy__ = _Intf.delete_intf

# Register intf in _Intf:
_Intf.intf_swigregister(intf)

def intf_Contain(*args) -> "Standard_Boolean":
    r"""
    Compute if the triangle <p1> <p2> <p3> contain <thepnt>.

    Parameters
    ----------
    P1: gp_Pnt
    P2: gp_Pnt
    P3: gp_Pnt
    ThePnt: gp_Pnt

    Returns
    -------
    bool

    """
    return _Intf.intf_Contain(*args)

def intf_PlaneEquation(*args) -> "Standard_Real &":
    r"""
    Computes the interference between two polygons in 2d. result : points of intersections and zones of tangence. computes the interference between a polygon or a straight line and a polyhedron. points of intersection and zones of tangence. give the plane equation of the triangle <p1> <p2> <p3>.

    Parameters
    ----------
    P1: gp_Pnt
    P2: gp_Pnt
    P3: gp_Pnt
    NormalVector: gp_XYZ

    Returns
    -------
    PolarDistance: float

    """
    return _Intf.intf_PlaneEquation(*args)

class Intf_Interference(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Tests if the polylines of intersection or the zones of tangence contain the point of intersection <thepnt>.

        Parameters
        ----------
        ThePnt: Intf_SectionPoint

        Returns
        -------
        bool

        """
        return _Intf.Intf_Interference_Contains(self, *args)

    def Dump(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _Intf.Intf_Interference_Dump(self, *args)

    def GetTolerance(self, *args) -> "Standard_Real":
        r"""
        Gives the tolerance used for the calculation.

        Returns
        -------
        float

        """
        return _Intf.Intf_Interference_GetTolerance(self, *args)

    def Insert(self, *args) -> "void":
        r"""
        Inserts a new zone of tangence in the current list of tangent zones of the interference and returns true when done.

        Parameters
        ----------
        TheZone: Intf_TangentZone

        Returns
        -------
        bool
        Insert a new segment of intersection in the current list of polylines of intersection of the interference.

        Parameters
        ----------
        pdeb: Intf_SectionPoint
        pfin: Intf_SectionPoint

        Returns
        -------
        None

        """
        return _Intf.Intf_Interference_Insert(self, *args)

    def LineValue(self, *args) -> "Intf_SectionLine const &":
        r"""
        Gives the polyline of intersection at address <index> in the interference.

        Parameters
        ----------
        Index: int

        Returns
        -------
        Intf_SectionLine

        """
        return _Intf.Intf_Interference_LineValue(self, *args)

    def NbSectionLines(self, *args) -> "Standard_Integer":
        r"""
        Gives the number of polylines of intersection in the interference.

        Returns
        -------
        int

        """
        return _Intf.Intf_Interference_NbSectionLines(self, *args)

    def NbSectionPoints(self, *args) -> "Standard_Integer":
        r"""
        Gives the number of points of intersection in the interference.

        Returns
        -------
        int

        """
        return _Intf.Intf_Interference_NbSectionPoints(self, *args)

    def NbTangentZones(self, *args) -> "Standard_Integer":
        r"""
        Gives the number of zones of tangence in the interference.

        Returns
        -------
        int

        """
        return _Intf.Intf_Interference_NbTangentZones(self, *args)

    def PntValue(self, *args) -> "Intf_SectionPoint const &":
        r"""
        Gives the point of intersection of address index in the interference.

        Parameters
        ----------
        Index: int

        Returns
        -------
        Intf_SectionPoint

        """
        return _Intf.Intf_Interference_PntValue(self, *args)

    def ZoneValue(self, *args) -> "Intf_TangentZone const &":
        r"""
        Gives the zone of tangence at address index in the interference.

        Parameters
        ----------
        Index: int

        Returns
        -------
        Intf_TangentZone

        """
        return _Intf.Intf_Interference_ZoneValue(self, *args)

    __repr__ = _dumps_object


# Register Intf_Interference in _Intf:
_Intf.Intf_Interference_swigregister(Intf_Interference)

class Intf_Polygon2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Bounding(self, *args) -> "Bnd_Box2d const &":
        r"""
        Returns the bounding box of the polygon.

        Returns
        -------
        Bnd_Box2d

        """
        return _Intf.Intf_Polygon2d_Bounding(self, *args)

    def Closed(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the polyline is closed.

        Returns
        -------
        bool

        """
        return _Intf.Intf_Polygon2d_Closed(self, *args)

    def DeflectionOverEstimation(self, *args) -> "Standard_Real":
        r"""
        Returns the tolerance of the polygon.

        Returns
        -------
        float

        """
        return _Intf.Intf_Polygon2d_DeflectionOverEstimation(self, *args)

    def NbSegments(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of segments in the polyline.

        Returns
        -------
        int

        """
        return _Intf.Intf_Polygon2d_NbSegments(self, *args)

    def Segment(self, *args) -> "void":
        r"""
        Returns the points of the segment <index> in the polygon.

        Parameters
        ----------
        theIndex: int
        theBegin: gp_Pnt2d
        theEnd: gp_Pnt2d

        Returns
        -------
        None

        """
        return _Intf.Intf_Polygon2d_Segment(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_Polygon2d

# Register Intf_Polygon2d in _Intf:
_Intf.Intf_Polygon2d_swigregister(Intf_Polygon2d)

class Intf_SectionLine(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty sectionline.

        Returns
        -------
        None
        Copies a sectionline.

        Parameters
        ----------
        Other: Intf_SectionLine

        Returns
        -------
        None

        """
        _Intf.Intf_SectionLine_swiginit(self, _Intf.new_Intf_SectionLine(*args))

    def Append(self, *args) -> "void":
        r"""
        Adds a point at the end of the sectionline.

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Returns
        -------
        None
        Concatenates the sectionline <ls> at the end of the sectionline <self>.

        Parameters
        ----------
        LS: Intf_SectionLine

        Returns
        -------
        None

        """
        return _Intf.Intf_SectionLine_Append(self, *args)

    def Close(self, *args) -> "void":
        r"""
        Closes the sectionline.

        Returns
        -------
        None

        """
        return _Intf.Intf_SectionLine_Close(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if thepi is in the sectionline <self>.

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Returns
        -------
        bool

        """
        return _Intf.Intf_SectionLine_Contains(self, *args)

    def Dump(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Indent: int

        Returns
        -------
        None

        """
        return _Intf.Intf_SectionLine_Dump(self, *args)

    def GetPoint(self, *args) -> "Intf_SectionPoint const &":
        r"""
        Gives the point of intersection of address <index> in the sectionline.

        Parameters
        ----------
        Index: int

        Returns
        -------
        Intf_SectionPoint

        """
        return _Intf.Intf_SectionLine_GetPoint(self, *args)

    def IsClosed(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the sectionline is closed.

        Returns
        -------
        bool

        """
        return _Intf.Intf_SectionLine_IsClosed(self, *args)

    def IsEnd(self, *args) -> "Standard_Integer":
        r"""
        Checks if <thepi> is an end of the sectionline. returns 1 for the beginning, 2 for the end, otherwise 0.

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Returns
        -------
        int

        """
        return _Intf.Intf_SectionLine_IsEnd(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Compares two sectionlines.

        Parameters
        ----------
        Other: Intf_SectionLine

        Returns
        -------
        bool

        """
        return _Intf.Intf_SectionLine_IsEqual(self, *args)

    def NumberOfPoints(self, *args) -> "Standard_Integer":
        r"""
        Returns number of points in this sectionline.

        Returns
        -------
        int

        """
        return _Intf.Intf_SectionLine_NumberOfPoints(self, *args)

    def Prepend(self, *args) -> "void":
        r"""
        Adds a point to the beginning of the sectionline <self>.

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Returns
        -------
        None
        Concatenates a sectionline <ls> at the beginning of the sectionline <self>.

        Parameters
        ----------
        LS: Intf_SectionLine

        Returns
        -------
        None

        """
        return _Intf.Intf_SectionLine_Prepend(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverses the order of the elements of the sectionline.

        Returns
        -------
        None

        """
        return _Intf.Intf_SectionLine_Reverse(self, *args)

    def __eq_wrapper__(self, other: "Intf_SectionLine") -> "bool":
        return _Intf.Intf_SectionLine___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_SectionLine

# Register Intf_SectionLine in _Intf:
_Intf.Intf_SectionLine_swigregister(Intf_SectionLine)

class Intf_SectionPoint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        Builds a sectionpoint with the respective dimensions (vertex edge or face) of the concerned arguments and their addresses in the topological structure.

        Parameters
        ----------
        Where: gp_Pnt
        DimeO: Intf_PIType
        AddrO1: int
        AddrO2: int
        ParamO: float
        DimeT: Intf_PIType
        AddrT1: int
        AddrT2: int
        ParamT: float
        Incid: float

        Returns
        -------
        None
        Builds a sectionpoint 2d with the respective dimensions (vertex or edge) of the concerned arguments and their addresses in the topological structure.

        Parameters
        ----------
        Where: gp_Pnt2d
        DimeO: Intf_PIType
        AddrO1: int
        ParamO: float
        DimeT: Intf_PIType
        AddrT1: int
        ParamT: float
        Incid: float

        Returns
        -------
        None

        """
        _Intf.Intf_SectionPoint_swiginit(self, _Intf.new_Intf_SectionPoint(*args))

    def Dump(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Indent: int

        Returns
        -------
        None

        """
        return _Intf.Intf_SectionPoint_Dump(self, *args)

    def Incidence(self, *args) -> "Standard_Real":
        r"""
        Gives the incidence at this section point. the incidence between the two triangles is given by the cosine. the best incidence is 0. (pi/2). the worst is 1. (null angle).

        Returns
        -------
        float

        """
        return _Intf.Intf_SectionPoint_Incidence(self, *args)

    def InfoFirst(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Dim: Intf_PIType

        Returns
        -------
        Add1: int
        Add2: int
        Param: float
        Gives the datas about the first argument of the interference.

        Parameters
        ----------
        Dim: Intf_PIType

        Returns
        -------
        Addr: int
        Param: float

        """
        return _Intf.Intf_SectionPoint_InfoFirst(self, *args)

    def InfoSecond(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Dim: Intf_PIType

        Returns
        -------
        Add1: int
        Add2: int
        Param: float
        Gives the datas about the second argument of the interference.

        Parameters
        ----------
        Dim: Intf_PIType

        Returns
        -------
        Addr: int
        Param: float

        """
        return _Intf.Intf_SectionPoint_InfoSecond(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the two sectionpoint have the same logical informations.

        Parameters
        ----------
        Other: Intf_SectionPoint

        Returns
        -------
        bool

        """
        return _Intf.Intf_SectionPoint_IsEqual(self, *args)

    def IsOnSameEdge(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the two sectionpoints are on the same edge of the first or the second element.

        Parameters
        ----------
        Other: Intf_SectionPoint

        Returns
        -------
        bool

        """
        return _Intf.Intf_SectionPoint_IsOnSameEdge(self, *args)

    def Merge(self, *args) -> "void":
        r"""
        Merges two sectionpoints.

        Parameters
        ----------
        Other: Intf_SectionPoint

        Returns
        -------
        None

        """
        return _Intf.Intf_SectionPoint_Merge(self, *args)

    def ParamOnFirst(self, *args) -> "Standard_Real":
        r"""
        Returns the cumulated parameter of the sectionpoint on the first element.

        Returns
        -------
        float

        """
        return _Intf.Intf_SectionPoint_ParamOnFirst(self, *args)

    def ParamOnSecond(self, *args) -> "Standard_Real":
        r"""
        Returns the cumulated parameter of the section point on the second element.

        Returns
        -------
        float

        """
        return _Intf.Intf_SectionPoint_ParamOnSecond(self, *args)

    def Pnt(self, *args) -> "gp_Pnt const":
        r"""
        Returns the location of the sectionpoint.

        Returns
        -------
        gp_Pnt

        """
        return _Intf.Intf_SectionPoint_Pnt(self, *args)

    def TypeOnFirst(self, *args) -> "Intf_PIType":
        r"""
        Returns the type of the section point on the first element.

        Returns
        -------
        Intf_PIType

        """
        return _Intf.Intf_SectionPoint_TypeOnFirst(self, *args)

    def TypeOnSecond(self, *args) -> "Intf_PIType":
        r"""
        Returns the type of the section point on the second element.

        Returns
        -------
        Intf_PIType

        """
        return _Intf.Intf_SectionPoint_TypeOnSecond(self, *args)

    def __eq_wrapper__(self, other: "Intf_SectionPoint") -> "bool":
        return _Intf.Intf_SectionPoint___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_SectionPoint

# Register Intf_SectionPoint in _Intf:
_Intf.Intf_SectionPoint_swigregister(Intf_SectionPoint)

class Intf_TangentZone(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Builds an empty tangent zone.

        Returns
        -------
        None

        """
        _Intf.Intf_TangentZone_swiginit(self, _Intf.new_Intf_TangentZone(*args))

    def Append(self, *args) -> "void":
        r"""
        Adds a sectionpoint to the tangentzone.

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Returns
        -------
        None
        Adds the tangentzone <tzi> to <self>.

        Parameters
        ----------
        Tzi: Intf_TangentZone

        Returns
        -------
        None

        """
        return _Intf.Intf_TangentZone_Append(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Checks if <thepi> is in tangentzone.

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Returns
        -------
        bool

        """
        return _Intf.Intf_TangentZone_Contains(self, *args)

    def Dump(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Indent: int

        Returns
        -------
        None

        """
        return _Intf.Intf_TangentZone_Dump(self, *args)

    def GetPoint(self, *args) -> "Intf_SectionPoint const &":
        r"""
        Gives the sectionpoint of address <index> in the tangentzone.

        Parameters
        ----------
        Index: int

        Returns
        -------
        Intf_SectionPoint

        """
        return _Intf.Intf_TangentZone_GetPoint(self, *args)

    def HasCommonRange(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the tangentzone <other> has a common part with <self>.

        Parameters
        ----------
        Other: Intf_TangentZone

        Returns
        -------
        bool

        """
        return _Intf.Intf_TangentZone_HasCommonRange(self, *args)

    def InfoFirst(self, *args) -> "void":
        r"""
        Gives information about the first argument of the interference. (usable only for polygon).

        Parameters
        ----------

        Returns
        -------
        segMin: int
        paraMin: float
        segMax: int
        paraMax: float

        """
        return _Intf.Intf_TangentZone_InfoFirst(self, *args)

    def InfoSecond(self, *args) -> "void":
        r"""
        Gives informations about the second argument of the interference. (usable only for polygon).

        Parameters
        ----------

        Returns
        -------
        segMin: int
        paraMin: float
        segMax: int
        paraMax: float

        """
        return _Intf.Intf_TangentZone_InfoSecond(self, *args)

    def Insert(self, *args) -> "Standard_Boolean":
        r"""
        Inserts a sectionpoint in the tangentzone.

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Returns
        -------
        bool

        """
        return _Intf.Intf_TangentZone_Insert(self, *args)

    def InsertAfter(self, *args) -> "void":
        r"""
        Inserts a sectionpoint after <index> in the tangentzone.

        Parameters
        ----------
        Index: int
        Pi: Intf_SectionPoint

        Returns
        -------
        None

        """
        return _Intf.Intf_TangentZone_InsertAfter(self, *args)

    def InsertBefore(self, *args) -> "void":
        r"""
        Inserts a sectionpoint before <index> in the tangentzone.

        Parameters
        ----------
        Index: int
        Pi: Intf_SectionPoint

        Returns
        -------
        None

        """
        return _Intf.Intf_TangentZone_InsertBefore(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Compares two tangentzones.

        Parameters
        ----------
        Other: Intf_TangentZone

        Returns
        -------
        bool

        """
        return _Intf.Intf_TangentZone_IsEqual(self, *args)

    def NumberOfPoints(self, *args) -> "Standard_Integer":
        r"""
        Returns number of sectionpoint in this tangentzone.

        Returns
        -------
        int

        """
        return _Intf.Intf_TangentZone_NumberOfPoints(self, *args)

    def ParamOnFirst(self, *args) -> "void":
        r"""
        Gives the parameter range of the tangentzone on the first argument of the interference. (usable only for polygon).

        Parameters
        ----------

        Returns
        -------
        paraMin: float
        paraMax: float

        """
        return _Intf.Intf_TangentZone_ParamOnFirst(self, *args)

    def ParamOnSecond(self, *args) -> "void":
        r"""
        Gives the parameter range of the tangentzone on the second argument of the interference. (usable only for polygon).

        Parameters
        ----------

        Returns
        -------
        paraMin: float
        paraMax: float

        """
        return _Intf.Intf_TangentZone_ParamOnSecond(self, *args)

    def PolygonInsert(self, *args) -> "void":
        r"""
        Inserts a point in the polygonal tangentzone.

        Parameters
        ----------
        Pi: Intf_SectionPoint

        Returns
        -------
        None

        """
        return _Intf.Intf_TangentZone_PolygonInsert(self, *args)

    def RangeContains(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <thepi> is in the parameter range of the tangentzone.

        Parameters
        ----------
        ThePI: Intf_SectionPoint

        Returns
        -------
        bool

        """
        return _Intf.Intf_TangentZone_RangeContains(self, *args)

    def __eq_wrapper__(self, other: "Intf_TangentZone") -> "bool":
        return _Intf.Intf_TangentZone___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_TangentZone

# Register Intf_TangentZone in _Intf:
_Intf.Intf_TangentZone_swigregister(Intf_TangentZone)

class Intf_Tool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _Intf.Intf_Tool_swiginit(self, _Intf.new_Intf_Tool(*args))

    def BeginParam(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        SegmentNum: int

        Returns
        -------
        float

        """
        return _Intf.Intf_Tool_BeginParam(self, *args)

    def EndParam(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        SegmentNum: int

        Returns
        -------
        float

        """
        return _Intf.Intf_Tool_EndParam(self, *args)

    def Hypr2dBox(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theHypr2d: gp_Hypr2d
        bounding: Bnd_Box2d
        boxHypr: Bnd_Box2d

        Returns
        -------
        None

        """
        return _Intf.Intf_Tool_Hypr2dBox(self, *args)

    def HyprBox(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theHypr: gp_Hypr
        bounding: Bnd_Box
        boxHypr: Bnd_Box

        Returns
        -------
        None

        """
        return _Intf.Intf_Tool_HyprBox(self, *args)

    def Lin2dBox(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theLin2d: gp_Lin2d
        bounding: Bnd_Box2d
        boxLin: Bnd_Box2d

        Returns
        -------
        None

        """
        return _Intf.Intf_Tool_Lin2dBox(self, *args)

    def LinBox(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theLin: gp_Lin
        bounding: Bnd_Box
        boxLin: Bnd_Box

        Returns
        -------
        None

        """
        return _Intf.Intf_Tool_LinBox(self, *args)

    def NbSegments(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Intf.Intf_Tool_NbSegments(self, *args)

    def Parab2dBox(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theParab2d: gp_Parab2d
        bounding: Bnd_Box2d
        boxHypr: Bnd_Box2d

        Returns
        -------
        None

        """
        return _Intf.Intf_Tool_Parab2dBox(self, *args)

    def ParabBox(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theParab: gp_Parab
        bounding: Bnd_Box
        boxHypr: Bnd_Box

        Returns
        -------
        None

        """
        return _Intf.Intf_Tool_ParabBox(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_Tool

# Register Intf_Tool in _Intf:
_Intf.Intf_Tool_swigregister(Intf_Tool)

class Intf_InterferencePolygon2d(Intf_Interference):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty interference of polygon.

        Returns
        -------
        None
        Constructs and computes an interference between two polygons.

        Parameters
        ----------
        Obje1: Intf_Polygon2d
        Obje2: Intf_Polygon2d

        Returns
        -------
        None
        Constructs and computes the auto interference of a polygon.

        Parameters
        ----------
        Obje: Intf_Polygon2d

        Returns
        -------
        None

        """
        _Intf.Intf_InterferencePolygon2d_swiginit(self, _Intf.new_Intf_InterferencePolygon2d(*args))

    def Perform(self, *args) -> "void":
        r"""
        Computes an interference between two polygons.

        Parameters
        ----------
        Obje1: Intf_Polygon2d
        Obje2: Intf_Polygon2d

        Returns
        -------
        None
        Computes the self interference of a polygon.

        Parameters
        ----------
        Obje: Intf_Polygon2d

        Returns
        -------
        None

        """
        return _Intf.Intf_InterferencePolygon2d_Perform(self, *args)

    def Pnt2dValue(self, *args) -> "gp_Pnt2d":
        r"""
        Gives the geometrical 2d point of the intersection point at address <index> in the interference.

        Parameters
        ----------
        Index: int

        Returns
        -------
        gp_Pnt2d

        """
        return _Intf.Intf_InterferencePolygon2d_Pnt2dValue(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Intf.delete_Intf_InterferencePolygon2d

# Register Intf_InterferencePolygon2d in _Intf:
_Intf.Intf_InterferencePolygon2d_swigregister(Intf_InterferencePolygon2d)





