/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitIndexUtil {
    private static final Logger LOG = Logger.getInstance(GitIndexUtil.class);
    private static final String EXECUTABLE_MODE = "100755";
    private static final String DEFAULT_MODE = "100644";

    @Nullable
    public static StagedFile listStaged(@NotNull GitRepository repository, @NotNull FilePath filePath) throws VcsException {
        List<StagedFile> result2;
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(1);
        }
        if ((result2 = GitIndexUtil.listStaged(repository, Collections.singleton(filePath))).size() != 1) {
            return null;
        }
        return result2.get(0);
    }

    @NotNull
    public static List<StagedFile> listStaged(@NotNull GitRepository repository, @NotNull Collection<FilePath> filePaths) throws VcsException {
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(2);
        }
        if (filePaths == null) {
            GitIndexUtil.$$$reportNull$$$0(3);
        }
        final ArrayList<StagedFile> result2 = new ArrayList<StagedFile>();
        final VirtualFile root = repository.getRoot();
        GitLineHandler h = new GitLineHandler(repository.getProject(), root, GitCommand.LS_FILES);
        h.addParameters("-s");
        h.endOptions();
        h.addRelativePaths(filePaths);
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)GitIndexUtil.parseListFilesStagedRecord(root, line));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        ArrayList<StagedFile> arrayList = result2;
        if (arrayList == null) {
            GitIndexUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static StagedFile listTree(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revision) throws VcsException {
        List<StagedFileOrDirectory> result2;
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(5);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(6);
        }
        if (revision == null) {
            GitIndexUtil.$$$reportNull$$$0(7);
        }
        if ((result2 = GitIndexUtil.listTree(repository, Collections.singleton(filePath), revision)).size() != 1 || !(result2.get(0) instanceof StagedFile)) {
            return null;
        }
        return (StagedFile)result2.get(0);
    }

    @NotNull
    public static List<StagedFileOrDirectory> listTree(@NotNull GitRepository repository, @NotNull Collection<FilePath> filePath, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(8);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(9);
        }
        if (revision == null) {
            GitIndexUtil.$$$reportNull$$$0(10);
        }
        final ArrayList<StagedFileOrDirectory> result2 = new ArrayList<StagedFileOrDirectory>();
        final VirtualFile root = repository.getRoot();
        GitLineHandler h = new GitLineHandler(repository.getProject(), root, GitCommand.LS_TREE);
        h.addParameters(revision.asString());
        h.endOptions();
        h.addRelativePaths(filePath);
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)GitIndexUtil.parseListTreeRecord(root, line));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        ArrayList<StagedFileOrDirectory> arrayList = result2;
        if (arrayList == null) {
            GitIndexUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static StagedFile parseListFilesStagedRecord(@NotNull VirtualFile root, @NotNull String line) {
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(12);
        }
        if (line == null) {
            GitIndexUtil.$$$reportNull$$$0(13);
        }
        try {
            StringScanner s = new StringScanner(line);
            String permissions = s.spaceToken();
            String hash = s.spaceToken();
            String stage = s.tabToken();
            String filePath = s.line();
            if (!"0".equals(stage)) {
                return null;
            }
            FilePath path = VcsUtil.getFilePath((VirtualFile)root, (String)GitUtil.unescapePath(filePath));
            boolean executable = EXECUTABLE_MODE.equals(permissions);
            return new StagedFile(path, hash, executable);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static StagedFileOrDirectory parseListTreeRecord(@NotNull VirtualFile root, @NotNull String line) {
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(14);
        }
        if (line == null) {
            GitIndexUtil.$$$reportNull$$$0(15);
        }
        try {
            StringScanner s = new StringScanner(line);
            String permissions = s.spaceToken();
            String type = s.spaceToken();
            String hash = s.tabToken();
            String filePath = GitUtil.unescapePath(s.line());
            if ("tree".equals(type)) {
                return new StagedDirectory(VcsUtil.getFilePath((VirtualFile)root, (String)filePath, (boolean)true));
            }
            if ("commit".equals(type)) {
                return new StagedSubrepo(VcsUtil.getFilePath((VirtualFile)root, (String)filePath, (boolean)true), hash);
            }
            if (!"blob".equals(type)) {
                return null;
            }
            boolean executable = EXECUTABLE_MODE.equals(permissions);
            return new StagedFile(VcsUtil.getFilePath((VirtualFile)root, (String)filePath), hash, executable);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Hash write(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull byte[] bytes, boolean executable) throws VcsException {
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(16);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(17);
        }
        if (bytes == null) {
            GitIndexUtil.$$$reportNull$$$0(18);
        }
        Hash hash = GitIndexUtil.write(repository, filePath, new ByteArrayInputStream(bytes), executable);
        if (hash == null) {
            GitIndexUtil.$$$reportNull$$$0(19);
        }
        return hash;
    }

    @NotNull
    public static Hash write(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull InputStream content, boolean executable) throws VcsException {
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(20);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(21);
        }
        if (content == null) {
            GitIndexUtil.$$$reportNull$$$0(22);
        }
        Hash hash = GitIndexUtil.hashObject(repository, filePath, content);
        GitIndexUtil.updateIndex(repository, filePath, hash, executable);
        Hash hash2 = hash;
        if (hash2 == null) {
            GitIndexUtil.$$$reportNull$$$0(23);
        }
        return hash2;
    }

    @NotNull
    private static Hash hashObject(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull InputStream content) throws VcsException {
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(24);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(25);
        }
        if (content == null) {
            GitIndexUtil.$$$reportNull$$$0(26);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.HASH_OBJECT);
        h.setSilent(true);
        h.addParameters("-w", "--stdin");
        h.addParameters("--path", VcsFileUtil.relativePath((VirtualFile)repository.getRoot(), (FilePath)filePath));
        h.setInputProcessor(GitHandlerInputProcessorUtil.redirectStream(content));
        h.endOptions();
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Hash hash = HashImpl.build((String)output.trim());
        if (hash == null) {
            GitIndexUtil.$$$reportNull$$$0(27);
        }
        return hash;
    }

    public static void updateIndex(@NotNull GitRepository repository, @NotNull FilePath filePath, @NotNull Hash blobHash, boolean isExecutable) throws VcsException {
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(28);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(29);
        }
        if (blobHash == null) {
            GitIndexUtil.$$$reportNull$$$0(30);
        }
        String mode = isExecutable ? EXECUTABLE_MODE : DEFAULT_MODE;
        String path = VcsFileUtil.relativePath((VirtualFile)repository.getRoot(), (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.UPDATE_INDEX);
        if (GitVersionSpecialty.CACHEINFO_SUPPORTS_SINGLE_PARAMETER_FORM.existsIn(repository)) {
            h.addParameters("--cacheinfo", mode + "," + blobHash.asString() + "," + path);
        } else {
            h.addParameters("--cacheinfo", mode, blobHash.asString(), path);
        }
        h.endOptions();
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
    }

    @NotNull
    public static byte[] read(@NotNull GitRepository repository, @NotNull String blobHash) throws VcsException {
        if (repository == null) {
            GitIndexUtil.$$$reportNull$$$0(31);
        }
        if (blobHash == null) {
            GitIndexUtil.$$$reportNull$$$0(32);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters(blobHash);
        h.endOptions();
        byte[] byArray = h.run();
        if (byArray == null) {
            GitIndexUtil.$$$reportNull$$$0(33);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 23: 
            case 27: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 23: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 17: 
            case 21: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 23: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/index/GitIndexUtil";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blobHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/index/GitIndexUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "listStaged";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "listTree";
                break;
            }
            case 19: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "hashObject";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listStaged";
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 23: 
            case 27: 
            case 33: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "listTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseListFilesStagedRecord";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseListTreeRecord";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hashObject";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 23: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StagedSubrepo
    extends StagedFileOrDirectory {
        @NotNull
        private final String myBlobHash;

        public StagedSubrepo(@NotNull FilePath path, @NotNull String blobHash) {
            if (path == null) {
                StagedSubrepo.$$$reportNull$$$0(0);
            }
            if (blobHash == null) {
                StagedSubrepo.$$$reportNull$$$0(1);
            }
            super(path);
            this.myBlobHash = blobHash;
        }

        @NotNull
        public String getBlobHash() {
            String string = this.myBlobHash;
            if (string == null) {
                StagedSubrepo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public String toString() {
            return "StagedSubRepo[" + this.myPath + "] at [" + this.myBlobHash + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blobHash";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/index/GitIndexUtil$StagedSubrepo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/index/GitIndexUtil$StagedSubrepo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlobHash";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class StagedDirectory
    extends StagedFileOrDirectory {
        public StagedDirectory(@NotNull FilePath path) {
            if (path == null) {
                StagedDirectory.$$$reportNull$$$0(0);
            }
            super(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/index/GitIndexUtil$StagedDirectory", "<init>"));
        }
    }

    public static class StagedFile
    extends StagedFileOrDirectory {
        @NotNull
        private final String myBlobHash;
        private final boolean myExecutable;

        public StagedFile(@NotNull FilePath path, @NotNull String blobHash, boolean executable) {
            if (path == null) {
                StagedFile.$$$reportNull$$$0(0);
            }
            if (blobHash == null) {
                StagedFile.$$$reportNull$$$0(1);
            }
            super(path);
            this.myBlobHash = blobHash;
            this.myExecutable = executable;
        }

        @NotNull
        public String getBlobHash() {
            String string = this.myBlobHash;
            if (string == null) {
                StagedFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isExecutable() {
            return this.myExecutable;
        }

        @Override
        public String toString() {
            return "StagedFile[" + this.myPath + "] at [" + this.myBlobHash + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blobHash";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/index/GitIndexUtil$StagedFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/index/GitIndexUtil$StagedFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlobHash";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class StagedFileOrDirectory {
        @NotNull
        protected final FilePath myPath;

        public StagedFileOrDirectory(@NotNull FilePath path) {
            if (path == null) {
                StagedFileOrDirectory.$$$reportNull$$$0(0);
            }
            this.myPath = path;
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                StagedFileOrDirectory.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        public String toString() {
            return "StagedFileOrDirectory[" + this.myPath + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/index/GitIndexUtil$StagedFileOrDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/index/GitIndexUtil$StagedFileOrDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

