/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHideOutputAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;

public class IpnbCodeOutputPanel<K extends IpnbOutputCell>
extends IpnbPanel<JComponent, K> {
    protected final IpnbFilePanel myParent;
    private final IpnbCodePanel myCodePanel;

    public IpnbCodeOutputPanel(@NotNull K cell, @Nullable IpnbFilePanel parent, @Nullable IpnbCodePanel codePanel) {
        if (cell == null) {
            IpnbCodeOutputPanel.$$$reportNull$$$0(0);
        }
        super(cell, new BorderLayout());
        this.myParent = parent;
        this.myViewPanel = this.createViewPanel();
        this.add(this.myViewPanel);
        this.myCodePanel = codePanel;
        this.myViewPanel.addMouseListener(this.createHideOutputListener());
        this.addRightClickMenu();
    }

    @Override
    protected JComponent createViewPanel() {
        JTextArea textArea = new JTextArea(((IpnbOutputCell)this.myCell).getSourceAsString());
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        Font font = textArea.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize());
        textArea.setFont(newFont);
        textArea.setBackground(IpnbEditorUtil.getBackground());
        return textArea;
    }

    @Override
    public void addRightClickMenu() {
        this.myViewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    ListPopup menu = IpnbCodeOutputPanel.this.createPopupMenu(new DefaultActionGroup(new AnAction[]{new IpnbHideOutputAction(IpnbCodeOutputPanel.this.myCodePanel)}));
                    menu.show(RelativePoint.fromScreen((Point)e.getLocationOnScreen()));
                }
            }
        });
    }

    @NotNull
    private MouseAdapter createHideOutputListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    IpnbCodeOutputPanel.this.myCodePanel.hideOutputPanel();
                }
            }
        };
        if (mouseAdapter == null) {
            IpnbCodeOutputPanel.$$$reportNull$$$0(1);
        }
        return mouseAdapter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeOutputPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeOutputPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHideOutputListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

