/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.auth.SvnAuthenticationProvider;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

class RepositoryLoader
extends Loader {
    @NotNull
    private final Queue<Pair<RepositoryTreeNode, Expander>> myLoadQueue;
    private boolean myQueueProcessorActive;

    RepositoryLoader(@NotNull SvnRepositoryCache cache) {
        if (cache == null) {
            RepositoryLoader.$$$reportNull$$$0(0);
        }
        super(cache);
        this.myLoadQueue = ContainerUtil.newLinkedList();
        this.myQueueProcessorActive = false;
    }

    @Override
    public void load(@NotNull RepositoryTreeNode node, @NotNull Expander afterRefreshExpander) {
        if (node == null) {
            RepositoryLoader.$$$reportNull$$$0(1);
        }
        if (afterRefreshExpander == null) {
            RepositoryLoader.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair data = Pair.create((Object)node, (Object)afterRefreshExpander);
        if (!this.myQueueProcessorActive) {
            this.startLoadTask((Pair<RepositoryTreeNode, Expander>)data);
            this.myQueueProcessorActive = true;
        } else {
            this.myLoadQueue.offer((Pair<RepositoryTreeNode, Expander>)data);
        }
    }

    private void setResults(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull List<DirectoryEntry> children) {
        if (data == null) {
            RepositoryLoader.$$$reportNull$$$0(3);
        }
        if (children == null) {
            RepositoryLoader.$$$reportNull$$$0(4);
        }
        this.myCache.put(((RepositoryTreeNode)data.first).getURL().toString(), children);
        this.refreshNode((RepositoryTreeNode)data.first, children, (Expander)data.second);
    }

    private void setError(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull String message) {
        if (data == null) {
            RepositoryLoader.$$$reportNull$$$0(5);
        }
        if (message == null) {
            RepositoryLoader.$$$reportNull$$$0(6);
        }
        this.myCache.put(((RepositoryTreeNode)data.first).getURL().toString(), message);
        this.refreshNodeError((RepositoryTreeNode)data.first, message);
    }

    private void startNext() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<RepositoryTreeNode, Expander> data = this.myLoadQueue.poll();
        if (data == null) {
            this.myQueueProcessorActive = false;
            return;
        }
        if (((RepositoryTreeNode)data.first).isDisposed()) {
            this.startNext();
        } else {
            this.startLoadTask(data);
        }
    }

    private void startLoadTask(@NotNull Pair<RepositoryTreeNode, Expander> data) {
        if (data == null) {
            RepositoryLoader.$$$reportNull$$$0(7);
        }
        ModalityState state = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess((Runnable)new LoadTask(data), (ProgressIndicator)new EmptyProgressIndicator(state)));
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        NodeLoadState nodeLoadState = NodeLoadState.REFRESHED;
        if (nodeLoadState == null) {
            RepositoryLoader.$$$reportNull$$$0(8);
        }
        return nodeLoadState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRefreshExpander";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLoadState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setResults";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startLoadTask";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LoadTask
    implements Runnable {
        @NotNull
        private final Pair<RepositoryTreeNode, Expander> myData;

        private LoadTask(Pair<RepositoryTreeNode, Expander> data) {
            if (data == null) {
                LoadTask.$$$reportNull$$$0(0);
            }
            this.myData = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList entries = ContainerUtil.newArrayList();
            RepositoryTreeNode node = (RepositoryTreeNode)this.myData.first;
            SvnVcs vcs = node.getVcs();
            SvnAuthenticationProvider.forceInteractive();
            try {
                Target target = Target.on(node.getURL());
                vcs.getFactoryFromSettings().createBrowseClient().list(target, Revision.HEAD, Depth.IMMEDIATES, entries::add);
            }
            catch (VcsException e) {
                SwingUtilities.invokeLater(() -> {
                    RepositoryLoader.this.setError((Pair<RepositoryTreeNode, Expander>)this.myData, e.getMessage());
                    RepositoryLoader.this.startNext();
                });
                return;
            }
            finally {
                SvnAuthenticationProvider.clearInteractive();
            }
            SwingUtilities.invokeLater(() -> {
                RepositoryLoader.this.setResults((Pair<RepositoryTreeNode, Expander>)this.myData, ContainerUtil.sorted((Collection)entries, DirectoryEntry.CASE_INSENSITIVE_ORDER));
                RepositoryLoader.this.startNext();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/dialogs/browserCache/RepositoryLoader$LoadTask", "<init>"));
        }
    }
}

