/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.awt.Cursor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearGraphUtils {
    public static final LinearGraphController.LinearGraphAnswer DEFAULT_GRAPH_ANSWER = new LinearGraphController.LinearGraphAnswer(Cursor.getDefaultCursor(), null);

    public static boolean intEqual(@Nullable Integer value, int number) {
        return value != null && value == number;
    }

    public static boolean isEdgeUp(@NotNull GraphEdge edge, int nodeIndex) {
        if (edge == null) {
            LinearGraphUtils.$$$reportNull$$$0(0);
        }
        return LinearGraphUtils.intEqual(edge.getDownNodeIndex(), nodeIndex);
    }

    public static boolean isEdgeDown(@NotNull GraphEdge edge, int nodeIndex) {
        if (edge == null) {
            LinearGraphUtils.$$$reportNull$$$0(1);
        }
        return LinearGraphUtils.intEqual(edge.getUpNodeIndex(), nodeIndex);
    }

    public static boolean isNormalEdge(@Nullable GraphEdge edge) {
        if (edge != null && edge.getType().isNormalEdge()) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return true;
        }
        return false;
    }

    @Nullable
    public static NormalEdge asNormalEdge(@Nullable GraphEdge edge) {
        if (LinearGraphUtils.isNormalEdge(edge)) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return NormalEdge.create(edge.getUpNodeIndex(), edge.getDownNodeIndex());
        }
        return null;
    }

    public static int getNotNullNodeIndex(@NotNull GraphEdge edge) {
        if (edge == null) {
            LinearGraphUtils.$$$reportNull$$$0(2);
        }
        if (edge.getUpNodeIndex() != null) {
            return edge.getUpNodeIndex();
        }
        assert (edge.getDownNodeIndex() != null);
        return edge.getDownNodeIndex();
    }

    @NotNull
    public static List<Integer> getUpNodes(@NotNull LinearGraph graph2, int nodeIndex) {
        if (graph2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_UP), graphEdge -> graphEdge.getUpNodeIndex());
        if (list2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<Integer> getDownNodes(@NotNull LinearGraph graph2, int nodeIndex) {
        if (graph2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(5);
        }
        List list2 = ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_DOWN), graphEdge -> graphEdge.getDownNodeIndex());
        if (list2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static List<Integer> getDownNodesIncludeNotLoad(@NotNull LinearGraph graph2, int nodeIndex) {
        if (graph2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(7);
        }
        List list2 = ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, EdgeFilter.ALL), graphEdge -> {
            if (LinearGraphUtils.isEdgeDown(graphEdge, nodeIndex)) {
                if (graphEdge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                    return graphEdge.getTargetId();
                }
                return graphEdge.getDownNodeIndex();
            }
            return null;
        });
        if (list2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public static LiteLinearGraph asLiteLinearGraph(final @NotNull LinearGraph graph2) {
        if (graph2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(9);
        }
        LiteLinearGraph liteLinearGraph = new LiteLinearGraph(){

            @Override
            public int nodesCount() {
                return graph2.nodesCount();
            }

            @Override
            @NotNull
            public List<Integer> getNodes(int nodeIndex, @NotNull LiteLinearGraph.NodeFilter filter) {
                if (filter == null) {
                    1.$$$reportNull$$$0(0);
                }
                List list2 = ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, filter.edgeFilter), edge -> {
                    if (LinearGraphUtils.isEdgeUp(edge, nodeIndex)) {
                        return edge.getUpNodeIndex();
                    }
                    if (LinearGraphUtils.isEdgeDown(edge, nodeIndex)) {
                        return edge.getDownNodeIndex();
                    }
                    return null;
                });
                if (list2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filter";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/graph/utils/LinearGraphUtils$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/graph/utils/LinearGraphUtils$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getNodes";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (liteLinearGraph == null) {
            LinearGraphUtils.$$$reportNull$$$0(10);
        }
        return liteLinearGraph;
    }

    @NotNull
    public static Cursor getCursor(boolean hand) {
        if (hand) {
            Cursor cursor = Cursor.getPredefinedCursor(12);
            if (cursor == null) {
                LinearGraphUtils.$$$reportNull$$$0(11);
            }
            return cursor;
        }
        Cursor cursor = Cursor.getDefaultCursor();
        if (cursor == null) {
            LinearGraphUtils.$$$reportNull$$$0(12);
        }
        return cursor;
    }

    public static LinearGraphController.LinearGraphAnswer createSelectedAnswer(@NotNull LinearGraph linearGraph, @NotNull Collection<Integer> selectedNodeIndexes) {
        if (linearGraph == null) {
            LinearGraphUtils.$$$reportNull$$$0(13);
        }
        if (selectedNodeIndexes == null) {
            LinearGraphUtils.$$$reportNull$$$0(14);
        }
        HashSet selectedIds = ContainerUtil.newHashSet();
        for (Integer nodeIndex : selectedNodeIndexes) {
            if (nodeIndex == null) continue;
            selectedIds.add(linearGraph.getNodeId(nodeIndex));
        }
        return new LinearGraphController.LinearGraphAnswer(LinearGraphUtils.getCursor(true), selectedIds);
    }

    @Nullable
    public static GraphEdge getEdge(@NotNull LinearGraph graph2, int up, int down) {
        if (graph2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(15);
        }
        List<GraphEdge> edges = graph2.getAdjacentEdges(up, EdgeFilter.NORMAL_DOWN);
        for (GraphEdge edge : edges) {
            if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), down)) continue;
            return edge;
        }
        return null;
    }

    @NotNull
    public static Set<Integer> convertNodeIndexesToIds(@NotNull LinearGraph graph2, @NotNull Collection<Integer> nodeIndexes) {
        if (graph2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(16);
        }
        if (nodeIndexes == null) {
            LinearGraphUtils.$$$reportNull$$$0(17);
        }
        Set set = ContainerUtil.map2Set(nodeIndexes, nodeIndex -> graph2.getNodeId((int)nodeIndex));
        if (set == null) {
            LinearGraphUtils.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    public static Set<Integer> convertIdsToNodeIndexes(@NotNull LinearGraph graph2, @NotNull Collection<Integer> ids) {
        if (graph2 == null) {
            LinearGraphUtils.$$$reportNull$$$0(19);
        }
        if (ids == null) {
            LinearGraphUtils.$$$reportNull$$$0(20);
        }
        List result2 = ContainerUtil.mapNotNull(ids, id -> graph2.getNodeIndex((int)id));
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)result2);
        if (hashSet == null) {
            LinearGraphUtils.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/utils/LinearGraphUtils";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodeIndexes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeIndexes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/utils/LinearGraphUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownNodes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownNodesIncludeNotLoad";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asLiteLinearGraph";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCursor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNodeIndexesToIds";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIdsToNodeIndexes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEdgeUp";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEdgeDown";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullNodeIndex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUpNodes";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDownNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDownNodesIncludeNotLoad";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "asLiteLinearGraph";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSelectedAnswer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEdge";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertNodeIndexesToIds";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertIdsToNodeIndexes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

