/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.google.common.primitives.Ints;
import com.intellij.util.ArrayUtil;
import com.intellij.vcs.log.graph.AbstractGraphCommit;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.IntGraphCommit;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphCommitImpl<CommitId>
extends AbstractGraphCommit<CommitId> {
    @NotNull
    private final CommitId myId;
    @NotNull
    private final Object myParents;

    private GraphCommitImpl(@NotNull CommitId id, @NotNull List<CommitId> parents, long timestamp) {
        if (id == null) {
            GraphCommitImpl.$$$reportNull$$$0(0);
        }
        if (parents == null) {
            GraphCommitImpl.$$$reportNull$$$0(1);
        }
        super(timestamp);
        this.myId = id;
        if (parents.isEmpty()) {
            this.myParents = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else if (parents.size() == 1) {
            this.myParents = parents.get(0);
            assert (!(this.myParents instanceof Object[]));
        } else {
            this.myParents = parents.toArray();
        }
    }

    @NotNull
    public CommitId getId() {
        CommitId CommitId2 = this.myId;
        if (CommitId2 == null) {
            GraphCommitImpl.$$$reportNull$$$0(2);
        }
        return CommitId2;
    }

    public CommitId get(int index) {
        if (this.myParents instanceof Object[]) {
            Object[] array = (Object[])this.myParents;
            if (index < 0 || index >= array.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return (CommitId)array[index];
        }
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (CommitId)this.myParents;
    }

    public int size() {
        return this.myParents instanceof Object[] ? ((Object[])this.myParents).length : 1;
    }

    @NotNull
    public static <CommitId> GraphCommit<CommitId> createCommit(@NotNull CommitId id, @NotNull List<CommitId> parents, long timestamp) {
        if (id == null) {
            GraphCommitImpl.$$$reportNull$$$0(3);
        }
        if (parents == null) {
            GraphCommitImpl.$$$reportNull$$$0(4);
        }
        if (id instanceof Integer) {
            GraphCommit<Integer> graphCommit = GraphCommitImpl.createIntCommit((Integer)id, parents, timestamp);
            if (graphCommit == null) {
                GraphCommitImpl.$$$reportNull$$$0(5);
            }
            return graphCommit;
        }
        GraphCommitImpl<Integer> graphCommitImpl = new GraphCommitImpl<Integer>((Integer)id, parents, timestamp);
        if (graphCommitImpl == null) {
            GraphCommitImpl.$$$reportNull$$$0(6);
        }
        return graphCommitImpl;
    }

    @NotNull
    public static GraphCommit<Integer> createIntCommit(int id, @NotNull List<Integer> parents, long timestamp) {
        if (parents == null) {
            GraphCommitImpl.$$$reportNull$$$0(7);
        }
        if (parents.size() == 1) {
            IntGraphCommit.SingleParent singleParent = new IntGraphCommit.SingleParent(timestamp, id, parents.get(0));
            if (singleParent == null) {
                GraphCommitImpl.$$$reportNull$$$0(8);
            }
            return singleParent;
        }
        IntGraphCommit.MultiParent multiParent = new IntGraphCommit.MultiParent(timestamp, id, Ints.toArray(parents));
        if (multiParent == null) {
            GraphCommitImpl.$$$reportNull$$$0(9);
        }
        return multiParent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/GraphCommitImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/GraphCommitImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommit";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIntCommit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

