/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.psi.formatter.FormatterUtil;
import java.util.Collection;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    protected final Project myProject;
    private final CheckinProjectPanel myPanel;

    public ReformatBeforeCheckinHandler(Project project, CheckinProjectPanel panel2) {
        this.myProject = project;
        this.myPanel = panel2;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        return new BooleanCommitOption(this.myPanel, VcsBundle.message((String)"checkbox.checkin.options.reformat.code", (Object[])new Object[0]), true, (Function0<Boolean>)((Function0)() -> this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT), value -> {
            this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT = value;
        });
    }

    protected VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(@NotNull Runnable finishAction) {
        if (finishAction == null) {
            ReformatBeforeCheckinHandler.$$$reportNull$$$0(0);
        }
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        Collection files2 = this.myPanel.getVirtualFiles();
        Runnable performCheckoutAction = () -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            finishAction.run();
        };
        if (configuration.REFORMAT_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.myProject)) {
            new ReformatCodeProcessor(this.myProject, CheckinHandlerUtil.getPsiFiles(this.myProject, files2), FormatterUtil.REFORMAT_BEFORE_COMMIT_COMMAND_NAME, performCheckoutAction, true).run();
        } else {
            performCheckoutAction.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishAction", "com/intellij/openapi/vcs/checkin/ReformatBeforeCheckinHandler", "runCheckinHandlers"));
    }
}

