/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.DnDActivateOnHoldTargetContent;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.IgnoredSettingsAction;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewCommitPanel;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcsUtil.VcsImplUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewI,
ProjectComponent,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangesViewManager");
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final ChangesListView myView;
    private final VcsConfiguration myVcsConfiguration;
    private JPanel myProgressLabel;
    private final Alarm myRepaintAlarm;
    private boolean myDisposed;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangesViewContentManager myContentManager;
    @NotNull
    private State myState;
    private PreviewDiffSplitterComponent mySplitterComponent;
    @NotNull
    private final TreeSelectionListener myTsl;
    @NotNull
    private final PropertyChangeListener myGroupingChangeListener;
    private MyChangeViewContent myContent;
    private boolean myModelUpdateInProgress;
    private MyTreeExpander myTreeExpander;

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(0);
        }
        ChangesViewI changesViewI = (ChangesViewI)project.getComponent(ChangesViewI.class);
        if (changesViewI == null) {
            ChangesViewManager.$$$reportNull$$$0(1);
        }
        return changesViewI;
    }

    public ChangesViewManager(@NotNull Project project, @NotNull ChangesViewContentManager contentManager) {
        if (project == null) {
            ChangesViewManager.$$$reportNull$$$0(2);
        }
        if (contentManager == null) {
            ChangesViewManager.$$$reportNull$$$0(3);
        }
        this.myDisposed = false;
        this.myState = new State();
        this.myProject = project;
        this.myContentManager = contentManager;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myView = new ChangesListView(project, VcsImplUtil.isNonModalCommit());
        this.myTreeExpander = new MyTreeExpander();
        this.myView.setTreeExpander((TreeExpander)this.myTreeExpander);
        this.myRepaintAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        this.myTsl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (LOG.isDebugEnabled()) {
                    Object[] paths = ChangesViewManager.this.myView.getSelectionPaths();
                    String joinedPaths = paths != null ? StringUtil.join((Object[])paths, (Function)FunctionUtil.string(), (String)", ") : null;
                    String message = "selection changed. selected:  " + joinedPaths;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(message + " from: " + DebugUtil.currentStackTrace());
                    } else {
                        LOG.debug(message);
                    }
                }
                boolean fromModelRefresh = ChangesViewManager.this.myModelUpdateInProgress;
                ApplicationManager.getApplication().invokeLater(() -> ChangesViewManager.this.updatePreview(fromModelRefresh));
            }
        };
        this.myGroupingChangeListener = e -> {
            this.myState.groupingKeys = this.myView.getGroupingSupport().getGroupingKeys();
            this.refreshView();
        };
    }

    public void projectOpened() {
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this.myProject);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        JComponent panel2 = this.createChangeViewComponent();
        this.myContent = new MyChangeViewContent(panel2, "Local Changes", false);
        this.myContent.setHelpId("ideaInterface.changes");
        this.myContent.setCloseable(false);
        this.myContentManager.addContent(this.myContent);
        this.scheduleRefresh();
        this.myProject.getMessageBus().connect().subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, () -> ApplicationManager.getApplication().invokeLater(() -> this.refreshView(), ModalityState.NON_MODAL, this.myProject.getDisposed()));
        this.updatePreview(false);
    }

    public void projectClosed() {
        this.myView.removeTreeSelectionListener(this.myTsl);
        this.myView.removeGroupingChangeListener(this.myGroupingChangeListener);
        this.myDisposed = true;
        this.myRepaintAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewManager" == null) {
            ChangesViewManager.$$$reportNull$$$0(4);
        }
        return "ChangesViewManager";
    }

    private JComponent createChangeViewComponent() {
        final ActionToolbar changesToolbar = this.createChangesToolbar();
        UIUtil.addBorder((JComponent)changesToolbar.getComponent(), (Border)IdeBorderFactory.createBorder((Color)JBColor.border(), (int)4));
        BorderLayoutPanel changesPanel = JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView))).addToLeft((Component)changesToolbar.getComponent());
        BorderLayoutPanel contentPanel = new BorderLayoutPanel(){

            public Dimension getMinimumSize() {
                return this.isMinimumSizeSet() ? super.getMinimumSize() : changesToolbar.getComponent().getPreferredSize();
            }
        };
        contentPanel.addToCenter((Component)changesPanel);
        if (VcsImplUtil.isNonModalCommit()) {
            contentPanel.addToBottom((Component)((Object)new ChangesViewCommitPanel(this.myProject)));
        }
        MyChangeProcessor changeProcessor = new MyChangeProcessor(this.myProject);
        this.mySplitterComponent = new PreviewDiffSplitterComponent((JComponent)contentPanel, changeProcessor, CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION, this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
        this.myView.installPopupHandler((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
        this.myView.getGroupingSupport().setGroupingKeysOrSkip(this.myState.groupingKeys);
        ChangesDnDSupport.install(this.myProject, this.myView);
        this.myView.addTreeSelectionListener(this.myTsl);
        this.myView.addGroupingChangeListener(this.myGroupingChangeListener);
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true){

            @NotNull
            public List<AnAction> getActions(boolean originalProvider) {
                List list2 = changesToolbar.getActions();
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager$3", "getActions"));
            }
        };
        this.myProgressLabel = JBUI.Panels.simplePanel();
        panel2.setContent((JComponent)JBUI.Panels.simplePanel((Component)((Object)this.mySplitterComponent)).addToBottom((Component)this.myProgressLabel));
        ChangesViewManager.registerShortcuts((JComponent)panel2);
        return panel2;
    }

    private static void registerShortcuts(@NotNull JComponent component) {
        if (component == null) {
            ChangesViewManager.$$$reportNull$$$0(5);
        }
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Refresh", (ShortcutSet)CommonShortcuts.getRerun(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.NewChangeList", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.RemoveChangeList", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.SetDefault", (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(85, 0x200 | ChangesViewManager.ctrlMask())), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"Diff.ShowDiff", (ShortcutSet)CommonShortcuts.getDiff(), (JComponent)component);
    }

    @NotNull
    private ActionToolbar createChangesToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(CustomActionsSchema.getInstance().getCorrectedAction("ChangesViewToolbar"));
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        DefaultActionGroup ignoreGroup = new DefaultActionGroup("Ignored Files", true);
        ignoreGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
        ignoreGroup.add((AnAction)new ToggleShowIgnoredAction());
        ignoreGroup.add((AnAction)new IgnoredSettingsAction());
        group.add((AnAction)ignoreGroup);
        group.add(CommonActionsManager.getInstance().createExpandAllHeaderAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this.myView)));
        group.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this.myView)));
        group.addSeparator();
        group.add((AnAction)new ToggleDetailsAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)group, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myView));
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            ChangesViewManager.$$$reportNull$$$0(6);
        }
        return actionToolbar;
    }

    @JdkConstants.InputEventMask
    private static int ctrlMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    private void updateProgressComponent(@NotNull Factory<JComponent> progress) {
        if (progress == null) {
            ChangesViewManager.$$$reportNull$$$0(7);
        }
        SwingUtilities.invokeLater(() -> {
            if (this.myProgressLabel != null) {
                this.myProgressLabel.removeAll();
                this.myProgressLabel.add((Component)progress.create());
                this.myProgressLabel.setMinimumSize((Dimension)JBUI.emptySize());
            }
        });
    }

    @Override
    public void updateProgressText(String text, boolean isError) {
        this.updateProgressComponent(ChangesViewManager.createTextStatusFactory(text, isError));
    }

    @Override
    public void setBusy(boolean b) {
        UIUtil.invokeLaterIfNeeded(() -> this.myView.setPaintBusy(b));
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(String text, boolean isError) {
        Factory factory = () -> {
            JLabel label2 = new JLabel(text);
            label2.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label2;
        };
        if (factory == null) {
            ChangesViewManager.$$$reportNull$$$0(8);
        }
        return factory;
    }

    @Override
    public void scheduleRefresh() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        int was = this.myRepaintAlarm.cancelAllRequests();
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule refresh, was " + was);
        }
        if (!this.myRepaintAlarm.isDisposed()) {
            this.myRepaintAlarm.addRequest(() -> this.refreshView(), 100, ModalityState.NON_MODAL);
        }
    }

    public void refreshImmediately() {
        this.myRepaintAlarm.cancelAllRequests();
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            return;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        TreeModelBuilder treeModelBuilder = new TreeModelBuilder(this.myProject, this.myView.getGrouping()).setChangeLists(changeListManager.getChangeListsCopy(), Registry.is((String)"vcs.skip.single.default.changelist")).setLocallyDeletedPaths(changeListManager.getDeletedFiles()).setModifiedWithoutEditing(changeListManager.getModifiedWithoutEditing()).setSwitchedFiles(changeListManager.getSwitchedFilesMap()).setSwitchedRoots(changeListManager.getSwitchedRoots()).setLockedFolders(changeListManager.getLockedFolders()).setLogicallyLockedFiles(changeListManager.getLogicallyLockedFolders()).setUnversioned(changeListManager.getUnversionedFiles());
        if (this.myState.myShowIgnored) {
            treeModelBuilder.setIgnored(changeListManager.getIgnoredFiles(), changeListManager.isIgnoredInUpdateMode());
        }
        DefaultTreeModel newModel = treeModelBuilder.build();
        this.myModelUpdateInProgress = true;
        try {
            this.myView.updateModel(newModel);
        }
        finally {
            this.myModelUpdateInProgress = false;
        }
        this.updatePreview(true);
    }

    private void updatePreview(boolean fromModelRefresh) {
        if (this.mySplitterComponent != null) {
            this.mySplitterComponent.updatePreview(fromModelRefresh);
        }
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(9);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(10);
        }
        this.myState = state;
        this.migrateShowFlattenSetting();
    }

    private void migrateShowFlattenSetting() {
        if (!this.myState.myShowFlatten) {
            this.myState.groupingKeys = ContainerUtil.set((Object[])ChangesTree.DEFAULT_GROUPING_KEYS);
            this.myState.myShowFlatten = true;
        }
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        if (groupingKey == null) {
            ChangesViewManager.$$$reportNull$$$0(11);
        }
        this.myView.getGroupingSupport().setGroupingKeysOrSkip(ContainerUtil.set((Object[])new String[]{groupingKey}));
    }

    @Override
    public void selectFile(@Nullable VirtualFile vFile) {
        if (vFile == null) {
            return;
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
        Change objectToFind = change != null ? change : vFile;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
        }
    }

    @Override
    public void selectChanges(@NotNull List<Change> changes2) {
        if (changes2 == null) {
            ChangesViewManager.$$$reportNull$$$0(12);
        }
        ArrayList paths = new ArrayList();
        for (Change change : changes2) {
            ContainerUtil.addIfNotNull(paths, (Object)this.myView.findNodePathInTree(change));
        }
        TreeUtil.selectPaths((JTree)((Object)this.myView), paths);
    }

    @Override
    public void refreshChangesViewNodeAsync(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangesViewManager.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.refreshChangesViewNode(file2), this.myProject.getDisposed());
    }

    private void refreshChangesViewNode(@NotNull VirtualFile file2) {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode node;
        ChangeListManager changeListManager;
        VirtualFile userObject;
        if (file2 == null) {
            ChangesViewManager.$$$reportNull$$$0(14);
        }
        Object object = userObject = (changeListManager = ChangeListManager.getInstance((Project)this.myProject)).isUnversioned(file2) ? file2 : changeListManager.getChange(file2);
        if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)this.myView.getModel().getRoot()), (Object)userObject)) != null) {
            this.myView.getModel().nodeChanged(node);
        }
    }

    @Nullable
    public static ChangesBrowserNode getDropRootNode(@NotNull Tree tree, @NotNull DnDEvent event) {
        if (tree == null) {
            ChangesViewManager.$$$reportNull$$$0(15);
        }
        if (event == null) {
            ChangesViewManager.$$$reportNull$$$0(16);
        }
        RelativePoint dropPoint = event.getRelativePoint();
        Point onTree = dropPoint.getPoint((Component)tree);
        TreePath dropPath = tree.getPathForLocation(onTree.x, onTree.y);
        if (dropPath == null) {
            return null;
        }
        TreeNode dropNode = (ChangesBrowserNode)dropPath.getLastPathComponent();
        while (!((DefaultMutableTreeNode)dropNode.getParent()).isRoot()) {
            dropNode = dropNode.getParent();
        }
        return dropNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingKey";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangesToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextStatusFactory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerShortcuts";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateProgressComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectChanges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refreshChangesViewNodeAsync";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refreshChangesViewNode";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDropRootNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeViewContent
    extends DnDActivateOnHoldTargetContent {
        private MyChangeViewContent(@NotNull JComponent component, String displayName, boolean isLockable) {
            if (displayName == null) {
                MyChangeViewContent.$$$reportNull$$$0(0);
            }
            super(ChangesViewManager.this.myProject, component, displayName, isLockable);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelveChangesManager.unshelveSilentlyWithDnd(ChangesViewManager.this.myProject, (ShelvedChangeListDragBean)attachedObject, ChangesViewManager.getDropRootNode(ChangesViewManager.this.myView, event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyChangeViewContent.$$$reportNull$$$0(1);
            }
            if ((attachedObject = event.getAttachedObject()) instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeViewContent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyChangeProcessor
    extends ChangeViewDiffRequestProcessor {
        MyChangeProcessor(Project project) {
            if (project == null) {
                MyChangeProcessor.$$$reportNull$$$0(0);
            }
            super(project, "ChangesView");
            Disposer.register((Disposable)project, (Disposable)this);
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
            boolean hasSelection;
            boolean bl = hasSelection = ChangesViewManager.this.myView.getSelectionCount() != 0;
            if (hasSelection) {
                List<ChangeViewDiffRequestProcessor.Wrapper> list2 = this.wrap(ChangesViewManager.this.myView.getSelectedChanges(), ChangesViewManager.this.myView.getSelectedUnversionedFiles());
                if (list2 == null) {
                    MyChangeProcessor.$$$reportNull$$$0(1);
                }
                return list2;
            }
            List<ChangeViewDiffRequestProcessor.Wrapper> list3 = this.getAllChanges();
            if (list3 == null) {
                MyChangeProcessor.$$$reportNull$$$0(2);
            }
            return list3;
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
            List<ChangeViewDiffRequestProcessor.Wrapper> list2 = this.wrap(ChangesViewManager.this.myView.getChanges(), ChangesViewManager.this.myView.getUnversionedFiles());
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            TreePath path;
            if (change == null) {
                MyChangeProcessor.$$$reportNull$$$0(4);
            }
            if ((path = ChangesViewManager.this.myView.findNodePathInTree(change.getUserObject())) != null) {
                TreeUtil.selectPath((JTree)((Object)ChangesViewManager.this.myView), (TreePath)path, (boolean)false);
            }
        }

        @NotNull
        private List<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull Stream<Change> changes2, @NotNull Stream<VirtualFile> unversioned) {
            if (changes2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(5);
            }
            if (unversioned == null) {
                MyChangeProcessor.$$$reportNull$$$0(6);
            }
            List<ChangeViewDiffRequestProcessor.Wrapper> list2 = Stream.concat(changes2.map(ChangeViewDiffRequestProcessor.ChangeWrapper::new), unversioned.map(ChangeViewDiffRequestProcessor.UnversionedFileWrapper::new)).collect(Collectors.toList());
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(7);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unversioned";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllChanges";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChange";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ToggleDetailsAction
    extends ShowDiffPreviewAction {
        private ToggleDetailsAction() {
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleDetailsAction.$$$reportNull$$$0(0);
            }
            ChangesViewManager.this.mySplitterComponent.setDetailsOn(state);
            ((ChangesViewManager)ChangesViewManager.this).myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN = state;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleDetailsAction.$$$reportNull$$$0(1);
            }
            return ((ChangesViewManager)ChangesViewManager.this).myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ToggleDetailsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ToggleShowIgnoredAction
    extends ToggleAction
    implements DumbAware {
        ToggleShowIgnoredAction() {
            super(VcsBundle.message((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleShowIgnoredAction.$$$reportNull$$$0(0);
            }
            return ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleShowIgnoredAction.$$$reportNull$$$0(1);
            }
            ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored = state;
            ChangesViewManager.this.refreshView();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ToggleShowIgnoredAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTreeExpander
    extends DefaultTreeExpander {
        MyTreeExpander() {
            super((JTree)((Object)ChangesViewManager.this.myView));
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)ChangesViewManager.this.myView), (int)2);
            TreeUtil.expand((JTree)((Object)ChangesViewManager.this.myView), (int)1);
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListsChanged() {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListUpdateDone() {
            ChangesViewManager.this.scheduleRefresh();
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewManager.this.myProject);
            VcsException updateException = changeListManager.getUpdateException();
            ChangesViewManager.this.setBusy(false);
            if (updateException == null) {
                Factory<JComponent> additionalUpdateInfo = changeListManager.getAdditionalUpdateInfo();
                if (additionalUpdateInfo != null) {
                    ChangesViewManager.this.updateProgressComponent((Factory<JComponent>)additionalUpdateInfo);
                } else {
                    ChangesViewManager.this.updateProgressText("", false);
                }
            } else {
                ChangesViewManager.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
            }
        }
    }

    public static class State {
        @Deprecated
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @XCollection
        public Set<String> groupingKeys = ContainerUtil.newHashSet();
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }
}

