/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDownloader {
    private static final Logger LOG = Logger.getInstance(PluginDownloader.class);
    private static final String FILENAME = "filename=";
    private final String myPluginId;
    private final String myPluginName;
    @Nullable
    private final String myProductCode;
    private final Date myReleaseDate;
    private final int myReleaseVersion;
    private final String myDescription;
    private final List<PluginId> myDepends;
    private final String myPluginUrl;
    private final BuildNumber myBuildNumber;
    private final boolean myForceHttps;
    private String myPluginVersion;
    private IdeaPluginDescriptor myDescriptor;
    private File myFile;
    private File myOldFile;

    private PluginDownloader(IdeaPluginDescriptor descriptor, String url, BuildNumber buildNumber, boolean forceHttps) {
        this.myPluginId = descriptor.getPluginId().getIdString();
        this.myPluginName = descriptor.getName();
        this.myProductCode = descriptor.getProductCode();
        this.myReleaseDate = descriptor.getReleaseDate();
        this.myReleaseVersion = descriptor.getReleaseVersion();
        this.myDescription = descriptor.getDescription();
        this.myDepends = descriptor instanceof PluginNode ? ((PluginNode)descriptor).getDepends() : Arrays.asList(descriptor.getDependentPluginIds());
        this.myPluginUrl = url;
        this.myBuildNumber = buildNumber;
        this.myForceHttps = forceHttps;
        this.myPluginVersion = descriptor.getVersion();
        this.myDescriptor = descriptor;
    }

    @NotNull
    public String getPluginId() {
        String string = this.myPluginId;
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    @NotNull
    public String getPluginName() {
        String string = this.myPluginName != null ? this.myPluginName : this.myPluginId;
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    @Nullable
    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    @NotNull
    public IdeaPluginDescriptor getDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myDescriptor;
        if (ideaPluginDescriptor == null) {
            PluginDownloader.$$$reportNull$$$0(2);
        }
        return ideaPluginDescriptor;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            PluginDownloader.$$$reportNull$$$0(3);
        }
        if (this.myFile != null) {
            return true;
        }
        IdeaPluginDescriptor descriptor = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManager.isPluginInstalled(PluginId.getId((String)this.myPluginId))) {
            descriptor = PluginManager.getPlugin(PluginId.getId((String)this.myPluginId));
            LOG.assertTrue(descriptor != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myOldFile = descriptor.isBundled() ? null : descriptor.getPath();
        }
        String errorMessage = null;
        try {
            this.myFile = this.downloadPlugin(indicator);
        }
        catch (IOException ex) {
            this.myFile = null;
            LOG.warn((Throwable)ex);
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                if (errorMessage == null) {
                    errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
                }
                String text = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                String title = IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]);
                app.invokeLater(() -> Messages.showErrorDialog((String)text, (String)title));
            }
            return false;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginDownloader.loadDescriptionFromJar(this.myFile);
        if (actualDescriptor != null) {
            InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
            if (state != null && state.wasUpdated(actualDescriptor.getPluginId())) {
                return false;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myDescriptor = actualDescriptor;
            if (PluginManagerCore.isIncompatible(actualDescriptor, this.myBuildNumber)) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation (since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
                return false;
            }
        }
        return true;
    }

    public static int compareVersionsSkipBrokenAndIncompatible(@NotNull IdeaPluginDescriptor existingPlugin, String newPluginVersion) {
        int state;
        if (existingPlugin == null) {
            PluginDownloader.$$$reportNull$$$0(4);
        }
        if ((state = PluginDownloader.comparePluginVersions(newPluginVersion, existingPlugin.getVersion())) < 0 && (PluginManagerCore.isBrokenPlugin(existingPlugin) || PluginManagerCore.isIncompatible(existingPlugin))) {
            state = 1;
        }
        return state;
    }

    public static int comparePluginVersions(String newPluginVersion, String oldPluginVersion) {
        return VersionComparatorUtil.compare((String)newPluginVersion, (String)oldPluginVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptionFromJar(File file2) throws IOException {
        IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file2, "plugin.xml");
        if (descriptor == null && file2.getName().endsWith(".zip")) {
            File outputDir = FileUtil.createTempDirectory((String)"plugin", (String)"");
            try {
                ZipUtil.extract((File)file2, (File)outputDir, null);
                File[] files2 = outputDir.listFiles();
                if (files2 != null && files2.length == 1) {
                    descriptor = PluginManagerCore.loadDescriptor(files2[0], "plugin.xml");
                }
            }
            finally {
                FileUtil.delete((File)outputDir);
            }
        }
        return descriptor;
    }

    public void install() throws IOException {
        if (this.myFile == null) {
            throw new IOException("Plugin '" + this.getPluginName() + "' was not successfully downloaded");
        }
        PluginInstaller.install(this.myFile, true, this.myOldFile, this.myDescriptor);
        InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
        if (state != null) {
            state.onPluginInstall(this.myDescriptor);
        }
    }

    @NotNull
    private File downloadPlugin(@NotNull ProgressIndicator indicator) throws IOException {
        File pluginsTemp;
        if (indicator == null) {
            PluginDownloader.$$$reportNull$$$0(5);
        }
        if (!(pluginsTemp = new File(PathManager.getPluginTempPath())).exists() && !pluginsTemp.mkdirs()) {
            throw new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
        }
        indicator.checkCanceled();
        indicator.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        File file2 = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
        File file3 = (File)HttpRequests.request((String)this.myPluginUrl).gzip(false).forceHttps(this.myForceHttps).productNameAsUserAgent().connect(request -> {
            request.saveToFile(file2, indicator);
            String fileName = this.guessFileName(request.getConnection(), file2);
            File newFile = new File(file2.getParentFile(), fileName);
            FileUtil.rename((File)file2, (File)newFile);
            return newFile;
        });
        if (file3 == null) {
            PluginDownloader.$$$reportNull$$$0(6);
        }
        return file3;
    }

    @NotNull
    private String guessFileName(@NotNull URLConnection connection, @NotNull File file2) throws IOException {
        if (connection == null) {
            PluginDownloader.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            PluginDownloader.$$$reportNull$$$0(8);
        }
        String fileName = null;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && contentDisposition.contains(FILENAME)) {
            int startIdx = contentDisposition.indexOf(FILENAME);
            int endIdx = contentDisposition.indexOf(59, startIdx);
            fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
        }
        if (fileName == null) {
            String usedURL = connection.getURL().toString();
            LOG.debug("url: " + usedURL);
            fileName = usedURL.substring(usedURL.lastIndexOf(47) + 1);
            if (fileName.length() == 0 || fileName.contains("?")) {
                fileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf(47) + 1);
            }
        }
        if (!PathUtil.isValidFileName(fileName)) {
            LOG.debug("fileName: " + fileName);
            FileUtil.delete((File)file2);
            throw new IOException("Invalid filename returned by a server");
        }
        String string = fileName;
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor) throws IOException {
        if (descriptor == null) {
            PluginDownloader.$$$reportNull$$$0(10);
        }
        return PluginDownloader.createDownloader(descriptor, null, null);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        if (descriptor == null) {
            PluginDownloader.$$$reportNull$$$0(11);
        }
        boolean forceHttps = host == null && (ApplicationManager.getApplication() == null || UpdateSettings.getInstance().canUseSecureConnection());
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader(descriptor, host, buildNumber, forceHttps);
        if (pluginDownloader == null) {
            PluginDownloader.$$$reportNull$$$0(12);
        }
        return pluginDownloader;
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor, @Nullable String host, @Nullable BuildNumber buildNumber, boolean forceHttps) throws IOException {
        String url;
        if (descriptor == null) {
            PluginDownloader.$$$reportNull$$$0(13);
        }
        try {
            if (host != null && descriptor instanceof PluginNode) {
                url = ((PluginNode)descriptor).getDownloadUrl();
                if (!new URI(url).isAbsolute()) {
                    url = new URL(new URL(host), url).toExternalForm();
                }
            } else {
                Application app = ApplicationManager.getApplication();
                ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
                String buildNumberAsString = buildNumber != null ? buildNumber.asString() : (app != null ? ApplicationInfo.getInstance().getApiVersion() : appInfo.getBuild().asString());
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("action", "download");
                parameters.put("id", descriptor.getPluginId().getIdString());
                parameters.put("build", buildNumberAsString);
                parameters.put("uuid", PermanentInstallationID.get());
                url = Urls.newFromEncoded(appInfo.getPluginsDownloadUrl()).addParameters(parameters).toExternalForm();
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        PluginDownloader pluginDownloader = new PluginDownloader(descriptor, url, buildNumber, forceHttps);
        if (pluginDownloader == null) {
            PluginDownloader.$$$reportNull$$$0(14);
        }
        return pluginDownloader;
    }

    @NotNull
    public static PluginNode createPluginNode(@Nullable String host, @NotNull PluginDownloader downloader) {
        IdeaPluginDescriptor descriptor;
        if (downloader == null) {
            PluginDownloader.$$$reportNull$$$0(15);
        }
        if ((descriptor = downloader.getDescriptor()) instanceof PluginNode) {
            PluginNode pluginNode = (PluginNode)descriptor;
            if (pluginNode == null) {
                PluginDownloader.$$$reportNull$$$0(16);
            }
            return pluginNode;
        }
        PluginNode node = new PluginNode(PluginId.getId((String)downloader.getPluginId()));
        node.setName(downloader.getPluginName());
        node.setProductCode(downloader.getProductCode());
        node.setReleaseDate(downloader.getReleaseDate());
        node.setReleaseVersion(downloader.getReleaseVersion());
        node.setVersion(downloader.getPluginVersion());
        node.setRepositoryName(host);
        node.setDownloadUrl(downloader.myPluginUrl);
        node.setDepends(downloader.myDepends, null);
        node.setDescription(downloader.myDescription);
        PluginNode pluginNode = node;
        if (pluginNode == null) {
            PluginDownloader.$$$reportNull$$$0(17);
        }
        return pluginNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingPlugin";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadPlugin";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFileName";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDownloader";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareVersionsSkipBrokenAndIncompatible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "downloadPlugin";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "guessFileName";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDownloader";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createPluginNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

