/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.NewRunConfigurationPopup;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.startup.ProjectStartupRunner;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.execution.startup.ProjectStartupTasksTableModel;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStartupConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JBTable myTable;
    private ToolbarDecorator myDecorator;
    private ProjectStartupTasksTableModel myModel;

    public ProjectStartupConfigurable(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        if ("preferences.startup.tasks" == null) {
            ProjectStartupConfigurable.$$$reportNull$$$0(0);
        }
        return "preferences.startup.tasks";
    }

    @Nls
    public String getDisplayName() {
        return "Startup Tasks";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.startup.tasks";
    }

    @Nullable
    public JComponent createComponent() {
        this.myModel = new ProjectStartupTasksTableModel();
        this.myTable = new JBTable((TableModel)this.myModel);
        this.myTable.getEmptyText().setText("Add run configurations with the + button");
        new TableSpeedSearch((JTable)this.myTable);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        DumbAwareAction.create(e -> {
            int row2 = this.myTable.getSelectedRow();
            if (row2 >= 0 && this.myModel.isCellEditable(row2, 1)) {
                this.myModel.setValueAt(!Boolean.TRUE.equals(this.myTable.getValueAt(row2, 1)), row2, 1);
            }
        }).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{32}), (JComponent)this.myTable);
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ProjectStartupConfigurable.this.editRunConfiguration();
                }
            }
        });
        this.installRenderers();
        this.myDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ProjectStartupConfigurable.this.selectAndAddConfiguration(button);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ProjectStartupConfigurable.this.editRunConfiguration();
            }
        }).setEditActionUpdater(e -> this.myTable.getSelectedRow() >= 0).disableUpAction().disableDownAction();
        JPanel tasksPanel = this.myDecorator.createPanel();
        JLabel label2 = new JLabel("Run tasks and tools via run configurations");
        label2.setForeground(UIUtil.getInactiveTextColor());
        label2.setHorizontalAlignment(4);
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)new JLabel("To be started on project opening:"), "West");
        wrapper2.add((Component)label2, "East");
        wrapper2.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)wrapper2, "North");
        main.add((Component)tasksPanel, "Center");
        return main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editRunConfiguration() {
        int row2 = this.myTable.getSelectedRow();
        if (row2 < 0) {
            return;
        }
        RunnerAndConfigurationSettings selected = this.myModel.getAllConfigurations().get(row2);
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        RunnerAndConfigurationSettings was = runManager.getSelectedConfiguration();
        try {
            runManager.setSelectedConfiguration(selected);
            new EditConfigurationsDialog(this.myProject).showAndGet();
        }
        finally {
            runManager.setSelectedConfiguration(was);
        }
        this.myModel.fireTableDataChanged();
        this.refreshDataUpdateSelection(selected);
    }

    private void refreshDataUpdateSelection(RunnerAndConfigurationSettings settings) {
        if (this.myTable.isEmpty()) {
            return;
        }
        this.myModel.reValidateConfigurations(new Processor<RunnerAndConfigurationSettings>(){
            private final RunManagerImpl runManager;
            {
                this.runManager = RunManagerImpl.getInstanceImpl(ProjectStartupConfigurable.this.myProject);
            }

            public boolean process(RunnerAndConfigurationSettings settings) {
                return this.runManager.getConfigurationById(settings.getUniqueID()) != null;
            }
        });
        if (settings != null) {
            List<RunnerAndConfigurationSettings> configurations = this.myModel.getAllConfigurations();
            for (int i = 0; i < configurations.size(); ++i) {
                RunnerAndConfigurationSettings configuration = configurations.get(i);
                if (configuration != settings) continue;
                TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
                return;
            }
        }
        TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{0});
        this.myTable.getSelectionModel().setLeadSelectionIndex(0);
    }

    private ChooseRunConfigurationPopup.ItemWrapper<Void> createNewWrapper(final AnActionButton button) {
        return new ChooseRunConfigurationPopup.ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return IconUtil.getAddIcon();
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic((String)ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]));
            }

            @Override
            public void perform(@NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (executor == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(2);
                }
                RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
                List typesToShow = ContainerUtil.filter((Collection)ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList(), configurationType -> {
                    ConfigurationFactory factory = runManager.getFactory((ConfigurationType)configurationType, null);
                    return factory != null && ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runManager.getConfigurationTemplate(factory).getConfiguration()) != null;
                });
                ListPopup popup2 = NewRunConfigurationPopup.createAddPopup(typesToShow, "", (Consumer<? super ConfigurationFactory>)((Consumer)factory -> ApplicationManager.getApplication().invokeLater(() -> {
                    EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(project, (ConfigurationFactory)factory);
                    if (dialog2.showAndGet()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                            if (configuration != null) {
                                ProjectStartupConfigurable.this.addConfiguration(configuration);
                            }
                        }, project.getDisposed());
                    }
                }, project.getDisposed())), null, null, false);
                ProjectStartupConfigurable.this.showPopup(button, (JBPopup)popup2);
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/startup/ProjectStartupConfigurable$5";
                objectArray[2] = "perform";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void addConfiguration(RunnerAndConfigurationSettings configuration) {
        if (!ProjectStartupRunner.canBeRun(configuration)) {
            String message = "Can not add Run Configuration '" + configuration.getName() + "' to Startup Tasks, since it can not be started with 'Run' action.";
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setHideOnClickOutside(true).setFadeoutTime(3000L).setCloseButtonEnabled(true).createBalloon();
            RelativePoint rp = new RelativePoint((Component)this.myDecorator.getActionsPanel(), new Point(5, 5));
            balloon.show(rp, Balloon.Position.atLeft);
            return;
        }
        this.myModel.addConfiguration(configuration);
        this.refreshDataUpdateSelection(configuration);
    }

    private void selectAndAddConfiguration(AnActionButton button) {
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ArrayList<ChooseRunConfigurationPopup.ItemWrapper> wrappers = new ArrayList<ChooseRunConfigurationPopup.ItemWrapper>();
        wrappers.add(this.createNewWrapper(button));
        ChooseRunConfigurationPopup.ItemWrapper[] allSettings = ChooseRunConfigurationPopup.createSettingsList(this.myProject, new ExecutorProvider(){

            @Override
            public Executor getExecutor() {
                return executor;
            }
        }, false);
        HashSet<RunnerAndConfigurationSettings> existing = new HashSet<RunnerAndConfigurationSettings>(this.myModel.getAllConfigurations());
        for (ChooseRunConfigurationPopup.ItemWrapper setting : allSettings) {
            RunnerAndConfigurationSettings settings;
            if (!(setting.getValue() instanceof RunnerAndConfigurationSettings) || (settings = (RunnerAndConfigurationSettings)setting.getValue()).isTemporary() || !ProjectStartupRunner.canBeRun(settings) || existing.contains(settings)) continue;
            wrappers.add(setting);
        }
        JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(wrappers).setRenderer((ListCellRenderer)new ColoredListCellRenderer<ChooseRunConfigurationPopup.ItemWrapper>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ChooseRunConfigurationPopup.ItemWrapper> list2, ChooseRunConfigurationPopup.ItemWrapper value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                this.setIcon(value.getIcon());
                this.append(value.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/startup/ProjectStartupConfigurable$7", "customizeCellRenderer"));
            }
        }).setItemChosenCallback(at -> {
            if (at.getValue() instanceof RunnerAndConfigurationSettings) {
                RunnerAndConfigurationSettings added = (RunnerAndConfigurationSettings)at.getValue();
                this.addConfiguration(added);
            } else {
                at.perform(this.myProject, executor, button.getDataContext());
            }
        }).createPopup();
        this.showPopup(button, popup2);
    }

    private void showPopup(AnActionButton button, JBPopup popup2) {
        RelativePoint point = button.getPreferredPopupPoint();
        if (point != null) {
            popup2.show(point);
        } else {
            popup2.showInCenterOf((Component)this.myDecorator.getActionsPanel());
        }
    }

    public boolean isModified() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        HashSet<RunnerAndConfigurationSettings> shared = new HashSet<RunnerAndConfigurationSettings>(projectStartupTaskManager.getSharedConfigurations());
        ArrayList<RunnerAndConfigurationSettings> list2 = new ArrayList<RunnerAndConfigurationSettings>(shared);
        list2.addAll(projectStartupTaskManager.getLocalConfigurations());
        Collections.sort(list2, ProjectStartupTasksTableModel.RunnerAndConfigurationSettingsComparator.getInstance());
        if (!Comparing.equal(list2, this.myModel.getAllConfigurations())) {
            return true;
        }
        return !Comparing.equal(shared, this.myModel.getSharedConfigurations());
    }

    public void apply() throws ConfigurationException {
        ArrayList<RunnerAndConfigurationSettings> shared = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> local = new ArrayList<RunnerAndConfigurationSettings>();
        Set<RunnerAndConfigurationSettings> sharedSet = this.myModel.getSharedConfigurations();
        List<RunnerAndConfigurationSettings> allConfigurations = this.myModel.getAllConfigurations();
        for (RunnerAndConfigurationSettings configuration : allConfigurations) {
            if (sharedSet.contains(configuration)) {
                shared.add(configuration);
                continue;
            }
            local.add(configuration);
        }
        ProjectStartupTaskManager.getInstance(this.myProject).setStartupConfigurations(shared, local);
    }

    public void reset() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        this.myModel.setData(projectStartupTaskManager.getSharedConfigurations(), projectStartupTaskManager.getLocalConfigurations());
        this.refreshDataUpdateSelection(null);
    }

    private void installRenderers() {
        TableColumn checkboxColumn = this.myTable.getColumnModel().getColumn(1);
        String header = checkboxColumn.getHeaderValue().toString();
        FontMetrics fm = this.myTable.getFontMetrics(this.myTable.getTableHeader().getFont());
        int width = -new JBCheckBox().getPreferredSize().width + fm.stringWidth(header + "ww");
        TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn, (int)width);
        checkboxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.myTable.getTableHeader().setResizingAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        nameColumn.setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row2, int column) {
                RunnerAndConfigurationSettings settings = ProjectStartupConfigurable.this.myModel.getAllConfigurations().get(row2);
                this.setIcon(settings.getConfiguration().getIcon());
                this.append(settings.getName());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/startup/ProjectStartupConfigurable", "getId"));
    }
}

