/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx {
    private final TIntObjectHashMap<PassConfig> myRegisteredPassFactories = new TIntObjectHashMap();
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories = new ArrayList<DirtyScopeTrackingHighlightingPassFactory>();
    private int nextAvailableId = 13;
    private boolean checkedForCycles;
    private final Project myProject;

    public TextEditorHighlightingPassRegistrarImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory, @Nullable int[] runAfterCompletionOf, @Nullable int[] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        int n;
        if (factory == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(0);
        }
        assert (!this.checkedForCycles);
        PassConfig info = new PassConfig(factory, runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterCompletionOf, runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterOfStartingOf);
        if (forcedPassId == -1) {
            int n2 = this.nextAvailableId;
            n = n2;
            this.nextAvailableId = n2 + 1;
        } else {
            n = forcedPassId;
        }
        int passId = n;
        PassConfig registered = (PassConfig)this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered in: " + PassConfig.access$100(registered);
        this.myRegisteredPassFactories.put(passId, (Object)info);
        if (factory instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory);
        }
        return passId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiatePasses(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull int[] passesToIgnore) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (passesToIgnore == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(3);
        }
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            if (!this.checkedForCycles) {
                this.checkedForCycles = true;
                this.checkForCycles();
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = editor.getDocument();
        PsiFile fileFromDoc = documentManager.getPsiFile(document);
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == document) : "Documents are different. Doc: " + document + "; Doc from file: " + documentFromFile + "; File: " + psiFile + "; Virtual file: " + PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        }
        TIntObjectHashMap id2Pass = new TIntObjectHashMap();
        TIntArrayList passesRefusedToCreate = new TIntArrayList();
        boolean isDumb = DumbService.getInstance((Project)this.myProject).isDumb();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            TextEditorHighlightingPass pass;
            if (ArrayUtil.find((int[])passesToIgnore, (int)passId) != -1) {
                return true;
            }
            PassConfig passConfig = (PassConfig)this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            TextEditorHighlightingPass textEditorHighlightingPass = pass = isDumb && !DumbService.isDumbAware((Object)factory) ? null : factory.createHighlightingPass(psiFile, editor);
            if (pass == null || isDumb && !DumbService.isDumbAware((Object)pass)) {
                passesRefusedToCreate.add(passId);
            } else {
                pass.setColorsScheme(editor.getColorsScheme());
                TIntArrayList ids = new TIntArrayList(passConfig.completionPredecessorIds.length);
                for (int id : passConfig.completionPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id)) continue;
                    ids.add(id);
                }
                pass.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                ids = new TIntArrayList(passConfig.startingPredecessorIds.length);
                for (int id : passConfig.startingPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id)) continue;
                    ids.add(id);
                }
                pass.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                pass.setId(passId);
                id2Pass.put(passId, (Object)pass);
            }
            return true;
        });
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap statusMap = daemonCodeAnalyzer.getFileStatusMap();
        passesRefusedToCreate.forEach(passId -> {
            statusMap.markFileUpToDate(document, passId);
            return true;
        });
        List<Object> list2 = Arrays.asList(id2Pass.getValues());
        if (list2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiateMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(5);
        }
        if (document == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (highlightInfoProcessor == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(7);
        }
        THashSet ids = new THashSet();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            TextEditorHighlightingPass pass;
            PassConfig passConfig = (PassConfig)this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            if (factory instanceof MainHighlightingPassFactory && (pass = ((MainHighlightingPassFactory)factory).createMainHighlightingPass(psiFile, document, highlightInfoProcessor)) != null) {
                ids.add((Object)pass);
                pass.setId(passId);
            }
            return true;
        });
        ArrayList<TextEditorHighlightingPass> arrayList = new ArrayList<TextEditorHighlightingPass>((Collection<TextEditorHighlightingPass>)ids);
        if (arrayList == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void checkForCycles() {
        TIntObjectHashMap transitivePredecessors = new TIntObjectHashMap();
        this.myRegisteredPassFactories.forEachEntry((passId, config2) -> {
            TIntHashSet allPredecessors = new TIntHashSet(((PassConfig)config2).completionPredecessorIds);
            allPredecessors.addAll(((PassConfig)config2).startingPredecessorIds);
            transitivePredecessors.put(passId, (Object)allPredecessors);
            allPredecessors.forEach(predecessorId -> {
                PassConfig predecessor = (PassConfig)this.myRegisteredPassFactories.get(predecessorId);
                if (predecessor == null) {
                    return true;
                }
                TIntHashSet transitives = (TIntHashSet)transitivePredecessors.get(predecessorId);
                if (transitives == null) {
                    transitives = new TIntHashSet();
                    transitivePredecessors.put(predecessorId, (Object)transitives);
                }
                transitives.addAll(predecessor.completionPredecessorIds);
                transitives.addAll(predecessor.startingPredecessorIds);
                return true;
            });
            return true;
        });
        transitivePredecessors.forEachKey(passId -> {
            if (((TIntHashSet)transitivePredecessors.get(passId)).contains(passId)) {
                throw new IllegalArgumentException("There is a cycle introduced involving pass " + ((PassConfig)this.myRegisteredPassFactories.get(passId)).passFactory);
            }
            return true;
        });
    }

    @Override
    @NotNull
    public List<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        List<DirtyScopeTrackingHighlightingPassFactory> list2 = this.myDirtyScopeTrackingFactories;
        if (list2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiatePasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateMainPasses";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeTrackingFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerTextEditorHighlightingPass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePasses";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instantiateMainPasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PassConfig {
        private final TextEditorHighlightingPassFactory passFactory;
        private final int[] startingPredecessorIds;
        private final int[] completionPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, @NotNull int[] completionPredecessorIds, @NotNull int[] startingPredecessorIds) {
            if (passFactory == null) {
                PassConfig.$$$reportNull$$$0(0);
            }
            if (completionPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(1);
            }
            if (startingPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(2);
            }
            this.completionPredecessorIds = completionPredecessorIds;
            this.startingPredecessorIds = startingPredecessorIds;
            this.passFactory = passFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "passFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completionPredecessorIds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startingPredecessorIds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

