/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomModelCache<T, H extends UserDataHolder> {
    private final Key<CachedValue<T>> myKey;
    private final Project myProject;

    public DomModelCache(Project project, @NonNls String keyName) {
        this.myProject = project;
        this.myKey = new Key(keyName);
    }

    @Nullable
    public T getCachedValue(@NotNull H dataHolder) {
        CachedValue cachedValue;
        if (dataHolder == null) {
            DomModelCache.$$$reportNull$$$0(0);
        }
        if ((cachedValue = (CachedValue)dataHolder.getUserData(this.myKey)) == null) {
            CachedValueProvider myProvider = () -> this.computeValue(dataHolder);
            CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myProject);
            cachedValue = manager.createCachedValue(myProvider, false);
            dataHolder.putUserData(this.myKey, (Object)cachedValue);
        }
        return (T)cachedValue.getValue();
    }

    @NotNull
    protected abstract CachedValueProvider.Result<T> computeValue(@NotNull H var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/util/xml/model/DomModelCache", "getCachedValue"));
    }
}

