/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeBaseClassQuickFix;
import com.jetbrains.python.inspections.quickfix.PyConvertToNewStyleQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyOldStyleClassesInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.oldstyle.class", new Object[0]);
        if (string == null) {
            PyOldStyleClassesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyOldStyleClassesInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyOldStyleClassesInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyOldStyleClassesInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyOldStyleClassesInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyOldStyleClassesInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(PyClass node) {
            List<PyClassLikeType> expressions = node.getSuperClassTypes(this.myTypeEvalContext);
            ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyConvertToNewStyleQuickFix()});
            if (!expressions.isEmpty()) {
                quickFixes.add(new PyChangeBaseClassQuickFix());
            }
            if (!node.isNewStyleClass(this.myTypeEvalContext)) {
                for (PyTargetExpression attr : node.getClassAttributes()) {
                    if (!"__slots__".equals(attr.getName())) continue;
                    this.registerProblem((PsiElement)attr, PyBundle.message("INSP.oldstyle.class.slots", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
                for (PyFunction attr : node.getMethods()) {
                    if (!"__getattribute__".equals(attr.getName())) continue;
                    ASTNode nameNode = attr.getNameNode();
                    assert (nameNode != null);
                    this.registerProblem(nameNode.getPsi(), PyBundle.message("INSP.oldstyle.class.getattribute", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyClass klass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            if (klass != null && !klass.isNewStyleClass(this.myTypeEvalContext)) {
                PyExpression callee;
                List<PyClassLikeType> types = klass.getSuperClassTypes(this.myTypeEvalContext);
                for (PyClassLikeType type : types) {
                    if (type == null) {
                        return;
                    }
                    String qName = type.getClassQName();
                    if (qName != null && qName.contains("PyQt")) {
                        return;
                    }
                    if (type instanceof PyClassType) continue;
                    return;
                }
                ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyConvertToNewStyleQuickFix()});
                if (!types.isEmpty()) {
                    quickFixes.add(new PyChangeBaseClassQuickFix());
                }
                if (PyUtil.isSuperCall(node) && (callee = node.getCallee()) != null) {
                    this.registerProblem((PsiElement)callee, PyBundle.message("INSP.oldstyle.class.super", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY)));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyOldStyleClassesInspection$Visitor", "<init>"));
        }
    }
}

