/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyNamedTupleInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "FieldsProcessor", "MaxBy", "Visitor", "intellij.python.community.impl"})
public final class PyNamedTupleInspection
extends PyInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new Visitor(holder, session);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "visitPyClass", "", "node", "Lcom/jetbrains/python/psi/PyClass;", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @Override
        public void visitPyClass(@Nullable PyClass node) {
            super.visitPyClass(node);
            if (node != null && LanguageLevel.forElement((PsiElement)node).isAtLeast(LanguageLevel.PYTHON36)) {
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyNamedTupleTypeProvider.Companion.isTypingNamedTupleDirectInheritor(node, typeEvalContext)) {
                    com.jetbrains.python.inspections.PyNamedTupleInspection$Companion.inspectFieldsOrder$default(Companion, node, (Function3)new Function3<PsiElement, String, ProblemHighlightType, Unit>(this){

                        public final void invoke(PsiElement p1, String p2, ProblemHighlightType p3) {
                            ((Visitor)((Object)this.receiver)).registerProblem(p1, p2, p3);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(Visitor.class);
                        }

                        public final String getName() {
                            return "registerProblem";
                        }

                        public final String getSignature() {
                            return "registerProblem(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/codeInspection/ProblemHighlightType;)V";
                        }
                    }, null, null, 12, null);
                }
            }
        }

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            super(holder, session);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection$FieldsProcessor;", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "filter", "Lkotlin/Function1;", "Lcom/jetbrains/python/psi/PyTargetExpression;", "", "hasAssignedValue", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "fieldsWithDefaultValue", "Ljava/util/TreeSet;", "getFieldsWithDefaultValue", "()Ljava/util/TreeSet;", "lastFieldWithoutDefaultValue", "getLastFieldWithoutDefaultValue", "()Lcom/jetbrains/python/psi/PyTargetExpression;", "lastFieldWithoutDefaultValueBox", "Lcom/jetbrains/python/inspections/PyNamedTupleInspection$MaxBy;", "execute", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "intellij.python.community.impl"})
    private static final class FieldsProcessor
    implements PsiScopeProcessor {
        @NotNull
        private final TreeSet<PyTargetExpression> fieldsWithDefaultValue;
        private final MaxBy<PyTargetExpression> lastFieldWithoutDefaultValueBox;
        private final Function1<PyTargetExpression, Boolean> filter;
        private final Function1<PyTargetExpression, Boolean> hasAssignedValue;

        @Nullable
        public final PyTargetExpression getLastFieldWithoutDefaultValue() {
            return this.lastFieldWithoutDefaultValueBox.getResult();
        }

        @NotNull
        public final TreeSet<PyTargetExpression> getFieldsWithDefaultValue() {
            return this.fieldsWithDefaultValue;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
            if (element instanceof PyTargetExpression && ((Boolean)this.filter.invoke((Object)element)).booleanValue()) {
                if (((Boolean)this.hasAssignedValue.invoke((Object)element)).booleanValue()) {
                    this.fieldsWithDefaultValue.add((PyTargetExpression)element);
                } else {
                    this.lastFieldWithoutDefaultValueBox.apply((PyTargetExpression)element);
                }
            }
            return true;
        }

        public FieldsProcessor(@NotNull Function1<? super PyTargetExpression, Boolean> filter, @NotNull Function1<? super PyTargetExpression, Boolean> hasAssignedValue) {
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Intrinsics.checkParameterIsNotNull(hasAssignedValue, (String)"hasAssignedValue");
            this.filter = filter;
            this.hasAssignedValue = hasAssignedValue;
            Comparator offsetComparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    PyTargetExpression p1 = (PyTargetExpression)a;
                    Comparable comparable = Integer.valueOf(p1.getTextOffset());
                    p1 = (PyTargetExpression)b;
                    Comparable comparable2 = comparable;
                    Integer n = p1.getTextOffset();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            this.lastFieldWithoutDefaultValueBox = new MaxBy(offsetComparator);
            this.fieldsWithDefaultValue = new TreeSet(offsetComparator);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u0004\u0018\u00018\u00002\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000@BX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection$MaxBy;", "T", "", "comparator", "Ljava/util/Comparator;", "(Ljava/util/Comparator;)V", "<set-?>", "result", "getResult", "()Ljava/lang/Object;", "setResult", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "apply", "", "t", "intellij.python.community.impl"})
    private static final class MaxBy<T> {
        @Nullable
        private T result;
        private final Comparator<T> comparator;

        @Nullable
        public final T getResult() {
            return this.result;
        }

        private final void setResult(T t) {
            this.result = t;
        }

        public final void apply(T t) {
            if (this.result == null || this.comparator.compare(this.result, t) < 0) {
                this.result = t;
            }
        }

        public MaxBy(@NotNull Comparator<T> comparator) {
            Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
            this.comparator = comparator;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JZ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rJH\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\n2\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/inspections/PyNamedTupleInspection$Companion;", "", "()V", "inspectFieldsOrder", "", "cls", "Lcom/jetbrains/python/psi/PyClass;", "callback", "Lkotlin/Function3;", "Lcom/intellij/psi/PsiElement;", "", "Lcom/intellij/codeInspection/ProblemHighlightType;", "filter", "Lkotlin/Function1;", "Lcom/jetbrains/python/psi/PyTargetExpression;", "", "hasAssignedValue", "registerErrorOnTargetsAboveBound", "bound", "targets", "Ljava/util/TreeSet;", "message", "intellij.python.community.impl"})
    public static final class Companion {
        public final void inspectFieldsOrder(@NotNull PyClass cls, @NotNull Function3<? super PsiElement, ? super String, ? super ProblemHighlightType, Unit> callback, @NotNull Function1<? super PyTargetExpression, Boolean> filter, @NotNull Function1<? super PyTargetExpression, Boolean> hasAssignedValue) {
            Intrinsics.checkParameterIsNotNull((Object)cls, (String)"cls");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Intrinsics.checkParameterIsNotNull(hasAssignedValue, (String)"hasAssignedValue");
            FieldsProcessor fieldsProcessor = new FieldsProcessor(filter, hasAssignedValue);
            cls.processClassLevelDeclarations(fieldsProcessor);
            this.registerErrorOnTargetsAboveBound(fieldsProcessor.getLastFieldWithoutDefaultValue(), fieldsProcessor.getFieldsWithDefaultValue(), "Fields with a default value must come after any fields without a default.", callback);
        }

        public static /* synthetic */ void inspectFieldsOrder$default(Companion companion, PyClass pyClass, Function3 function3, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = inspectFieldsOrder.1.INSTANCE;
            }
            if ((n & 8) != 0) {
                function12 = inspectFieldsOrder.2.INSTANCE;
            }
            companion.inspectFieldsOrder(pyClass, (Function3<? super PsiElement, ? super String, ? super ProblemHighlightType, Unit>)function3, (Function1<? super PyTargetExpression, Boolean>)function1, (Function1<? super PyTargetExpression, Boolean>)function12);
        }

        /*
         * WARNING - void declaration
         */
        private final void registerErrorOnTargetsAboveBound(PyTargetExpression bound, TreeSet<PyTargetExpression> targets, String message, Function3<? super PsiElement, ? super String, ? super ProblemHighlightType, Unit> callback) {
            if (bound != null) {
                void $receiver$iv;
                SortedSet<PyTargetExpression> sortedSet = targets.headSet(bound);
                Intrinsics.checkExpressionValueIsNotNull(sortedSet, (String)"targets\n          .headSet(bound)");
                Iterable iterable = sortedSet;
                for (Object element$iv : $receiver$iv) {
                    PyTargetExpression it;
                    PyTargetExpression pyTargetExpression = it = (PyTargetExpression)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pyTargetExpression, (String)"it");
                    callback.invoke((Object)pyTargetExpression, (Object)message, (Object)ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

