/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.inspections.PyCompatibilityInspection;
import com.jetbrains.python.inspections.PyCompatibilityInspectionAdvertiserSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCompatibilityInspectionAdvertiser
implements Annotator {
    private static final String NOTIFICATIONS_TITLE = "Python Versions Compatibility";
    private static final NotificationGroup BALLOON_NOTIFICATIONS = new NotificationGroup("Python Compatibility Inspection Advertiser", NotificationDisplayType.STICKY_BALLOON, false);
    private static final Key<Boolean> DONT_SHOW_BALLOON = Key.create((String)"showingPyCompatibilityAdvertiserBalloon");
    private static final boolean SHOW_ONCE_FOR_VERSION = true;
    @Language(value="HTML")
    private static final String YES_NO_REFS = "<a href=\"#yes\">Yes</a>&nbsp;&nbsp;<a href=\"#no\">No</a>";
    private static final String USING_FUTURE_IMPORTS = "Your source code contains __future__ imports";
    private static final String USING_SIX = "Your source code imports the 'six' package";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(1);
        }
        if (element instanceof PyFile) {
            PyFile pyFile = (PyFile)element;
            Project project = element.getProject();
            VirtualFile vFile = pyFile.getVirtualFile();
            if (vFile != null && FileIndexFacade.getInstance((Project)project).isInLibraryClasses(vFile)) {
                return;
            }
            Boolean showingFlag = (Boolean)project.getUserData(DONT_SHOW_BALLOON);
            if (showingFlag != null && showingFlag.booleanValue()) {
                return;
            }
            if (!PyCompatibilityInspectionAdvertiser.moduleUsesPythonSdk(pyFile)) {
                return;
            }
            int inspectionVersion = PyCompatibilityInspectionAdvertiser.getSettings((Project)project).version;
            if (inspectionVersion < 3) {
                if (PyCompatibilityInspectionAdvertiser.isCompatibilityInspectionEnabled(element)) {
                    LanguageLevel pyVersion = PyCompatibilityInspectionAdvertiser.getLatestConfiguredCompatiblePython3Version(element);
                    if (pyVersion != null && pyVersion.isOlderThan(LanguageLevel.getLatest())) {
                        PyCompatibilityInspectionAdvertiser.showStalePython3VersionWarning(pyFile, project, pyVersion);
                    }
                } else if (PyCompatibilityInspectionAdvertiser.containsFutureImports(pyFile)) {
                    PyCompatibilityInspectionAdvertiser.showInspectionAdvertisement(project, USING_FUTURE_IMPORTS);
                } else if (PyPsiUtils.containsImport(pyFile, "six")) {
                    PyCompatibilityInspectionAdvertiser.showInspectionAdvertisement(project, USING_SIX);
                }
            }
        }
    }

    private static boolean moduleUsesPythonSdk(@NotNull PyFile file) {
        Module module2;
        if (file == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(2);
        }
        if ((module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file.getVirtualFile(), (Project)file.getProject())) != null) {
            return PythonSdkType.findPythonSdk(module2) != null;
        }
        return false;
    }

    @Nullable
    private static LanguageLevel getLatestConfiguredCompatiblePython3Version(@NotNull PsiElement element) {
        LanguageLevel latestVersion;
        if (element == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(3);
        }
        return (latestVersion = PyCompatibilityInspectionAdvertiser.getLatestConfiguredCompatiblePythonVersion(element)) != null && !latestVersion.isPython2() ? latestVersion : null;
    }

    private static void showStalePython3VersionWarning(@NotNull PyFile file, @NotNull Project project, @NotNull LanguageLevel latestConfiguredVersion) {
        if (file == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(5);
        }
        if (latestConfiguredVersion == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(6);
        }
        List<LanguageLevel> versionsToEnable = PyCompatibilityInspectionAdvertiser.getVersionsNewerThan(latestConfiguredVersion);
        String versionsList = StringUtil.join(versionsToEnable, (String)",&nbsp;");
        String message = String.format("Code compatibility inspection is configured for Python versions up to %s.<br/>Would you like to enable it for Python %s?<br/><a href=\"#yes\">Yes</a>&nbsp;&nbsp;<a href=\"#no\">No</a>", new Object[]{latestConfiguredVersion, versionsList});
        PyCompatibilityInspectionAdvertiser.showSingletonNotification(project, NOTIFICATIONS_TITLE, message, NotificationType.INFORMATION, (notification2, event) -> {
            boolean enabled = "#yes".equals(event.getDescription());
            if (enabled) {
                PyCompatibilityInspectionAdvertiser.enableVersions(project, (PsiElement)file, versionsToEnable);
            }
            if (!enabled) {
                // empty if block
            }
            PyCompatibilityInspectionAdvertiser.getSettings((Project)project).version = 3;
        });
    }

    @NotNull
    private static List<LanguageLevel> getVersionsNewerThan(@NotNull LanguageLevel version) {
        if (version == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(7);
        }
        ArrayList<LanguageLevel> result = new ArrayList<LanguageLevel>();
        LanguageLevel latest = LanguageLevel.getLatest();
        for (LanguageLevel level : LanguageLevel.SUPPORTED_LEVELS) {
            if (!version.isOlderThan(level) || !latest.isAtLeast(level)) continue;
            result.add(level);
        }
        ArrayList<LanguageLevel> arrayList = result;
        if (arrayList == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void enableVersions(@NotNull Project project, @NotNull PsiElement file, @NotNull List<LanguageLevel> versions) {
        String shortName;
        InspectionProfileImpl profile;
        InspectionToolWrapper tool;
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(9);
        }
        if (file == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(10);
        }
        if (versions == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(11);
        }
        if ((tool = (profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile()).getInspectionTool(shortName = PyCompatibilityInspectionAdvertiser.getCompatibilityInspectionShortName(), project)) != null) {
            profile.modifyProfile(model -> {
                PyCompatibilityInspection inspection = (PyCompatibilityInspection)model.getUnwrappedTool(shortName, file);
                inspection.ourVersions.addAll((Collection)ContainerUtil.map((Collection)versions, LanguageLevel::toString));
            });
            EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)profile, (String)shortName);
        }
    }

    private static void showInspectionAdvertisement(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(12);
        }
        if (message == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(13);
        }
        String msg = message + ".<br/>Would you like to enable Code compatibility inspection?<br/>" + YES_NO_REFS;
        PyCompatibilityInspectionAdvertiser.showSingletonNotification(project, NOTIFICATIONS_TITLE, msg, NotificationType.INFORMATION, (notification2, event) -> {
            boolean enabled = "#yes".equals(event.getDescription());
            if (enabled) {
                PyCompatibilityInspectionAdvertiser.enableCompatibilityInspection(project);
            }
            if (!enabled) {
                // empty if block
            }
            PyCompatibilityInspectionAdvertiser.getSettings((Project)project).version = 3;
        });
    }

    private static void showSingletonNotification(@NotNull Project project, @NotNull String title, @NotNull String htmlContent, @NotNull NotificationType type, @NotNull NotificationListener listener2) {
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(14);
        }
        if (title == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(15);
        }
        if (htmlContent == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(16);
        }
        if (type == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(17);
        }
        if (listener2 == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(18);
        }
        project.putUserData(DONT_SHOW_BALLOON, (Object)true);
        BALLOON_NOTIFICATIONS.createNotification(title, htmlContent, type, (notification2, event) -> {
            try {
                listener2.hyperlinkUpdate(notification2, event);
            }
            finally {
                notification2.expire();
            }
        }).notify(project);
    }

    private static boolean containsFutureImports(@NotNull PyFile file) {
        if (file == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(19);
        }
        for (PyFromImportStatement importStatement : file.getFromImports()) {
            if (!importStatement.isFromFuture()) continue;
            return true;
        }
        return false;
    }

    private static boolean isCompatibilityInspectionEnabled(@NotNull PsiElement anchor) {
        InspectionProfileImpl profile;
        InspectionToolWrapper tool;
        if (anchor == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(20);
        }
        return (tool = (profile = InspectionProfileManager.getInstance((Project)anchor.getProject()).getCurrentProfile()).getInspectionTool(PyCompatibilityInspectionAdvertiser.getCompatibilityInspectionShortName(), anchor.getProject())) != null && profile.isToolEnabled(HighlightDisplayKey.findById((String)tool.getID()), anchor);
    }

    private static void enableCompatibilityInspection(@NotNull Project project) {
        InspectionProfileImpl profile;
        InspectionToolWrapper tool;
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(21);
        }
        if ((tool = (profile = InspectionProfileManager.getInstance((Project)project).getCurrentProfile()).getInspectionTool(PyCompatibilityInspectionAdvertiser.getCompatibilityInspectionShortName(), project)) != null) {
            profile.setToolEnabled(tool.getShortName(), true);
            EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)profile, (String)PyCompatibilityInspectionAdvertiser.getCompatibilityInspectionShortName());
        }
    }

    @Nullable
    private static LanguageLevel getLatestConfiguredCompatiblePythonVersion(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(22);
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)anchor.getProject()).getCurrentProfile();
        PyCompatibilityInspection inspection = (PyCompatibilityInspection)profile.getUnwrappedTool(PyCompatibilityInspectionAdvertiser.getCompatibilityInspectionShortName(), anchor);
        JDOMExternalizableStringList versions = inspection.ourVersions;
        if (versions.isEmpty()) {
            return null;
        }
        String maxVersion = (String)Collections.max(versions);
        return LanguageLevel.fromPythonVersion(maxVersion);
    }

    @NotNull
    private static String getCompatibilityInspectionShortName() {
        String string = PyCompatibilityInspection.class.getSimpleName();
        if (string == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static PyCompatibilityInspectionAdvertiserSettings getSettings(@NotNull Project project) {
        if (project == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(24);
        }
        PyCompatibilityInspectionAdvertiserSettings pyCompatibilityInspectionAdvertiserSettings = (PyCompatibilityInspectionAdvertiserSettings)ServiceManager.getService((Project)project, PyCompatibilityInspectionAdvertiserSettings.class);
        if (pyCompatibilityInspectionAdvertiserSettings == null) {
            PyCompatibilityInspectionAdvertiser.$$$reportNull$$$0(25);
        }
        return pyCompatibilityInspectionAdvertiserSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latestConfiguredVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyCompatibilityInspectionAdvertiser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspectionAdvertiser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionsNewerThan";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibilityInspectionShortName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moduleUsesPythonSdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLatestConfiguredCompatiblePython3Version";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showStalePython3VersionWarning";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersionsNewerThan";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enableVersions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showInspectionAdvertisement";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showSingletonNotification";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "containsFutureImports";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibilityInspectionEnabled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "enableCompatibilityInspection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLatestConfiguredCompatiblePythonVersion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

