/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filmtab;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import mediathek.config.Daten;
import mediathek.gui.GuiFilme;
import mediathek.gui.messages.DownloadInfoUpdateAvailableEvent;
import mediathek.gui.messages.TimerEvent;
import mediathek.gui.messages.UpdateStatusBarLeftDisplayEvent;
import mediathek.javafx.CenteredBorderPane;
import mediathek.javafx.VerticalSeparator;
import mediathek.javafx.filmtab.FilmInfoLabel;
import mediathek.javafx.filmtab.FilmTabDownloadInformationLabel;
import net.engio.mbassy.listener.Handler;

public class FilmTabInfoPane
extends HBox {
    private final FilmTabDownloadInformationLabel downloadInformationLabel;
    private final FilmInfoLabel filmInfoLabel;

    public FilmTabInfoPane(final Daten daten, GuiFilme tabFilme) {
        this.downloadInformationLabel = new FilmTabDownloadInformationLabel(daten);
        this.filmInfoLabel = new FilmInfoLabel(daten, tabFilme);
        this.getChildren().addAll((Node[])new Node[]{new CenteredBorderPane((Node)this.filmInfoLabel), new VerticalSeparator(), new CenteredBorderPane((Node)this.downloadInformationLabel), new VerticalSeparator()});
        if (this.isVisible()) {
            daten.getMessageBus().subscribe(this);
        }
        this.visibleProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observable2, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    daten.getMessageBus().subscribe(this);
                } else {
                    daten.getMessageBus().unsubscribe(this);
                }
            }
        });
    }

    private void updateLayout() {
        this.filmInfoLabel.updateValues();
    }

    @Handler
    private void handleDownloadInfoUpdate(DownloadInfoUpdateAvailableEvent e) {
        Platform.runLater(this.downloadInformationLabel::setInfoFilme);
    }

    @Handler
    private void handleLeftDisplayUpdate(UpdateStatusBarLeftDisplayEvent e) {
        Platform.runLater(this::updateLayout);
    }

    @Handler
    private void handleTimerEvent(TimerEvent e) {
        Platform.runLater(this::updateLayout);
    }
}

