/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.AbstractCalculation;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;

final class ElementAt<E>
extends AbstractCalculation<E>
implements ListEventListener<E> {
    private final EventList<E> source;
    private final int index;
    private final E defaultValue;

    public ElementAt(EventList<E> source2, int index, E defaultValue) {
        super(source2.size() > index ? source2.get(index) : defaultValue);
        this.source = source2;
        this.index = index;
        this.defaultValue = defaultValue;
        this.source.addListEventListener(this);
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        Object oldValue = this.getValue();
        this.setValue(this.source.size() > this.index ? this.source.get(this.index) : this.defaultValue);
        Object newValue = this.getValue();
        this.fireValueChange(oldValue, newValue);
    }
}

