# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OpenGLInstanceCulling(Object):
    """
    OpenGLInstanceCulling - Frustum culling and LOD management.
    
    Superclass: Object
    
    This class is used to cull instances based on their transformation
    matrix. It was designed to improve performances when there is large
    number of instances in OpenGLGlyph3DMapper.
    
    Each instance is tested on the GPU through vertex shader to know if
    it is inside of the frustum view. If it is, the distance to the
    camera is computed to select and send to the geometry shader the
    corresponding LOD index. The geometry shader register the instance to
    the corresponding vertex stream and therefore the corresponding
    transform feedback buffer in video memory.
    
    @warning   GL_ARB_gpu_shader5 extension is required.
    
    {.cpp}
    
    Newculling; IdType nb_instances = 1000000;
    
    // buffer of size 16*nb_instances containing transform matrices.
    OpenGLBufferObject* buffer_matrix = ...;
    
    // buffer of size 4*nb_instances containing color buffer to pass
    through. OpenGLBufferObject* buffer_color = ...;
    
    // Initialize LODs culling->_init_lod(polydata); // LOD0 : full
    geometry culling->_add_lod(_2._0, 0.5); // LOD1 : after 2.0, 50%
    triangles culling->_add_lod(_5._0, 0.99); // LOD2 : after 5.0, 1%
    triangles
    
    // Build shader and binds culling->_build_culling_shaders(ren, actor,
    nb_instances); culling->_run_culling_shaders(nb_instances, buffer_matrix,
    buffer_color);
    
    // Get number of instances in LOD 0 int nb_inst_in_lod0 =
    culling->_get_lod(_0)._number_of_instances;
    
    // Get VBO and IBO of LOD 1 OpenGLBufferObject* VBO1 =
    culling->_get_lod(_1)._position_vbo; OpenGLBufferObject* IBO1 =
    culling->_get_lod(_1)._ibo;
    
    // Get instances buffer of LOD 2 // buffer is interleaved [
    transform_matrix0 color0 transform_matrix1 color1 ... ]
    OpenGLBufferObject* buffer2 = culling->_get_lod_buffer(_2);
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLInstanceCulling, obj, update, **traits)
    
    color_lod = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Overload color with unique color per LOD.
        """
    )

    def _color_lod_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorLOD,
                        self.color_lod)

    def _get_helper(self):
        return wrap_vtk(self._vtk_obj.GetHelper())
    helper = traits.Property(_get_helper, desc=\
        """
        Get helper structure.
        """
    )

    def get_lod_buffer(self, *args):
        """
        V.get_lod_buffer(int) -> OpenGLBufferObject
        C++: OpenGLBufferObject *GetLODBuffer(IdType index)
        Get the transform feedback buffer generated by the culling
        program.
        """
        ret = self._wrap_call(self._vtk_obj.GetLODBuffer, *args)
        return wrap_vtk(ret)

    def _get_number_of_lod(self):
        return self._vtk_obj.GetNumberOfLOD()
    number_of_lod = traits.Property(_get_number_of_lod, desc=\
        """
        Get number of LOD currently declared.
        """
    )

    def add_lod(self, *args):
        """
        V.add_lod(float, float)
        C++: void AddLOD(float distance, float targetReduction)
        Add a level of detail. distance is the distance after which LOD
        is enabled target_reduction is the reduction factor applied on
        polydata (vtk_decimate_pro is used)
        
        @sa DecimatePro::SetTargetReduction
        """
        ret = self._wrap_call(self._vtk_obj.AddLOD, *args)
        return ret

    def build_culling_shaders(self, *args):
        """
        V.build_culling_shaders(OpenGLShaderCache, int, bool)
        C++: void BuildCullingShaders(OpenGLShaderCache *cache,
            IdType numInstances, bool withNormals)
        Build culling shader program (if not created yet) and binds it.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BuildCullingShaders, *my_args)
        return ret

    def init_lod(self, *args):
        """
        V.init_lod(PolyData)
        C++: void InitLOD(PolyData *pd)
        Initialize LOD with a polydata
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitLOD, *my_args)
        return ret

    def run_culling_shaders(self, *args):
        """
        V.run_culling_shaders(int, OpenGLBufferObject,
            OpenGLBufferObject, OpenGLBufferObject)
        C++: void RunCullingShaders(IdType numInstances,
            OpenGLBufferObject *matrixBuffer,
            OpenGLBufferObject *colorBuffer,
            OpenGLBufferObject *normalBuffer)
        Run the culling program and generate LOD buffers.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RunCullingShaders, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('color_lod', 'GetColorLOD'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'color_lod'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLInstanceCulling, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLInstanceCulling properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['color_lod']),
            title='Edit OpenGLInstanceCulling properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLInstanceCulling properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

