# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class MotionFXCFGReader(MultiBlockDataSetAlgorithm):
    """
    MotionFXCFGReader - reader for motion_fx motion definitions cfg
    files.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    motion_fx files comprise of `motion`s for a collection of STL files.
    The motions define the transformations to apply to STL geometry to
    emulate motion like translation, rotation, planetary motion, etc.
    
    This reader reads such a CFG file and produces a temporal output for
    the time range defined in the file. The resolution of time can be
    controlled using the `_set_time_resolution` method. The output is a
    multiblock dataset with blocks for each of bodies, identified by an
    STL file, in the cfg file.
    
    The reader uses PEGTL (https://github.com/taocpp/PEGTL) to define and
    parse the grammar for the CFG file.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMotionFXCFGReader, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Get/Set the filename.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    time_resolution = traits.Trait(100, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        Get/Set the time resolution for timesteps produced by the reader.
        """
    )

    def _time_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeResolution,
                        self.time_resolution)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('time_resolution', 'GetTimeResolution'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'file_name', 'progress_text', 'time_resolution'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MotionFXCFGReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MotionFXCFGReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name', 'time_resolution']),
            title='Edit MotionFXCFGReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MotionFXCFGReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

