/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph;

import org.logstash.common.Util;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.graph.Edge;
import org.logstash.config.ir.graph.Vertex;

public final class BooleanEdge
extends Edge {
    public static final BooleanEdgeFactory trueFactory = new BooleanEdgeFactory(true);
    public static final BooleanEdgeFactory falseFactory = new BooleanEdgeFactory(false);
    private final Boolean edgeType;

    public Boolean getEdgeType() {
        return this.edgeType;
    }

    public BooleanEdge(Boolean edgeType, Vertex outVertex, Vertex inVertex) throws InvalidIRException {
        super(outVertex, inVertex);
        this.edgeType = edgeType;
    }

    @Override
    public String individualHashSource() {
        return this.getClass().getCanonicalName() + "|" + this.getEdgeType() + "|";
    }

    @Override
    public String getId() {
        return Util.digest(this.getFrom().getId() + "[" + this.getEdgeType() + "]->" + this.getTo().getId());
    }

    @Override
    public String toString() {
        return this.getFrom() + " -|" + this.edgeType + "|-> " + this.getTo();
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == null) {
            return false;
        }
        if (sourceComponent == this) {
            return true;
        }
        if (sourceComponent instanceof BooleanEdge) {
            BooleanEdge otherE = (BooleanEdge)sourceComponent;
            return this.getFrom().sourceComponentEquals(otherE.getFrom()) && this.getTo().sourceComponentEquals(otherE.getTo()) && this.getEdgeType().equals(otherE.getEdgeType());
        }
        return false;
    }

    @Override
    public BooleanEdge copy(Vertex from, Vertex to) throws InvalidIRException {
        return new BooleanEdge(this.edgeType, from, to);
    }

    public static class BooleanEdgeFactory
    extends Edge.EdgeFactory {
        private final Boolean edgeType;

        public Boolean getEdgeType() {
            return this.edgeType;
        }

        public BooleanEdgeFactory(Boolean edgeType) {
            this.edgeType = edgeType;
        }

        @Override
        public BooleanEdge make(Vertex in, Vertex out) throws InvalidIRException {
            return new BooleanEdge(this.edgeType, in, out);
        }

        public int hashCode() {
            return this.edgeType.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof BooleanEdgeFactory) {
                return ((BooleanEdgeFactory)other).getEdgeType().equals(this.edgeType);
            }
            return false;
        }

        public String toString() {
            return "BooleanEdge.BooleanEdgeFactory[" + this.edgeType + "]";
        }
    }
}

