/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.logstash.ObjectMappers;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.HashableWithSource;
import org.logstash.config.ir.SourceComponent;

public final class PluginDefinition
implements SourceComponent,
HashableWithSource {
    private final Type type;
    private final String name;
    private final Map<String, Object> arguments;

    @Override
    public String hashSource() {
        try {
            String serializedArgs = ObjectMappers.JSON_MAPPER.writeValueAsString(this.getArguments());
            return this.getClass().getCanonicalName() + "|" + this.getType().toString() + "|" + this.getName() + "|" + serializedArgs;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize plugin args as JSON", e);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public PluginDefinition(Type type, String name, Map<String, Object> arguments) {
        this.type = type;
        this.name = name;
        this.arguments = arguments;
    }

    public String toString() {
        return this.type.toString().toLowerCase() + "-" + this.name + this.arguments;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.arguments});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof PluginDefinition) {
            PluginDefinition oPlugin = (PluginDefinition)o;
            return this.type.equals((Object)oPlugin.type) && this.name.equals(oPlugin.name) && this.arguments.equals(oPlugin.arguments);
        }
        return false;
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent o) {
        if (o == null) {
            return false;
        }
        if (o instanceof PluginDefinition) {
            PluginDefinition oPluginDefinition = (PluginDefinition)o;
            HashSet<String> allArgs = new HashSet<String>();
            allArgs.addAll(this.getArguments().keySet());
            allArgs.addAll(oPluginDefinition.getArguments().keySet());
            boolean argsMatch = allArgs.stream().filter(k -> !k.equals("id")).allMatch(k -> Objects.equals(this.getArguments().get(k), oPluginDefinition.getArguments().get(k)));
            return argsMatch && this.type.equals((Object)oPluginDefinition.type) && this.name.equals(oPluginDefinition.name);
        }
        return false;
    }

    @Override
    public SourceWithMetadata getSourceWithMetadata() {
        return null;
    }

    public static enum Type {
        INPUT,
        FILTER,
        OUTPUT,
        CODEC;

    }
}

