"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var __1 = require("../..");
var brush_1 = require("../../../components/brush/brush");
var tooltip_1 = require("../../../components/tooltip");
var get_chart_container_dimensions_1 = require("../../../state/selectors/get_chart_container_dimensions");
var get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
var connected_component_1 = require("../renderer/canvas/connected_component");
var highlighter_brush_1 = require("../renderer/dom/highlighter_brush");
var compute_chart_dimensions_1 = require("./selectors/compute_chart_dimensions");
var compute_legend_1 = require("./selectors/compute_legend");
var get_brush_area_1 = require("./selectors/get_brush_area");
var get_cursor_pointer_1 = require("./selectors/get_cursor_pointer");
var get_legend_items_labels_1 = require("./selectors/get_legend_items_labels");
var get_tooltip_anchor_1 = require("./selectors/get_tooltip_anchor");
var heatmap_spec_1 = require("./selectors/heatmap_spec");
var is_brush_available_1 = require("./selectors/is_brush_available");
var is_brushing_1 = require("./selectors/is_brushing");
var is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
var on_brush_end_caller_1 = require("./selectors/on_brush_end_caller");
var on_element_click_caller_1 = require("./selectors/on_element_click_caller");
var on_element_out_caller_1 = require("./selectors/on_element_out_caller");
var on_element_over_caller_1 = require("./selectors/on_element_over_caller");
var tooltip_2 = require("./selectors/tooltip");
var EMPTY_MAP = new Map();
var HeatmapState = (function () {
    function HeatmapState() {
        this.chartType = __1.ChartTypes.Heatmap;
        this.onElementClickCaller = on_element_click_caller_1.createOnElementClickCaller();
        this.onElementOverCaller = on_element_over_caller_1.createOnElementOverCaller();
        this.onElementOutCaller = on_element_out_caller_1.createOnElementOutCaller();
        this.onBrushEndCaller = on_brush_end_caller_1.createOnBrushEndCaller();
    }
    HeatmapState.prototype.isInitialized = function (globalState) {
        return heatmap_spec_1.getSpecOrNull(globalState) !== null ? get_internal_is_intialized_1.InitStatus.Initialized : get_internal_is_intialized_1.InitStatus.ChartNotInitialized;
    };
    HeatmapState.prototype.isBrushAvailable = function (globalState) {
        return is_brush_available_1.isBrushAvailableSelector(globalState);
    };
    HeatmapState.prototype.isBrushing = function (globalState) {
        return is_brushing_1.isBrushingSelector(globalState);
    };
    HeatmapState.prototype.isChartEmpty = function () {
        return false;
    };
    HeatmapState.prototype.getLegendItems = function (globalState) {
        return compute_legend_1.computeLegendSelector(globalState);
    };
    HeatmapState.prototype.getLegendItemsLabels = function (globalState) {
        return get_legend_items_labels_1.getLegendItemsLabelsSelector(globalState);
    };
    HeatmapState.prototype.getLegendExtraValues = function () {
        return EMPTY_MAP;
    };
    HeatmapState.prototype.chartRenderer = function (containerRef, forwardStageRef) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(tooltip_1.Tooltip, { getChartContainerRef: containerRef }),
            react_1.default.createElement(connected_component_1.Heatmap, { forwardStageRef: forwardStageRef }),
            react_1.default.createElement(brush_1.BrushTool, null),
            react_1.default.createElement(highlighter_brush_1.HighlighterFromBrush, null)));
    };
    HeatmapState.prototype.getPointerCursor = function (globalState) {
        return get_cursor_pointer_1.getPointerCursorSelector(globalState);
    };
    HeatmapState.prototype.isTooltipVisible = function (globalState) {
        return { visible: is_tooltip_visible_1.isTooltipVisibleSelector(globalState), isExternal: false };
    };
    HeatmapState.prototype.getTooltipInfo = function (globalState) {
        return tooltip_2.getTooltipInfoSelector(globalState);
    };
    HeatmapState.prototype.getTooltipAnchor = function (globalState) {
        return get_tooltip_anchor_1.getTooltipAnchorSelector(globalState);
    };
    HeatmapState.prototype.getProjectionContainerArea = function (globalState) {
        return get_chart_container_dimensions_1.getChartContainerDimensionsSelector(globalState);
    };
    HeatmapState.prototype.getMainProjectionArea = function (globalState) {
        return compute_chart_dimensions_1.computeChartDimensionsSelector(globalState);
    };
    HeatmapState.prototype.getBrushArea = function (globalState) {
        return get_brush_area_1.getBrushAreaSelector(globalState);
    };
    HeatmapState.prototype.getDebugState = function () {
        return {};
    };
    HeatmapState.prototype.eventCallbacks = function (globalState) {
        this.onElementOverCaller(globalState);
        this.onElementOutCaller(globalState);
        this.onElementClickCaller(globalState);
        this.onBrushEndCaller(globalState);
    };
    return HeatmapState;
}());
exports.HeatmapState = HeatmapState;
//# sourceMappingURL=chart_state.js.map