/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.api.CodePosition;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.CodeLinesInfo;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.search.StringRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CodeUsageInfo {
    private final JNodeCache nodeCache;
    private final Map<JNode, UsageInfo> usageMap = new ConcurrentHashMap<JNode, UsageInfo>();

    public CodeUsageInfo(JNodeCache nodeCache) {
        this.nodeCache = nodeCache;
    }

    public void processClass(JavaClass javaClass, CodeLinesInfo linesInfo, List<StringRef> lines) {
        Map<CodePosition, JavaNode> usage = javaClass.getUsageMap();
        for (Map.Entry<CodePosition, JavaNode> entry : usage.entrySet()) {
            CodePosition codePosition = entry.getKey();
            JavaNode javaNode = entry.getValue();
            this.addUsage(this.nodeCache.makeFrom(javaNode), javaClass, linesInfo, codePosition, lines);
        }
    }

    private void addUsage(JNode jNode, JavaClass javaClass, CodeLinesInfo linesInfo, CodePosition codePosition, List<StringRef> lines) {
        UsageInfo usageInfo = this.usageMap.computeIfAbsent(jNode, key -> new UsageInfo());
        int line = codePosition.getLine();
        JavaNode javaNodeByLine = linesInfo.getJavaNodeByLine(line);
        StringRef codeLine = lines.get(line - 1);
        JNode node = this.nodeCache.makeFrom(javaNodeByLine == null ? javaClass : javaNodeByLine);
        CodeNode codeNode = new CodeNode(node, line, codeLine);
        usageInfo.addUsage(codeNode);
    }

    public List<CodeNode> getUsageList(JNode node) {
        UsageInfo usageInfo = this.usageMap.get(node);
        if (usageInfo == null) {
            return Collections.emptyList();
        }
        return usageInfo.getUsageList();
    }

    public static class UsageInfo {
        private final List<CodeNode> usageList = new ArrayList<CodeNode>();

        public List<CodeNode> getUsageList() {
            return this.usageList;
        }

        public synchronized void addUsage(CodeNode codeNode) {
            this.usageList.add(codeNode);
        }
    }
}

