/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.UiUtils;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JMethod
extends JNode {
    private static final long serialVersionUID = 3834526867464663751L;
    private static final ImageIcon ICON_MTH_DEF = UiUtils.openIcon("methdef_obj");
    private static final ImageIcon ICON_MTH_PRI = UiUtils.openIcon("methpri_obj");
    private static final ImageIcon ICON_MTH_PRO = UiUtils.openIcon("methpro_obj");
    private static final ImageIcon ICON_MTH_PUB = UiUtils.openIcon("methpub_obj");
    private static final ImageIcon ICON_CONSTRUCTOR = UiUtils.openIcon("constr_ovr");
    private static final ImageIcon ICON_SYNC = UiUtils.openIcon("synch_co");
    private final transient JavaMethod mth;
    private final transient JClass jParent;

    public JMethod(JavaMethod javaMethod, JClass jClass) {
        this.mth = javaMethod;
        this.jParent = jClass;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.mth;
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    public ArgType getReturnType() {
        return this.mth.getReturnType();
    }

    @Override
    public JClass getRootClass() {
        return this.jParent.getRootClass();
    }

    @Override
    public int getLine() {
        return this.mth.getDecompiledLine();
    }

    @Override
    public Icon getIcon() {
        AccessInfo accessFlags = this.mth.getAccessFlags();
        OverlayIcon icon = UiUtils.makeIcon(accessFlags, ICON_MTH_PUB, ICON_MTH_PRI, ICON_MTH_PRO, ICON_MTH_DEF);
        if (accessFlags.isConstructor()) {
            icon.add(ICON_CONSTRUCTOR);
        }
        if (accessFlags.isSynchronized()) {
            icon.add(ICON_SYNC);
        }
        return icon;
    }

    String makeBaseString() {
        if (this.mth.isClassInit()) {
            return "{...}";
        }
        StringBuilder base = new StringBuilder();
        if (this.mth.isConstructor()) {
            base.append(this.mth.getDeclaringClass().getName());
        } else {
            base.append(this.mth.getName());
        }
        base.append('(');
        Iterator<ArgType> it = this.mth.getArguments().iterator();
        while (it.hasNext()) {
            base.append(UiUtils.typeStr(it.next()));
            if (!it.hasNext()) continue;
            base.append(", ");
        }
        base.append(')');
        return base.toString();
    }

    @Override
    public String makeString() {
        return UiUtils.typeFormat(this.makeBaseString(), this.getReturnType());
    }

    @Override
    public String makeLongString() {
        String name = this.mth.getDeclaringClass().getFullName() + '.' + this.makeBaseString();
        return UiUtils.typeFormat(name, this.getReturnType());
    }

    public int hashCode() {
        return this.mth.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JMethod && this.mth.equals(((JMethod)o).mth);
    }
}

