#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hasql
version:              1.4.5.1
visibility:           public
id:                   hasql-1.4.5.1-HFrhOZzBgOqFddyJpOR55F
key:                  hasql-1.4.5.1-HFrhOZzBgOqFddyJpOR55F
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  473a85f073210d0903a2ac1c1c6bc7ff
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-8.10.5/site-local/hasql-1.4.5.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hasql-1.4.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hasql-1.4.5.1
hs-libraries:         HShasql-1.4.5.1-HFrhOZzBgOqFddyJpOR55F
depends:
    attoparsec-0.14.1-IwUGXYiDhQIB5nUHrI5Wg8 base-4.14.2.0
    bytestring-0.10.12.0
    bytestring-strict-builder-0.4.5.4-EXyHRvCUxc0EosEM792RfA
    contravariant-1.5.3-KWoYE9wiUjmElzHNq2wj10
    dlist-1.0-AY7L3vPTTCQEIACGjuCugq
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    hashtables-1.2.4.1-42Uu2tMM0gKL5YQT67BKGp mtl-2.2.2
    postgresql-binary-0.12.4-GpOFt4xRW7920L7tTddwXO
    postgresql-libpq-0.9.4.3-GURAPDQPILI44u2l0Z99kj
    profunctors-5.6.2-HmnVxCk8JDbE3jxtqz7wd8 text-1.2.4.1
    text-builder-0.6.6.2-ItnXmCk9lK7w5hxTT4sXl transformers-0.5.6.2
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

