/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.TreeMap;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.LegacyConfigurationsSupplier;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.logging.text.TreeFormatter;

public class NoMatchingConfigurationSelectionException
extends RuntimeException {
    public NoMatchingConfigurationSelectionException(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentResolveMetadata targetComponent, boolean variantAware) {
        super(NoMatchingConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, targetComponent, variantAware));
    }

    private static String generateMessage(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentResolveMetadata targetComponent, boolean variantAware) {
        TreeMap<String, ConfigurationMetadata> configurations = new TreeMap<String, ConfigurationMetadata>();
        Optional<ImmutableList<? extends ConfigurationMetadata>> variantsForGraphTraversal = targetComponent.getVariantsForGraphTraversal();
        ImmutableList variantsParticipatingInSelection = (ImmutableList)variantsForGraphTraversal.or((Supplier)new LegacyConfigurationsSupplier(targetComponent));
        for (ConfigurationMetadata configurationMetadata : variantsParticipatingInSelection) {
            configurations.put(configurationMetadata.getName(), configurationMetadata);
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Unable to find a matching " + (variantAware ? "variant" : "configuration") + " of " + targetComponent.getId().getDisplayName());
        formatter.startChildren();
        if (configurations.isEmpty()) {
            formatter.node("None of the " + (variantAware ? "variants" : "consumable configurations") + " have attributes.");
        } else {
            for (ConfigurationMetadata configuration : configurations.values()) {
                AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, attributeMatcher, configuration, variantAware);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

