/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.native;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.json4s.FileInput;
import org.json4s.JsonAST;
import org.json4s.JsonAST$JNothing$;
import org.json4s.JsonInput;
import org.json4s.ParserUtil;
import org.json4s.ReaderInput;
import org.json4s.StreamInput;
import org.json4s.StringInput;
import org.json4s.native.JsonParser;
import org.json4s.native.JsonParser$CloseArr$;
import org.json4s.native.JsonParser$CloseObj$;
import org.json4s.native.JsonParser$End$;
import org.json4s.native.JsonParser$NullVal$;
import org.json4s.native.JsonParser$OpenArr$;
import org.json4s.native.JsonParser$OpenObj$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class JsonParser$ {
    public static JsonParser$ MODULE$;
    private final Function3<JsonParser.Parser, Object, Object, JsonAST.JValue> astParser;
    public final char org$json4s$native$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(JsonInput in, boolean useBigDecimalForDouble) {
        return this.parse(in, useBigDecimalForDouble, true);
    }

    public JsonAST.JValue parse(JsonInput in, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        JsonAST.JValue jValue;
        JsonInput jsonInput = in;
        if (jsonInput instanceof StringInput) {
            StringInput stringInput = (StringInput)jsonInput;
            String s = stringInput.string();
            jValue = this.parse(s, useBigDecimalForDouble, useBigIntForLong);
        } else if (jsonInput instanceof ReaderInput) {
            ReaderInput readerInput = (ReaderInput)jsonInput;
            Reader rdr = readerInput.reader();
            jValue = this.parse(rdr, useBigDecimalForDouble, useBigIntForLong, this.parse$default$4());
        } else if (jsonInput instanceof StreamInput) {
            StreamInput streamInput = (StreamInput)jsonInput;
            InputStream stream = streamInput.stream();
            jValue = this.parse((Reader)new InputStreamReader(stream, "UTF-8"), useBigDecimalForDouble, useBigIntForLong, this.parse$default$4());
        } else if (jsonInput instanceof FileInput) {
            FileInput fileInput = (FileInput)jsonInput;
            File file = fileInput.file();
            jValue = this.parse((Reader)new FileReader(file), useBigDecimalForDouble, useBigIntForLong, this.parse$default$4());
        } else {
            throw new MatchError(jsonInput);
        }
        return jValue;
    }

    public JsonAST.JValue parse(String s) throws ParserUtil.ParseException {
        return this.parse(s, false, true);
    }

    public JsonAST.JValue parse(String s, boolean useBigDecimalForDouble) throws ParserUtil.ParseException {
        return this.parse(s, useBigDecimalForDouble, true);
    }

    public JsonAST.JValue parse(String s, boolean useBigDecimalForDouble, boolean useBigIntForLong) throws ParserUtil.ParseException {
        return this.parse(new ParserUtil.Buffer(new StringReader(s), false), useBigDecimalForDouble, useBigIntForLong);
    }

    public JsonAST.JValue parse(Reader s, boolean closeAutomatically, boolean useBigDecimalForDouble, boolean useBigIntForLong) throws ParserUtil.ParseException {
        return this.parse(new ParserUtil.Buffer(s, closeAutomatically), useBigDecimalForDouble, useBigIntForLong);
    }

    public Option<JsonAST.JValue> parseOpt(String s) {
        return this.parseOpt(s, false);
    }

    public Option<JsonAST.JValue> parseOpt(String s, boolean useBigDecimalForDouble) {
        Option option;
        try {
            option = this.parse(s, useBigDecimalForDouble).toOption();
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JsonAST.JValue> parseOpt(Reader s, boolean closeAutomatically, boolean useBigDecimalForDouble) {
        Option option;
        try {
            option = this.parse(s, closeAutomatically, useBigDecimalForDouble, this.parse$default$4()).toOption();
        }
        catch (Exception exception) {
            option = None$.MODULE$;
        }
        return option;
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p) {
        return this.parse(s, p, false);
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble) {
        return this.parse(new StringReader(s), p, useBigDecimalForDouble);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p) {
        return this.parse(s, p, false);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble) {
        return this.parse(s, p, useBigDecimalForDouble, true);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        return p.apply(new JsonParser.Parser(new ParserUtil.Buffer(s, false), useBigDecimalForDouble, useBigIntForLong));
    }

    private JsonAST.JValue parse(ParserUtil.Buffer buf, boolean useBigDecimal, boolean useBigInt) {
        JsonAST.JValue jValue;
        try {
            try {
                jValue = this.astParser.apply(new JsonParser.Parser(buf, useBigDecimal, useBigInt), BoxesRunTime.boxToBoolean(useBigDecimal), BoxesRunTime.boxToBoolean(useBigInt));
            }
            catch (ParserUtil.ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParserUtil.ParseException("parsing failed", e);
            }
        }
        finally {
            buf.release();
        }
        return jValue;
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parse$default$3() {
        return false;
    }

    public boolean parse$default$4() {
        return true;
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public boolean parseOpt$default$3() {
        return false;
    }

    private static final JsonAST.JValue reverse$1(JsonAST.JValue v2) {
        JsonAST.JValue jValue;
        JsonAST.JValue jValue2 = v2;
        if (jValue2 instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue2;
            List<Tuple2<String, JsonAST.JValue>> l = jObject.obj();
            jValue = package$.MODULE$.JObject().apply((List<Tuple2<String, JsonAST.JValue>>)l.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String n = (String)tuple2._1();
                JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                Tuple2<String, JsonAST.JValue> tuple22 = new Tuple2<String, JsonAST.JValue>(n, JsonParser$.reverse$1(v));
                return tuple22;
            }, List$.MODULE$.canBuildFrom()).reverse());
        } else if (jValue2 instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue2;
            List<JsonAST.JValue> l = jArray.arr();
            jValue = package$.MODULE$.JArray().apply((List<JsonAST.JValue>)l.map((Function1<JsonAST.JValue, JsonAST.JValue> & Serializable & scala.Serializable)v -> JsonParser$.reverse$1(v), List$.MODULE$.canBuildFrom()).reverse());
        } else {
            jValue = jValue2;
        }
        return jValue;
    }

    private static final JsonAST.JValue toJValue$1(Object x, JsonParser.Parser p$1) {
        JsonAST.JValue jValue;
        Object object = x;
        if (!(object instanceof JsonAST.JValue)) {
            Throwable throwable;
            Option<Throwable> option;
            if (object instanceof Throwable && !(option = NonFatal$.MODULE$.unapply(throwable = (Throwable)object)).isEmpty()) {
                throw p$1.fail(new StringBuilder(17).append("unexpected field ").append(x).toString());
            }
            throw new MatchError(object);
        }
        JsonAST.JValue jValue2 = jValue = (JsonAST.JValue)object;
        return jValue2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void closeBlock$1(Object v, JsonParser.Parser p$1, JsonParser.ValStack vals$1, ObjectRef root$1) {
        Object a;
        Object o;
        boolean bl = false;
        Some some = null;
        Option<Object> option = vals$1.peekOption();
        if (option instanceof Some) {
            Tuple2 tuple2;
            Object name;
            bl = true;
            some = (Some)option;
            Object a2 = some.value();
            if (a2 instanceof Tuple2 && (name = (tuple2 = (Tuple2)a2)._1()) instanceof String) {
                String string = (String)name;
                vals$1.pop(Tuple2.class);
                JsonAST.JObject obj = vals$1.peek(JsonAST.JObject.class);
                Tuple2<String, JsonAST.JValue> tuple22 = new Tuple2<String, JsonAST.JValue>(string, JsonParser$.toJValue$1(v, p$1));
                vals$1.replace(package$.MODULE$.JObject().apply(obj.obj().$colon$colon(tuple22)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (o = some.value()) instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)o;
            Tuple2 tuple2 = vals$1.peek(Tuple2.class);
            vals$1.replace(package$.MODULE$.JObject().apply(jObject.obj().$colon$colon(tuple2)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl && (a = some.value()) instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)a;
            JsonAST.JValue jValue = JsonParser$.toJValue$1(v, p$1);
            vals$1.replace(package$.MODULE$.JArray().apply(jArray.arr().$colon$colon(jValue)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Object x = some.value();
            throw p$1.fail(new StringBuilder(40).append("expected field, array or object but got ").append(x).toString());
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        root$1.elem = new Some<JsonAST.JValue>(JsonParser$.reverse$1(JsonParser$.toJValue$1(v, p$1)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void newValue$1(JsonAST.JValue v, JsonParser.ValStack vals$1, JsonParser.Parser p$1) {
        Tuple2 tuple2;
        Object name;
        Object object = vals$1.peekAny();
        if (object instanceof Tuple2 && (name = (tuple2 = (Tuple2)object)._1()) instanceof String) {
            String string = (String)name;
            vals$1.pop(Tuple2.class);
            JsonAST.JObject obj = vals$1.peek(JsonAST.JObject.class);
            Tuple2<String, JsonAST.JValue> tuple22 = new Tuple2<String, JsonAST.JValue>(string, v);
            vals$1.replace(package$.MODULE$.JObject().apply(obj.obj().$colon$colon(tuple22)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)object;
            JsonAST.JValue jValue = v;
            vals$1.replace(package$.MODULE$.JArray().apply(jArray.arr().$colon$colon(jValue)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw p$1.fail("expected field or array");
        }
    }

    public static final /* synthetic */ JsonAST.JValue $anonfun$astParser$1(JsonParser.Parser p, boolean useBigDecimal, boolean useBigIntForLong) {
        JsonParser$End$ jsonParser$End$;
        JsonParser.Token token;
        JsonParser.ValStack vals = new JsonParser.ValStack(p);
        JsonParser.Token token2 = null;
        ObjectRef<None$> root = ObjectRef.create(None$.MODULE$);
        do {
            BoxedUnit boxedUnit;
            JsonParser.Token token3;
            if (JsonParser$OpenObj$.MODULE$.equals(token3 = (token2 = p.nextToken()))) {
                vals.push(package$.MODULE$.JObject().apply(Nil$.MODULE$));
                boxedUnit = BoxedUnit.UNIT;
            } else if (token3 instanceof JsonParser.FieldStart) {
                JsonParser.FieldStart fieldStart = (JsonParser.FieldStart)token3;
                String name = fieldStart.name();
                vals.push(package$.MODULE$.JField().apply(name, null));
                boxedUnit = BoxedUnit.UNIT;
            } else if (token3 instanceof JsonParser.StringVal) {
                JsonParser.StringVal stringVal = (JsonParser.StringVal)token3;
                String x = stringVal.value();
                JsonParser$.newValue$1(package$.MODULE$.JString().apply(x), vals, p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (token3 instanceof JsonParser.IntVal) {
                JsonParser.IntVal intVal = (JsonParser.IntVal)token3;
                BigInt x = intVal.value();
                JsonParser$.newValue$1(package$.MODULE$.JInt().apply(x), vals, p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (token3 instanceof JsonParser.LongVal) {
                JsonParser.LongVal longVal = (JsonParser.LongVal)token3;
                long x = longVal.value();
                JsonParser$.newValue$1(package$.MODULE$.JLong().apply(x), vals, p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (token3 instanceof JsonParser.DoubleVal) {
                JsonParser.DoubleVal doubleVal = (JsonParser.DoubleVal)token3;
                double x = doubleVal.value();
                JsonParser$.newValue$1(package$.MODULE$.JDouble().apply(x), vals, p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (token3 instanceof JsonParser.BigDecimalVal) {
                JsonParser.BigDecimalVal bigDecimalVal = (JsonParser.BigDecimalVal)token3;
                BigDecimal x = bigDecimalVal.value();
                JsonParser$.newValue$1(package$.MODULE$.JDecimal().apply(x), vals, p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (token3 instanceof JsonParser.BoolVal) {
                JsonParser.BoolVal boolVal = (JsonParser.BoolVal)token3;
                boolean x = boolVal.value();
                JsonParser$.newValue$1(package$.MODULE$.JBool().apply(x), vals, p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (JsonParser$NullVal$.MODULE$.equals(token3)) {
                JsonParser$.newValue$1(package$.MODULE$.JNull(), vals, p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (JsonParser$CloseObj$.MODULE$.equals(token3)) {
                JsonParser$.closeBlock$1(vals.popAny(), p, vals, root);
                boxedUnit = BoxedUnit.UNIT;
            } else if (JsonParser$OpenArr$.MODULE$.equals(token3)) {
                vals.push(package$.MODULE$.JArray().apply(Nil$.MODULE$));
                boxedUnit = BoxedUnit.UNIT;
            } else if (JsonParser$CloseArr$.MODULE$.equals(token3)) {
                JsonParser$.closeBlock$1(vals.pop(JsonAST.JArray.class), p, vals, root);
                boxedUnit = BoxedUnit.UNIT;
            } else if (JsonParser$End$.MODULE$.equals(token3)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(token3);
            }
            token = token2;
            jsonParser$End$ = JsonParser$End$.MODULE$;
        } while (token == null ? jsonParser$End$ != null : !token.equals(jsonParser$End$));
        return (JsonAST.JValue)((Option)root.elem).getOrElse((Function0<JsonAST$JNothing$> & Serializable & scala.Serializable)() -> package$.MODULE$.JNothing());
    }

    private JsonParser$() {
        MODULE$ = this;
        this.astParser = (Function3<JsonParser.Parser, Object, Object, JsonAST.JValue> & Serializable & scala.Serializable)(p, useBigDecimal, useBigIntForLong) -> JsonParser$.$anonfun$astParser$1(p, BoxesRunTime.unboxToBoolean(useBigDecimal), BoxesRunTime.unboxToBoolean(useBigIntForLong));
        this.org$json4s$native$JsonParser$$EOF = (char)-1;
    }
}

