/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import org.apache.lucene.search.DoubleValuesSource;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.expression.GeoEmptyValueSource;
import org.elasticsearch.script.expression.GeoLatitudeValueSource;
import org.elasticsearch.script.expression.GeoLongitudeValueSource;

final class GeoField {
    static final String EMPTY_VARIABLE = "empty";
    static final String LAT_VARIABLE = "lat";
    static final String LON_VARIABLE = "lon";
    static final String ISEMPTY_METHOD = "isEmpty";
    static final String GETLAT_METHOD = "getLat";
    static final String GETLON_METHOD = "getLon";

    private GeoField() {
    }

    static DoubleValuesSource getVariable(IndexFieldData<?> fieldData, String fieldName, String variable) {
        switch (variable) {
            case "empty": {
                return new GeoEmptyValueSource(fieldData);
            }
            case "lat": {
                return new GeoLatitudeValueSource(fieldData);
            }
            case "lon": {
                return new GeoLongitudeValueSource(fieldData);
            }
        }
        throw new IllegalArgumentException("Member variable [" + variable + "] does not exist for geo field [" + fieldName + "].");
    }

    static DoubleValuesSource getMethod(IndexFieldData<?> fieldData, String fieldName, String method) {
        switch (method) {
            case "isEmpty": {
                return new GeoEmptyValueSource(fieldData);
            }
            case "getLat": {
                return new GeoLatitudeValueSource(fieldData);
            }
            case "getLon": {
                return new GeoLongitudeValueSource(fieldData);
            }
        }
        throw new IllegalArgumentException("Member method [" + method + "] does not exist for geo field [" + fieldName + "].");
    }
}

