/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class DataStream
extends AbstractDiffable<DataStream>
implements ToXContentObject {
    private final String name;
    private final String timeStampField;
    private final List<String> indices;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> new DataStream((String)args[0], (String)args[1], (List)args[2]));

    public DataStream(String name, String timeStampField, List<String> indices) {
        this.name = name;
        this.timeStampField = timeStampField;
        this.indices = indices;
    }

    public String getName() {
        return this.name;
    }

    public String getTimeStampField() {
        return this.timeStampField;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public DataStream(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readStringList());
    }

    public static Diff<DataStream> readDiffFrom(StreamInput in) throws IOException {
        return DataStream.readDiffFrom(DataStream::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.timeStampField);
        out.writeStringCollection(this.indices);
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return (DataStream)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(TIMESTAMP_FIELD_FIELD.getPreferredName(), this.timeStampField);
        builder.field(INDICES_FIELD.getPreferredName(), this.indices);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.name.equals(that.name) && this.timeStampField.equals(that.timeStampField) && this.indices.equals(that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeStampField, this.indices);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TIMESTAMP_FIELD_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDICES_FIELD);
    }
}

