#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 unordered-containers
version:              0.2.14.0
visibility:           public
id:                   unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
key:                  unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
license:              BSD-3-Clause
copyright:
    2010-2014 Johan Tibell
    2010 Edward Z. Yang

maintainer:           johan.tibell@gmail.com, David.Feuer@gmail.com
author:               Johan Tibell
homepage:
    https://github.com/haskell-unordered-containers/unordered-containers

synopsis:             Efficient hashing-based container types
description:
    Efficient hashing-based container types.  The containers have been
    optimized for performance critical use, both in terms of large data
    quantities and high speed.

    The declared cost of each operation is either worst-case or
    amortized, but remains valid even if structures are shared.

category:             Data
abi:                  201c273fbc18db08ef3a79f9462466eb
exposed:              True
exposed-modules:
    Data.HashMap.Internal Data.HashMap.Internal.Array
    Data.HashMap.Internal.List Data.HashMap.Internal.Strict
    Data.HashMap.Internal.Unsafe Data.HashMap.Lazy Data.HashMap.Strict
    Data.HashSet Data.HashSet.Internal

import-dirs:
    /usr/lib/ghc-8.10.5/site-local/unordered-containers-0.2.14.0

library-dirs:
    /usr/lib/ghc-8.10.5/site-local/unordered-containers-0.2.14.0

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/unordered-containers-0.2.14.0

hs-libraries:         HSunordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
depends:
    base-4.14.2.0 deepseq-1.4.4.0
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo

haddock-interfaces:
    /usr/share/doc/haskell-unordered-containers/html/unordered-containers.haddock

haddock-html:         /usr/share/doc/haskell-unordered-containers/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

