#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.1
visibility:           public
id:                   trifecta-2.1.1-JuYz6TDVWlHHJ0AL505vP8
key:                  trifecta-2.1.1-JuYz6TDVWlHHJ0AL505vP8
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  a700b163c34813bac4be87724886aa29
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-8.10.5/site-local/trifecta-2.1.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/trifecta-2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/trifecta-2.1.1
hs-libraries:         HStrifecta-2.1.1-JuYz6TDVWlHHJ0AL505vP8
depends:
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i array-0.5.4.0
    base-4.14.2.0 blaze-builder-0.4.2.1-CvyaA91rGJh3LGq34EOJVB
    blaze-html-0.9.1.2-1n12vqHaYUE6IcJnZT4iT0
    blaze-markup-0.8.2.8-3vU6uXP6yL6HskSuj4A8TX bytestring-0.10.12.0
    charset-0.3.8-4iWjhAmMSYyAaq3GWZzCtv
    comonad-5.0.8-8a10YHmXJVq2BoDg3RtKOL containers-0.6.4.1
    deepseq-1.4.4.0 fingertree-0.1.4.2-BtlaX1boPWd7OaHKwClIz0
    ghc-prim-0.6.1 hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
    lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC mtl-2.2.2
    parsers-0.12.10-DGz13yHc7wxB3ssNjoRPte
    prettyprinter-1.7.0-CsdPyvSK7SYH1Sdty7tDdn
    prettyprinter-ansi-terminal-1.1.2-8t5lfdDDTyYCi98eRKlTl
    profunctors-5.6.2-HmnVxCk8JDbE3jxtqz7wd8
    reducers-3.12.3-3OH28QLg4tC5xW9GuEBrC8 transformers-0.5.6.2
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

