#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tasty
version:              1.4.1
visibility:           public
id:                   tasty-1.4.1-o6GqK7uhQW6VZVrPJnWQG
key:                  tasty-1.4.1-o6GqK7uhQW6VZVrPJnWQG
license:              MIT
maintainer:           Roman Cheplyaka <roma@ro-che.info>
author:               Roman Cheplyaka <roma@ro-che.info>
homepage:             https://github.com/feuerbach/tasty
synopsis:             Modern and extensible testing framework
description:
    Tasty is a modern testing framework for Haskell.
    It lets you combine your unit tests, golden
    tests, QuickCheck/SmallCheck properties, and any
    other types of tests into a single test suite.

category:             Testing
abi:                  2f2d47c8217475a11ed8915ee929c612
exposed:              True
exposed-modules:
    Test.Tasty Test.Tasty.Ingredients Test.Tasty.Ingredients.Basic
    Test.Tasty.Ingredients.ConsoleReporter Test.Tasty.Options
    Test.Tasty.Patterns.Eval Test.Tasty.Patterns.Parser
    Test.Tasty.Patterns.Types Test.Tasty.Providers
    Test.Tasty.Providers.ConsoleFormat Test.Tasty.Runners

hidden-modules:
    Control.Concurrent.Async Test.Tasty.Parallel Test.Tasty.Core
    Test.Tasty.Options.Core Test.Tasty.Options.Env Test.Tasty.Patterns
    Test.Tasty.Patterns.Expr Test.Tasty.Run Test.Tasty.Runners.Reducers
    Test.Tasty.Runners.Utils Test.Tasty.CmdLine
    Test.Tasty.Ingredients.ListTests
    Test.Tasty.Ingredients.IncludingOptions

import-dirs:          /usr/lib/ghc-8.10.5/site-local/tasty-1.4.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/tasty-1.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/tasty-1.4.1
hs-libraries:         HStasty-1.4.1-o6GqK7uhQW6VZVrPJnWQG
depends:
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i base-4.14.2.0
    clock-0.8.2-CUh6FGzlB8CArRlXh1LKmY containers-0.6.4.1 mtl-2.2.2
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e stm-2.5.0.1
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV
    unbounded-delays-0.1.1.1-E9kjP04mqKD38mJEZHuFFN unix-2.7.2.2
    wcwidth-0.0.2-45vc1V32rdt9NOjwsS0tDw

haddock-interfaces:   /usr/share/doc/haskell-tasty/html/tasty.haddock
haddock-html:         /usr/share/doc/haskell-tasty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

