#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 quickcheck-instances
version:              0.3.25.2
visibility:           public
id:                   quickcheck-instances-0.3.25.2-d55WE7pIQIDZ5tlUZLXeH
key:                  quickcheck-instances-0.3.25.2-d55WE7pIQIDZ5tlUZLXeH
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

    For information on writing a test-suite with Cabal
    see <https://www.haskell.org/cabal/users-guide/developing-packages.html#test-suites>

category:             Testing
abi:                  8a1fc024f0bb57ef57d290c180f9121e
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.These
    Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:
    /usr/lib/ghc-8.10.5/site-local/quickcheck-instances-0.3.25.2

library-dirs:
    /usr/lib/ghc-8.10.5/site-local/quickcheck-instances-0.3.25.2

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/quickcheck-instances-0.3.25.2

hs-libraries:         HSquickcheck-instances-0.3.25.2-d55WE7pIQIDZ5tlUZLXeH
depends:
    QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk array-0.5.4.0
    base-4.14.2.0 bytestring-0.10.12.0
    case-insensitive-1.2.1.0-6tEs2ust6UoJNkdDoolIXx containers-0.6.4.1
    data-fix-0.3.1-D9MFel1sX0UA9T9qsnfRBB
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    integer-logarithms-1.0.3.1-BDgIIkoswVLGQoPIf73qBL
    old-time-1.1.0.3-L4487sR2g8B3hwiiVWHb93
    scientific-0.3.7.0-Ea1GK6jx8XDEEsfAKxwFym
    splitmix-0.1.0.3-LNddawZskL3KJc3uwIEc7o
    strict-0.4.0.1-JMnBD6iPAun9tbAlBpqxyD
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV text-1.2.4.1
    these-1.1.1.1-6gES5kDvvXJGGRCQQG0Vwd time-1.9.3
    time-compat-1.9.6-IRFK5lCmLyZ3fyMFVeT95j transformers-0.5.6.2
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    uuid-types-1.0.5-EgNl6lc27W27kXZpOd1nsx
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

