#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 http-client-restricted
version:              0.0.4
visibility:           public
id:                   http-client-restricted-0.0.4-5bViN7qzmFW9cMDYyvRQdY
key:                  http-client-restricted-0.0.4-5bViN7qzmFW9cMDYyvRQdY
license:              MIT
copyright:            2018 Joey Hess, 2013 Michael Snoyman
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess
synopsis:             restricting the servers that http-client will use
description:
    Addition to the http-client and http-client-tls
    libraries, that restricts the HTTP servers that can be used.

    This is useful when a security policy needs to eg, prevent connections to
    HTTP servers on localhost or a local network, or only allow connections
    to a specific HTTP server.

    It handles restricting redirects as well as the initial HTTP connection,
    and it also guards against DNS poisoning attacks.

category:             Network
abi:                  f39abb7a2d1ed7a7561b947d7139761d
exposed:              True
exposed-modules:      Network.HTTP.Client.Restricted
import-dirs:          /usr/lib/ghc-8.10.5/site-local/http-client-restricted-0.0.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/http-client-restricted-0.0.4
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/http-client-restricted-0.0.4

hs-libraries:         HShttp-client-restricted-0.0.4-5bViN7qzmFW9cMDYyvRQdY
depends:
    base-4.14.2.0 connection-0.3.1-994dwTkpWiXKAue8yj9mGy
    data-default-0.7.1.1-FiQ1o71Il6AF4wrr19xinj
    http-client-0.7.8-9CCfo3vVp8P3jNF4QXUQLt
    http-client-tls-0.3.5.3-BwcyGhNOyAz2bcL5AaZcNX
    network-3.1.2.2-DhUKX0ZpAd35HJ7CPbrOZd
    network-bsd-2.8.1.0-KqLVFuzsdXl9KyoZ9cCUf8
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du

haddock-interfaces:
    /usr/share/doc/haskell-http-client-restricted/html/http-client-restricted.haddock

haddock-html:         /usr/share/doc/haskell-http-client-restricted/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

