#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hedgehog
version:              1.0.4
visibility:           public
id:                   hedgehog-1.0.4-GZj6VxVSGFK5WrDvoC2VKW
key:                  hedgehog-1.0.4-GZj6VxVSGFK5WrDvoC2VKW
license:              BSD-3-Clause
maintainer:           Jacob Stanley <jacob@stanley.io>
author:               Jacob Stanley
homepage:             https://hedgehog.qa
synopsis:             Release with confidence.
description:
    <http://hedgehog.qa/ Hedgehog> automatically generates a comprehensive array
    of test cases, exercising your software in ways human testers would never
    imagine.

    Generate hundreds of test cases automatically, exposing even the
    most insidious of corner cases. Failures are automatically simplified, giving
    developers coherent, intelligible error messages.

    To get started quickly, see the <https://github.com/hedgehogqa/haskell-hedgehog/tree/master/hedgehog-example examples>.

category:             Testing
abi:                  a3ee4b035612ba0ec6ffcddbb2c75758
exposed:              True
exposed-modules:
    Hedgehog Hedgehog.Gen Hedgehog.Internal.Config
    Hedgehog.Internal.Discovery Hedgehog.Internal.Distributive
    Hedgehog.Internal.Exception Hedgehog.Internal.Gen
    Hedgehog.Internal.HTraversable Hedgehog.Internal.Opaque
    Hedgehog.Internal.Prelude Hedgehog.Internal.Property
    Hedgehog.Internal.Queue Hedgehog.Internal.Range
    Hedgehog.Internal.Region Hedgehog.Internal.Report
    Hedgehog.Internal.Runner Hedgehog.Internal.Seed
    Hedgehog.Internal.Show Hedgehog.Internal.Shrink
    Hedgehog.Internal.Source Hedgehog.Internal.State
    Hedgehog.Internal.TH Hedgehog.Internal.Tree
    Hedgehog.Internal.Tripping Hedgehog.Main Hedgehog.Range

import-dirs:          /usr/lib/ghc-8.10.3/site-local/hedgehog-1.0.4
library-dirs:         /usr/lib/ghc-8.10.3/site-local/hedgehog-1.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.3/hedgehog-1.0.4
hs-libraries:         HShedgehog-1.0.4-GZj6VxVSGFK5WrDvoC2VKW
depends:
    ansi-terminal-0.11-2SXi8ZhU18i2uWLidRUotS
    async-2.2.2-ERU47gwt5NP8C9F4W71ZPz base-4.14.1.0
    bytestring-0.10.12.0
    concurrent-output-1.10.12-3iZ6TU4oZikpjeLfxfC1u containers-0.6.2.1
    deepseq-1.4.4.0 directory-1.3.6.0
    erf-2.0.0.0-6AnMvFnwVaM5ZNfg6TTNq1 exceptions-0.10.4
    lifted-async-0.10.1.2-6k5eT0fxXDHAnVadfxsMhD
    mmorph-1.1.4-LFHH2riUvlgOZSNioXuQY
    monad-control-1.0.2.3-D0QtFvOGiobG7KTK5Cfhxz mtl-2.2.2
    pretty-show-1.10-EhdS2ToA2sEFyivshN51pj
    primitive-0.7.1.0-Jxsyd70oUttYiCXCa0HqV
    random-1.2.0-6zIdUIrmHInBiqbyqpDYsu
    resourcet-1.2.4.2-ZFSaJqdPhTF3bDqUsNijS stm-2.5.0.0
    template-haskell-2.16.0.0 text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2
    transformers-base-0.4.5.2-5NQt00osHIwIugRpgg1tUI
    wl-pprint-annotated-0.1.0.1-CleX5Oo9lJ7DXogwNUI50g

haddock-interfaces:   /usr/share/doc/haskell-hedgehog/html/hedgehog.haddock
haddock-html:         /usr/share/doc/haskell-hedgehog/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

