#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 edit-distance-vector
version:              1.0.0.4
visibility:           public
id:                   edit-distance-vector-1.0.0.4-IEvnkBFGWfEDoangoGIcxQ
key:                  edit-distance-vector-1.0.0.4-IEvnkBFGWfEDoangoGIcxQ
license:              BSD-3-Clause
copyright:            (c) 2015 Thomas Sutton and others.
maintainer:           me@thomas-sutton.id.au
author:               Thomas Sutton
homepage:             https://github.com/thsutton/edit-distance-vector
synopsis:             Calculate edit distances and edit scripts between vectors.
description:
    An implementation of the Wagner–Fischer dynamic programming algorithm to
    find the optimal edit script and cost between two sequences.

    The implementation in this package is specialised to sequences represented
    with "Data.Vector" but is otherwise agnostic to:

    * The type of values in the vectors;

    * The type representing edit operations; and

    * The type representing the cost of operations.

category:             Data, Data Structures, Algorithms
abi:                  f2ef046f05d413301eec810b3a8f57d2
exposed:              True
exposed-modules:      Data.Vector.Distance
import-dirs:          /usr/lib/ghc-8.10.5/site-local/edit-distance-vector-1.0.0.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/edit-distance-vector-1.0.0.4
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/edit-distance-vector-1.0.0.4

hs-libraries:         HSedit-distance-vector-1.0.0.4-IEvnkBFGWfEDoangoGIcxQ
depends:              base-4.14.2.0 vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
haddock-interfaces:
    /usr/share/doc/haskell-edit-distance-vector/html/edit-distance-vector.haddock

haddock-html:         /usr/share/doc/haskell-edit-distance-vector/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

