/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableCollection;
import java.io.File;
import java.util.HashSet;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.changedetection.TaskExecutionModeResolver;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskProperties;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class ResolveTaskExecutionModeExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveTaskExecutionModeExecuter.class);
    private final PropertyWalker propertyWalker;
    private final PathToFileResolver fileResolver;
    private final TaskExecuter executer;
    private final TaskExecutionModeResolver executionModeResolver;

    public ResolveTaskExecutionModeExecuter(TaskExecutionModeResolver executionModeResolver, PathToFileResolver fileResolver, PropertyWalker propertyWalker, TaskExecuter executer) {
        this.propertyWalker = propertyWalker;
        this.fileResolver = fileResolver;
        this.executer = executer;
        this.executionModeResolver = executionModeResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, final TaskExecutionContext context) {
        Timer clock = Time.startTimer();
        TaskProperties taskProperties = DefaultTaskProperties.resolve(this.propertyWalker, this.fileResolver, task);
        context.setTaskProperties(taskProperties);
        TaskExecutionMode taskExecutionMode = this.executionModeResolver.getExecutionMode(task, taskProperties);
        TaskOutputsInternal outputs = task.getOutputs();
        context.setTaskExecutionMode(taskExecutionMode);
        outputs.setPreviousOutputFiles((FileCollection)new LazilyInitializedFileCollection(){

            public FileCollection createDelegate() {
                AfterPreviousExecutionState previousExecution = context.getAfterPreviousExecution();
                if (previousExecution == null) {
                    return ImmutableFileCollection.of();
                }
                ImmutableCollection outputFingerprints = previousExecution.getOutputFileProperties().values();
                HashSet<File> outputs = new HashSet<File>();
                for (FileCollectionFingerprint fileCollectionFingerprint : outputFingerprints) {
                    for (String absolutePath : fileCollectionFingerprint.getFingerprints().keySet()) {
                        outputs.add(new File(absolutePath));
                    }
                }
                return ImmutableFileCollection.of(outputs);
            }

            public String getDisplayName() {
                return "previous output files";
            }
        });
        LOGGER.debug("Putting task artifact state for {} into context took {}.", (Object)task, (Object)clock.getElapsed());
        try {
            TaskExecuterResult taskExecuterResult = this.executer.execute(task, state, context);
            return taskExecuterResult;
        }
        finally {
            outputs.setPreviousOutputFiles(null);
            context.setTaskExecutionMode(null);
            context.setTaskProperties(null);
            LOGGER.debug("Removed task artifact state for {} from context.");
        }
    }
}

