/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import java.util.List;
import net.rubygrapefruit.platform.prompts.AbstractListener;
import net.rubygrapefruit.platform.prompts.PasswordView;
import net.rubygrapefruit.platform.prompts.SelectView;
import net.rubygrapefruit.platform.prompts.SelectionListener;
import net.rubygrapefruit.platform.prompts.TextEntryListener;
import net.rubygrapefruit.platform.prompts.TextView;
import net.rubygrapefruit.platform.prompts.YesNoListener;
import net.rubygrapefruit.platform.prompts.YesNoView;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.Terminals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prompter {
    static final TerminalOutput.Color SELECTION_COLOR = TerminalOutput.Color.Cyan;
    private final boolean interactive;
    private final Terminals terminals;

    public Prompter(Terminals terminals) {
        this.interactive = terminals.isTerminalInput() && terminals.isTerminal(Terminals.Output.Stdout) && terminals.getTerminal(Terminals.Output.Stdout).supportsCursorMotion();
        this.terminals = terminals;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public Integer select(String prompt, List<String> options, int defaultOption) {
        if (this.interactive) {
            return this.selectInteractive(prompt, options, defaultOption);
        }
        return defaultOption;
    }

    public String enterText(String prompt, String defaultValue) {
        if (this.interactive) {
            return this.enterTextInteractive(prompt, defaultValue);
        }
        return defaultValue;
    }

    public String enterPassword(String prompt) {
        if (this.interactive) {
            return this.enterPasswordInteractive(prompt);
        }
        return null;
    }

    public Boolean askYesNo(String prompt, boolean defaultValue) {
        if (this.interactive) {
            return this.yesNoInteractive(prompt, defaultValue);
        }
        return defaultValue;
    }

    private Boolean yesNoInteractive(String prompt, boolean defaultValue) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        YesNoView view = new YesNoView(output, prompt, defaultValue);
        YesNoListener listener = new YesNoListener(defaultValue);
        view.render();
        this.handleInput(listener);
        view.close(listener.getSelected());
        return listener.getSelected();
    }

    private Integer selectInteractive(String prompt, List<String> options, int defaultOption) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        SelectView view = new SelectView(output, prompt, options, defaultOption);
        SelectionListener listener = new SelectionListener(view, options);
        view.render();
        this.handleInput(listener);
        view.close(listener.getSelected());
        return listener.getSelected();
    }

    private String enterTextInteractive(String prompt, String defaultValue) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        TextView view = new TextView(output, prompt, defaultValue);
        TextEntryListener listener = new TextEntryListener(view, defaultValue);
        view.render();
        this.handleInput(listener);
        view.close(listener.getEntered());
        return listener.getEntered();
    }

    private String enterPasswordInteractive(String prompt) {
        TerminalOutput output = this.terminals.getTerminal(Terminals.Output.Stdout);
        PasswordView view = new PasswordView(output, prompt);
        TextEntryListener listener = new TextEntryListener(view, null);
        view.render();
        this.handleInput(listener);
        view.close(listener.getEntered());
        return listener.getEntered();
    }

    private void handleInput(AbstractListener listener) {
        TerminalInput input = this.terminals.getTerminalInput();
        input.rawMode();
        try {
            while (!listener.isFinished()) {
                input.read(listener);
            }
        }
        finally {
            input.reset();
        }
    }
}

