// SPDX-License-Identifier: GPL-2.0-only
//
// aw88399.h --  ALSA SoC AW88399 codec support
//
// Copyright (c) 2023 AWINIC Technology CO., LTD
//
// Author: Weidong Wang <wangweidong.a@awinic.com>
//

#ifndef __AW88399_H__
#define __AW88399_H__

/* registers list */
#define AW88399_ID_REG			(0x00)
#define AW88399_SYSST_REG		(0x01)
#define AW88399_SYSINT_REG		(0x02)
#define AW88399_SYSINTM_REG		(0x03)
#define AW88399_SYSCTRL_REG		(0x04)
#define AW88399_SYSCTRL2_REG		(0x05)
#define AW88399_I2SCTRL1_REG		(0x06)
#define AW88399_I2SCTRL2_REG		(0x07)
#define AW88399_I2SCTRL3_REG		(0x08)
#define AW88399_DACCFG1_REG		(0x09)
#define AW88399_DACCFG2_REG		(0x0A)
#define AW88399_DACCFG3_REG		(0x0B)
#define AW88399_DACCFG4_REG		(0x0C)
#define AW88399_DACCFG5_REG		(0x0D)
#define AW88399_DACCFG6_REG		(0x0E)
#define AW88399_DACCFG7_REG		(0x0F)
#define AW88399_MPDCFG1_REG		(0x10)
#define AW88399_MPDCFG2_REG		(0x11)
#define AW88399_MPDCFG3_REG		(0x12)
#define AW88399_MPDCFG4_REG		(0x13)
#define AW88399_PWMCTRL1_REG		(0x14)
#define AW88399_PWMCTRL2_REG		(0x15)
#define AW88399_PWMCTRL3_REG		(0x16)
#define AW88399_I2SCFG1_REG		(0x17)
#define AW88399_DBGCTRL_REG		(0x18)
#define AW88399_HAGCST_REG		(0x20)
#define AW88399_VBAT_REG		(0x21)
#define AW88399_TEMP_REG		(0x22)
#define AW88399_PVDD_REG		(0x23)
#define AW88399_ISNDAT_REG		(0x24)
#define AW88399_VSNDAT_REG		(0x25)
#define AW88399_I2SINT_REG		(0x26)
#define AW88399_I2SCAPCNT_REG		(0x27)
#define AW88399_ANASTA1_REG		(0x28)
#define AW88399_ANASTA2_REG		(0x29)
#define AW88399_ANASTA3_REG		(0x2A)
#define AW88399_TESTDET_REG		(0x2B)
#define AW88399_DSMCFG1_REG		(0x30)
#define AW88399_DSMCFG2_REG		(0x31)
#define AW88399_DSMCFG3_REG		(0x32)
#define AW88399_DSMCFG4_REG		(0x33)
#define AW88399_DSMCFG5_REG		(0x34)
#define AW88399_DSMCFG6_REG		(0x35)
#define AW88399_DSMCFG7_REG		(0x36)
#define AW88399_DSMCFG8_REG		(0x37)
#define AW88399_TESTIN_REG		(0x38)
#define AW88399_TESTOUT_REG		(0x39)
#define AW88399_MEMTEST_REG		(0x3A)
#define AW88399_VSNCTRL1_REG		(0x3B)
#define AW88399_ISNCTRL1_REG		(0x3C)
#define AW88399_ISNCTRL2_REG		(0x3D)
#define AW88399_DSPMADD_REG		(0x40)
#define AW88399_DSPMDAT_REG		(0x41)
#define AW88399_WDT_REG		(0x42)
#define AW88399_ACR1_REG		(0x43)
#define AW88399_ACR2_REG		(0x44)
#define AW88399_ASR1_REG		(0x45)
#define AW88399_ASR2_REG		(0x46)
#define AW88399_DSPCFG_REG		(0x47)
#define AW88399_ASR3_REG		(0x48)
#define AW88399_ASR4_REG		(0x49)
#define AW88399_DSPVCALB_REG		(0x4A)
#define AW88399_CRCCTRL_REG		(0x4B)
#define AW88399_DSPDBG1_REG		(0x4C)
#define AW88399_DSPDBG2_REG		(0x4D)
#define AW88399_DSPDBG3_REG		(0x4E)
#define AW88399_PLLCTRL1_REG		(0x50)
#define AW88399_PLLCTRL2_REG		(0x51)
#define AW88399_PLLCTRL3_REG		(0x52)
#define AW88399_CDACTRL1_REG		(0x53)
#define AW88399_CDACTRL2_REG		(0x54)
#define AW88399_CDACTRL3_REG		(0x55)
#define AW88399_SADCCTRL1_REG		(0x56)
#define AW88399_SADCCTRL2_REG		(0x57)
#define AW88399_BOPCTRL1_REG		(0x58)
#define AW88399_BOPCTRL2_REG		(0x5A)
#define AW88399_BOPCTRL3_REG		(0x5B)
#define AW88399_BOPCTRL4_REG		(0x5C)
#define AW88399_BOPCTRL5_REG		(0x5D)
#define AW88399_BOPCTRL6_REG		(0x5E)
#define AW88399_BOPCTRL7_REG		(0x5F)
#define AW88399_BSTCTRL1_REG		(0x60)
#define AW88399_BSTCTRL2_REG		(0x61)
#define AW88399_BSTCTRL3_REG		(0x62)
#define AW88399_BSTCTRL4_REG		(0x63)
#define AW88399_BSTCTRL5_REG		(0x64)
#define AW88399_BSTCTRL6_REG		(0x65)
#define AW88399_BSTCTRL7_REG		(0x66)
#define AW88399_BSTCTRL8_REG		(0x67)
#define AW88399_BSTCTRL9_REG		(0x68)
#define AW88399_BSTCTRL10_REG		(0x69)
#define AW88399_CPCTRL_REG		(0x6A)
#define AW88399_EFWH_REG		(0x6C)
#define AW88399_EFWM2_REG		(0x6D)
#define AW88399_EFWM1_REG		(0x6E)
#define AW88399_EFWL_REG		(0x6F)
#define AW88399_TESTCTRL1_REG		(0x70)
#define AW88399_TESTCTRL2_REG		(0x71)
#define AW88399_EFCTRL1_REG		(0x72)
#define AW88399_EFCTRL2_REG		(0x73)
#define AW88399_EFRH4_REG		(0x74)
#define AW88399_EFRH3_REG		(0x75)
#define AW88399_EFRH2_REG		(0x76)
#define AW88399_EFRH1_REG		(0x77)
#define AW88399_EFRL4_REG		(0x78)
#define AW88399_EFRL3_REG		(0x79)
#define AW88399_EFRL2_REG		(0x7A)
#define AW88399_EFRL1_REG		(0x7B)
#define AW88399_TM_REG			(0x7C)
#define AW88399_TM2_REG		(0x7D)

#define AW88399_REG_MAX		(0x7E)
#define AW88399_MUTE_VOL		(1023)

#define AW88399_DSP_CFG_ADDR		(0x9B00)
#define AW88399_DSP_REG_CFG_ADPZ_RA	(0x9B68)
#define AW88399_DSP_FW_ADDR		(0x8980)
#define AW88399_DSP_ROM_CHECK_ADDR	(0x1F40)
#define AW88399_DSP_ROM_CHECK_DATA	(0x4638)

#define AW88399_CALI_RE_HBITS_MASK	(~(0xFFFF0000))
#define AW88399_CALI_RE_HBITS_SHIFT	(16)

#define AW88399_CALI_RE_LBITS_MASK	(~(0xFFFF))
#define AW88399_CALI_RE_LBITS_SHIFT	(0)

#define AW88399_I2STXEN_START_BIT	(9)
#define AW88399_I2STXEN_BITS_LEN	(1)
#define AW88399_I2STXEN_MASK		\
	(~(((1<<AW88399_I2STXEN_BITS_LEN)-1) << AW88399_I2STXEN_START_BIT))

#define AW88399_I2STXEN_DISABLE	(0)
#define AW88399_I2STXEN_DISABLE_VALUE	\
	(AW88399_I2STXEN_DISABLE << AW88399_I2STXEN_START_BIT)

#define AW88399_I2STXEN_ENABLE		(1)
#define AW88399_I2STXEN_ENABLE_VALUE	\
	(AW88399_I2STXEN_ENABLE << AW88399_I2STXEN_START_BIT)

#define AW88399_VOL_START_BIT		(0)
#define AW88399_VOL_BITS_LEN		(10)
#define AW88399_VOL_MASK		\
	(~(((1<<AW88399_VOL_BITS_LEN)-1) << AW88399_VOL_START_BIT))

#define AW88399_PWDN_START_BIT		(0)
#define AW88399_PWDN_BITS_LEN		(1)
#define AW88399_PWDN_MASK		\
	(~(((1<<AW88399_PWDN_BITS_LEN)-1) << AW88399_PWDN_START_BIT))

#define AW88399_PWDN_POWER_DOWN	(1)
#define AW88399_PWDN_POWER_DOWN_VALUE	\
	(AW88399_PWDN_POWER_DOWN << AW88399_PWDN_START_BIT)

#define AW88399_PWDN_WORKING		(0)
#define AW88399_PWDN_WORKING_VALUE	\
	(AW88399_PWDN_WORKING << AW88399_PWDN_START_BIT)

#define AW88399_DSPBY_START_BIT	(2)
#define AW88399_DSPBY_BITS_LEN		(1)
#define AW88399_DSPBY_MASK		\
	(~(((1<<AW88399_DSPBY_BITS_LEN)-1) << AW88399_DSPBY_START_BIT))

#define AW88399_DSPBY_WORKING		(0)
#define AW88399_DSPBY_WORKING_VALUE	\
	(AW88399_DSPBY_WORKING << AW88399_DSPBY_START_BIT)

#define AW88399_DSPBY_BYPASS		(1)
#define AW88399_DSPBY_BYPASS_VALUE	\
	(AW88399_DSPBY_BYPASS << AW88399_DSPBY_START_BIT)

#define AW88399_MEM_CLKSEL_START_BIT	(3)
#define AW88399_MEM_CLKSEL_BITS_LEN	(1)
#define AW88399_MEM_CLKSEL_MASK		\
	(~(((1<<AW88399_MEM_CLKSEL_BITS_LEN)-1) << AW88399_MEM_CLKSEL_START_BIT))

#define AW88399_MEM_CLKSEL_OSCCLK	(0)
#define AW88399_MEM_CLKSEL_OSCCLK_VALUE	\
	(AW88399_MEM_CLKSEL_OSCCLK << AW88399_MEM_CLKSEL_START_BIT)

#define AW88399_MEM_CLKSEL_DAPHCLK	(1)
#define AW88399_MEM_CLKSEL_DAPHCLK_VALUE	\
	(AW88399_MEM_CLKSEL_DAPHCLK << AW88399_MEM_CLKSEL_START_BIT)

#define AW88399_DITHER_EN_START_BIT	(15)
#define AW88399_DITHER_EN_BITS_LEN	(1)
#define AW88399_DITHER_EN_MASK		 \
	(~(((1<<AW88399_DITHER_EN_BITS_LEN)-1) << AW88399_DITHER_EN_START_BIT))

#define AW88399_DITHER_EN_DISABLE	(0)
#define AW88399_DITHER_EN_DISABLE_VALUE	\
	(AW88399_DITHER_EN_DISABLE << AW88399_DITHER_EN_START_BIT)

#define AW88399_DITHER_EN_ENABLE	(1)
#define AW88399_DITHER_EN_ENABLE_VALUE	\
	(AW88399_DITHER_EN_ENABLE << AW88399_DITHER_EN_START_BIT)

#define AW88399_HMUTE_START_BIT	(8)
#define AW88399_HMUTE_BITS_LEN		(1)
#define AW88399_HMUTE_MASK		\
	(~(((1<<AW88399_HMUTE_BITS_LEN)-1) << AW88399_HMUTE_START_BIT))

#define AW88399_HMUTE_DISABLE		(0)
#define AW88399_HMUTE_DISABLE_VALUE	\
	(AW88399_HMUTE_DISABLE << AW88399_HMUTE_START_BIT)

#define AW88399_HMUTE_ENABLE		(1)
#define AW88399_HMUTE_ENABLE_VALUE	\
	(AW88399_HMUTE_ENABLE << AW88399_HMUTE_START_BIT)

#define AW88399_EF_DBMD_START_BIT	(2)
#define AW88399_EF_DBMD_BITS_LEN	(1)
#define AW88399_EF_DBMD_MASK		\
	(~(((1<<AW88399_EF_DBMD_BITS_LEN)-1) << AW88399_EF_DBMD_START_BIT))

#define AW88399_EF_DBMD_OR		(1)
#define AW88399_EF_DBMD_OR_VALUE	\
	(AW88399_EF_DBMD_OR << AW88399_EF_DBMD_START_BIT)

#define AW88399_VDSEL_START_BIT	(5)
#define AW88399_VDSEL_BITS_LEN		(1)
#define AW88399_VDSEL_MASK		\
	(~(((1<<AW88399_VDSEL_BITS_LEN)-1) << AW88399_VDSEL_START_BIT))

#define AW88399_EF_ISN_GESLP_H_START_BIT	(0)
#define AW88399_EF_ISN_GESLP_H_BITS_LEN	(10)
#define AW88399_EF_ISN_GESLP_H_MASK		\
	(~(((1<<AW88399_EF_ISN_GESLP_H_BITS_LEN)-1) << AW88399_EF_ISN_GESLP_H_START_BIT))

/* EF_VSN_GESLP_H bit 9:0 (EFRH3 0x75) */
#define AW88399_EF_VSN_GESLP_H_START_BIT	(0)
#define AW88399_EF_VSN_GESLP_H_BITS_LEN	(10)
#define AW88399_EF_VSN_GESLP_H_MASK		\
	(~(((1<<AW88399_EF_VSN_GESLP_H_BITS_LEN)-1) << AW88399_EF_VSN_GESLP_H_START_BIT))

#define AW88399_EF_ISN_GESLP_L_START_BIT	(0)
#define AW88399_EF_ISN_GESLP_L_BITS_LEN	(10)
#define AW88399_EF_ISN_GESLP_L_MASK		\
	(~(((1<<AW88399_EF_ISN_GESLP_L_BITS_LEN)-1) << AW88399_EF_ISN_GESLP_L_START_BIT))

/* EF_VSN_GESLP_L bit 9:0 (EFRL3 0x79) */
#define AW88399_EF_VSN_GESLP_L_START_BIT	(0)
#define AW88399_EF_VSN_GESLP_L_BITS_LEN	(10)
#define AW88399_EF_VSN_GESLP_L_MASK		\
	(~(((1<<AW88399_EF_VSN_GESLP_L_BITS_LEN)-1) << AW88399_EF_VSN_GESLP_L_START_BIT))

#define AW88399_INTERNAL_VSN_TRIM_H_START_BIT	(9)
#define AW88399_INTERNAL_VSN_TRIM_H_BITS_LEN	(6)
#define AW88399_INTERNAL_VSN_TRIM_H_MASK	\
	(~(((1<<AW88399_INTERNAL_VSN_TRIM_H_BITS_LEN)-1) << AW88399_INTERNAL_VSN_TRIM_H_START_BIT))

#define AW88399_INTERNAL_VSN_TRIM_L_START_BIT	(9)
#define AW88399_INTERNAL_VSN_TRIM_L_BITS_LEN	(6)
#define AW88399_INTERNAL_VSN_TRIM_L_MASK	\
	(~(((1<<AW88399_INTERNAL_VSN_TRIM_L_BITS_LEN)-1) << AW88399_INTERNAL_VSN_TRIM_L_START_BIT))

#define AW88399_RCV_MODE_START_BIT	(7)
#define AW88399_RCV_MODE_BITS_LEN	(1)
#define AW88399_RCV_MODE_MASK		\
	(~(((1<<AW88399_RCV_MODE_BITS_LEN)-1) << AW88399_RCV_MODE_START_BIT))

#define AW88399_CLKI_START_BIT		(4)
#define AW88399_NOCLKI_START_BIT	(5)
#define AW88399_PLLI_START_BIT		(0)
#define AW88399_PLLI_INT_VALUE		(1)
#define AW88399_PLLI_INT_INTERRUPT \
	(AW88399_PLLI_INT_VALUE << AW88399_PLLI_START_BIT)

#define AW88399_CLKI_INT_VALUE		(1)
#define AW88399_CLKI_INT_INTERRUPT \
	(AW88399_CLKI_INT_VALUE << AW88399_CLKI_START_BIT)

#define AW88399_NOCLKI_INT_VALUE	(1)
#define AW88399_NOCLKI_INT_INTERRUPT \
	(AW88399_NOCLKI_INT_VALUE << AW88399_NOCLKI_START_BIT)

#define AW88399_BIT_SYSINT_CHECK \
		(AW88399_PLLI_INT_INTERRUPT | \
		AW88399_CLKI_INT_INTERRUPT | \
		AW88399_NOCLKI_INT_INTERRUPT)

#define AW88399_CRC_CHECK_START_BIT	(12)
#define AW88399_CRC_CHECK_BITS_LEN	(3)
#define AW88399_CRC_CHECK_BITS_MASK	\
	(~(((1<<AW88399_CRC_CHECK_BITS_LEN)-1) << AW88399_CRC_CHECK_START_BIT))

#define AW88399_RCV_MODE_RECEIVER	(1)
#define AW88399_RCV_MODE_RECEIVER_VALUE	\
	(AW88399_RCV_MODE_RECEIVER << AW88399_RCV_MODE_START_BIT)

#define AW88399_AMPPD_START_BIT	(1)
#define AW88399_AMPPD_BITS_LEN		(1)
#define AW88399_AMPPD_MASK		\
	(~(((1<<AW88399_AMPPD_BITS_LEN)-1) << AW88399_AMPPD_START_BIT))

#define AW88399_AMPPD_WORKING		(0)
#define AW88399_AMPPD_WORKING_VALUE	\
	(AW88399_AMPPD_WORKING << AW88399_AMPPD_START_BIT)

#define AW88399_AMPPD_POWER_DOWN	(1)
#define AW88399_AMPPD_POWER_DOWN_VALUE	\
	(AW88399_AMPPD_POWER_DOWN << AW88399_AMPPD_START_BIT)

#define AW88399_RAM_CG_BYP_START_BIT	(0)
#define AW88399_RAM_CG_BYP_BITS_LEN	(1)
#define AW88399_RAM_CG_BYP_MASK		\
	(~(((1<<AW88399_RAM_CG_BYP_BITS_LEN)-1) << AW88399_RAM_CG_BYP_START_BIT))

#define AW88399_RAM_CG_BYP_WORK	(0)
#define AW88399_RAM_CG_BYP_WORK_VALUE	\
	(AW88399_RAM_CG_BYP_WORK << AW88399_RAM_CG_BYP_START_BIT)

#define AW88399_RAM_CG_BYP_BYPASS	(1)
#define AW88399_RAM_CG_BYP_BYPASS_VALUE	\
	(AW88399_RAM_CG_BYP_BYPASS << AW88399_RAM_CG_BYP_START_BIT)

#define AW88399_CRC_END_ADDR_START_BIT	(0)
#define AW88399_CRC_END_ADDR_BITS_LEN	(12)
#define AW88399_CRC_END_ADDR_MASK	\
	(~(((1<<AW88399_CRC_END_ADDR_BITS_LEN)-1) << AW88399_CRC_END_ADDR_START_BIT))

#define AW88399_CRC_CODE_EN_START_BIT	(13)
#define AW88399_CRC_CODE_EN_BITS_LEN	(1)
#define AW88399_CRC_CODE_EN_MASK	\
	(~(((1<<AW88399_CRC_CODE_EN_BITS_LEN)-1) << AW88399_CRC_CODE_EN_START_BIT))

#define AW88399_CRC_CODE_EN_DISABLE	(0)
#define AW88399_CRC_CODE_EN_DISABLE_VALUE	\
	(AW88399_CRC_CODE_EN_DISABLE << AW88399_CRC_CODE_EN_START_BIT)

#define AW88399_CRC_CODE_EN_ENABLE	(1)
#define AW88399_CRC_CODE_EN_ENABLE_VALUE	\
	(AW88399_CRC_CODE_EN_ENABLE << AW88399_CRC_CODE_EN_START_BIT)

#define AW88399_CRC_CFG_EN_START_BIT	(12)
#define AW88399_CRC_CFG_EN_BITS_LEN	(1)
#define AW88399_CRC_CFG_EN_MASK		\
	(~(((1<<AW88399_CRC_CFG_EN_BITS_LEN)-1) << AW88399_CRC_CFG_EN_START_BIT))

#define AW88399_CRC_CFG_EN_DISABLE	(0)
#define AW88399_CRC_CFG_EN_DISABLE_VALUE	\
	(AW88399_CRC_CFG_EN_DISABLE << AW88399_CRC_CFG_EN_START_BIT)

#define AW88399_CRC_CFG_EN_ENABLE	(1)
#define AW88399_CRC_CFG_EN_ENABLE_VALUE	\
	(AW88399_CRC_CFG_EN_ENABLE << AW88399_CRC_CFG_EN_START_BIT)

#define AW88399_OCDS_START_BIT		(3)
#define AW88399_OCDS_OC		(1)
#define AW88399_OCDS_OC_VALUE		\
	(AW88399_OCDS_OC << AW88399_OCDS_START_BIT)

#define AW88399_NOCLKS_START_BIT	(5)
#define AW88399_NOCLKS_NO_CLOCK	(1)
#define AW88399_NOCLKS_NO_CLOCK_VALUE	\
	(AW88399_NOCLKS_NO_CLOCK << AW88399_NOCLKS_START_BIT)

#define AW88399_SWS_START_BIT		(8)
#define AW88399_SWS_SWITCHING		(1)
#define AW88399_SWS_SWITCHING_VALUE	\
	(AW88399_SWS_SWITCHING << AW88399_SWS_START_BIT)

#define AW88399_BSTS_START_BIT		(9)
#define AW88399_BSTS_FINISHED		(1)
#define AW88399_BSTS_FINISHED_VALUE	\
	(AW88399_BSTS_FINISHED << AW88399_BSTS_START_BIT)

#define AW88399_UVLS_START_BIT		(14)
#define AW88399_UVLS_NORMAL		(0)
#define AW88399_UVLS_NORMAL_VALUE	\
	(AW88399_UVLS_NORMAL << AW88399_UVLS_START_BIT)

#define AW88399_BSTOCS_START_BIT	(11)
#define AW88399_BSTOCS_OVER_CURRENT	(1)
#define AW88399_BSTOCS_OVER_CURRENT_VALUE	\
	(AW88399_BSTOCS_OVER_CURRENT << AW88399_BSTOCS_START_BIT)

#define AW88399_OTHS_START_BIT		(1)
#define AW88399_OTHS_OT		(1)
#define AW88399_OTHS_OT_VALUE		\
	(AW88399_OTHS_OT << AW88399_OTHS_START_BIT)

#define AW88399_PLLS_START_BIT		(0)
#define AW88399_PLLS_LOCKED		(1)
#define AW88399_PLLS_LOCKED_VALUE	\
	(AW88399_PLLS_LOCKED << AW88399_PLLS_START_BIT)

#define AW88399_CLKS_START_BIT		(4)
#define AW88399_CLKS_STABLE		(1)
#define AW88399_CLKS_STABLE_VALUE	\
	(AW88399_CLKS_STABLE << AW88399_CLKS_START_BIT)

#define AW88399_BIT_PLL_CHECK \
		(AW88399_CLKS_STABLE_VALUE | \
		AW88399_PLLS_LOCKED_VALUE)

#define AW88399_BIT_SYSST_CHECK_MASK \
		(~(AW88399_UVLS_NORMAL_VALUE | \
		AW88399_BSTOCS_OVER_CURRENT_VALUE | \
		AW88399_BSTS_FINISHED_VALUE | \
		AW88399_SWS_SWITCHING_VALUE | \
		AW88399_NOCLKS_NO_CLOCK_VALUE | \
		AW88399_CLKS_STABLE_VALUE | \
		AW88399_OCDS_OC_VALUE | \
		AW88399_OTHS_OT_VALUE | \
		AW88399_PLLS_LOCKED_VALUE))

#define AW88399_BIT_SYSST_NOSWS_CHECK \
		(AW88399_BSTS_FINISHED_VALUE | \
		AW88399_CLKS_STABLE_VALUE | \
		AW88399_PLLS_LOCKED_VALUE)

#define AW88399_BIT_SYSST_SWS_CHECK \
		(AW88399_BSTS_FINISHED_VALUE | \
		AW88399_CLKS_STABLE_VALUE | \
		AW88399_PLLS_LOCKED_VALUE | \
		AW88399_SWS_SWITCHING_VALUE)

#define AW88399_CCO_MUX_START_BIT	(14)
#define AW88399_CCO_MUX_BITS_LEN	(1)
#define AW88399_CCO_MUX_MASK		\
	(~(((1<<AW88399_CCO_MUX_BITS_LEN)-1) << AW88399_CCO_MUX_START_BIT))

#define AW88399_CCO_MUX_DIVIDED	(0)
#define AW88399_CCO_MUX_DIVIDED_VALUE	\
	(AW88399_CCO_MUX_DIVIDED << AW88399_CCO_MUX_START_BIT)

#define AW88399_CCO_MUX_BYPASS		(1)
#define AW88399_CCO_MUX_BYPASS_VALUE	\
	(AW88399_CCO_MUX_BYPASS << AW88399_CCO_MUX_START_BIT)

#define AW88399_NOISE_GATE_EN_START_BIT	(13)
#define AW88399_NOISE_GATE_EN_BITS_LEN		(1)
#define AW88399_NOISE_GATE_EN_MASK	\
	(~(((1<<AW88399_NOISE_GATE_EN_BITS_LEN)-1) << AW88399_NOISE_GATE_EN_START_BIT))

#define AW88399_WDT_CNT_START_BIT	(0)
#define AW88399_WDT_CNT_BITS_LEN	(8)
#define AW88399_WDT_CNT_MASK		\
	(~(((1<<AW88399_WDT_CNT_BITS_LEN)-1) << AW88399_WDT_CNT_START_BIT))

#define AW88399_VOLUME_STEP_DB			(64)
#define AW88399_VOL_DEFAULT_VALUE		(0)
#define AW88399_DSP_ODD_NUM_BIT_TEST		(0x5555)
#define AW88399_EF_ISN_GESLP_SIGN_MASK		(~(1 << 9))
#define AW88399_EF_ISN_GESLP_SIGN_NEG		(0xfe00)

#define AW88399_EF_VSN_GESLP_SIGN_MASK		(~(1 << 9))
#define AW88399_EF_VSN_GESLP_SIGN_NEG		(0xfe00)

#define AW88399_TEM4_SIGN_MASK			(~(1 << 5))
#define AW88399_TEM4_SIGN_NEG			(0xffc0)

#define AW88399_ICABLK_FACTOR			(1)
#define AW88399_VCABLK_FACTOR			(1)
#define AW88399_VCABLK_DAC_FACTOR		(2)

#define AW88399_VCALB_ADJ_FACTOR		(12)
#define AW88399_VCALB_ACCURACY			(1 << 12)

#define AW88399_ISCAL_FACTOR			(3125)
#define AW88399_VSCAL_FACTOR			(18875)
#define AW88399_ISCAL_DAC_FACTOR		(3125)
#define AW88399_VSCAL_DAC_FACTOR		(12600)
#define AW88399_CABL_BASE_VALUE		(1000)

#define AW88399_DEV_DEFAULT_CH			(0)
#define AW88399_DEV_DSP_CHECK_MAX		(5)
#define AW88399_MAX_RAM_WRITE_BYTE_SIZE	(128)
#define AW88399_DSP_RE_SHIFT			(12)
#define AW88399_CALI_RE_MAX			(15000)
#define AW88399_CALI_RE_MIN			(4000)
#define AW_FW_ADDR_LEN				(4)
#define AW88399_DSP_RE_TO_SHOW_RE(re, shift)	(((re) * (1000)) >> (shift))
#define AW88399_SHOW_RE_TO_DSP_RE(re, shift)	(((re) << shift) / (1000))
#define AW88399_CRC_CHECK_PASS_VAL		(0x4)

#define AW88399_CRC_CFG_BASE_ADDR		(0xD80)
#define AW88399_CRC_FW_BASE_ADDR		(0x4C0)
#define AW88399_ACF_FILE			"/*(DEBLOBBED)*/"
#define AW88399_DEV_SYSST_CHECK_MAX		(10)

#define AW88399_I2C_NAME			"aw88399"

#define AW88399_START_RETRIES			(5)
#define AW88399_START_WORK_DELAY_MS		(0)

#define AW88399_RATES (SNDRV_PCM_RATE_8000_48000 | \
			SNDRV_PCM_RATE_96000)
#define AW88399_FORMATS (SNDRV_PCM_FMTBIT_S16_LE | \
			SNDRV_PCM_FMTBIT_S24_LE | \
			SNDRV_PCM_FMTBIT_S32_LE)

#define FADE_TIME_MAX		100000
#define FADE_TIME_MIN		0

#define AW88399_PROFILE_EXT(xname, profile_info, profile_get, profile_set) \
{ \
	.iface = SNDRV_CTL_ELEM_IFACE_MIXER, \
	.name = xname, \
	.info = profile_info, \
	.get = profile_get, \
	.put = profile_set, \
}

enum {
	AW_EF_AND_CHECK = 0,
	AW_EF_OR_CHECK,
};

enum {
	AW88399_DEV_VDSEL_DAC = 0,
	AW88399_DEV_VDSEL_VSENSE = 32,
};

enum {
	AW88399_DSP_CRC_NA = 0,
	AW88399_DSP_CRC_OK = 1,
};

enum {
	AW88399_DSP_FW_UPDATE_OFF = 0,
	AW88399_DSP_FW_UPDATE_ON = 1,
};

enum {
	AW88399_FORCE_UPDATE_OFF = 0,
	AW88399_FORCE_UPDATE_ON = 1,
};

enum {
	AW88399_1000_US = 1000,
	AW88399_2000_US = 2000,
	AW88399_3000_US = 3000,
	AW88399_4000_US = 4000,
};

enum AW88399_DEV_STATUS {
	AW88399_DEV_PW_OFF = 0,
	AW88399_DEV_PW_ON,
};

enum AW88399_DEV_FW_STATUS {
	AW88399_DEV_FW_FAILED = 0,
	AW88399_DEV_FW_OK,
};

enum AW88399_DEV_MEMCLK {
	AW88399_DEV_MEMCLK_OSC = 0,
	AW88399_DEV_MEMCLK_PLL = 1,
};

enum AW88399_DEV_DSP_CFG {
	AW88399_DEV_DSP_WORK = 0,
	AW88399_DEV_DSP_BYPASS = 1,
};

enum {
	AW88399_DSP_16_DATA = 0,
	AW88399_DSP_32_DATA = 1,
};

enum {
	AW88399_NOT_RCV_MODE = 0,
	AW88399_RCV_MODE = 1,
};

enum {
	AW88399_SYNC_START = 0,
	AW88399_ASYNC_START,
};

struct aw88399 {
	struct aw_device *aw_pa;
	struct mutex lock;
	struct gpio_desc *reset_gpio;
	struct delayed_work start_work;
	struct regmap *regmap;
	struct aw_container *aw_cfg;

	unsigned int check_val;
	unsigned int crc_init_val;
	unsigned int vcalb_init_val;
	unsigned int dither_st;
};

#endif
