/* $NoKeywords:$ */
/**
 * @file
 *
 * AMD FCH Component
 *
 *
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:     AGESA
 * @e sub-project: FCH
 *
 */
/*
*****************************************************************************
*
 * Copyright (c) 2008 - 2012, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* ***************************************************************************
*
*/

#ifndef _AMD_FCH_H_
#define _AMD_FCH_H_

typedef AGESA_STATUS FCH_INIT (IN VOID *DataPtr);
typedef VOID FCH_TASK_ENTRY (IN VOID *FchCfg);


/// FCH API build options
typedef struct {
  FCH_INIT        *InitReset;                   ///< InitReset
  FCH_INIT        *InitResetConstructor;        ///< InitResetConstructor
  FCH_INIT        *InitEnv;                     ///< InitEnv
  FCH_INIT        *InitEnvConstructor;          ///< InitEnvConstructor
  FCH_INIT        *InitMid;                     ///< InitMid
  FCH_INIT        *InitMidConstructor;          ///< InitMidConstructor
  FCH_INIT        *InitLate;                    ///< InitLate
  FCH_INIT        *InitLateConstructor;         ///< InitLateConstructor
} BLDOPT_FCH_FUNCTION;

#endif
