/* $NoKeywords:$ */
/**
 * @file
 *
 * Collectively assign unique filecodes for assert and debug to each source file.
 *
 * Publish values for decorated filenames, which can be used for
 * ASSERT and debug support using a preprocessor define like:
 * @n <tt> \#define FILECODE MY_C_FILENAME_FILECODE </tt> @n
 * This file serves as a reference for debugging to associate the code and filename.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  Include
 * @e \$Revision: 86079 $   @e \$Date: 2013-01-16 00:59:04 -0600 (Wed, 16 Jan 2013) $
 */
/*****************************************************************************
 *
 * Copyright (c) 2008 - 2013, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#ifndef _FILECODE_H_
#define _FILECODE_H_

#define UNASSIGNED_FILE_FILECODE                                         (0xFFFF)

/// For debug use in any Platform's options C file.
/// Can be reused for platforms and image builds, since only one options file can be built.
#define PLATFORM_SPECIFIC_OPTIONS_FILECODE                               (0xBBBB)


#define PROC_GNB_COMMON_GNBLIBFEATURES_FILECODE                          (0xA001)
#define PROC_GNB_GNBINITATEARLY_FILECODE                                 (0xA017)
#define PROC_GNB_GNBINITATENV_FILECODE                                   (0xA020)
#define PROC_GNB_GNBINITATLATE_FILECODE                                  (0xA021)
#define PROC_GNB_GNBINITATMID_FILECODE                                   (0xA022)
#define PROC_GNB_GNBINITATPOST_FILECODE                                  (0xA023)
#define PROC_GNB_GNBINITATRESET_FILECODE                                 (0xA024)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIB_FILECODE                    (0xA025)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBCPUACC_FILECODE              (0xA026)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBHEAP_FILECODE                (0xA027)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBIOACC_FILECODE               (0xA028)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBMEMACC_FILECODE              (0xA029)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCI_FILECODE                 (0xA02A)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBLIBPCIACC_FILECODE              (0xA030)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXCARDINFO_FILECODE            (0xA031)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXENUMCONNECTORS_FILECODE      (0xA032)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GFXPOWERPLAYTABLE_FILECODE      (0xA033)
#define PROC_GNB_MODULES_GNBNBINITLIBV1_GNBNBINITLIBV1_FILECODE          (0xA034)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGDATA_FILECODE           (0xA036)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIECONFIGLIB_FILECODE            (0xA037)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEINPUTPARSER_FILECODE          (0xA038)
#define PROC_GNB_MODULES_GNBPCIECONFIG_PCIEMAPTOPOLOGY_FILECODE          (0xA039)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMBLACKLIST_FILECODE     (0xA03B)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEASPMEXITLATENCY_FILECODE   (0xA03C)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPHYSERVICES_FILECODE       (0xA03D)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPIFSERVICES_FILECODE       (0xA03E)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTREGACC_FILECODE        (0xA03F)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPORTSERVICES_FILECODE      (0xA041)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEPOWERMGMT_FILECODE         (0xA043)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIESILICONSERVICES_FILECODE   (0xA045)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETIMER_FILECODE             (0xA046)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIETOPOLOGYSERVICES_FILECODE  (0xA047)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEUTILITYLIB_FILECODE        (0xA048)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV1_PCIEWRAPPERREGACC_FILECODE     (0xA049)

#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGENV_FILECODE              (0xA08E)
#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGPOST_FILECODE             (0xA08F)
#define PROC_GNB_MODULES_GNBTABLE_GNBTABLE_FILECODE                      (0xA090)
#define PROC_GNB_MODULES_GNBGFXINITLIBV1_GNBGFXINITLIBV1_FILECODE        (0xA091)
#define PROC_GNB_MODULES_GNBIVRSLIB_GNBIVRSLIB_FILECODE                  (0xA0A8)
#define PROC_GNB_MODULES_GNBNBINITLIBV4_GNBNBINITLIBV4_FILECODE          (0xA0A9)
#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBPCIETRANSLATION_FILECODE   (0xA0AA)

#define PROC_GNB_MODULES_GNBSBLIB_GNBSBPCIE_FILECODE                     (0xA0BA)
#define PROC_GNB_MODULES_GNBSBLIB_GNBSBLIB_FILECODE                      (0xA0BB)
#define PROC_GNB_MODULES_GNBCOMMONLIB_GNBTIMERLIB_FILECODE               (0xA0BD)
#define PROC_GNB_MODULES_GNBPCIECONFIG_GNBHANDLELIB_FILECODE             (0xA0C0)
#define PROC_GNB_MODULES_GNBPCIEASPM_PCIEASPM_FILECODE                   (0xA0C2)

#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPHYSERVICESV5_FILECODE     (0xA0C5)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPIFSERVICESV5_FILECODE     (0xA0C6)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPORTSERVICESV5_FILECODE    (0xA0C7)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEPOWERMGMTV5_FILECODE       (0xA0C8)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIESILICONSERVICESV5_FILECODE (0xA0C9)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIEWRAPPERSERVICESV5_FILECODE (0xA0CA)
#define PROC_GNB_MODULES_GNBNBINITLIBV5_GNBNBINITLIBV5_FILECODE          (0xA0CB)


#define PROC_GNB_MODULES_GNBFAMTRANSLATION_GNBTRANSLATION_FILECODE       (0xA0DB)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPOWERMGMTV4_FILECODE       (0xA0DC)
#define PROC_GNB_MODULES_GNBPCIEINITLIBV4_PCIEPORTSERVICESV4_FILECODE    (0xA0DD)

#define PROC_GNB_MODULES_GNBGFXCONFIG_GFXCONFIGMID_FILECODE              (0xA0E0)

#define PROC_GNB_MODULES_GNBIOAPIC_GNBIOAPIC_FILECODE                    (0xA0EE)

#define PROC_GNB_MODULES_GNBPCIEMAXPAYLOAD_PCIEMAXPAYLOAD_FILECODE       (0xA0F4)
#define PROC_GNB_MODULES_GNBPCIECLKPM_PCIECLKPM_FILECODE                 (0xA0F5)

#define PROC_GNB_MODULES_GNBPCIEINITLIBV5_PCIETOPOLOGYSERVICESV5_FILECODE (0xA100)
#define PROC_GNB_MODULES_GNBPCIETRAININGV2_PCIETRAININGV2_FILECODE        (0xA101)
#define PROC_GNB_MODULES_GNBPCIETRAININGV2_PCIEWORKAROUNDSV2_FILECODE     (0xA102)

#define PROC_RECOVERY_GNB_GNBRECOVERY_FILECODE                           (0xAE01)
#define PROC_RECOVERY_GNB_NBINITRECOVERY_FILECODE                        (0xAE02)
#define PROC_GNB_GNBINITATS3SAVE_FILECODE                                (0xAE03)
#define PROC_GNB_MODULES_GNBSVIEW_GNBSVIEW_FILECODE                      (0xAE04)


#define PROC_GNB_MODULES_GNBINITKB_GFXENVINITKB_FILECODE                 (0xAE20)
#define PROC_GNB_MODULES_GNBINITKB_GFXINTEGRATEDINFOTABLEKB_FILECODE     (0xAE21)
#define PROC_GNB_MODULES_GNBINITKB_GFXMIDINITKB_FILECODE                 (0xAE22)
#define PROC_GNB_MODULES_GNBINITKB_GFXPOSTINITKB_FILECODE                (0xAE23)
#define PROC_GNB_MODULES_GNBINITKB_GFXLIBKB_FILECODE                     (0xAE24)
#define PROC_GNB_MODULES_GNBINITKB_GNBEARLYINITKB_FILECODE               (0xAE25)
#define PROC_GNB_MODULES_GNBINITKB_GNBENVINITKB_FILECODE                 (0xAE26)
#define PROC_GNB_MODULES_GNBINITKB_GNBMIDINITKB_FILECODE                 (0xAE27)
#define PROC_GNB_MODULES_GNBINITKB_GNBPOSTINITKB_FILECODE                (0xAE28)
#define PROC_GNB_MODULES_GNBINITKB_GNBREGISTERACCKB_FILECODE             (0xAE29)
#define PROC_GNB_MODULES_GNBINITKB_PCIECOMPLEXDATAKB_FILECODE            (0xAE2A)
#define PROC_GNB_MODULES_GNBINITKB_PCIECONFIGKB_FILECODE                 (0xAE2B)
#define PROC_GNB_MODULES_GNBINITKB_PCIEEARLYINITKB_FILECODE              (0xAE2C)
#define PROC_GNB_MODULES_GNBINITKB_PCIEENVINITKB_FILECODE                (0xAE2D)
#define PROC_GNB_MODULES_GNBINITKB_PCIEMIDINITKB_FILECODE                (0xAE2F)
#define PROC_GNB_MODULES_GNBINITKB_PCIEPOSTINITKB_FILECODE               (0xAE30)
#define PROC_GNB_MODULES_GNBINITKB_PCIELIBKB_FILECODE                    (0xAE31)
#define PROC_GNB_MODULES_GNBINITKB_GFXGMCINITKB_FILECODE                 (0xAE32)
#define PROC_GNB_MODULES_GNBPCIEALIBV2_PCIEALIBV2_FILECODE               (0xAE33)
#define PROC_GNB_MODULES_GNBINITKV_ALIBKVD_FILECODE                      (0xAE34)
#define PROC_GNB_MODULES_GNBINITKV_GNBREGISTERXLATKV_FILECODE            (0xAE37)
#define PROC_GNB_MODULES_GNBINITKV_GNBFUSETABLEKV_FILECODE               (0xAE39)
#define PROC_GNB_MODULES_GNBINITKV_GNBURAKV_FILECODE                     (0xAE3B)
#define PROC_GNB_MODULES_GNBINITKB_GNBURATOKENMAPKB_FILECODE             (0xAE3E)
#define PROC_GNB_MODULES_GNBINITBK_GNBURABK_FILECODE                     (0xAE3F)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV3_GFXINTEGRATEDINFOTABLE_FILECODE (0xAE42)
#define PROC_GNB_MODULES_GNBGFXINTTABLEV3_GFXPWRPLAYTABLE_FILECODE       (0xAE43)
#define PROC_GNB_MODULES_GNBSCSLIBV1_GNBSCSLIBV1_FILECODE                (0xAE44)
#define PROC_GNB_MODULES_GNBINITKB_GFXSAMUINITKB_FILECODE                (0xAE45)

#define PROC_GNB_MODULES_GNBINITML_GFXENVINITML_FILECODE                 (0xAE50)

// FCH
#define PROC_FCH_AZALIA_AZALIARESET_FILECODE                             (0xB001)
#define PROC_FCH_AZALIA_AZALIAENV_FILECODE                               (0xB002)
#define PROC_FCH_AZALIA_AZALIAMID_FILECODE                               (0xB003)
#define PROC_FCH_AZALIA_AZALIALATE_FILECODE                              (0xB004)
#define PROC_FCH_COMMON_ACPILIB_FILECODE                                 (0xB010)
#define PROC_FCH_COMMON_FCHLIB_FILECODE                                  (0xB011)
#define PROC_FCH_COMMON_FCHCOMMON_FILECODE                               (0xB012)
#define PROC_FCH_COMMON_FCHCOMMONSMM_FILECODE                            (0xB013)
#define PROC_FCH_COMMON_MEMLIB_FILECODE                                  (0xB014)
#define PROC_FCH_COMMON_PCILIB_FILECODE                                  (0xB015)
#define PROC_FCH_COMMON_FCHPELIB_FILECODE                                (0xB016)
#define PROC_FCH_GEC_GECRESET_FILECODE                                   (0xB020)
#define PROC_FCH_GEC_GECENV_FILECODE                                     (0xB021)
#define PROC_FCH_GEC_GECMID_FILECODE                                     (0xB022)
#define PROC_FCH_GEC_GECLATE_FILECODE                                    (0xB023)
#define PROC_FCH_GEC_FAMILY_YANGTZE_YANGTZEGECSERVICE_FILECODE           (0xB028)
#define PROC_FCH_GEC_FAMILY_YANGTZE_YANGTZEGECENVSERVICE_FILECODE        (0xB029)
#define PROC_FCH_HWACPI_HWACPIRESET_FILECODE                             (0xB030)
#define PROC_FCH_HWACPI_HWACPIENV_FILECODE                               (0xB031)
#define PROC_FCH_HWACPI_HWACPIMID_FILECODE                               (0xB032)
#define PROC_FCH_HWACPI_HWACPILATE_FILECODE                              (0xB033)
#define PROC_FCH_HWACPI_FAMILY_YANGTZE_YANGTZEHWACPIENVSERVICE_FILECODE  (0xB03C)
#define PROC_FCH_HWACPI_FAMILY_YANGTZE_YANGTZEHWACPIMIDSERVICE_FILECODE  (0xB03D)
#define PROC_FCH_HWACPI_FAMILY_YANGTZE_YANGTZEHWACPILATESERVICE_FILECODE (0xB03E)
#define PROC_FCH_HWACPI_FAMILY_YANGTZE_YANGTZESSSERVICE_FILECODE         (0xB03F)
#define PROC_FCH_HWM_HWMRESET_FILECODE                                   (0xB050)
#define PROC_FCH_HWM_HWMENV_FILECODE                                     (0xB051)
#define PROC_FCH_HWM_HWMMID_FILECODE                                     (0xB052)
#define PROC_FCH_HWM_HWMLATE_FILECODE                                    (0xB053)
#define PROC_FCH_HWM_FAMILY_YANGTZE_YANGTZEHWMENVSERVICE_FILECODE        (0xB05A)
#define PROC_FCH_HWM_FAMILY_YANGTZE_YANGTZEHWMMIDSERVICE_FILECODE        (0xB05B)
#define PROC_FCH_HWM_FAMILY_YANGTZE_YANGTZEHWMLATESERVICE_FILECODE       (0xB05C)
#define PROC_FCH_IMC_IMCENV_FILECODE                                     (0xB060)
#define PROC_FCH_IMC_IMCMID_FILECODE                                     (0xB061)
#define PROC_FCH_IMC_IMCLATE_FILECODE                                    (0xB062)
#define PROC_FCH_IMC_IMCLIB_FILECODE                                     (0xB063)
#define PROC_FCH_IMC_IMCRESET_FILECODE                                   (0xB064)
#define PROC_FCH_IMC_FCHECENV_FILECODE                                   (0xB065)
#define PROC_FCH_IMC_FCHECMID_FILECODE                                   (0xB066)
#define PROC_FCH_IMC_FCHECLATE_FILECODE                                  (0xB067)
#define PROC_FCH_IMC_FCHECRESET_FILECODE                                 (0xB068)
#define PROC_FCH_IMC_FAMILY_HUDSON2_HUDSON2IMCSERVICE_FILECODE           (0xB069)
#define PROC_FCH_IMC_FAMILY_YUBA_YUBAIMCSERVICE_FILECODE                 (0xB06A)
#define PROC_FCH_IMC_FAMILY_YANGTZE_YANGTZEIMCSERVICE_FILECODE           (0xB06B)
#define PROC_FCH_IMC_FAMILY_AVALON_AVALONIMCSERVICE_FILECODE             (0xB36B)
#define PROC_FCH_IDE_IDEENV_FILECODE                                     (0xB06D)
#define PROC_FCH_IDE_IDEMID_FILECODE                                     (0xB06E)
#define PROC_FCH_IDE_IDELATE_FILECODE                                    (0xB06F)
#define PROC_FCH_INTERFACE_INITRESETDEF_FILECODE                         (0xB070)
#define PROC_FCH_INTERFACE_INITENVDEF_FILECODE                           (0xB071)
#define PROC_FCH_INTERFACE_FCHINITRESET_FILECODE                         (0xB072)
#define PROC_FCH_INTERFACE_FCHINITENV_FILECODE                           (0xB073)
#define PROC_FCH_INTERFACE_FCHINITLATE_FILECODE                          (0xB074)
#define PROC_FCH_INTERFACE_FCHINITMID_FILECODE                           (0xB075)
#define PROC_FCH_INTERFACE_FCHINITS3_FILECODE                            (0xB076)
#define PROC_FCH_INTERFACE_FCHTASKLAUNCHER_FILECODE                      (0xB077)
#define PROC_FCH_IR_IRENV_FILECODE                                       (0xB080)
#define PROC_FCH_IR_IRMID_FILECODE                                       (0xB081)
#define PROC_FCH_IR_IRLATE_FILECODE                                      (0xB082)
#define PROC_FCH_PCIB_PCIBRESET_FILECODE                                 (0xB090)
#define PROC_FCH_PCIB_PCIBENV_FILECODE                                   (0xB091)
#define PROC_FCH_PCIB_PCIBMID_FILECODE                                   (0xB092)
#define PROC_FCH_PCIB_PCIBLATE_FILECODE                                  (0xB093)
#define PROC_FCH_PCIE_ABRESET_FILECODE                                   (0xB0A0)
#define PROC_FCH_PCIE_ABENV_FILECODE                                     (0xB0A1)
#define PROC_FCH_PCIE_ABMID_FILECODE                                     (0xB0A2)
#define PROC_FCH_PCIE_ABLATE_FILECODE                                    (0xB0A3)
#define PROC_FCH_PCIE_GPPHP_FILECODE                                     (0xB0A4)
#define PROC_FCH_PCIE_GPPLIB_FILECODE                                    (0xB0A5)
#define PROC_FCH_PCIE_GPPRESET_FILECODE                                  (0xB0A6)
#define PROC_FCH_PCIE_GPPENV_FILECODE                                    (0xB0A7)
#define PROC_FCH_PCIE_GPPMID_FILECODE                                    (0xB0A8)
#define PROC_FCH_PCIE_GPPLATE_FILECODE                                   (0xB0A9)
#define PROC_FCH_PCIE_PCIERESET_FILECODE                                 (0xB0AA)
#define PROC_FCH_PCIE_PCIEENV_FILECODE                                   (0xB0AB)
#define PROC_FCH_PCIE_PCIEMID_FILECODE                                   (0xB0AC)
#define PROC_FCH_PCIE_PCIELATE_FILECODE                                  (0xB0AD)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABRESETSERVICE_FILECODE      (0xB0AE)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABENVSERVICE_FILECODE        (0xB0AF)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2ABSERVICE_FILECODE           (0xB0B0)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2GPPRESETSERVICE_FILECODE     (0xB0B1)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2GPPSERVICE_FILECODE          (0xB0B2)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2PCIEENVSERVICE_FILECODE      (0xB0B3)
#define PROC_FCH_PCIE_FAMILY_HUDSON2_HUDSON2PCIESERVICE_FILECODE         (0xB0B4)
#define PROC_FCH_PCIE_FAMILY_YUBA_YUBAABRESETSERVICE_FILECODE            (0xB0B5)
#define PROC_FCH_PCIE_FAMILY_YUBA_YUBAABENVSERVICE_FILECODE              (0xB0B6)
#define PROC_FCH_PCIE_FAMILY_YUBA_YUBAABSERVICE_FILECODE                 (0xB0B7)
#define PROC_FCH_PCIE_FAMILY_YANGTZE_YANGTZEABRESETSERVICE_FILECODE      (0xB0B8)
#define PROC_FCH_PCIE_FAMILY_YANGTZE_YANGTZEABENVSERVICE_FILECODE        (0xB0B9)
#define PROC_FCH_PCIE_FAMILY_YANGTZE_YANGTZEABSERVICE_FILECODE           (0xB0BA)
#define PROC_FCH_PCIE_FAMILY_AVALON_AVALONABRESETSERVICE_FILECODE        (0xB3B8)
#define PROC_FCH_PCIE_FAMILY_AVALON_AVALONABENVSERVICE_FILECODE          (0xB3B9)
#define PROC_FCH_PCIE_FAMILY_AVALON_AVALONABSERVICE_FILECODE             (0xB3BA)
#define PROC_FCH_SATA_AHCIENV_FILECODE                                   (0xB0C0)
#define PROC_FCH_SATA_AHCIMID_FILECODE                                   (0xB0C1)
#define PROC_FCH_SATA_AHCILATE_FILECODE                                  (0xB0C2)
#define PROC_FCH_SATA_AHCILIB_FILECODE                                   (0xB0C3)
#define PROC_FCH_SATA_IDE2AHCIENV_FILECODE                               (0xB0C4)
#define PROC_FCH_SATA_IDE2AHCIMID_FILECODE                               (0xB0C5)
#define PROC_FCH_SATA_IDE2AHCILATE_FILECODE                              (0xB0C6)
#define PROC_FCH_SATA_IDE2AHCILIB_FILECODE                               (0xB0C7)
#define PROC_FCH_SATA_RAIDENV_FILECODE                                   (0xB0C8)
#define PROC_FCH_SATA_RAIDMID_FILECODE                                   (0xB0C9)
#define PROC_FCH_SATA_RAIDLATE_FILECODE                                  (0xB0CA)
#define PROC_FCH_SATA_RAIDLIB_FILECODE                                   (0xB0CB)
#define PROC_FCH_SATA_SATAENV_FILECODE                                   (0xB0CC)
#define PROC_FCH_SATA_SATAENVLIB_FILECODE                                (0xB0CD)
#define PROC_FCH_SATA_SATAIDEENV_FILECODE                                (0xB0CE)
#define PROC_FCH_SATA_SATAIDEMID_FILECODE                                (0xB0CF)
#define PROC_FCH_SATA_SATAIDELATE_FILECODE                               (0xB0D0)
#define PROC_FCH_SATA_SATAIDELIB_FILECODE                                (0xB0D1)
#define PROC_FCH_SATA_SATAMID_FILECODE                                   (0xB0D2)
#define PROC_FCH_SATA_SATALATE_FILECODE                                  (0xB0D3)
#define PROC_FCH_SATA_SATALIB_FILECODE                                   (0xB0D4)
#define PROC_FCH_SATA_SATARESET_FILECODE                                 (0xB0D5)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATARESETSERVICE_FILECODE    (0xB0D6)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATAENVSERVICE_FILECODE      (0xB0D7)
#define PROC_FCH_SATA_FAMILY_HUDSON2_HUDSON2SATASERVICE_FILECODE         (0xB0D8)
#define PROC_FCH_SATA_FAMILY_YUBA_YUBASATARESETSERVICE_FILECODE          (0xB0D9)
#define PROC_FCH_SATA_FAMILY_YUBA_YUBASATAENVSERVICE_FILECODE            (0xB0DA)
#define PROC_FCH_SATA_FAMILY_YUBA_YUBASATASERVICE_FILECODE               (0xB0DB)
#define PROC_FCH_SATA_FAMILY_YANGTZE_YANGTZESATARESETSERVICE_FILECODE    (0xB0DC)
#define PROC_FCH_SATA_FAMILY_YANGTZE_YANGTZESATAENVSERVICE_FILECODE      (0xB0DD)
#define PROC_FCH_SATA_FAMILY_YANGTZE_YANGTZESATASERVICE_FILECODE         (0xB0DE)
#define PROC_FCH_SD_SDENV_FILECODE                                       (0xB0E0)
#define PROC_FCH_SD_SDMID_FILECODE                                       (0xB0E1)
#define PROC_FCH_SD_SDLATE_FILECODE                                      (0xB0E2)
#define PROC_FCH_SD_FAMILY_YANGTZE_YANGTZESDSERVICE_FILECODE             (0xB0E9)
#define PROC_FCH_SD_FAMILY_YANGTZE_YANGTZESDRESETSERVICE_FILECODE        (0xB0EA)
#define PROC_FCH_SD_FAMILY_YANGTZE_YANGTZESDENVSERVICE_FILECODE          (0xB0EB)
#define PROC_FCH_SPI_LPCRESET_FILECODE                                   (0xB0F0)
#define PROC_FCH_SPI_LPCENV_FILECODE                                     (0xB0F1)
#define PROC_FCH_SPI_LPCMID_FILECODE                                     (0xB0F2)
#define PROC_FCH_SPI_LPCLATE_FILECODE                                    (0xB0F3)
#define PROC_FCH_SPI_SPIRESET_FILECODE                                   (0xB0F4)
#define PROC_FCH_SPI_SPIENV_FILECODE                                     (0xB0F5)
#define PROC_FCH_SPI_SPIMID_FILECODE                                     (0xB0F6)
#define PROC_FCH_SPI_SPILATE_FILECODE                                    (0xB0F7)
#define PROC_FCH_SPI_FAMILY_YANGTZE_YANGTZELPCENVSERVICE_FILECODE        (0xB0FE)
#define PROC_FCH_SPI_FAMILY_YANGTZE_YANGTZELPCRESETSERVICE_FILECODE      (0xB0FF)
#define PROC_FCH_USB_EHCIRESET_FILECODE                                  (0xB100)
#define PROC_FCH_USB_EHCIENV_FILECODE                                    (0xB101)
#define PROC_FCH_USB_EHCIMID_FILECODE                                    (0xB102)
#define PROC_FCH_USB_EHCILATE_FILECODE                                   (0xB103)
#define PROC_FCH_USB_OHCIRESET_FILECODE                                  (0xB104)
#define PROC_FCH_USB_OHCIENV_FILECODE                                    (0xB105)
#define PROC_FCH_USB_OHCIMID_FILECODE                                    (0xB106)
#define PROC_FCH_USB_OHCILATE_FILECODE                                   (0xB107)
#define PROC_FCH_USB_USBRESET_FILECODE                                   (0xB108)
#define PROC_FCH_USB_USBENV_FILECODE                                     (0xB109)
#define PROC_FCH_USB_USBMID_FILECODE                                     (0xB10A)
#define PROC_FCH_USB_USBLATE_FILECODE                                    (0xB10B)
#define PROC_FCH_USB_XHCIRESET_FILECODE                                  (0xB10C)
#define PROC_FCH_USB_XHCIENV_FILECODE                                    (0xB10D)
#define PROC_FCH_USB_XHCIMID_FILECODE                                    (0xB10E)
#define PROC_FCH_USB_XHCILATE_FILECODE                                   (0xB10F)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEEHCIENVSERVICE_FILECODE       (0xB124)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEEHCIMIDSERVICE_FILECODE       (0xB125)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEEHCILATESERVICE_FILECODE      (0xB126)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEOHCIENVSERVICE_FILECODE       (0xB127)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEOHCIMIDSERVICE_FILECODE       (0xB128)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEOHCILATESERVICE_FILECODE      (0xB129)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEXHCIRESETSERVICE_FILECODE     (0xB12A)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEXHCIENVSERVICE_FILECODE       (0xB12B)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEXHCIMIDSERVICE_FILECODE       (0xB12C)
#define PROC_FCH_USB_FAMILY_YANGTZE_YANGTZEXHCILATESERVICE_FILECODE      (0xB12D)
#define PROC_FCH_USB_XHCIRECOVERY_FILECODE                               (0xB12E)
#define PROC_FCH_PCIE_GPPPORTINIT_FILECODE                               (0xB12F)
#define PROC_FCH_PCIE_GPPALLINONE_FILECODE                               (0xB2C0)

#define LIB_AMDLIB_FILECODE                                              (0xC001)

#define LEGACY_PROC_AGESACALLOUTS_FILECODE                               (0xC010)
#define LEGACY_PROC_HOBTRANSFER_FILECODE                                 (0xC011)
#define LEGACY_PROC_DISPATCHER_FILECODE                                  (0xC012)


#define PROC_COMMON_AMDINITEARLY_FILECODE                                (0xC020)
#define PROC_COMMON_AMDINITENV_FILECODE                                  (0xC021)
#define PROC_COMMON_AMDINITLATE_FILECODE                                 (0xC022)
#define PROC_COMMON_AMDINITMID_FILECODE                                  (0xC023)
#define PROC_COMMON_AMDINITPOST_FILECODE                                 (0xC024)
#define PROC_COMMON_AMDINITRECOVERY_FILECODE                             (0xC025)
#define PROC_COMMON_AMDINITRESET_FILECODE                                (0xC026)
#define PROC_COMMON_AMDINITRESUME_FILECODE                               (0xC027)
#define PROC_COMMON_AMDS3LATERESTORE_FILECODE                            (0xC028)
#define PROC_COMMON_AMDS3SAVE_FILECODE                                   (0xC029)
#define PROC_COMMON_AMDLATERUNAPTASK_FILECODE                            (0xC02A)

#define PROC_COMMON_COMMONRETURNS_FILECODE                               (0xC0C0)
#define PROC_COMMON_CREATESTRUCT_FILECODE                                (0xC0D0)
#define PROC_COMMON_COMMONINITS_FILECODE                                 (0xC0F0)
#define PROC_COMMON_S3RESTORESTATE_FILECODE                              (0xC0F8)
#define PROC_COMMON_S3SAVESTATE_FILECODE                                 (0xC0F9)

#define PROC_CPU_CPUAPICUTILITIES_FILECODE                               (0xC401)
#define PROC_CPU_TABLE_FILECODE                                          (0xC403)
#define PROC_CPU_TABLEHT_FILECODE                                        (0xC404)
#define PROC_CPU_CPUEARLYINIT_FILECODE                                   (0xC405)
#define PROC_CPU_CPUEVENTLOG_FILECODE                                    (0xC406)
#define PROC_CPU_CPUFAMILYTRANSLATION_FILECODE                           (0xC407)
#define PROC_CPU_CPUGENERALSERVICES_FILECODE                             (0xC408)
#define PROC_CPU_CPULATEINIT_FILECODE                                    (0xC40A)
#define PROC_CPU_CPUMICROCODEPATCH_FILECODE                              (0xC40B)
#define PROC_CPU_CPUWARMRESET_FILECODE                                   (0xC40C)
#define PROC_CPU_HEAPMANAGER_FILECODE                                    (0xC40D)
#define PROC_CPU_CPUBIST_FILECODE                                        (0xC40E)
#define PROC_CPU_MMIOMAPMANAGER_FILECODE                                 (0xC40F)

#define PROC_CPU_CPUPOSTINIT_FILECODE                                    (0xC420)
#define PROC_CPU_CPUPOWERMGMT_FILECODE                                   (0xC430)
#define PROC_CPU_CPUPOWERMGMTMULTISOCKET_FILECODE                        (0xC431)
#define PROC_CPU_CPUPOWERMGMTSINGLESOCKET_FILECODE                       (0xC432)
#define PROC_CPU_S3_FILECODE                                             (0xC460)

// Family 15h



// Family 16h
#define PROC_CPU_FAMILY_0X16_CPUF16BRANDID_FILECODE                      (0xCC00)
#define PROC_CPU_FAMILY_0X16_CPUF16UTILITIES_FILECODE                    (0xCC01)
#define PROC_CPU_FAMILY_0X16_CPUF16WHEAINITDATATABLES_FILECODE           (0xCC02)
#define PROC_CPU_FAMILY_0X16_CPUF16CACHEDEFAULTS_FILECODE                (0xCC03)
#define PROC_CPU_FAMILY_0X16_CPUF16DMI_FILECODE                          (0xCC04)
#define PROC_CPU_FAMILY_0X16_CPUF16PCIUNKNOWNTABLES_FILECODE             (0xCC05)
#define PROC_CPU_FAMILY_0X16_CPUF16MSRUNKNOWNTABLES_FILECODE             (0xCC06)
#define PROC_CPU_FAMILY_0X16_CPUF16PSTATEHPCMODE_FILECODE                (0xCC07)
#define PROC_CPU_FAMILY_0X16_CPUF16MMIOMAP_FILECODE                      (0xCC08)
#define PROC_CPU_FAMILY_0X16_CPUF16PREFETCHMODE_FILECODE                 (0xCC09)
#define PROC_CPU_FAMILY_0X16_CPUF16APM_FILECODE                          (0xCC0A)
#define PROC_CPU_FAMILY_0X16_CPUF16CRAT_FILECODE                         (0xCC0B)

#define PROC_CPU_FAMILY_0X16_KB_F16KBLOGICALIDTABLES_FILECODE            (0xCC20)
#define PROC_CPU_FAMILY_0X16_KB_F16KBINITEARLYTABLE_FILECODE             (0xCC21)
#define PROC_CPU_FAMILY_0X16_KB_F16KBEQUIVALENCETABLE_FILECODE           (0xCC22)
#define PROC_CPU_FAMILY_0X16_KB_F16KBMICROCODEPATCHTABLES_FILECODE       (0xCC23)
#define PROC_CPU_FAMILY_0X16_KB_F16KBPCITABLES_FILECODE                  (0xCC24)
#define PROC_CPU_FAMILY_0X16_KB_F16KBMSRTABLES_FILECODE                  (0xCC25)
#define PROC_CPU_FAMILY_0X16_KB_F16KBSHAREDMSRTABLE_FILECODE             (0xCC26)
#define PROC_CPU_FAMILY_0X16_KB_F16KBUTILITIES_FILECODE                  (0xCC27)
#define PROC_CPU_FAMILY_0X16_KB_F16KBC6STATE_FILECODE                    (0xCC28)
#define PROC_CPU_FAMILY_0X16_KB_F16KBCOREAFTERRESET_FILECODE             (0xCC29)
#define PROC_CPU_FAMILY_0X16_KB_F16KBCPB_FILECODE                        (0xCC2A)
#define PROC_CPU_FAMILY_0X16_KB_F16KBDMI_FILECODE                        (0xCC2B)
#define PROC_CPU_FAMILY_0X16_KB_F16KBIOCSTATE_FILECODE                   (0xCC2C)
#define PROC_CPU_FAMILY_0X16_KB_F16KBNBAFTERRESET_FILECODE               (0xCC2D)
#define PROC_CPU_FAMILY_0X16_KB_F16KBPOWERCHECK_FILECODE                 (0xCC2E)
#define PROC_CPU_FAMILY_0X16_KB_F16KBPSTATE_FILECODE                     (0xCC2F)
#define PROC_CPU_FAMILY_0X16_KB_F16KBPSI_FILECODE                        (0xCC30)
#define PROC_CPU_FAMILY_0X16_KB_F16KBHTC_FILECODE                        (0xCC31)
#define PROC_CPU_FAMILY_0X16_KB_F16KBPOWERMGMTSYSTEMTABLES_FILECODE      (0xCC32)
#define PROC_CPU_FAMILY_0X16_KB_F16KBSCS_FILECODE                        (0xCC33)
#define PROC_CPU_FAMILY_0X16_KB_F16KBCACHEFLUSHONHALT_FILECODE           (0xCC34)


#define PROC_CPU_FEATURE_CPUCACHEFLUSHONHALT_FILECODE                    (0xDC01)
#define PROC_CPU_FEATURE_CPUCACHEINIT_FILECODE                           (0xDC02)
#define PROC_CPU_FEATURE_CPUDMI_FILECODE                                 (0xDC10)
#define PROC_CPU_FEATURE_CPUFEATURELEVELING_FILECODE                     (0xDC20)
#define PROC_CPU_FEATURE_CPUL3FEATURES_FILECODE                          (0xDC30)
#define PROC_CPU_FEATURE_CPUPSTATEGATHER_FILECODE                        (0xDC41)
#define PROC_CPU_FEATURE_CPUPSTATELEVELING_FILECODE                      (0xDC42)
#define PROC_CPU_FEATURE_CPUPSTATETABLES_FILECODE                        (0xDC43)
#define PROC_CPU_FEATURE_CPUSLIT_FILECODE                                (0xDC50)
#define PROC_CPU_FEATURE_CPUSRAT_FILECODE                                (0xDC60)
#define PROC_CPU_FEATURE_CPUWHEA_FILECODE                                (0xDC70)
#define PROC_CPU_FEATURE_CPUC6STATE_FILECODE                             (0xDC82)
#define PROC_CPU_FEATURE_CPUCPB_FILECODE                                 (0xDC83)
#define PROC_CPU_FEATURE_CPULOWPWRPSTATE_FILECODE                        (0xDC84)
#define PROC_CPU_FEATURE_CPUIOCSTATE_FILECODE                            (0xDC85)
#define PROC_CPU_FEATURE_CPUPSTATEHPCMODE_FILECODE                       (0xDC86)
#define PROC_CPU_FEATURE_CPUAPM_FILECODE                                 (0xDC87)
#define PROC_CPU_FEATURE_CPUFEATURES_FILECODE                            (0xDC90)
#define PROC_CPU_FEATURE_CPUMSGBASEDC1E_FILECODE                         (0xDCA0)
#define PROC_CPU_FEATURE_CPUCORELEVELING_FILECODE                        (0xDCB0)
#define PROC_CPU_FEATURE_PRESERVEMAILBOX_FILECODE                        (0xDCC0)
#define PROC_CPU_FEATURE_CPUPSI_FILECODE                                 (0xDCC1)
#define PROC_CPU_FEATURE_CPUHTC_FILECODE                                 (0xDCC2)
#define PROC_CPU_FEATURE_CPUCRAT_FILECODE                                (0xDCD0)
#define PROC_CPU_FEATURE_CPUCDIT_FILECODE                                (0xDCD1)
#define PROC_CPU_FEATURE_CPUTDPLIMITING_FILECODE                         (0xDCD2)
#define PROC_CPU_FEATURE_CPUPREFETCHMODE_FILECODE                        (0xDCD3)
#define PROC_CPU_FEATURE_CPUSCS_FILECODE                                 (0xDCD4)


#define PROC_IDS_CONTROL_IDSCTRL_FILECODE                                (0xE801)
#define PROC_IDS_LIBRARY_IDSLIB_FILECODE                                 (0xE802)
#define PROC_IDS_DEBUG_IDSDEBUG_FILECODE                                 (0xE803)
#define PROC_IDS_PERF_IDSPERF_FILECODE                                   (0xE804)
#define PROC_IDS_LIBRARY_IDSREGACC_FILECODE                              (0xE810)
#define PROC_IDS_DEBUG_IDSDPHDTOUT_FILECODE                              (0xE811)
#define PROC_IDS_DEBUG_IDSDEBUGPRINT_FILECODE                            (0xE812)
#define PROC_IDS_DEBUG_IDSDPSERIAL_FILECODE                              (0xE813)
#define PROC_IDS_DEBUG_IDSDPREDIRECTIO_FILECODE                          (0xE814)
#define PROC_IDS_DEBUG_IDSDPRAM_FILECODE                                 (0xE815)

#define PROC_IDS_DEBUG_IDSIDTTABLE_FILECODE                              (0xE81E)
#define PROC_IDS_CONTROL_IDSNVTOCMOS_FILECODE                            (0xE81F)
#define PROC_IDS_FAMILY_0X16_KB_IDSF16KBALLSERVICE_FILECODE              (0xE821)

///0xE820 ~ 0xE840 is reserved for ids extend module

#define PROC_MEM_ARDK_MA_FILECODE                                    (0xF001)

#define PROC_MEM_FEAT_CHINTLV_MFCHI_FILECODE                         (0xF081)
#define PROC_MEM_FEAT_CSINTLV_MFCSI_FILECODE                         (0xF082)
#define PROC_MEM_FEAT_ECC_MFECC_FILECODE                             (0xF083)
#define PROC_MEM_FEAT_ECC_MFEMP_FILECODE                             (0xF085)
#define PROC_MEM_FEAT_EXCLUDIMM_MFDIMMEXCLUD_FILECODE                (0xF086)
#define PROC_MEM_FEAT_IDENDIMM_MFIDENDIMM_FILECODE                   (0xF088)
#define PROC_MEM_FEAT_LVDDR3_MFLVDDR3_FILECODE                       (0xF08A)
#define PROC_MEM_FEAT_MEMCLR_MFMEMCLR_FILECODE                       (0xF08B)
#define PROC_MEM_FEAT_ODTHERMAL_MFODTHERMAL_FILECODE                 (0xF08D)
#define PROC_MEM_FEAT_PARTRN_MFPARALLELTRAINING_FILECODE             (0xF08F)
#define PROC_MEM_FEAT_PARTRN_MFSTANDARDTRAINING_FILECODE             (0xF091)
#define PROC_MEM_FEAT_S3_MFS3_FILECODE                               (0xF092)
#define PROC_MEM_FEAT_TABLE_MFTDS_FILECODE                           (0xF093)
#define PROC_MEM_FEAT_CRAT_MFCRAT_FILECODE                           (0xF095)
#define PROC_MEM_FEAT_DATAEYE_MF2DDATAEYE_FILECODE                   (0xF097)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFWRDAT2DTRAINING_FILECODE         (0xF098)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DEYERIMSEARCH_FILECODE      (0xF099)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDDQS2DTRAINING_FILECODE         (0xF09A)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DTRAINING_FILECODE          (0xF09B)
#define PROC_MEM_FEAT_RDWR2DTRAINING_MFRDWR2DPATTERNGENERATION_FILECODE (0xF09C)
#define PROC_MEM_FEAT_RDWR2DTRAINING_KB_MFRDWR2DKB_FILECODE             (0xF09D)
#define PROC_MEM_FEAT_RDWR2DTRAINING_ML_MFRDWR2DML_FILECODE             (0xF09E)
#define PROC_MEM_FEAT_AGGRESSOR_MFAGGRESSOR_FILECODE                    (0xF09F)

#define PROC_MEM_MAIN_MDEF_FILECODE                                  (0xF101)
#define PROC_MEM_MAIN_MINIT_FILECODE                                 (0xF102)
#define PROC_MEM_MAIN_MM_FILECODE                                    (0xF103)
#define PROC_MEM_FEAT_DMI_MFDMI_FILECODE                             (0xF104)
#define PROC_MEM_MAIN_MMECC_FILECODE                                 (0xF105)
#define PROC_MEM_MAIN_MMEXCLUDEDIMM_FILECODE                         (0xF106)
#define PROC_MEM_MAIN_MMNODEINTERLEAVE_FILECODE                      (0xF10B)
#define PROC_MEM_MAIN_MMONLINESPARE_FILECODE                         (0xF10C)
#define PROC_MEM_MAIN_MMPARALLELTRAINING_FILECODE                    (0xF10D)
#define PROC_MEM_MAIN_MMSTANDARDTRAINING_FILECODE                    (0xF10E)
#define PROC_MEM_MAIN_MUC_FILECODE                                   (0xF10F)
#define PROC_MEM_MAIN_MMMEMCLR_FILECODE                              (0xF110)
#define PROC_MEM_MAIN_MMFLOW_FILECODE                                (0xF112)
#define PROC_MEM_MAIN_MERRHDL_FILECODE                               (0xF113)
#define PROC_MEM_MAIN_MMLVDDR3_FILECODE                              (0xF115)
#define PROC_MEM_MAIN_MMUMAALLOC_FILECODE                            (0xF116)
#define PROC_MEM_MAIN_MMMEMRESTORE_FILECODE                          (0xF117)
#define PROC_MEM_MAIN_MMCONDITIONALPSO_FILECODE                      (0xF118)
#define PROC_MEM_MAIN_MMAGGRESSOR_FILECODE                           (0xF119)
#define PROC_MEM_MAIN_KB_MMFLOWKB_FILECODE                           (0xF124)

#define PROC_MEM_NB_MN_FILECODE                                      (0XF27C)
#define PROC_MEM_NB_MNDCT_FILECODE                                   (0XF27D)
#define PROC_MEM_NB_MNPHY_FILECODE                                   (0XF27E)
#define PROC_MEM_NB_MNMCT_FILECODE                                   (0XF27F)
#define PROC_MEM_NB_MNS3_FILECODE                                    (0XF280)
#define PROC_MEM_NB_MNFLOW_FILECODE                                  (0XF281)
#define PROC_MEM_NB_MNFEAT_FILECODE                                  (0XF282)
#define PROC_MEM_NB_MNTRAIN3_FILECODE                                (0XF284)
#define PROC_MEM_NB_MNREG_FILECODE                                   (0XF285)
#define PROC_MEM_NB_MNPMU_FILECODE                                   (0xF2B7)
#define PROC_MEM_NB_KB_MNREGKB_FILECODE                              (0XF2B8)
#define PROC_MEM_NB_KB_MNKB_FILECODE                                 (0XF2B9)
#define PROC_MEM_NB_KB_MNMCTKB_FILECODE                              (0XF2BA)
#define PROC_MEM_NB_KB_MNOTKB_FILECODE                               (0XF2BB)
#define PROC_MEM_NB_KB_MNDCTKB_FILECODE                              (0XF2BC)
#define PROC_MEM_NB_KB_MNPHYKB_FILECODE                              (0XF2BD)
#define PROC_MEM_NB_KB_MNS3KB_FILECODE                               (0XF2BE)
#define PROC_MEM_NB_KB_MNIDENDIMMKB_FILECODE                         (0XF2BF)
#define PROC_MEM_NB_KB_MNFLOWKB_FILECODE                             (0XF2C0)
#define PROC_MEM_NB_KB_MNPROTOKB_FILECODE                            (0XF2C1)


#define PROC_MEM_PS_MP_FILECODE                                      (0XF401)
#define PROC_MEM_PS_MPRTT_FILECODE                                   (0XF422)
#define PROC_MEM_PS_MPMAXFREQ_FILECODE                               (0XF423)
#define PROC_MEM_PS_MPODTPAT_FILECODE                                (0XF424)
#define PROC_MEM_PS_MPSAO_FILECODE                                   (0XF425)
#define PROC_MEM_PS_MPMR0_FILECODE                                   (0XF426)
#define PROC_MEM_PS_MPRC2IBT_FILECODE                                (0XF427)
#define PROC_MEM_PS_MPRC10OPSPD_FILECODE                             (0XF428)
#define PROC_MEM_PS_MPLRIBT_FILECODE                                 (0XF429)
#define PROC_MEM_PS_MPLRNPR_FILECODE                                 (0XF42A)
#define PROC_MEM_PS_MPLRNLR_FILECODE                                 (0XF42B)
#define PROC_MEM_PS_MPS2D_FILECODE                                   (0XF436)
#define PROC_MEM_PS_MPSEEDS_FILECODE                                 (0XF437)
#define PROC_MEM_PS_KB_MPSKB3_FILECODE                               (0XF438)
#define PROC_MEM_PS_KB_MPKB3_FILECODE                                (0XF439)
#define PROC_MEM_PS_KB_MPUKB3_FILECODE                               (0XF43A)
#define PROC_MEM_PS_KB_FT3_MPSKBFT3_FILECODE                         (0XF43B)
#define PROC_MEM_PS_MPCADCFG_FILECODE                                (0XF43C)
#define PROC_MEM_PS_MPDATACFG_FILECODE                               (0XF43D)

#define PROC_MEM_TECH_MT_FILECODE                                    (0XF501)
#define PROC_MEM_TECH_MTHDI_FILECODE                                 (0XF502)
#define PROC_MEM_TECH_MTTDIMBT_FILECODE                              (0XF504)
#define PROC_MEM_TECH_MTTECC_FILECODE                                (0XF505)
#define PROC_MEM_TECH_MTTHRC_FILECODE                                (0XF506)
#define PROC_MEM_TECH_MTTML_FILECODE                                 (0XF507)
#define PROC_MEM_TECH_MTTOPTSRC_FILECODE                             (0XF509)
#define PROC_MEM_TECH_MTTSRC_FILECODE                                (0XF50B)
#define PROC_MEM_TECH_MTTEDGEDETECT_FILECODE                         (0XF50C)
#define PROC_MEM_TECH_DDR3_MT3_FILECODE                              (0XF581)
#define PROC_MEM_TECH_DDR3_MTOT3_FILECODE                            (0XF583)
#define PROC_MEM_TECH_DDR3_MTRCI3_FILECODE                           (0XF584)
#define PROC_MEM_TECH_DDR3_MTSDI3_FILECODE                           (0XF585)
#define PROC_MEM_TECH_DDR3_MTSPD3_FILECODE                           (0XF586)
#define PROC_MEM_TECH_DDR3_MTTWL3_FILECODE                           (0XF587)
#define PROC_MEM_TECH_DDR3_MTTECC3_FILECODE                          (0XF588)
#define PROC_MEM_TECH_DDR3_MTLRDIMM3_FILECODE                        (0XF589)
#define PROC_MEM_TECH_MTTHRCSEEDTRAIN_FILECODE                       (0XF58A)
#define PROC_MEM_TECH_MTTRDDQS2DTRAINING_FILECODE                    (0XF58B)
#define PROC_MEM_TECH_MTTRDDQS2DEYERIMSEARCH_FILECODE                (0XF58C)

#endif // _FILECODE_H_
