/* wptClipEditDlg.cpp - Clipboard Editor dialog
 *	Copyright (C) 2000-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <stdio.h>

#include "wptTypes.h"
#include "wptW32API.h"
#include "wptVersion.h"
#include "wptErrors.h"
#include "wptGPG.h"
#include "wptNLS.h"
#include "../resource.h"


BOOL CALLBACK 
clip_edit_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    HANDLE clipmem;
    OPENFILENAME open;
    FILE * fp;
    char * cliptext = NULL, * newtext = NULL,  * p;
    char file[512] = "";
    int nbytes, id, size;
    
    switch ( msg )  {
    case WM_INITDIALOG:
	#ifndef LANG_DE	
	SetWindowText (dlg, _("Clipboard Editor"));
	SetDlgItemText (dlg, IDC_CLIPEDIT_SEND, _("&Copy"));
	SetDlgItemText (dlg, IDC_CLIPEDIT_CLEAR, _("Clea&r"));
	SetDlgItemText (dlg, IDC_CLIPEDIT_LOAD, _("&Load"));	
	SetDlgItemText (dlg, IDC_CLIPEDIT_SAVE, _("&Save"));
	#endif
        CloseClipboard (); /* make sure it is closed. */
	if( OpenClipboard( NULL ) == FALSE ) {
	    msg_box( dlg, winpt_strerror( WPTERR_CLIP_OPEN ), _("Clipboard"), MB_ERR );
	    return FALSE;
	}
	clipmem = GetClipboardData (CF_TEXT);
	if (clipmem == NULL) {
	    center_window (dlg);
	    SetForegroundWindow (dlg);
	    CloseClipboard ();
	    return FALSE;
	}
	cliptext = (char *) GlobalLock (clipmem);
	if (cliptext == NULL || !strlen (cliptext)) {
	    CloseClipboard ();
	    return FALSE;
	}
	p = new char [strlen (cliptext)+2];
	if (!p)
	    BUG (0);
	strcpy (p, cliptext);
	GlobalUnlock (clipmem);
	CloseClipboard ();
	SetDlgItemText (dlg, IDC_CLIPEDIT_CLIPTEXT2, p);
	free_if_alloc (p);
	center_window (dlg);
	SetForegroundWindow (dlg);
	return TRUE;
        
    case WM_SYSCOMMAND:
	if (LOWORD (wparam) == SC_CLOSE)
	    EndDialog (dlg, TRUE);
	return FALSE;
        
    case WM_COMMAND:
	switch (LOWORD (wparam)) {
	case IDOK:		
	    EndDialog (dlg, TRUE);
	    return TRUE;
            
	case IDC_CLIPEDIT_SEND:
	    if (IsDlgButtonChecked (dlg, IDC_CLIPEDIT_QUOTE)) {
		gpgme_data_t txt;
		gpgme_data_new_from_clipboard (&txt);
		gpgme_data_mail_quote (&txt);
		gpgme_data_release_and_set_clipboard (txt);
		SendMessage (dlg, WM_INITDIALOG, 0, 0);
		return TRUE;
	    }
	    SendDlgItemMessage (dlg, IDC_CLIPEDIT_CLIPTEXT2, EM_SETSEL, 0, -1);
	    SendDlgItemMessage (dlg, IDC_CLIPEDIT_CLIPTEXT2, WM_COPY, 0, 0);
	    return TRUE;
            
	case IDC_CLIPEDIT_CLEAR:
	    if( OpenClipboard( NULL ) == FALSE ) {	
		msg_box( dlg,  winpt_strerror( WPTERR_CLIP_OPEN ), _("Clipboard"), MB_ERR );
		return FALSE;
	    }			
	    if (EmptyClipboard () == FALSE) {
		CloseClipboard ();
		msg_box (dlg, winpt_strerror (WPTERR_CLIP_EMPTY), _("Clipboard"), MB_ERR);
		return FALSE;
	    }
	    CloseClipboard ();
	    SetDlgItemText (dlg, IDC_CLIPEDIT_CLIPTEXT2, "");
	    return TRUE;
            
	case IDC_CLIPEDIT_LOAD:
	    memset (&open, 0, sizeof (open));
	    open.lStructSize = sizeof (OPENFILENAME);
	    open.hInstance = glob_hinst;
	    open.lpstrTitle = _("File Open");
	    open.lpstrFilter = (char *)_("All Files (*.*)\0*.*");
	    open.hwndOwner = dlg;
	    open.lpstrFile = file;	
	    open.nMaxFile = sizeof (file)-1;	
	    open.Flags = 0;
	    if (GetOpenFileName (&open)) {
		if( (size=get_file_size( file )) > MAX_CLIPTEXT_SIZE ) {
		    id = msg_box( dlg, _("The file you want to add is very large.\n"
			                "Still proceed?"), _("Clipboard"), MB_INFO|MB_YESNO );
		    if( id == IDNO )
			return FALSE;
		}
		fp = fopen( file, "rb" );
		if (!fp) {
		    msg_box (dlg, winpt_strerror (WPTERR_FILE_OPEN), _("Clipboard"), MB_ERR);
		    return FALSE;
		}
		p = new char[size+1];
		if (!p)
		    BUG (0);
		fread( p, 1, size, fp );
		p[size] = '\0';	
		fclose( fp );
		SetDlgItemText( dlg, IDC_CLIPEDIT_CLIPTEXT2, p );
		free_if_alloc( p );
		PostMessage( dlg, WM_COMMAND, MAKEWPARAM(IDC_CLIPEDIT_SEND, 0), NULL );
		return TRUE;
	    }
	    break;
            
	case IDC_CLIPEDIT_SAVE:
	    memset (&open, 0, sizeof (open));
	    open.lStructSize = sizeof OPENFILENAME;
	    open.hInstance = glob_hinst;
	    open.lpstrTitle = _("File Save");
	    open.lpstrFile = (char *)_("All Files (*.*)\0*.*");
	    open.hwndOwner = dlg;	
	    open.lpstrFile = file;	
	    open.nMaxFile = sizeof (file) - 1;
            
	    if( GetSaveFileName( &open ) ) {
		if( file_exist_check( file ) == 0 ) {
		    id = msg_box( dlg, _("File already exists!\nOverwrite?"),
                                 _("Clipboard"), MB_INFO|MB_YESNO );
		    if( id == IDNO )
			return FALSE;
		}
		fp = fopen( file, "wb" );
		if( !fp ) {
		    msg_box( dlg, winpt_strerror( WPTERR_FILE_CREAT ), _("Clipboard"), MB_ERR );
		    return FALSE;		
		}
		nbytes = SendDlgItemMessage( dlg, IDC_CLIPEDIT_CLIPTEXT2, WM_GETTEXTLENGTH, 0, 0 );
		if( nbytes > 0 ) {
		    p = new char[nbytes+1];		
		    if( !p )
			BUG( NULL );
		    GetDlgItemText( dlg, IDC_CLIPEDIT_CLIPTEXT2, p, nbytes );
		    fwrite( p, 1, nbytes, fp );
		}	   
		fclose( fp );	
		free_if_alloc( p );
	    }
	    break;
	}
	break;
    }
    
    return FALSE;
} /* clip_edit_dlg_proc */
