# Makefile - WinPT.dsp

ifndef CFG
CFG=WinPT - Win32 Debug
endif
CC=gcc
CFLAGS=
CXX=g++
CXXFLAGS=$(CFLAGS)
RC=windres -O COFF
ifeq "$(CFG)"  "WinPT - Win32 Release"
CFLAGS+=-ULANG_DE -W -UAFX_TARG_DEU -fexceptions -O2 -ISrc -IMyGPGME -IInclude -IGnupg -IPTD -DWIN32 -DNDEBUG -D_WINDOWS -D_MBCS -DHAVE_DOSISH_SYSTEM
LD=$(CXX) $(CXXFLAGS)
LDFLAGS=
LDFLAGS+=-Wl,--subsystem,windows -LPTD -LMyGPGME -LGnupg
LIBS+=-lPTD -lmygpgme -lcomctl32 -lws2_32 -lkernel32 -luser32 -lcomdlg32 -ladvapi32 -lshell32 -lgdi32 -lgnupg
else
ifeq "$(CFG)"  "WinPT - Win32 Debug"
CFLAGS+=-D_MBCS -W -DHAVE_DOSISH_SYSTEM -fexceptions -g -O0 -ISrc -IMyGPGME -IInclude -IGnupg -IPTD -DWIN32 -D_DEBUG -D_WINDOWS
LD=$(CXX) $(CXXFLAGS)
LDFLAGS=
LDFLAGS+=-Wl,--subsystem,windows -LPTD -LMyGPGME -LGnupg
LIBS+=-lkernel32 -luser32 -lgdi32 -lcomdlg32 -lcomctl32 -ladvapi32 -lshell32 -lws2_32 -lwldap32 -lPTD -lmygpgme -lgnupg
endif
endif

ifndef TARGET
TARGET=WinPT.exe
endif

.PHONY: all
all: $(TARGET)

%.o: %.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cpp
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cxx
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.res: %.rc
	$(RC) $(CPPFLAGS) -o $@ -i $<

RESOURCEN= \
	Src/ChangeLog \
	resource.h \
	Safe.ico \
	Sign.ico \
	WinPT-en.rc \
	winpt2.ico \
	winpt_km.bmp

DIALOGS= \
	Src/wptAboutDlgs.cpp \
	Src/wptCardDlg.cpp \
	Src/wptClipDecryptDlg.cpp \
	Src/wptClipEditDlg.cpp \
	Src/wptClipEncryptDlg.cpp \
	Src/wptClipImportDlg.cpp \
	Src/wptClipSignDlg.cpp \
	Src/wptClipSignEncDlg.cpp \
	Src/wptClipVerifyDlg.cpp \
	Src/wptCommonDlg.cpp \
	Src/wptDateDlg.cpp \
	Src/wptFileManagerDlg.cpp \
	Src/wptFileSaveDlg.cpp \
	Src/wptFileStatDlg.cpp \
	Src/wptFileVerifyDlg.cpp \
	Src/wptFirstRunDlg.cpp \
	Src/wptGPGOptDlg.cpp \
	Src/wptGPGPrefsDlg.cpp \
	Src/wptGroupsDlg.cpp \
	Src/wptKeyCacheDlg.cpp \
	Src/wptKeyEditDlgs.cpp \
	Src/wptKeyEditOwnertrustDlg.cpp \
	Src/wptKeyeditSetPrefDlg.cpp \
	Src/wptKeygenCBDlg.cpp \
	Src/wptKeygenDlg.cpp \
	Src/wptKeyImportStatusDlg.cpp \
	Src/wptKeyManagerDlg.cpp \
	Src/wptKeyPropsDlg.cpp \
	Src/wptKeyRevokeDlg.cpp \
	Src/wptKeyRevokersDlg.cpp \
	Src/wptKeyserverDlg.cpp \
	Src/wptKeyserverSearchDlg.cpp \
	Src/wptKeysigDlg.cpp \
	Src/wptKeysignDlg.cpp \
	Src/wptKeyTrustPathDlg.cpp \
	Src/wptMDSumDlg.cpp \
	Src/wptOwnertrustDlg.cpp \
	Src/wptPassphraseDlg.cpp \
	Src/wptPINDlg.cpp \
	Src/wptPreferencesDlg.cpp \
	Src/wptProgressDlg.cpp \
	Src/wptProxySettingsDlg.cpp \
	Src/wptTextInputDlg.cpp

HEADERFILES= \
	Include/wptAgent.h \
	Include/wptCard.h \
	Include/wptCommonCtl.h \
	Include/wptContext.h \
	Include/wptCryptdisk.h \
	Include/wptDlgs.h \
	Include/wptErrors.h \
	Include/wptFileManager.h \
	Include/wptGPG.h \
	Include/wptGpgCmds.h \
	Include/WptGPGOptSkel.h \
	Include/wptHotkey.h \
	Include/wptHTTP.h \
	Include/wptKeyEdit.h \
	Include/wptKeylist.h \
	Include/wptKeyManager.h \
	Include/wptKeyserver.h \
	Include/wptNLS.h \
	Include/wptRegistry.h \
	Include/wptTypes.h \
	Include/wptUTF8.h \
	Include/wptVersion.h \
	Include/wptW32API.h

ICONS= \
	icons/key_delete.ico \
	icons/key_export.ico \
	icons/key_import.ico \
	icons/key_props.ico \
	icons/key_sign.ico \
	icons/sort_downarrow.ico \
	icons/sort_uparrow.ico

SRCS=$(RESOURCEN) $(DIALOGS) $(HEADERFILES) $(ICONS)  \
	Src/WinPT.cpp \
	Src/wptCardManager.cpp \
	Src/wptCardPCSC.c \
	Src/wptCryptdisk.cpp \
	Src/wptCurrWnd.cpp \
	Src/wptErrors.cpp \
	Src/wptFileManager.cpp \
	Src/wptGPG.cpp \
	Src/wptGPGME.cpp \
	Src/wptGPGParser.cpp \
	Src/wptHotkey.cpp \
	Src/wptHTTP.c \
	Src/wptImagelist.cpp \
	Src/wptImportList.cpp \
	Src/wptKeylist.cpp \
	Src/wptKeyManager.cpp \
	Src/wptKeyserver.cpp \
	Src/wptListView.cpp \
	Src/wptMainProc.cpp \
	Src/wptMAPI.cpp \
	Src/wptNLS.c \
	Src/wptPassCache.cpp \
	Src/wptPassphraseCB.cpp \
	Src/wptRegistry.cpp \
	Src/wptSigList.cpp \
	Src/wptSymEnc.cpp \
	Src/wptTrayPop.cpp \
	Src/wptUTF8.cpp \
	Src/wptVerifyList.cpp \
	Src/wptW32API.cpp

OBJS=$(patsubst %.rc,%.res,$(patsubst %.cxx,%.o,$(patsubst %.cpp,%.o,$(patsubst %.cc,%.o,$(patsubst %.c,%.o,$(filter %.c %.cc %.cpp %.cxx %.rc,$(SRCS)))))))

$(TARGET): $(OBJS)
	$(LD) $(LDFLAGS) -o $@ $(OBJS) $(LIBS)

.PHONY: clean
clean:
	-rm -f $(OBJS) $(TARGET) WinPT.dep

.PHONY: depends
depends:
	-$(CXX) $(CXXFLAGS) $(CPPFLAGS) -MM $(filter %.c %.cc %.cpp %.cxx,$(SRCS)) > WinPT.dep

-include WinPT.dep

