/* wptListView.h - Dynamic list view control
 *	Copyright (C) 2001-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_LISTVIEW_H
#define WPT_LISTVIEW_H

#define KEYLIST_SORT_DESC 0x8000

typedef int (CALLBACK *listview_cmp) (LPARAM lParam1, LPARAM lParam2,
				      LPARAM lParamSort);
struct listview_column_s {
    int pos;
    int width;
    char *fieldname;
};
typedef struct listview_column_s * listview_column_t;

struct listview_ctrl_s {
    HWND ctrl;
    int cols;
    int items;
};
typedef struct listview_ctrl_s * listview_ctrl_t;

int listview_new( listview_ctrl_t *ctx );
void listview_release( listview_ctrl_t ctx );
int listview_add_column( listview_ctrl_t ctx, listview_column_t col );
int listview_add_item( listview_ctrl_t ctx, const char *text );
int listview_add_item2( listview_ctrl_t ctx, const char * text, void * magic );
void listview_add_sub_item( listview_ctrl_t ctx, int pos, int col, 
						    const char *text );
int listview_count_items( listview_ctrl_t ctx, int curr_sel );
int listview_del_item( listview_ctrl_t ctx, int pos );
int listview_del_all( listview_ctrl_t ctx );
int listview_get_item_state( listview_ctrl_t ctx, int pos );
int listview_sort_items( listview_ctrl_t ctx, int sortby,
			 listview_cmp sort_cb );
int listview_get_curr_pos( listview_ctrl_t ctx );
int listview_get_item_text (listview_ctrl_t ctx, int entry, int pos, 
			    char *text, int maxbytes);
void listview_set_ext_style( listview_ctrl_t ctx );
int listview_set_column_order( listview_ctrl_t ctx, int *array );
int listview_del_items( listview_ctrl_t ctx );
void listview_select_all( listview_ctrl_t ctx );

#endif /* WPT_LISTVIEW_H */