// SPDX-FileCopyrightText: 2023 g10 code Gmbh
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <QString>
#include <QHash>
#include <QNetworkAccessManager>

using Token = QByteArray;
using ClientId = QString;
using Email = QString;
using Port = int;

struct Server {
    using Id = QString;
    Id id;
    Port port;
};

class ServerState
{
public:
    static ServerState &instance();

    QHash<Email, Server> servers;

    QNetworkAccessManager qnam;

    QHash<Token, Email> composerRequest;

private:
    ServerState();
};
