gpgv(1)                                                   gpgv(1)



NAME
       gpgv -- signature verification tool

SYNOPSIS
       gpgv  [options]  [signed files]

DESCRIPTION
       gpgv is the OpenPGP signature checking tool.


       This  program  is  a stripped down version of gpg which is
       only able to check signatures.   It  is  somewhat  smaller
       than  the  full  blown  gpg and uses a different (and more
       simple way) to check that the public keys used to made the
       signature  are  trustworth.  There is no options files and
       only very few options are implemented.

       gpgv assumes that all keys in the keyring are  trustworty.
       It  uses  by default a keyring named trustedkeys.gpg which
       is assumed to be in the home directory as defined by GnuPG
       or set by an option or an environment variable.  An option
       may be used to specify another keyring  or  even  multiple
       keyrings.

OPTIONS
       gpgv recognizes these options:

       -v, --verbose
                 Give more information during processing. If used
                 twice, the input data is listed in detail.

       -q, --quiet
                 Try to be as quiet as possible.

       --keyring file
                 Add file to  the  list  of  keyrings.   If  file
                 begins  with  a  tilde  and  a  slash, these are
                 replaced by the HOME directory. If the  filename
                 does not contain a slash, it is assumed to be in
                 the home-directory ("~/.gnupg" if  --homedir  is
                 not  used).  The filename may be prefixed with a
                 scheme:

                 "gnupg-ring:" is the default one.

                 It might make sense  to  use  it  together  with
                 --no-default-keyring.

       --homedir directory
                 Set  the name of the home directory to directory
                 If this  option  is  not  used  it  defaults  to
                 "~/.gnupg".  It  does not make sense to use this
                 in a options file. This also overrides the envi
                 ronment variable "GNUPGHOME".

       --status-fd n
                 Write   special   status  strings  to  the  file
                 descriptor n.  See the file DETAILS in the docu
                 mentation for a listing of them.

       --logger-fd n
                 Write log output to file descriptor n and not to
                 stderr.

       --ignore-time-conflict
                 GnuPG normally checks that the timestamps  asso
                 ciated  with  keys and signatures have plausible
                 values.  However, sometimes a signature seems to
                 be  older  than  the  key due to clock problems.
                 This option makes these checks just a warning.

RETURN VALUE
       The program returns 0 if everything  was  fine,  1  if  at
       least  one  signature  was  bad, and other error codes for
       fatal errors.


EXAMPLES
       gpgv pgpfile

       gpgv sigfile [files]
                 Verify the signature of  the  file.  The  second
                 form is used for detached signatures, where sig
                 file is the  detached  signature  (either  ASCII
                 armored  or  binary)  and [files] are the signed
                 data; if this is not given the name of the  file
                 holding  the  signed data is constructed by cut
                 ting  off  the  extension  (".asc",  ".sig"   or
                 ".sign") from sigfile.

ENVIRONMENT
       HOME      Used to locate the default home directory.

       GNUPGHOME If set directory used instead of "~/.gnupg".

FILES
       ~/.gnupg/trustedkeys.gpg
                 The default keyring with the allowed keys



                                                          gpgv(1)
