/* status-table.h
 *      Copyright (C) 2002, 2005 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef GPGME_STATUS_TABLE_H
#define GPGME_STATUS_TABLE_H

struct status_table_s {
    const char *name;
    gpg_status_code_t code;
};

static struct status_table_s status_table[] = {
  { "ABORT", STATUS_ABORT },
  { "ALREADY_SIGNED", STATUS_ALREADY_SIGNED },
  { "BADARMOR", STATUS_BADARMOR },
  { "BADMDC", STATUS_BADMDC },
  { "BADSIG", STATUS_BADSIG },
  { "BAD_PASSPHRASE", STATUS_BAD_PASSPHRASE },
  { "BEGIN_DECRYPTION", STATUS_BEGIN_DECRYPTION },
  { "BEGIN_ENCRYPTION", STATUS_BEGIN_ENCRYPTION },
  { "BEGIN_STREAM", STATUS_BEGIN_STREAM },
  { "CARDCTRL", STATUS_CARDCTRL },
  { "DECRYPTION_FAILED", STATUS_DECRYPTION_FAILED },
  { "DECRYPTION_OKAY", STATUS_DECRYPTION_OKAY },
  { "DELETE_PROBLEM", STATUS_DELETE_PROBLEM },
  { "ENC_TO", STATUS_ENC_TO },
  { "END_DECRYPTION", STATUS_END_DECRYPTION },
  { "END_ENCRYPTION", STATUS_END_ENCRYPTION },
  { "END_STREAM", STATUS_END_STREAM },
  { "ENTER", STATUS_ENTER },
  { "ERRMDC", STATUS_ERRMDC },
  { "ERROR", STATUS_ERROR },
  { "ERRSIG", STATUS_ERRSIG },
  { "EXPKEYSIG", STATUS_EXPKEYSIG },
  { "EXPSIG", STATUS_EXPSIG },
  { "FILE_DONE", STATUS_FILE_DONE },
  { "FILE_ERROR", STATUS_FILE_ERROR },
  { "FILE_START", STATUS_FILE_START },
  { "GET_BOOL", STATUS_GET_BOOL },
  { "GET_HIDDEN", STATUS_GET_HIDDEN },
  { "GET_LINE", STATUS_GET_LINE },
  { "GOODMDC", STATUS_GOODMDC },
  { "GOODSIG", STATUS_GOODSIG },
  { "GOOD_PASSPHRASE", STATUS_GOOD_PASSPHRASE },
  { "GOT_IT", STATUS_GOT_IT },
  { "IMPORTED", STATUS_IMPORTED },
  { "IMPORT_CHECK", STATUS_IMPORT_CHECK },
  { "IMPORT_OK", STATUS_IMPORT_OK },
  { "IMPORT_RES", STATUS_IMPORT_RES },
  { "INV_RECP", STATUS_INV_RECP },
  { "KEYEXPIRED", STATUS_KEYEXPIRED },
  { "KEYREVOKED", STATUS_KEYREVOKED },
  { "KEY_CREATED", STATUS_KEY_CREATED },
  { "LEAVE", STATUS_LEAVE },
  { "MISSING_PASSPHRASE", STATUS_MISSING_PASSPHRASE },
  { "NEED_PASSPHRASE", STATUS_NEED_PASSPHRASE },
  { "NEED_PASSPHRASE_PIN", STATUS_NEED_PASSPHRASE_PIN },
  { "NEED_PASSPHRASE_SYM,", STATUS_NEED_PASSPHRASE_SYM },
  { "NODATA", STATUS_NODATA },
  { "NOTATION_DATA", STATUS_NOTATION_DATA },
  { "NOTATION_NAME", STATUS_NOTATION_NAME },
  { "NO_PUBKEY", STATUS_NO_PUBKEY },
  { "NO_RECP", STATUS_NO_RECP },
  { "NO_SECKEY", STATUS_NO_SECKEY },
  { "PLAINTEXT", STATUS_PLAINTEXT },
  { "PLAINTEXT_LENGTH", STATUS_PLAINTEXT_LENGTH },
  { "POLICY_URL", STATUS_POLICY_URL },
  { "PROGRESS", STATUS_PROGRESS },
  { "REVKEYSIG", STATUS_REVKEYSIG },
  { "RSA_OR_IDEA", STATUS_RSA_OR_IDEA },
  { "SC_OP_FAILURE", STATUS_SC_OP_FAILURE },
  { "SC_OP_SUCCESS", STATUS_SC_OP_SUCCESS },
  { "SESSION_KEY", STATUS_SESSION_KEY },
  { "SIGEXPIRED", STATUS_SIGEXPIRED },
  { "SIG_CREATED", STATUS_SIG_CREATED },
  { "SIG_ID", STATUS_SIG_ID },
  { "SIG_SUBPACKET", STATUS_SIG_SUBPACKET },
  { "TRUNCATED", STATUS_TRUNCATED },
  { "TRUST_FULLY", STATUS_TRUST_FULLY },
  { "TRUST_MARGINAL", STATUS_TRUST_MARGINAL },
  { "TRUST_NEVER", STATUS_TRUST_NEVER },
  { "TRUST_ULTIMATE", STATUS_TRUST_ULTIMATE },
  { "TRUST_UNDEFINED", STATUS_TRUST_UNDEFINED },
  { "UNEXPECTED", STATUS_UNEXPECTED },
  { "USERID_HINT", STATUS_USERID_HINT },
  { "VALIDSIG", STATUS_VALIDSIG },
  {NULL, 0} };

#endif /*GPGME_STATUS_TABLE_H*/